/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.oa.InvalidUserKeyException;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBServantManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.security.core.AppContextManager;
import java.util.HashMap;
import java.util.Map;

public class AppContextManagerImpl
implements AppContextManager {
    private EJBContainer ejbContainer = null;
    private EJBServantManager ejbServantManager = null;
    private static final TraceComponent tc = Tr.register(AppContextManagerImpl.class, "Security", "com.ibm.ejs.resources.security");

    public Map getJ2EEName(byte[] userKeyBytes) {
        HashMap<String, String> map;
        block31: {
            block28: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getJ2EEName");
                }
                map = null;
                if (this.ejbContainer == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No EJBContainer service");
                    }
                    return null;
                }
                if (this.ejbServantManager == null && this.ejbContainer != null) {
                    try {
                        this.ejbServantManager = this.ejbContainer.getServantManager();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.security.core.AppContextManagerImpl.getJ2EEName", "69");
                        if (!tc.isDebugEnabled()) break block28;
                        Tr.debug(tc, "attempt to get EJBServantManager failed", e);
                    }
                }
            }
            if (this.ejbServantManager != null) {
                byte[] servantKeyBytes;
                block30: {
                    servantKeyBytes = null;
                    try {
                        if (userKeyBytes != null) {
                            UserKey userKey;
                            block29: {
                                userKey = null;
                                try {
                                    userKey = new UserKey(userKeyBytes);
                                }
                                catch (InvalidUserKeyException ex) {
                                    if (!tc.isDebugEnabled()) break block29;
                                    Tr.debug(tc, "create userKey failed;  exception was " + ex.getMessage());
                                    ex.printStackTrace();
                                }
                            }
                            if (userKey != null) {
                                servantKeyBytes = userKey.getServantKey();
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "userKey is null;  userKeyBytes was " + new String(userKeyBytes));
                            }
                            break block30;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "userKeyBytes is null");
                        }
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block30;
                        Tr.debug(tc, "Exception caught: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                }
                try {
                    byte[] j2eeNameBytes = this.ejbServantManager.getJ2EENameBytes(servantKeyBytes);
                    J2EENameFactory j2eeNameFactory = this.ejbContainer.getJ2EENameFactory();
                    if (j2eeNameFactory != null) {
                        J2EEName j2eeName = j2eeNameFactory.create(j2eeNameBytes);
                        if (j2eeName != null) {
                            map = new HashMap<String, String>(3);
                            map.put("WebAppName", j2eeName.getApplication());
                            map.put("Module", j2eeName.getModule());
                            map.put("Component", j2eeName.getComponent());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "J2EEName: application name = " + j2eeName.getApplication() + ", module name = " + j2eeName.getModule() + ", component name = " + j2eeName.getComponent());
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "J2EEName is null; j2eeNameBytes was " + new String(j2eeNameBytes));
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "J2EENameFactory is null");
                    }
                    break block31;
                }
                catch (CSIException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught when converting servant Key to J2EENameBytes: minor code = " + ex.getMinorCode() + " Exception Message = " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    break block31;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cyc> ejbServantManager is null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEName");
        }
        return map;
    }

    void initialize(EJBContainer e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (this.ejbContainer == null) {
            this.ejbContainer = e;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppContextManager initialized");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    boolean initialized() {
        return this.ejbContainer != null;
    }
}

