/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config.securitydomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SecDomainHelper {
    private static TraceComponent tc = Tr.register(SecDomainHelper.class, "security", "com.ibm.ws.security.config.securitydomain");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());

    public static String validateMultiDomain(Hashtable targets, ConfigService configService, boolean isLocalMode, String processType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMultiDomain");
        }
        String errorMsg = "security.domain.app.deploy.error.SECJ7782E";
        String warningMsg = "security.domain.app.deploy.warning.SECJ7783W";
        String allowDeployment = "SUCCESS";
        try {
            AdminService adminService = null;
            if (processType == null || processType.length() == 0) {
                adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateMultiDomain", " Error: no process type provided by the caller and AdminService object is null");
                    }
                    return SecDomainHelper.getFormattedMessage(resBundle, warningMsg, null);
                }
                processType = adminService.getProcessType();
                if (processType == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateMultiDomain", " Error: retrieved a null processType from the AdminService object");
                    }
                    return SecDomainHelper.getFormattedMessage(resBundle, warningMsg, null);
                }
            }
            if (!processType.equalsIgnoreCase("DeploymentManager")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateMultiDomain", " this process is not a Dmgr -- no need to validate");
                }
                return allowDeployment;
            }
            CommandProviderHelper helper = null;
            if (configService == null) {
                helper = CommandMgr.getCommandMgr().getCommandProviderHelper();
                if (helper == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateMultiDomain", "Error: no ConfigService provided by the caller and CommandProviderHelper object is null");
                    }
                    return SecDomainHelper.getFormattedMessage(resBundle, warningMsg, null);
                }
                configService = helper.getConfigService();
                if (configService == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateMultiDomain", "Error: no ConfigService provide by the caller and cannot retrieve one from CommandProviderHelper");
                    }
                    return SecDomainHelper.getFormattedMessage(resBundle, warningMsg, null);
                }
            }
            if (!SecurityObjectLocator.getSecurityConfigManager().isMultiDomainDefined()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateMultiDomain", " multi-security domains not defined -- no need to validate");
                }
                return allowDeployment;
            }
            Enumeration keys = targets.keys();
            String reference_domain = null;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String multipleTargets = (String)targets.get(key);
                String[] atoms = multipleTargets.split("\\+");
                String target = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "multiple target's key and value are: key = " + key + " value = " + multipleTargets);
                }
                for (int i = 0; i < atoms.length; ++i) {
                    target = atoms[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "target's key and value are: key = " + key + " value = " + target);
                    }
                    if (target == null) continue;
                    String resource = SecDomainHelper.convertResourceNameToCommandForm(target);
                    String current_domain = SecDomainHelper.getSecurityDomainForResource(resource, configService, isLocalMode);
                    if (current_domain == null) {
                        current_domain = "admin";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resource name: " + resource + " has domain: " + current_domain);
                    }
                    if (current_domain != null && reference_domain == null) {
                        reference_domain = current_domain;
                    }
                    if (current_domain == null || current_domain.equals("admin") || reference_domain.equals(current_domain) || !SecDomainHelper.isDistinctDomain(current_domain)) continue;
                    if (SecurityObjectLocator.getSecurityConfig("security").getPropertyBool("com.ibm.websphere.security.deployAcrossDomains")) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "validateMultiDomain", "warning: across domain deployment is allowed: property com.ibm.websphere.security.deployAcrossDomains is set to true in security.xml");
                        }
                        return SecDomainHelper.getFormattedMessage(resBundle, warningMsg, null);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateMultiDomain", "Error: deploying application modules across multiple security domains that are disjoint: " + reference_domain + " and " + current_domain);
                    }
                    return SecDomainHelper.getFormattedMessage(resBundle, errorMsg, new Object[]{reference_domain, current_domain});
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.config.securitydomain.SecDomainHelper", "%c%");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateMultiDomain", "caught exception in validateMultiDomain" + e.getMessage());
            }
            return SecDomainHelper.getFormattedMessage(resBundle, errorMsg, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMultiDomain", " retuning 0 -- success");
        }
        return allowDeployment;
    }

    public static String getSecurityDomainForResource(String resourceName, ConfigService configService, boolean isLocalMode) throws Exception {
        String name;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityDomainForResource", new Object[]{resourceName});
            }
            Session session = null;
            name = null;
            String resource = null;
            try {
                session = new Session();
                String domainOfCell = null;
                ObjectName[] resourceObjectName = null;
                domainOfCell = SecDomainHelper.getCellDomain(session, configService);
                resourceObjectName = configService.resolve(session, resourceName);
                if (resourceObjectName != null && resourceObjectName.length > 0) {
                    String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
                    String resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName[0]);
                    resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
                    name = SecDomainHelper.findDomainForResource(session, configService, resource);
                    if (name == null) {
                        ObjectName cluster;
                        String inCluster;
                        if (resourceType.equals("Server") && (inCluster = (String)configService.getAttribute(session, resourceObjectName[0], "clusterName")) != null && (cluster = configService.resolve(session, "Cell=:ServerCluster=" + inCluster)[0]) != null) {
                            String clusterResource = null;
                            String clusterConfigID = ConfigServiceHelper.getConfigDataId(cluster).toString();
                            clusterResource = clusterConfigID != null && clusterConfigID.lastIndexOf(124) > 0 ? clusterConfigID.substring(0, clusterConfigID.lastIndexOf(124)) : clusterConfigID;
                            name = SecDomainHelper.findDomainForResource(session, configService, clusterResource);
                        }
                        if (name == null && domainOfCell != null) {
                            name = domainOfCell;
                        }
                    }
                    break block14;
                }
                String msg = "warning: a resource object name for: " + resourceName + " is null or invalid";
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new Exception(msg);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.config.securitydomain.SecDomainHelper", "%c%");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSecurityDomainForResource caught exception ", e.getMessage());
                }
                throw e;
            }
            finally {
                if (session != null) {
                    configService.discard(session);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityDomainForResource", new Object[]{name});
        }
        return name;
    }

    public static String getCellDomain(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellDomain");
        }
        String domainOfCell = null;
        ObjectName cell = configService.resolve(session, "Cell=")[0];
        if (cell != null) {
            String cellResource = null;
            String cellConfigID = ConfigServiceHelper.getConfigDataId(cell).toString();
            cellResource = cellConfigID != null && cellConfigID.lastIndexOf(124) > 0 ? cellConfigID.substring(0, cellConfigID.lastIndexOf(124)) : cellConfigID;
            domainOfCell = SecDomainHelper.findDomainForResource(session, configService, cellResource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellDomain", new Object[]{domainOfCell});
        }
        return domainOfCell;
    }

    public static String findDomainForResource(Session session, ConfigService configService, String resourceName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findDomainForResource", new Object[]{resourceName});
        }
        String domainName = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
        ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
        for (int j = 0; j < domains.length; ++j) {
            ObjectName domain = domains[j];
            List members = (List)configService.getAttribute(session, domain, "members");
            for (int k = 0; k < members.size(); ++k) {
                AttributeList member = (AttributeList)members.get(k);
                String resourceMember = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                if (!resourceMember.equalsIgnoreCase(resourceName)) continue;
                domainName = (String)configService.getAttribute(session, domain, "name");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCellDomain", new Object[]{domainName});
                }
                return domainName;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findDomainForResource", new Object[]{domainName});
        }
        return domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDistinctDomain(String domainName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDistinctDomain", new Object[]{domainName});
        }
        boolean value = false;
        boolean pushed = false;
        try {
            pushed = domainName != null && domainName.equalsIgnoreCase("admin") ? SecurityObjectLocator.pushAppContext("") : SecurityObjectLocator.pushContext(domainName, "domain");
            value = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry(false) != null || SecurityObjectLocator.getSecurityConfig().getJAASLoginConfig(false) != null || SecurityObjectLocator.getSecurityConfigManager().getObject("AppSecurity::authDataEntries", false) != null || SecurityObjectLocator.getSecurityConfig().getAuthorizationConfig(false) != null;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.config.securitydomain.SecDomainHelper", "%c%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isDistinctDomain caught exception ", e.getMessage());
            }
        }
        finally {
            if (pushed) {
                SecurityObjectLocator.popContext();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDistinctDomain", value);
        }
        return value;
    }

    public static String convertResourceNameToCommandForm(String name) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToCommandForm", new Object[]{name});
        }
        if ((i = name.indexOf(":")) >= 0 && i < name.length() && (name = name.substring(i + 1)) != null) {
            name = name.replace("cell=", " Cell=");
            name = name.replace("node=", "Node=");
            name = name.replace("server=", "Server=");
            name = name.replace("cluster=", "ServerCluster=");
            name = name.replaceAll(",", ":");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToCommandForm", new Object[]{name});
        }
        return name;
    }

    public static String convertResource(String scope) {
        String result = null;
        String[] atoms = scope.split("/");
        boolean keyword = true;
        for (int i = 0; i < atoms.length; ++i) {
            if (keyword) {
                if (atoms[i].equals("cells")) {
                    result = "Cell=";
                } else if (atoms[i].equals("nodes")) {
                    result = result + ":Node=";
                } else if (atoms[i].equals("servers")) {
                    result = result + ":Server=";
                } else if (atoms[i].equals("clusters")) {
                    result = result + ":ServerCluster=";
                } else if (atoms[i].equals("nodegroups")) {
                    result = result + ":NodeGroup=";
                } else if (atoms[i].equals("buses")) {
                    result = result + ":SIBus=";
                }
                keyword = false;
                continue;
            }
            result = result + atoms[i];
            keyword = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertResource", new Object[]{result});
        }
        return result;
    }

    public static String convertResource1(String scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertResource1");
        }
        String result = null;
        String[] atoms = scope.split("/");
        boolean keyword = true;
        for (int i = 0; i < atoms.length; ++i) {
            if (keyword) {
                if (atoms[i].equals("cells")) {
                    result = "Cell=";
                } else if (atoms[i].equals("nodes")) {
                    result = result + ":Node=";
                } else if (atoms[i].equals("servers")) {
                    result = result + ":Server=";
                } else if (atoms[i].equals("clusters")) {
                    result = result + ":Cluster=";
                } else if (atoms[i].equals("nodegroups")) {
                    result = result + ":NodeGroup=";
                } else if (atoms[i].equals("buses")) {
                    result = result + ":SIBus=";
                }
                keyword = false;
                continue;
            }
            result = result + atoms[i];
            keyword = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertResource1", new Object[]{result});
        }
        return result;
    }

    public static String getFormattedMessage(ResourceBundle bundle, String key, Object[] args) {
        String message = null;
        try {
            message = bundle.getString(key);
            if (message == null) {
                message = "Cannot find message key " + key + "in resource bundle" + bundle.toString();
                Tr.event(tc, message);
            }
            message = MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            message = "Cannot find message key " + key + "in resource bundle " + bundle.toString();
            Tr.event(tc, message);
            return message;
        }
        catch (NullPointerException npe) {
            message = "Null pointer exception caught trying to find message key " + key + " in resource bundle " + bundle.toString();
            Tr.event(tc, message);
        }
        return message;
    }

    public static String getClusterName(String scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterName");
        }
        String result = null;
        String[] atoms = scope.split("/");
        for (int i = 0; i < atoms.length; ++i) {
            if (!atoms[i].equals("clusters") || i >= atoms.length - 1) continue;
            result = atoms[i + 1];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterName", result);
        }
        return result;
    }

    public static String validateMultiDomainWrap(Object targets, Object configService, boolean isLocalMode, String processType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMultiDomainWrap");
        }
        String retValue = null;
        retValue = SecDomainHelper.validateMultiDomain((Hashtable)targets, (ConfigService)configService, isLocalMode, processType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMultiDomainWrap", retValue);
        }
        return retValue;
    }
}

