/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.naming.NamingAuthzConfig;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.List;

public class NamingAuthzConfigImpl
extends GenericConfigHelperImpl
implements NamingAuthzConfig {
    private static final TraceComponent tc = Tr.register(NamingAuthzConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private String cacheKey = null;
    private static final String NAMING_AUTHZ = "naming-authz.xml";
    private boolean namingUnprotected = false;
    private boolean alreadyChecked = false;

    public NamingAuthzConfigImpl(String _cacheKey) {
        this.cacheKey = _cacheKey;
    }

    public boolean isNamingReadUnprotected() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.cacheKey + "isNamingReadUnprotected()");
        }
        if (this.alreadyChecked) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.cacheKey + "isNamingReadUnprotected() returned cached value: ", this.namingUnprotected);
            }
            return this.namingUnprotected;
        }
        String namingUnprotectedFromProp = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.security.multiDomain.setNamingReadUnprotected");
        if (namingUnprotectedFromProp != null) {
            this.namingUnprotected = Boolean.valueOf(namingUnprotectedFromProp);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using the custom property to set the namingReadUnprotected flag to: " + this.namingUnprotected);
            }
        } else {
            try {
                ConfigService configService = WsServiceRegistry.getService(this, ConfigService.class);
                ConfigScope scope = configService.createScope(0);
                List resource = configService.getDocumentObjects(scope, NAMING_AUTHZ);
                ConfigObject doc = (ConfigObject)resource.get(0);
                List authzs = doc.getObjectList("authorizations");
                block2: for (int i = 0; i < authzs.size(); ++i) {
                    ConfigObject authz = (ConfigObject)authzs.get(i);
                    ConfigObject role = authz.getObject("role");
                    String roleName = role.getString("roleName", null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "roleName " + roleName);
                    }
                    if (!roleName.equals("CosNamingRead")) continue;
                    List specialSubjects = authz.getObjectList("specialSubjects");
                    for (int j = 0; j < specialSubjects.size(); ++j) {
                        ConfigObject specialSubject = (ConfigObject)specialSubjects.get(j);
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "specialSubject " + specialSubject);
                        }
                        if (!specialSubject.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi", "EveryoneExt")) continue;
                        this.namingUnprotected = true;
                        if (!tc.isDebugEnabled()) continue block2;
                        Tr.debug(tc, "naming read operation is unprotected");
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception reading naming authorization file: " + e);
                }
                this.namingUnprotected = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, this.cacheKey + "isNamingReadUnprotected()", this.namingUnprotected);
        }
        this.alreadyChecked = true;
        return this.namingUnprotected;
    }
}

