/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.profileregistry.ProfileRegistry;
import com.ibm.ws.management.profileregistry.ProfileRegistryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.config.EncodePasswords;
import com.ibm.ws.security.config.SecurityConfigCacheReference;
import com.ibm.ws.security.config.SecurityConfigException;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectImpl;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityConfigObjectListImpl;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.security.util.NodeVersionUtils;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.wsspi.runtime.config.ConfigHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConfigManagerImpl
implements SecurityConfigManager {
    public static final String CFG_OBJ_DELIM = "::";
    public static final String CFG_ATTR_DELIM = "#";
    public static final String CFG_VALUE_DELIM = "=";
    public static final String CFG_UNEXPANDED_KEY = "unexpanded";
    public static final int NOT_LIST_TYPE = 0;
    public static final int OBJECT_LIST_TYPE = 1;
    public static final int STRING_LIST_TYPE = 2;
    public static final int INTEGER_LIST_TYPE = 3;
    public static final int LONG_LIST_TYPE = 4;
    public static final int BOOLEAN_LIST_TYPE = 5;
    public static final int FLOAT_LIST_TYPE = 6;
    public static final int NO_SCOPE_VALUE = 1000;
    public static final int CELL_SCOPE_VALUE = 900;
    public static final int NODEGROUP_SCOPE_VALUE = 800;
    public static final int SIBUS_SCOPE_VALUE = 750;
    public static final int CLUSTER_SCOPE_VALUE = 700;
    public static final int NODE_SCOPE_VALUE = 600;
    public static final int SERVER_SCOPE_VALUE = 500;
    public static final int APP_SCOPE_VALUE = 400;
    private static SecurityConfigManagerImpl _instance = null;
    private static Map<String, Map<String, Object>> _cacheCache = new ConcurrentHashMap<String, Map<String, Object>>();
    private static HashMap<String, String> _sibusDomainMap = new HashMap();
    private static HashSet<String> _domainSet = new HashSet();
    private static String _processDomainName = null;
    private static String _cellDomainName = null;
    private static String _processType = null;
    private static boolean _processDomainScanDone = false;
    private String _cellConfigPath;
    private static boolean _isManagedProcess = false;
    private static boolean _isAdminAgent = false;
    private static boolean _isAdminAgentChecked = false;
    private static boolean _isNodeAgent = false;
    private static boolean _isDeploymentManager = false;
    private static boolean _isMultiDomainDefined = false;
    private static boolean _isMultiDomainDefinedChecked = false;
    private static boolean _isMixedCluster = false;
    private static boolean _isMixedClusterChecked = false;
    private static boolean _sibusDomainFound = false;
    private boolean _serverSecurityXMLCheckDone;
    private boolean _serverSecurityXMLExists;
    private ProfileRegistry _profileRegistry;
    private static VariableMap _variableMap = null;
    private boolean _realmsDomainScanDone;
    private HashMap<String, String> _realmToDomainMap;
    private static Object o = new Object();
    private static boolean _WIMUserRegAssignedToDomainChecked = false;
    private static boolean _isWIMUserRegAssignedToDomain = false;
    private static TraceComponent tc = Tr.register(SecurityConfigManagerImpl.class, "SecurityConfigManager", "com.ibm.ejs.resources.security");

    public static synchronized SecurityConfigManagerImpl getInstance() {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (_instance == null) {
            _instance = new SecurityConfigManagerImpl();
            SecurityObjectLocator.setSecurityConfigManager(_instance);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() " + (_instance != null ? _instance : "null"));
        }
        return _instance;
    }

    private SecurityConfigManagerImpl() {
        block7: {
            this._cellConfigPath = null;
            this._serverSecurityXMLCheckDone = false;
            this._serverSecurityXMLExists = false;
            this._profileRegistry = null;
            this._realmToDomainMap = new HashMap();
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>");
            }
            _instance = this;
            if (RasHelper.isServer()) {
                try {
                    ConfigService service = WsServiceRegistry.getService(SecurityConfigManagerImpl.class, ConfigService.class);
                    if (service == null) {
                        service = ConfigServiceFactory.createConfigService(SecurityConfigManagerImpl.getConfigRoot(), SecurityConfigManagerImpl.getCellName(), null, null);
                    }
                    ConfigScope cfgScope = service.getScope(0);
                    this._cellConfigPath = cfgScope.getAbsolutePath("");
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "<init> cell config path: " + this._cellConfigPath);
                    }
                }
                catch (Exception e) {
                    if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "<init> Unexpected exception: " + e);
                }
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    @Override
    public boolean isAdminAgent() {
        if (!_isAdminAgentChecked && AdminServiceFactory.getAdminService() != null) {
            String procType = AdminServiceFactory.getAdminService().getProcessType();
            _isAdminAgent = procType.equalsIgnoreCase("AdminAgent");
            _isAdminAgentChecked = true;
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdminAgent " + _isAdminAgent);
        }
        return _isAdminAgent;
    }

    Map<String, Object> getCache(SecurityConfigObject sco) {
        Map<String, Object> cache;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCache() " + sco);
        }
        if ((cache = sco.getCache()) == null) {
            cache = this.getCache(sco.getConfigFilePath() + "/" + sco.getConfigFileName());
            sco.setCache(cache);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCache()");
        }
        return cache;
    }

    Map<String, Object> getCache(SecurityConfigObjectList scol) {
        Map<String, Object> cache;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCache() " + scol);
        }
        if ((cache = scol.getCache()) == null) {
            cache = this.getCache(scol.getConfigFilePath() + "/" + scol.getConfigFileName());
            scol.setCache(cache);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCache()");
        }
        return cache;
    }

    private synchronized Map<String, Object> createCache(String key) {
        Map<String, Object> cache = _cacheCache.get(key);
        if (cache == null) {
            cache = new ConcurrentHashMap<String, Object>();
            _cacheCache.put(key, cache);
        }
        return cache;
    }

    Map<String, Object> getCache(String key) {
        Map<String, Object> cache;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCache() " + key);
        }
        if ((cache = _cacheCache.get(key)) == null) {
            return this.createCache(key);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCache()");
        }
        return cache;
    }

    @Override
    public String getDomainId() {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainId()");
        }
        String id = null;
        if (_isNodeAgent) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDomainId() in " + _processType + " process, returning 'admin'");
            }
            return "admin";
        }
        if (_isAdminAgent) {
            id = AdminContext.peek();
            if (id != null) {
                id = "profile:" + id;
            }
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getDomainId() peek returned " + id);
            }
        } else {
            String resType;
            SecurityConfigResource res;
            if (this.isMixedCluster()) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDomainName in mixed cluster, returning 'admin'");
                }
                return "admin";
            }
            if (_processDomainScanDone && _processDomainName == null && !_sibusDomainFound && !this.isMultiDomainDefined()) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDomainId() no domains defined for this process, returning 'admin'");
                }
                return "admin";
            }
            if (!_processDomainScanDone) {
                this.scanDomains();
            }
            if ((res = SecurityObjectLocator.peekContext()) != null && !(resType = res.getType()).equalsIgnoreCase("admin")) {
                if (resType.equalsIgnoreCase("application")) {
                    id = _processDomainName;
                } else if (resType.equalsIgnoreCase("SIBus")) {
                    String resName = res.getName();
                    if (resName != null && resName.length() > 0) {
                        id = _sibusDomainMap.get(resName);
                        if (id == null) {
                            id = _cellDomainName;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getDomainId() type=SIBus on thread with no bus name, using cell domain or admin");
                            }
                        }
                    } else {
                        id = _cellDomainName;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainId() type=SIBus on thread with no bus name, using cell domain or admin");
                        }
                    }
                } else if (resType.equalsIgnoreCase("domain")) {
                    String resName = res.getName();
                    if (resName != null && resName.length() > 0) {
                        if (_domainSet.contains(resName)) {
                            id = resName;
                        } else {
                            id = _processDomainName;
                            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                Tr.debug(tc, "getDomainId() type=domain on thread but domain name on thread not defined, using process domain or admin");
                            }
                        }
                    } else {
                        id = _processDomainName;
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainId() type=domain on thread with no domain name, using process domain or admin");
                        }
                    }
                } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDomainId() unknown resource type: " + res.getType() + ". Using admin config");
                }
            }
            if (id != null) {
                id = "domain:" + id;
            }
        }
        if (id == null) {
            id = "admin";
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainId() " + id);
        }
        return id;
    }

    @Override
    public String getDomainId(SecurityConfigResource res) {
        String resType;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainId(res)", res);
        }
        String id = null;
        if (_isNodeAgent) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDomainId(res) in " + _processType + " process, returning 'admin'");
            }
            return "admin";
        }
        if (this.isMixedCluster()) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDomainName in mixed cluster, returning 'admin'");
            }
            return "admin";
        }
        if (_processDomainScanDone && _processDomainName == null && !_sibusDomainFound && !this.isMultiDomainDefined()) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDomainId(res) no domains defined for this process, returning 'admin'");
            }
            return "admin";
        }
        if (!_processDomainScanDone) {
            this.scanDomains();
        }
        if (res != null && !(resType = res.getType()).equalsIgnoreCase("admin")) {
            if (resType.equalsIgnoreCase("application")) {
                id = _processDomainName;
            } else if (resType.equalsIgnoreCase("SIBus")) {
                String resName = res.getName();
                if (resName != null && resName.length() > 0) {
                    id = _sibusDomainMap.get(resName);
                    if (id == null) {
                        id = _cellDomainName;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainId(res) type=SIBus on thread with no bus name, using cell domain or admin");
                        }
                    }
                } else {
                    id = _cellDomainName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDomainId(res) type=SIBus on thread with no bus name, using cell domain or admin");
                    }
                }
            } else if (resType.equalsIgnoreCase("domain")) {
                String resName = res.getName();
                if (resName != null && resName.length() > 0) {
                    if (_domainSet.contains(resName)) {
                        id = resName;
                    } else {
                        id = _processDomainName;
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainId(res) type=domain on thread but domain name on thread not defined, using process domain or admin");
                        }
                    }
                } else {
                    id = _processDomainName;
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDomainId(res) type=domain on thread with no domain name, using process domain or admin");
                    }
                }
            } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getDomainId(res) unknown resource type: " + res.getType() + ". Using admin config");
            }
        }
        if (id != null) {
            id = "domain:" + id;
        }
        if (id == null) {
            id = "admin";
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainId(res) " + id);
        }
        return id;
    }

    @Override
    public String getDomainName() {
        SecurityConfigResource res;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainName");
        }
        if (_isAdminAgent || _isNodeAgent) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDomainName in process type " + _processType + ", returning null");
            }
            return null;
        }
        if (this.isMixedCluster()) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDomainName in mixed cluster, returning null");
            }
            return null;
        }
        if (!_processDomainScanDone && RasHelper.isServer()) {
            this.scanDomains();
        }
        if ((res = SecurityObjectLocator.peekContext()) != null) {
            if (res.getType().equalsIgnoreCase("SIBus")) {
                String domain = _sibusDomainMap.get(res.getName());
                if (domain == null) {
                    domain = _cellDomainName;
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDomainName no domain found for SIBus " + res.getName() + ", returning process domain " + domain);
                    }
                } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDomainName returning domain " + domain + " for SIBus " + res.getName());
                }
                return domain;
            }
            if (res.getType().equalsIgnoreCase("domain")) {
                String domain = res.getName();
                if (_domainSet.contains(domain)) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDomainName returning domain " + domain + " for SIBus " + res.getName());
                    }
                } else {
                    domain = _processDomainName;
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDomainName no domain found for name " + res.getName() + ", returning process domain " + domain);
                    }
                }
                return domain;
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainName", _processDomainName);
        }
        return _processDomainName;
    }

    private void scanDomains() {
        block38: {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.entry(tc, "scanDomains");
            }
            if (!ManagementScopeManager.isInitialized()) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "scanDomains ManagementScopeManager not initialized, returning");
                }
                return;
            }
            if (_isAdminAgent || _isNodeAgent) {
                _processDomainScanDone = true;
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "scanDomains in process type " + _processType + ", ignoring securitydomains");
                }
                return;
            }
            if (this.isMixedCluster()) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "scanDomains in mixed cluster, ignoring securitydomains");
                }
                return;
            }
            if (!this._serverSecurityXMLCheckDone) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "scanDomains checking for server level security.xml");
                }
                this._serverSecurityXMLExists = SecurityConfigManagerImpl.loadTopLevelObjectFromRCS("security.xml", "server") != null;
                this._serverSecurityXMLCheckDone = true;
            }
            if (this._serverSecurityXMLExists) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "scanDomains server level security.xml exists, ignoring any domains");
                }
                _processDomainScanDone = true;
                return;
            }
            try {
                ConfigService configService = WsServiceRegistry.getService(this, ConfigService.class);
                ConfigScope scope = configService.createScope(0);
                String[] domains = scope.list("../../waspolicies/default/securitydomains");
                if (domains != null) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "scanDomains - domain list found");
                    }
                    ManagementScopeManager scopeMgr = ManagementScopeManager.getInstance();
                    int currentLowestMatchingScope = 1000;
                    int lowestLevelScopeAllowed = 500;
                    String clusterName = null;
                    if (!_isDeploymentManager) {
                        clusterName = scopeMgr.getClusterName();
                    }
                    if (clusterName != null && clusterName != "") {
                        lowestLevelScopeAllowed = 700;
                    }
                    for (int i = 0; i < domains.length && currentLowestMatchingScope > lowestLevelScopeAllowed; ++i) {
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "scanDomains - domain name: " + domains[i]);
                        }
                        _domainSet.add(domains[i]);
                        List resource = configService.getDocumentObjects(scope, "../../waspolicies/default/securitydomains/" + domains[i] + "/domain-security-map.xml");
                        ConfigObject doc = (ConfigObject)resource.get(0);
                        List members = doc.getObjectList("members");
                        for (int j = 0; j < members.size(); ++j) {
                            ConfigObject member = (ConfigObject)members.get(j);
                            String resourceName = member.getString("resourceName", null);
                            String resourceType = member.getString("resourceType", null);
                            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                Tr.debug(tc, "scanDomains - resourceName: " + (resourceName != null ? resourceName : "null"));
                                Tr.debug(tc, "scanDomains - resourceType: " + (resourceType != null ? resourceType : "null"));
                            }
                            if (resourceName != null && resourceType != null) {
                                int scopeValue = 0;
                                if (resourceType.equalsIgnoreCase("SIBus")) {
                                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                                        Tr.exit(tc, "getDomainName mapping SIBus " + resourceName + " to domain " + domains[i]);
                                    }
                                    _sibusDomainMap.put(resourceName, domains[i]);
                                    _sibusDomainFound = true;
                                    continue;
                                }
                                if (currentLowestMatchingScope <= lowestLevelScopeAllowed) continue;
                                if (resourceType.equalsIgnoreCase("Cell")) {
                                    scopeValue = 900;
                                } else if (resourceType.equalsIgnoreCase("NodeGroup")) {
                                    scopeValue = 800;
                                } else if (resourceType.equalsIgnoreCase("Node")) {
                                    scopeValue = 600;
                                } else if (resourceType.equalsIgnoreCase("ServerCluster") || resourceType.equalsIgnoreCase("Cluster")) {
                                    scopeValue = 700;
                                } else if (resourceType.equalsIgnoreCase("Server")) {
                                    scopeValue = 500;
                                } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "scanDomains - invalid resource type");
                                }
                                if (!_isDeploymentManager && scopeValue > 0 && scopeValue >= lowestLevelScopeAllowed && scopeValue < currentLowestMatchingScope && scopeMgr.currentScopeContained(resourceName, 2)) {
                                    currentLowestMatchingScope = scopeValue;
                                    _processDomainName = domains[i];
                                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "scanDomains - lower level scope match found");
                                    }
                                }
                                if (scopeValue != 900) continue;
                                _cellDomainName = domains[i];
                                if (!_isDeploymentManager) continue;
                                _processDomainName = domains[i];
                                continue;
                            }
                            if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "scanDomains - invalid resource name or type");
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) break block38;
                Tr.debug(tc, "scanDomains - unexpected exception", e);
            }
        }
        _processDomainScanDone = true;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "scanDomains", _processDomainName == null ? "null" : _processDomainName);
        }
    }

    @Override
    public String getDomain() {
        return this.getDomainName();
    }

    @Override
    public String getString(SecurityConfigObject baseObject, String descriptor, String attrname, String defaultValue, boolean decode, boolean expand) {
        String value;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getString()", new Object[]{baseObject, descriptor, attrname, defaultValue, decode, expand});
        }
        String cacheKey = this.getAbsoluteDescriptor(baseObject, descriptor) + CFG_ATTR_DELIM + attrname;
        if (!expand && !decode) {
            cacheKey = cacheKey + CFG_ATTR_DELIM + CFG_UNEXPANDED_KEY;
        }
        if ((value = (String)this.getCache(baseObject).get(cacheKey)) == null) {
            SecurityConfigObject sco;
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getString() attribute: " + cacheKey + " not found in cache");
            }
            if ((sco = (SecurityConfigObject)this.getObject(baseObject, descriptor, false, 0, true)) != null) {
                ConfigObject rcsObject = ((SecurityConfigObjectImpl)sco).getConfigObject();
                value = decode || !expand ? rcsObject.getUnexpandedString(attrname, defaultValue) : rcsObject.getString(attrname, defaultValue);
            }
            if (value != null) {
                this.getCache(baseObject).put(cacheKey, value);
            }
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getString() attribute: " + cacheKey + ", value: " + value + " found in cache");
        }
        if (value != null && decode) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getString() encoded value: " + value);
            }
            value = ConfigHelper.decodePassword(value);
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getString() decoded value is: " + value);
            }
            if (expand) {
                block22: {
                    if (_variableMap == null) {
                        try {
                            _variableMap = WsServiceRegistry.getService(SecurityConfigManagerImpl.class, VariableMap.class);
                        }
                        catch (Exception e) {
                            if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) break block22;
                            Tr.debug(tc, "getString() Exception getting VariableMap service: " + e);
                        }
                    }
                }
                if (_variableMap != null) {
                    value = _variableMap.expand(value);
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getString() decoded and expanded value is: " + value);
                    }
                } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getString() decode and expand requested but _variableMap is null");
                }
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            if (cacheKey.toLowerCase().indexOf("password") != -1) {
                Tr.exit(tc, "getString()", new Object[]{ConfigUtils.mask(value)});
            } else {
                Tr.exit(tc, "getString()", new Object[]{value});
            }
        }
        return value;
    }

    @Override
    public List getStringList(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringList()", new Object[]{baseObject, descriptor});
        }
        List stringList = (List)this.getObject(baseObject, descriptor, true, 2, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringList()", stringList);
        }
        return stringList;
    }

    @Override
    public Integer getInteger(SecurityConfigObject baseObject, String descriptor, String attrname, int defaultValue) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInteger()", new Object[]{baseObject, descriptor, attrname, defaultValue});
        }
        String cacheKey = this.getAbsoluteDescriptor(baseObject, descriptor) + CFG_ATTR_DELIM + attrname;
        Integer value = (Integer)this.getCache(baseObject).get(cacheKey);
        if (value == null) {
            SecurityConfigObject sco;
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getInteger() attribute: " + cacheKey + " not found in cache");
            }
            if ((sco = (SecurityConfigObject)this.getObject(baseObject, descriptor, false, 0, true)) != null) {
                ConfigObject rcsObject = ((SecurityConfigObjectImpl)sco).getConfigObject();
                value = rcsObject.getInt(attrname, defaultValue);
            }
            if (value != null) {
                this.getCache(baseObject).put(cacheKey, value);
            }
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getInteger() value: " + cacheKey + " found in cache");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInteger()", new Object[]{value});
        }
        return value;
    }

    @Override
    public List getIntegerList(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getIntegerList()", new Object[]{baseObject, descriptor});
        }
        List integerList = (List)this.getObject(baseObject, descriptor, true, 3, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getIntegerList()", integerList);
        }
        return integerList;
    }

    @Override
    public Float getFloat(SecurityConfigObject baseObject, String descriptor, String attrname, float defaultValue) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFloat()", new Object[]{baseObject, descriptor, attrname, Float.valueOf(defaultValue)});
        }
        String cacheKey = this.getAbsoluteDescriptor(baseObject, descriptor) + CFG_ATTR_DELIM + attrname;
        Float value = (Float)this.getCache(baseObject).get(cacheKey);
        if (value == null) {
            SecurityConfigObject sco;
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getFloat() attribute: " + cacheKey + " not found in cache");
            }
            if ((sco = (SecurityConfigObject)this.getObject(baseObject, descriptor, false, 0, true)) != null) {
                ConfigObject rcsObject = ((SecurityConfigObjectImpl)sco).getConfigObject();
                value = new Float(rcsObject.getFloat(attrname, defaultValue));
            }
            if (value != null) {
                this.getCache(baseObject).put(cacheKey, value);
            }
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getFloat() value: " + cacheKey + " found in cache");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFloat()", new Object[]{value});
        }
        return value;
    }

    @Override
    public List getFloatList(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFloatList()", new Object[]{baseObject, descriptor});
        }
        List floatList = (List)this.getObject(baseObject, descriptor, true, 6, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFloatList()", floatList);
        }
        return floatList;
    }

    @Override
    public Long getLong(SecurityConfigObject baseObject, String descriptor, String attrname, long defaultValue) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLong()", new Object[]{baseObject, descriptor, attrname, defaultValue});
        }
        String cacheKey = this.getAbsoluteDescriptor(baseObject, descriptor) + CFG_ATTR_DELIM + attrname;
        Long value = (Long)this.getCache(baseObject).get(cacheKey);
        if (value == null) {
            SecurityConfigObject sco;
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getLong() attribute: " + cacheKey + " not found in cache");
            }
            if ((sco = (SecurityConfigObject)this.getObject(baseObject, descriptor, false, 0, true)) != null) {
                ConfigObject rcsObject = ((SecurityConfigObjectImpl)sco).getConfigObject();
                value = rcsObject.getLong(attrname, defaultValue);
            }
            if (value != null) {
                this.getCache(baseObject).put(cacheKey, value);
            }
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getLong() value: " + cacheKey + " found in cache");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLong()", new Object[]{value});
        }
        return value;
    }

    @Override
    public List getLongList(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLongList()", new Object[]{baseObject, descriptor});
        }
        List longList = (List)this.getObject(baseObject, descriptor, true, 4, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLongList()", longList);
        }
        return longList;
    }

    @Override
    public Boolean getBoolean(SecurityConfigObject baseObject, String descriptor, String attrname, boolean defaultValue) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoolean()", new Object[]{baseObject, descriptor, attrname, defaultValue});
        }
        String cacheKey = this.getAbsoluteDescriptor(baseObject, descriptor) + CFG_ATTR_DELIM + attrname;
        Boolean value = (Boolean)this.getCache(baseObject).get(cacheKey);
        if (value == null) {
            SecurityConfigObject sco;
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getBoolean() attribute: " + cacheKey + " not found in cache");
            }
            if ((sco = (SecurityConfigObject)this.getObject(baseObject, descriptor, false, 0, true)) != null) {
                ConfigObject rcsObject = ((SecurityConfigObjectImpl)sco).getConfigObject();
                value = rcsObject.getBoolean(attrname, defaultValue);
            }
            if (value != null) {
                this.getCache(baseObject).put(cacheKey, value);
            }
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getBoolean() value: " + cacheKey + " found in cache");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoolean()", new Object[]{value});
        }
        return value;
    }

    @Override
    public List getBooleanList(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBooleanList()", new Object[]{baseObject, descriptor});
        }
        List booleanList = (List)this.getObject(baseObject, descriptor, true, 5, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBooleanList()", booleanList);
        }
        return booleanList;
    }

    private SecurityConfigObject getRootObject(String descriptor, boolean inherit) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootObject()", new Object[]{descriptor, inherit});
        }
        SecurityConfigObject sco = null;
        String fileName = null;
        String desc = null;
        boolean domainConfig = false;
        if (descriptor.equalsIgnoreCase("AppSecurity")) {
            domainConfig = true;
            if (this.isAdminAgent()) {
                fileName = "security.xml";
                desc = "Security";
            } else {
                fileName = "domain-security.xml";
                desc = "AppSecurity";
            }
        } else if (descriptor.equalsIgnoreCase("security")) {
            fileName = "security.xml";
            desc = "Security";
        } else if (descriptor.equalsIgnoreCase("Audit")) {
            fileName = "audit.xml";
            desc = "Audit";
        }
        if (fileName != null) {
            sco = this.getRootObject(fileName, desc, null, domainConfig, inherit, false);
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRootObject() unknown root descriptor " + descriptor);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootObject()", sco);
        }
        return sco;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityConfigObject getRootObject(String fileName, String descriptor, String scope, boolean domainConfig, boolean inherit, boolean doCache) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootObject()", new Object[]{fileName, descriptor, scope, domainConfig, inherit, doCache});
        }
        SecurityConfigObject sco = null;
        if (fileName != null) {
            String configPath = null;
            if (!domainConfig) {
                configPath = this._cellConfigPath;
            } else {
                if (this.isAdminAgent()) {
                    String id = AdminContext.peek();
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getRootObject() AdminAgent profile id: " + id);
                    }
                    if (id != null) {
                        boolean pushed = false;
                        try {
                            pushed = AdminContext.push(null);
                            Map profileMap = this.getProfileRegistry().lookupProfile(id);
                            configPath = (String)profileMap.get("profile.registry.profile.root") + "/config/cells/" + (String)profileMap.get("profile.registry.cell.name");
                        }
                        finally {
                            if (pushed) {
                                AdminContext.pop();
                            }
                        }
                    }
                } else {
                    String domain = this.getDomainName();
                    if (domain != null) {
                        configPath = this._cellConfigPath + "/../../waspolicies/default/securitydomains/" + domain;
                    }
                }
                if (inherit && configPath == null) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getRootObject() domain config requested but no domain found, using cell config");
                    }
                    fileName = "security.xml";
                    descriptor = "Security";
                    configPath = this._cellConfigPath;
                    domainConfig = false;
                }
            }
            if (configPath != null) {
                Map<String, Object> cache = null;
                if (doCache) {
                    cache = this.getCache(configPath + "/" + fileName);
                    sco = (SecurityConfigObject)cache.get(descriptor);
                }
                if (sco == null) {
                    ConfigObject rcsObject;
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getRootObject() " + descriptor + " object not found in cache");
                    }
                    if ((rcsObject = SecurityConfigManagerImpl.loadTopLevelObjectFromRCS(configPath + "/" + fileName, "")) != null) {
                        sco = new SecurityConfigObjectImpl(rcsObject, descriptor, descriptor, fileName, configPath, domainConfig, cache);
                        if (doCache) {
                            cache.put(descriptor, sco);
                        }
                    }
                } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRootObject() " + descriptor + " object found in cache");
                }
            } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getRootObject() no domain defined and inherit false, returning null");
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootObject()", new Object[]{sco});
        }
        return sco;
    }

    @Override
    public SecurityConfigObject getObject(String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject()", new Object[]{descriptor});
        }
        SecurityConfigObject sco = this.getObject(descriptor, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject()", new Object[]{sco});
        }
        return sco;
    }

    @Override
    public SecurityConfigObject getObject(String descriptor, boolean inherit) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject()", new Object[]{descriptor, inherit});
        }
        SecurityConfigObject sco = null;
        String fileName = null;
        String desc = null;
        boolean domainConfig = false;
        String[] descriptors = descriptor.split(CFG_OBJ_DELIM, 2);
        String topLevelDescriptor = descriptors[0];
        if (topLevelDescriptor.equalsIgnoreCase("AppSecurity")) {
            domainConfig = true;
            if (_isAdminAgent) {
                fileName = "security.xml";
                desc = "Security";
            } else {
                fileName = "domain-security.xml";
                desc = "AppSecurity";
            }
        } else if (topLevelDescriptor.equalsIgnoreCase("security")) {
            fileName = "security.xml";
            desc = "Security";
        } else if (topLevelDescriptor.equalsIgnoreCase("Audit")) {
            fileName = "audit.xml";
            desc = "Audit";
        }
        if (fileName != null) {
            sco = this.getRootObject(fileName, desc, null, domainConfig, inherit, true);
            if (sco != null && descriptors.length > 1) {
                sco = (SecurityConfigObject)this.getObject(sco, descriptors[1], false, 0, inherit);
            }
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getObject() unknown root descriptor " + topLevelDescriptor);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject()", new Object[]{sco});
        }
        return sco;
    }

    @Override
    public SecurityConfigObject getObject(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject()", new Object[]{baseObject, descriptor});
        }
        SecurityConfigObject sco = (SecurityConfigObject)this.getObject(baseObject, descriptor, false, 0, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject()", new Object[]{sco});
        }
        return sco;
    }

    @Override
    public SecurityConfigObject getObject(SecurityConfigObject baseObject, String descriptor, boolean inherit) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject()", new Object[]{baseObject, descriptor, inherit});
        }
        SecurityConfigObject sco = (SecurityConfigObject)this.getObject(baseObject, descriptor, false, 0, inherit);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject()", new Object[]{sco});
        }
        return sco;
    }

    private Object getObject(SecurityConfigObject baseObject, String descriptor, boolean isList, int listType, boolean inherit) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject()", new Object[]{baseObject, descriptor, isList, listType, inherit});
        }
        String cacheKey = this.getAbsoluteDescriptor(baseObject, descriptor);
        Map<String, Object> cache = this.getCache(baseObject);
        Object configObject = cache.get(cacheKey);
        if (configObject != null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObject() object: " + cacheKey + " found in cache");
            }
            if (configObject instanceof SecurityConfigCacheReference) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObject() object: " + cacheKey + " found cache reference object: " + configObject);
                }
                configObject = inherit ? ((SecurityConfigCacheReference)configObject).getTargetObject() : null;
            }
        } else {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObject() object: " + cacheKey + " not found in cache");
            }
            configObject = this.getObjectFromRCS(baseObject, descriptor, isList, listType);
            if (inherit && (configObject == null || isList && listType == 1 && ((SecurityConfigObjectList)configObject).size() == 0)) {
                Object lowerLevelConfigObject = configObject;
                String topLevelDescriptor = null;
                String[] descriptors = cacheKey.split(CFG_OBJ_DELIM, 2);
                if (descriptors.length == 1) {
                    descriptors = cacheKey.split(CFG_ATTR_DELIM, 2);
                }
                if ((topLevelDescriptor = descriptors[0]) != null) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObject() looking for parent config file of: " + baseObject.getConfigFileName());
                    }
                    String parentFile = null;
                    String parentDescriptor = null;
                    if (topLevelDescriptor.equals("AppSecurity")) {
                        parentFile = "security.xml";
                        parentDescriptor = "Security";
                    }
                    if (parentFile != null) {
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getObject() parent config file of: " + baseObject.getConfigFileName() + " is: " + parentFile);
                        }
                        configObject = this.getRootObject(parentFile, parentDescriptor, null, false, false, true);
                        if (descriptors.length > 1 && (configObject = this.getObject((SecurityConfigObject)configObject, descriptors[1], isList, listType, inherit)) == null) {
                            configObject = lowerLevelConfigObject;
                        }
                    } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObject() inherit requested and no parent defined for: " + baseObject.getConfigFileName());
                    }
                }
                SecurityConfigCacheReference cacheObject = new SecurityConfigCacheReference(configObject);
                cache.put(cacheKey, cacheObject);
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObject() adding cache ref object: " + cacheObject);
                }
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject()", new Object[]{configObject});
        }
        return configObject;
    }

    @Override
    public SecurityConfigObjectList getObjectList(String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectList()", new Object[]{descriptor});
        }
        String[] descriptors = descriptor.split(CFG_OBJ_DELIM, 2);
        SecurityConfigObject sco = this.getObject(descriptors[0], true);
        SecurityConfigObjectList scol = (SecurityConfigObjectList)this.getObject(sco, descriptors[1], true, 1, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectList()", new Object[]{scol});
        }
        return scol;
    }

    @Override
    public SecurityConfigObjectList getObjectList(String descriptor, boolean inherit) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectList()", new Object[]{descriptor, inherit});
        }
        String[] descriptors = descriptor.split(CFG_OBJ_DELIM, 2);
        SecurityConfigObject sco = this.getObject(descriptors[0], inherit);
        SecurityConfigObjectList scol = null;
        if (sco != null) {
            scol = (SecurityConfigObjectList)this.getObject(sco, descriptors[1], true, 1, inherit);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectList()", new Object[]{scol});
        }
        return scol;
    }

    @Override
    public SecurityConfigObjectList getObjectList(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectList()", new Object[]{baseObject, descriptor});
        }
        SecurityConfigObjectList scol = (SecurityConfigObjectList)this.getObject(baseObject, descriptor, true, 1, true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectList()", new Object[]{scol});
        }
        return scol;
    }

    @Override
    public SecurityConfigObjectList getObjectList(SecurityConfigObject baseObject, String descriptor, boolean inherit) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectList()", new Object[]{baseObject, descriptor, inherit});
        }
        SecurityConfigObjectList scol = (SecurityConfigObjectList)this.getObject(baseObject, descriptor, true, 1, inherit);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectList()", new Object[]{scol});
        }
        return scol;
    }

    private Object getObjectFromRCS(SecurityConfigObject baseObject, String objDescriptor, boolean isList, int listType) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectFromRCS()", new Object[]{baseObject, objDescriptor, isList, listType});
        }
        if (objDescriptor == null || objDescriptor.equals("")) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectFromRCS() object descriptor null, returning baseObject");
            }
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectFromRCS()", new Object[]{baseObject});
            }
            return baseObject;
        }
        String[] objectDescriptors = objDescriptor.split(CFG_OBJ_DELIM);
        List objList = null;
        ConfigObject currentRCSObject = null;
        String currentObjectDescriptor = null;
        String tag = null;
        Object currentObject = null;
        String configFilePath = null;
        String configFileName = null;
        boolean isDomainConfig = false;
        Map<String, Object> cache = null;
        if (baseObject != null) {
            currentRCSObject = ((SecurityConfigObjectImpl)baseObject).getConfigObject();
            currentObjectDescriptor = baseObject.getDescriptor();
            cache = this.getCache(baseObject);
            configFilePath = baseObject.getConfigFilePath();
            configFileName = baseObject.getConfigFileName();
            isDomainConfig = baseObject.isDomainConfig();
        } else {
            SecurityConfigObject topLevelObject = this.getObject(objectDescriptors[0], false);
            if (topLevelObject == null) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObjectFromRCS() error getting object " + objectDescriptors[0]);
                }
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getObjectFromRCS()", new Object[]{null});
                }
                return null;
            }
            currentRCSObject = ((SecurityConfigObjectImpl)topLevelObject).getConfigObject();
            currentObjectDescriptor = topLevelObject.getDescriptor();
            cache = this.getCache(topLevelObject);
            configFilePath = topLevelObject.getConfigFilePath();
            configFileName = topLevelObject.getConfigFileName();
            isDomainConfig = topLevelObject.isDomainConfig();
        }
        block12: for (int i = 0; i < objectDescriptors.length && currentRCSObject != null; ++i) {
            boolean isLastObject;
            String cacheKey = null;
            cacheKey = i == 0 && baseObject == null ? currentObjectDescriptor : currentObjectDescriptor + CFG_OBJ_DELIM + objectDescriptors[i];
            currentObject = cache.get(cacheKey);
            boolean bl = isLastObject = i == objectDescriptors.length - 1;
            if (currentObject != null) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObjectFromRCS() object: " + cacheKey + " found in cache");
                }
                currentObjectDescriptor = cacheKey;
                if (currentObject instanceof SecurityConfigObjectImpl) {
                    currentRCSObject = ((SecurityConfigObjectImpl)currentObject).getConfigObject();
                    continue;
                }
                if (currentObject instanceof SecurityConfigObjectListImpl) {
                    if (isLastObject && isList) continue;
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObjectFromRCS() List object: " + tag + " is not last descriptor or list not requested");
                    }
                    currentObject = null;
                    currentRCSObject = null;
                    continue;
                }
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObjectFromRCS() object: " + tag + " not SecurityConfigObjectImpl or SecurityConfigObjectListImpl");
                }
                currentObject = null;
                currentRCSObject = null;
                continue;
            }
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectFromRCS() object: " + cacheKey + " not found in cache");
            }
            String[] descriptorParts = objectDescriptors[i].split(CFG_ATTR_DELIM);
            tag = descriptorParts[0];
            switch (descriptorParts.length) {
                case 1: {
                    currentObjectDescriptor = cacheKey;
                    if (isLastObject && isList) {
                        switch (listType) {
                            case 1: {
                                objList = currentRCSObject.getObjectList(tag);
                                break;
                            }
                            case 2: {
                                objList = currentRCSObject.getStringList(tag);
                                break;
                            }
                            case 3: {
                                objList = currentRCSObject.getIntList(tag);
                                break;
                            }
                            case 4: {
                                objList = currentRCSObject.getLongList(tag);
                                break;
                            }
                            case 5: {
                                objList = currentRCSObject.getBooleanList(tag);
                                break;
                            }
                            case 6: {
                                objList = currentRCSObject.getFloatList(tag);
                            }
                        }
                        objList = currentRCSObject.getObjectList(tag);
                        if (objList == null) {
                            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                Tr.debug(tc, "getObjectFromRCS() List object: " + tag + " not found in RCS");
                            }
                            currentRCSObject = null;
                            continue block12;
                        }
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getObjectFromRCS() List object: " + objectDescriptors[i] + " found in RCS");
                        }
                        currentObject = new SecurityConfigObjectListImpl(objList, currentObjectDescriptor, tag, configFileName, configFilePath, isDomainConfig, cache);
                        cache.put(currentObjectDescriptor, currentObject);
                        continue block12;
                    }
                    if (i == 0 && baseObject == null) {
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getObjectFromRCS() object: " + tag + ". using existing top level config object");
                        }
                        currentObject = this.getObject(objectDescriptors[0], false);
                        currentRCSObject = ((SecurityConfigObjectImpl)currentObject).getConfigObject();
                        continue block12;
                    }
                    if ((currentRCSObject = currentRCSObject.getObject(tag)) == null) {
                        if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) continue block12;
                        Tr.debug(tc, "getObjectFromRCS() object: " + tag + " not found in RCS");
                        continue block12;
                    }
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObjectFromRCS() object: " + tag + " found in RCS");
                    }
                    currentObject = new SecurityConfigObjectImpl(currentRCSObject, currentObjectDescriptor, tag, configFileName, configFilePath, isDomainConfig, cache);
                    cache.put(currentObjectDescriptor, currentObject);
                    continue block12;
                }
                case 2: {
                    String[] attr_and_value;
                    if (isLastObject && isList) {
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getObjectFromRCS() list requested but attr=value supplied for final object: " + objectDescriptors[i]);
                        }
                        currentRCSObject = null;
                    }
                    if ((attr_and_value = descriptorParts[1].split(CFG_VALUE_DELIM)).length != 2) {
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getObjectFromRCS() invalid object descriptor: " + objectDescriptors[i]);
                        }
                        currentRCSObject = null;
                        continue block12;
                    }
                    String attribute = attr_and_value[0];
                    String value = attr_and_value[1];
                    String listDescriptor = currentObjectDescriptor + CFG_OBJ_DELIM + tag;
                    SecurityConfigObjectList objectList = (SecurityConfigObjectList)cache.get(listDescriptor);
                    if (objectList == null) {
                        List rcsList = currentRCSObject.getObjectList(tag);
                        if (rcsList == null) {
                            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                Tr.debug(tc, "getObjectFromRCS() list object: " + tag + " not found in RCS");
                            }
                            currentRCSObject = null;
                        } else {
                            objectList = new SecurityConfigObjectListImpl(rcsList, listDescriptor, tag, configFileName, configFilePath, isDomainConfig, cache);
                            cache.put(listDescriptor, objectList);
                        }
                    } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObjectFromRCS() object list: " + listDescriptor + " found in cache");
                    }
                    if (objectList == null) continue block12;
                    currentObject = this.getObjectFromList(objectList, attribute, value);
                    if (currentObject != null) {
                        currentRCSObject = ((SecurityConfigObjectImpl)currentObject).getConfigObject();
                        currentObjectDescriptor = currentObjectDescriptor + CFG_OBJ_DELIM + objectDescriptors[i];
                        continue block12;
                    }
                    currentRCSObject = null;
                    continue block12;
                }
                default: {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObjectFromRCS() invalid object descriptor: " + objectDescriptors[i]);
                    }
                    currentRCSObject = null;
                }
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectFromRCS()", new Object[]{currentObject});
        }
        return currentObject;
    }

    @Override
    public SecurityConfigObject getObjectFromList(SecurityConfigObjectList securityConfigObjectList, String attribute, String identifier) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectFromList()", new Object[]{securityConfigObjectList, attribute, identifier});
        }
        String listDescriptor = securityConfigObjectList.getDescriptor();
        String tag = securityConfigObjectList.getTag();
        String cacheKey = null;
        String searchAttr = null;
        SecurityConfigObject result = null;
        if (attribute == null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectFromList() no attribute specified");
            }
        } else {
            searchAttr = attribute;
        }
        if (searchAttr != null) {
            cacheKey = listDescriptor + CFG_ATTR_DELIM + searchAttr + CFG_VALUE_DELIM + identifier;
            result = (SecurityConfigObject)this.getCache(securityConfigObjectList).get(cacheKey);
            if (result == null) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObjectFromList() object: " + cacheKey + " not found in cache");
                }
                boolean found = false;
                for (int i = 0; i < securityConfigObjectList.size() && !found; ++i) {
                    result = this.getObjectFromList(securityConfigObjectList, i);
                    if (result == null) {
                        if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "getObjectFromList() object in list " + tag + " at index " + i + " is null");
                        continue;
                    }
                    String value = result.getString(searchAttr);
                    if (value == null || !value.equals(identifier)) continue;
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObjectFromList() object: " + cacheKey + " found");
                    }
                    found = true;
                }
                if (!found) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getObjectFromList() object: " + cacheKey + " not found in RCS");
                    }
                } else {
                    this.getCache(securityConfigObjectList).put(cacheKey, result);
                }
            } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectFromList() object: " + cacheKey + " found in cache");
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectFromList()", new Object[]{result});
        }
        return result;
    }

    @Override
    public SecurityConfigObject getObjectFromList(SecurityConfigObjectList securityConfigObjectList, int index) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectFromList()", new Object[]{securityConfigObjectList, index});
        }
        String cacheKey = securityConfigObjectList.getDescriptor() + CFG_ATTR_DELIM + "_index_" + index;
        SecurityConfigObject result = (SecurityConfigObject)this.getCache(securityConfigObjectList).get(cacheKey);
        if (result == null) {
            List rcsObjList;
            ConfigObject rcsObject;
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectFromList() object: " + cacheKey + " not found in cache");
            }
            if ((rcsObject = (ConfigObject)(rcsObjList = securityConfigObjectList.getList()).get(index)) == null) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObjectFromList() index " + index + " not found in RCS");
                }
            } else {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObjectFromList() index " + index + " found in RCS");
                }
                Map<String, Object> cache = this.getCache(securityConfigObjectList);
                result = new SecurityConfigObjectImpl(rcsObject, cacheKey, securityConfigObjectList.getTag(), securityConfigObjectList.getConfigFileName(), securityConfigObjectList.getConfigFilePath(), securityConfigObjectList.isDomainConfig(), cache);
                cache.put(cacheKey, result);
            }
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getObjectFromList() object: " + cacheKey + " found in cache");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectFromList()", new Object[]{result});
        }
        return result;
    }

    @Override
    public Properties getProperties(String descriptor, String propTag) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties()", new Object[]{descriptor, propTag});
        }
        Properties props = this.getProperties(this.getObject(descriptor), propTag);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties()", new Object[]{props});
        }
        return props;
    }

    @Override
    public Properties getProperties(String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties()", new Object[]{descriptor});
        }
        Properties props = this.getProperties(this.getObject(descriptor), "properties");
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties()", new Object[]{props});
        }
        return props;
    }

    @Override
    public Properties getProperties(SecurityConfigObject secCfgObject, String propTag) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties()", new Object[]{secCfgObject, propTag});
        }
        String cacheKey = secCfgObject.getDescriptor() + CFG_ATTR_DELIM + propTag;
        Properties props = (Properties)this.getCache(secCfgObject).get(cacheKey);
        if (props == null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getProperties() Properties object: " + cacheKey + " not found in cache");
            }
            SecurityConfigObjectList secCfgObjList = this.getObjectList(secCfgObject, propTag);
            List rcsObjList = secCfgObjList.getList();
            props = new Properties();
            if (rcsObjList != null) {
                for (int i = 0; i < rcsObjList.size(); ++i) {
                    ConfigObject rcsObject = (ConfigObject)rcsObjList.get(i);
                    props.put(rcsObject.getString("name", null), rcsObject.getString("value", null));
                }
            }
            this.getCache(secCfgObject).put(cacheKey, props);
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "getProperties() Properties object: " + cacheKey + " found in cache");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties()", new Object[]{props});
        }
        return props;
    }

    @Override
    public Properties getProperties(SecurityConfigObject secCfgObject, String propTag, boolean inherit) {
        List rcsObjList;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties()", new Object[]{secCfgObject, propTag, inherit});
        }
        Properties props = new Properties();
        SecurityConfigObjectList secCfgObjList = this.getObjectList(secCfgObject, propTag, inherit);
        if (secCfgObjList != null && (rcsObjList = secCfgObjList.getList()) != null) {
            for (int i = 0; i < rcsObjList.size(); ++i) {
                ConfigObject rcsObject = (ConfigObject)rcsObjList.get(i);
                props.put(rcsObject.getString("name", null), rcsObject.getString("value", null));
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties()", new Object[]{props});
        }
        return props;
    }

    @Override
    public Properties getProperties(List rcsObjList) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties() from List", new Object[]{rcsObjList});
        }
        Properties props = new Properties();
        if (rcsObjList != null) {
            for (int i = 0; i < rcsObjList.size(); ++i) {
                ConfigObject rcsObject = (ConfigObject)rcsObjList.get(i);
                props.put(rcsObject.getString("name", null), rcsObject.getString("value", null));
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties() from List", new Object[]{props});
        }
        return props;
    }

    private String getAbsoluteDescriptor(SecurityConfigObject baseObject, String descriptor) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAbsoluteDescriptor()", new Object[]{baseObject, descriptor});
        }
        String fullDescriptor = null;
        if (baseObject == null) {
            fullDescriptor = descriptor;
        } else {
            fullDescriptor = baseObject.getDescriptor();
            if (descriptor != null && !descriptor.equals("")) {
                fullDescriptor = fullDescriptor + CFG_OBJ_DELIM + descriptor;
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAbsoluteDescriptor()", new Object[]{fullDescriptor});
        }
        return fullDescriptor;
    }

    public void parseConfig(ConfigObject security2) {
        int security_cacheTimeout;
        Boolean security_dynamicallyUpdateSSLConfig;
        Boolean security_appEnabled;
        Boolean security_enforceFineGrainedJCASecurity;
        Boolean security_enforceJava2Security;
        Boolean security_issuePermissionWarning;
        Boolean security_useDomainQualifiedUserNames;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "parseConfig()", new Object[]{security2});
        }
        Map<String, Object> cache = this.getCache(this.getObject("security", false));
        Boolean security_enabled = security2.getBoolean("enabled", false);
        if (security_enabled != null) {
            cache.put("Security#enabled", security_enabled);
        }
        if ((security_useDomainQualifiedUserNames = Boolean.valueOf(security2.getBoolean("useDomainQualifiedUserNames", false))) != null) {
            cache.put("Security#useDomainQualifiedUserNames", security_useDomainQualifiedUserNames);
        }
        if ((security_issuePermissionWarning = Boolean.valueOf(security2.getBoolean("issuePermissionWarning", false))) != null) {
            cache.put("Security#issuePermissionWarning", security_issuePermissionWarning);
        }
        if ((security_enforceJava2Security = Boolean.valueOf(security2.getBoolean("enforceJava2Security", false))) != null) {
            cache.put("Security#enforceJava2Security", security_enforceJava2Security);
        }
        if ((security_enforceFineGrainedJCASecurity = Boolean.valueOf(security2.getBoolean("enforceFineGrainedJCASecurity", false))) != null) {
            cache.put("Security#enforceFineGrainedJCASecurity", security_enforceFineGrainedJCASecurity);
        }
        if ((security_appEnabled = Boolean.valueOf(security2.getBoolean("appEnabled", false))) != null) {
            cache.put("Security#appEnabled", security_appEnabled);
        }
        if ((security_dynamicallyUpdateSSLConfig = Boolean.valueOf(security2.getBoolean("dynamicallyUpdateSSLConfig", false))) != null) {
            cache.put("Security#dynamicallyUpdateSSLConfig", security_dynamicallyUpdateSSLConfig);
        }
        if ((security_cacheTimeout = security2.getInt("cacheTimeout", 0)) == 0) {
            security_cacheTimeout = 10;
        }
        cache.put("Security#cacheTimeout", security_cacheTimeout);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseConfig()");
        }
    }

    @Override
    public SecurityConfigObject merge(String scope, String processType) throws SecurityConfigException, Exception {
        ConfigObject scopeSecurity;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "merge() with scope: " + scope);
        }
        SecurityConfigObject cellSecurity = this.getObject("security", false);
        Map<String, Object> cache = this.getCache(cellSecurity);
        if (processType == null) {
            processType = "server";
        }
        if ((scopeSecurity = SecurityConfigManagerImpl.loadTopLevelObjectFromRCS("security.xml", scope)) == null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() error getting RCS security object for scope: " + scope + "\n security.xml might be corrupt or missing.");
                Tr.debug(tc, "merge() this is probably normal and not a problem if no server specific security has been defined");
            }
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "merge() error getting RCS security object, returning cell security object" + cellSecurity);
            }
            return cellSecurity;
        }
        if (scopeSecurity.isSet("enabled") && !scopeSecurity.getBoolean("enabled", false)) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() security disabled in the " + processType);
            }
            cache.put("Security#enabled", Boolean.FALSE);
        }
        if (scopeSecurity.isSet("appEnabled") && !scopeSecurity.getBoolean("appEnabled", false)) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() application security disabled in the " + processType);
            }
            cache.put("Security#appEnabled", Boolean.FALSE);
        }
        if (scopeSecurity.isSet("useDomainQualifiedUserNames")) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() using useDomainQualifiedUserNames from " + processType + " security");
            }
            cache.put("Security#useDomainQualifiedUserNames", scopeSecurity.getBoolean("useDomainQualifiedUserNames", false));
        }
        if (scopeSecurity.isSet("cacheTimeout")) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() using cacheTimeout from " + processType + " security");
            }
            cache.put("Security#cacheTimeout", scopeSecurity.getInt("cacheTimeout", 0));
        }
        if (scopeSecurity.isSet("issuePermissionWarning")) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() using issuePermissionWarning from " + processType + " security");
            }
            cache.put("Security#issuePermissionWarning", scopeSecurity.getBoolean("issuePermissionWarning", false));
        }
        if (scopeSecurity.isSet("enforceJava2Security")) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() using enforceJava2Security from " + processType + " security");
            }
            cache.put("Security#enforceJava2Security", scopeSecurity.getBoolean("enforceJava2Security", false));
        }
        if (scopeSecurity.isSet("enforceFineGrainedJCASecurity")) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge() using enforceFineGrainedJCASecurity from " + processType + " security");
            }
            cache.put("Security#enforceFineGrainedJCASecurity", scopeSecurity.getBoolean("enforceFineGrainedJCASecurity", false));
        }
        this.mergeCSI(scopeSecurity, processType);
        List scopeProps = scopeSecurity.getObjectList("properties");
        Properties cellProps = cellSecurity.getProperties();
        if (scopeProps != null) {
            for (int i = 0; i < scopeProps.size(); ++i) {
                ConfigObject prop = (ConfigObject)scopeProps.get(i);
                if (prop == null) continue;
                String key = prop.getString("name", null);
                String value = prop.getString("value", null);
                if (key == null || value == null) continue;
                cellProps.put(key, value);
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "merge()", new Object[]{cellSecurity});
        }
        return cellSecurity;
    }

    private void mergeCSI(ConfigObject scopeSecurity, String processType) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeCSI()", new Object[]{scopeSecurity, processType});
        }
        SecurityConfigObject sco = this.getObject("security", false);
        Map<String, Object> cache = this.getCache(sco);
        ConfigObject csi = scopeSecurity.getObject("CSI");
        if (csi != null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "mergeCSI() using CSI configuration from " + processType + " security");
            }
            String csiDescriptor = "Security::CSI";
            for (String key : cache.keySet()) {
                if (!key.startsWith(csiDescriptor)) continue;
                cache.remove(key);
            }
            SecurityConfigObjectImpl csiObject = new SecurityConfigObjectImpl(csi, csiDescriptor, "CSI", sco.getConfigFileName(), sco.getConfigFilePath(), sco.isDomainConfig(), cache);
            cache.put(csiDescriptor, csiObject);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeCSI()");
        }
    }

    @Override
    public synchronized SecurityConfigObject refreshSSLConfig() throws SecurityConfigException {
        ConfigObject csi;
        ConfigObject security2;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshSSLConfig");
        }
        SecurityConfigObject sec2 = this.getObject("security");
        Map<String, Object> cache = this.getCache(sec2);
        String configFilePath = sec2.getConfigFilePath();
        String configFileName = sec2.getConfigFileName();
        boolean isDomainConfig = sec2.isDomainConfig();
        String[] keys = this.getCacheKeys(cache);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.startsWith("Security::CSI::claims") && !key.startsWith("Security::CSI::performs") && !key.startsWith("Security::keyStores") && !key.startsWith("Security::keyManagers") && !key.startsWith("Security::trustManagers") && !key.startsWith("Security::repertoire") && !key.startsWith("Security::keySetGroups") && !key.startsWith("Security::dynamicSSLConfigSelections") && !key.startsWith("Security#com.ibm.ssl") && !key.startsWith("Security#com.ibm.security") && !key.startsWith("Security#was.com.ibm.websphere.security.zos.csiv2")) continue;
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshSSLConfig() removing key " + key);
                }
                cache.remove(key);
            }
        }
        if ((security2 = SecurityConfigManagerImpl.loadTopLevelObjectFromRCS("security.xml", "cell")) == null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshSSLConfig() error loading cell level security.xml");
            }
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "refreshSSLConfig null");
            }
            return null;
        }
        List props = security2.getObjectList("properties");
        if (props != null) {
            Properties topLevelProps = this.getProperties("security");
            for (int i = 0; i < props.size(); ++i) {
                String name;
                ConfigObject prop = (ConfigObject)props.get(i);
                if (prop == null || (name = prop.getString("name", null)) == null || !name.startsWith("Security#com.ibm.ssl") && !name.startsWith("Security#com.ibm.security") && !name.startsWith("Security#was.com.ibm.websphere.security.zos.csiv2")) continue;
                topLevelProps.put(name, prop.getString("value", null));
            }
        }
        if ((csi = security2.getObject("CSI")) != null) {
            ConfigObject performs;
            SecurityConfigObjectImpl sco = null;
            ConfigObject claims = csi.getObject("claims");
            if (claims != null) {
                sco = new SecurityConfigObjectImpl(claims, "Security::CSI::claims", "claims", configFileName, configFilePath, isDomainConfig, cache);
                cache.put("Security::CSI::claims", sco);
            }
            if ((performs = csi.getObject("performs")) != null) {
                sco = new SecurityConfigObjectImpl(performs, "Security::CSI::performs", "performs", configFileName, configFilePath, isDomainConfig, cache);
                cache.put("Security::CSI::performs", sco);
            }
        }
        String[] sslListObjects = new String[]{"keyStores", "keyManagers", "trustManagers", "repertoire", "keySetGroups", "dynamicSSLConfigSelections"};
        for (int i = 0; i < sslListObjects.length; ++i) {
            List list = security2.getObjectList(sslListObjects[i]);
            if (list == null) continue;
            String descriptor = "Security::" + sslListObjects[i];
            SecurityConfigObjectListImpl scoList = new SecurityConfigObjectListImpl(list, descriptor, sslListObjects[i], configFileName, configFilePath, isDomainConfig, cache);
            cache.put(descriptor, scoList);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshSSLConfig");
        }
        return this.getObject("security", false);
    }

    private static ConfigObject loadTopLevelObjectFromRCS(String pathFile, String scopeName) {
        ConfigObject rcsObject;
        block17: {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.entry(tc, "loadTopLevelObjectFromRCS", new Object[]{pathFile, scopeName});
            }
            int scope = -1;
            if (scopeName.equals("cell")) {
                scope = 0;
            } else if (scopeName.equals("server")) {
                scope = 4;
            } else if (scopeName.equals("node")) {
                scope = 4;
            } else if (!scopeName.equals("")) {
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadTopLevelObjectFromRCS() unsupported scope: " + scopeName);
                }
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadTopLevelObjectFromRCS null");
                }
                return null;
            }
            rcsObject = null;
            try {
                ConfigScope cfgScope;
                List list;
                ConfigService service = WsServiceRegistry.getService(SecurityConfigManagerImpl.class, ConfigService.class);
                if (service == null) {
                    service = ConfigServiceFactory.createConfigService(SecurityConfigManagerImpl.getConfigRoot(), SecurityConfigManagerImpl.getCellName(), null, null);
                }
                if ((rcsObject = (ConfigObject)(list = service.getDocumentObjects(cfgScope = scope == -1 ? null : service.getScope(scope), pathFile)).get(0)) == null) {
                    Tr.error(tc, "ssl.init.nullsecobject.CWPKI0009E");
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "loadTopLevelObjectFromRCS() error getting 1st object from List");
                    }
                }
                if (EncodePasswords.hasPlainTextPasswords(rcsObject)) {
                    EncodePasswords.fixPasswords(pathFile);
                }
            }
            catch (Exception e) {
                if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "loadTopLevelObjectFromRCS() exception", e);
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTopLevelObjectFromRCS", rcsObject);
        }
        return rcsObject;
    }

    private static String getConfigRoot() {
        ConfigRepository repository2;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRoot");
        }
        if ((repository2 = ConfigRepositoryFactory.getConfigRepository()) != null) {
            Properties props = repository2.getConfig();
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigRoot");
            }
            return props.getProperty("was.repository.root");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRoot", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getCellName() {
        String cellName;
        block15: {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.entry(tc, "getCellName");
            }
            cellName = null;
            com.ibm.websphere.management.configservice.ConfigService cs = null;
            Session session = null;
            cs = com.ibm.websphere.management.configservice.ConfigServiceFactory.getConfigService();
            if (cs == null) {
                Properties props = new Properties();
                props.put("location", "local");
                cs = com.ibm.websphere.management.configservice.ConfigServiceFactory.createConfigService(true, props);
            }
            session = new Session();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            cellName = ConfigServiceHelper.getDisplayName(cell);
            try {
                cs.discard(session);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception discarding session: " + session.getSessionId());
                }
                break block15;
            }
            catch (Exception e) {
                block16: {
                    try {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Exception occurred retrieving cell name: " + e);
                    }
                    catch (Throwable throwable) {
                        block17: {
                            try {
                                cs.discard(session);
                            }
                            catch (Exception e2) {
                                if (!tc.isDebugEnabled()) break block17;
                                Tr.debug(tc, "Exception discarding session: " + session.getSessionId());
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    cs.discard(session);
                }
                catch (Exception e3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception discarding session: " + session.getSessionId());
                    }
                }
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", cellName);
        }
        return cellName;
    }

    @Override
    public synchronized void purgeCache(SecurityConfigObject sco) throws SecurityConfigException {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "purgeCache " + sco);
        }
        if (!_isAdminAgent) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not AdminAgent process");
            }
            throw new SecurityConfigException("Called from outside AdminAgent runtime, this is not intended");
        }
        if (!sco.isDomainConfig()) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not using domain config");
            }
            throw new SecurityConfigException("Called with a Admin level config SCO, this is not intended");
        }
        String cacheKey = sco.getConfigFilePath() + "/" + sco.getConfigFileName();
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "cacheKey=" + cacheKey);
        }
        _cacheCache.remove(cacheKey);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "purgeCache");
        }
    }

    @Override
    public synchronized SecurityConfigObject refreshFromConfig() throws SecurityConfigException {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshFromConfig");
        }
        SecurityConfigObject sco = this.getObject("security", false);
        ConfigObject security2 = SecurityConfigManagerImpl.loadTopLevelObjectFromRCS("security.xml", "cell");
        if (security2 != null) {
            HashMap<String, Object> cache = new HashMap<String, Object>();
            _cacheCache.put(sco.getConfigFilePath() + "/" + sco.getConfigFileName(), cache);
            sco = new SecurityConfigObjectImpl(security2, "Security", "Security", sco.getConfigFileName(), sco.getConfigFilePath(), sco.isDomainConfig(), cache);
            cache.put("Security", sco);
            this.parseConfig(security2);
        } else if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
            Tr.debug(tc, "refreshFromConfig error loading cell level security.xml");
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshFromConfig " + sco);
        }
        return sco;
    }

    private String[] getCacheKeys(Map<String, Object> cache) {
        String[] keys = null;
        boolean done = false;
        do {
            try {
                keys = cache.keySet().toArray(new String[0]);
                done = true;
            }
            catch (ConcurrentModificationException e) {
                Tr.info(tc, "getCacheKeys() ConcurrentModificationException, retry");
            }
            catch (Exception e) {
                Tr.info(tc, "getCacheKeys() unexpected Exception", e);
                done = true;
            }
        } while (!done);
        return keys;
    }

    @Override
    public synchronized SecurityConfigObjectList refreshAuthData(String scope) throws SecurityConfigException {
        List list;
        Map<String, Object> cache;
        String[] keys;
        SecurityConfigObjectList list2;
        SecurityConfigObject security2;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAuthData " + scope);
        }
        if ((security2 = this.getObject(scope, false)) != null && (list2 = security2.getObjectList("authDataEntries", false)) != null && (keys = this.getCacheKeys(cache = this.getCache(list2))) != null) {
            String authDataEntriesKey = list2.getDescriptor();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.startsWith(authDataEntriesKey)) continue;
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshAuthData() removing key: " + key);
                }
                cache.remove(key);
            }
        }
        SecurityConfigObjectList scoList = null;
        SecurityConfigObject sec2 = this.getRootObject(scope, false);
        if (sec2 != null && (list = ((SecurityConfigObjectImpl)sec2).getConfigObject().getObjectList("authDataEntries")) != null && list.size() > 0) {
            Map<String, Object> cache2 = this.getCache(sec2);
            String configFilePath = sec2.getConfigFilePath();
            String configFileName = sec2.getConfigFileName();
            boolean isDomainConfig = sec2.isDomainConfig();
            String authDataEntriesKey = sec2.getDescriptor() + CFG_OBJ_DELIM + "authDataEntries";
            scoList = new SecurityConfigObjectListImpl(list, authDataEntriesKey, "authDataEntries", configFileName, configFilePath, isDomainConfig, cache2);
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshAuthData() adding list object to cache: ", scoList);
            }
            cache2.put(authDataEntriesKey, scoList);
        }
        scoList = this.getObject(scope, true).getObjectList("authDataEntries", true);
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAuthData()", scoList);
        }
        return scoList;
    }

    @Override
    public synchronized void refreshSPNEGOAuthMechanism(String scope) {
        List newList;
        SecurityConfigObject sec2;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshSPNEGOAuthMechanism");
        }
        String listDescriptor = null;
        listDescriptor = _isAdminAgent || scope.equalsIgnoreCase("security") ? "Security::authMechanisms" : "AppSecurity::authMechanisms";
        SecurityConfigObjectList scol = this.getObjectList(listDescriptor, false);
        if (scol != null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshSPNEGOAuthMechanism() got authMechanisms SecurityConfigObjectList: " + scol);
            }
            Map<String, Object> cache = this.getCache(scol);
            String[] keys = this.getCacheKeys(cache);
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                if (key.equals(listDescriptor) || !key.startsWith(listDescriptor)) continue;
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshSPNEGOAuthMechanism() removing key: " + key);
                }
                cache.remove(key);
            }
            List rcsList = scol.getList();
            Iterator iter = rcsList.iterator();
            while (iter.hasNext()) {
                ConfigObject rcsConfigObject = (ConfigObject)iter.next();
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshSPNEGOAuthMechanism() got RCS object from List: " + rcsConfigObject);
                }
                if (!rcsConfigObject.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SPNEGO") && !rcsConfigObject.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "KRB5")) continue;
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshSPNEGOAuthMechanism() removing RCS object from List: " + rcsConfigObject);
                }
                iter.remove();
            }
        }
        if ((sec2 = this.getRootObject(scope, false)) != null && (newList = ((SecurityConfigObjectImpl)sec2).getConfigObject().getObjectList("authMechanisms")) != null && newList.size() > 0) {
            ConfigObject rcsConfigObject = null;
            for (int k = 0; k < newList.size(); ++k) {
                rcsConfigObject = (ConfigObject)newList.get(k);
                if (rcsConfigObject.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SPNEGO")) {
                    if (scol != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "refreshSPNEGOAuthMechanism() adding RCS object to List: ", rcsConfigObject);
                        }
                        scol.getList().add(rcsConfigObject);
                        continue;
                    }
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "refreshSPNEGOAuthMechanism() adding authMech List to cache");
                    }
                    scol = new SecurityConfigObjectListImpl(newList, listDescriptor, "authMechanisms", sec2.getConfigFileName(), sec2.getConfigFilePath(), sec2.isDomainConfig(), this.getCache(sec2));
                    this.getCache(sec2).put(listDescriptor, scol);
                    continue;
                }
                if (!rcsConfigObject.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "KRB5")) continue;
                if (scol != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "refreshSPNEGOAuthMechanism() adding RCS object to List: ", rcsConfigObject);
                    }
                    scol.getList().add(rcsConfigObject);
                    continue;
                }
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshSPNEGOAuthMechanism() adding authMech List to cache");
                }
                scol = new SecurityConfigObjectListImpl(newList, listDescriptor, "authMechanisms", sec2.getConfigFileName(), sec2.getConfigFilePath(), sec2.isDomainConfig(), this.getCache(sec2));
                this.getCache(sec2).put(listDescriptor, scol);
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshSPNEGOAuthMechanism()");
        }
    }

    @Override
    public synchronized void refreshDynamicReload(String scope) {
        ConfigObject rcsConfigObject;
        SecurityConfigObject sec2;
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshDynamicReload");
        }
        String descriptor = null;
        descriptor = _isAdminAgent || scope.equalsIgnoreCase("security") ? "Security::dynamicReload" : "AppSecurity::dynamicReload";
        SecurityConfigObject sco = this.getObject(descriptor, false);
        if (sco != null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshDynamicReload got dynamicReload SecurityConfigObject: " + sco);
            }
            Map<String, Object> cache = this.getCache(sco);
            String[] keys = this.getCacheKeys(cache);
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                if (!key.startsWith(descriptor)) continue;
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshDynamicReload removing key: " + key);
                }
                cache.remove(key);
            }
        }
        if ((sec2 = this.getRootObject(scope, false)) != null && (rcsConfigObject = ((SecurityConfigObjectImpl)sec2).getConfigObject().getObject("dynamicReload")) != null) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshDynamicReload adding new dynamicReload object to cache");
            }
            sco = new SecurityConfigObjectImpl(rcsConfigObject, descriptor, "dynamicReload", sec2.getConfigFileName(), sec2.getConfigFilePath(), sec2.isDomainConfig(), this.getCache(sec2));
            this.getCache(sec2).put(descriptor, sco);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshDynamicReload");
        }
    }

    public static void setProcessType(String type) {
        _processType = type;
        _isManagedProcess = _processType.equalsIgnoreCase("ManagedProcess");
        _isAdminAgent = _processType.equalsIgnoreCase("AdminAgent");
        _isAdminAgentChecked = true;
        _isNodeAgent = _processType.equalsIgnoreCase("NodeAgent");
        _isDeploymentManager = _processType.equalsIgnoreCase("DeploymentManager");
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "setProcessType " + _processType);
        }
    }

    private ProfileRegistry getProfileRegistry() {
        block3: {
            try {
                this._profileRegistry = ProfileRegistryFactory.getRegistry();
            }
            catch (Exception e) {
                if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "getProfileRegistry unexpected exception", e);
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProfileRegistry " + this._profileRegistry);
        }
        return this._profileRegistry;
    }

    public static String getProcessType() {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessType " + _processType);
        }
        return _processType;
    }

    private boolean isMixedCluster() {
        if (!_isManagedProcess) {
            return false;
        }
        if (_isMixedClusterChecked) {
            return _isMixedCluster;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMixedCluster");
        }
        _isMixedCluster = false;
        Session session = new Session();
        ObjectName clusterName = SecurityConfigManagerImpl.getClusterObjectName(session);
        if (clusterName != null) {
            _isMixedCluster = !this.validateClusterAtleastVersion7(clusterName, session);
        }
        _isMixedClusterChecked = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMixedCluster", _isMixedCluster);
        }
        return _isMixedCluster;
    }

    private static ObjectName getClusterObjectName(Session session) {
        ObjectName clusterObjectName;
        block15: {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.entry(tc, "getClusterName");
            }
            clusterObjectName = null;
            com.ibm.websphere.management.configservice.ConfigService cs = null;
            try {
                ObjectName[] clusterList;
                block14: {
                    block13: {
                        cs = com.ibm.websphere.management.configservice.ConfigServiceFactory.getConfigService();
                        if (cs == null) {
                            Properties props = new Properties();
                            props.put("location", "local");
                            cs = com.ibm.websphere.management.configservice.ConfigServiceFactory.createConfigService(true, props);
                        }
                        clusterList = null;
                        try {
                            clusterList = cs.resolve(session, "Cell=:ServerCluster=");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Cell=:ServerCluster= -> " + clusterList.toString(), clusterList.length);
                            }
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block13;
                            Tr.debug(tc, "Exception occurred retrieving ServerCluster name: " + e);
                        }
                    }
                    if (clusterList == null || clusterList.length == 0) {
                        try {
                            clusterList = cs.resolve(session, "Cell=" + SecurityConfigManagerImpl.getCellName() + ":ServerCluster=");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Cell=:Cluster= -> " + clusterList.toString(), clusterList.length);
                            }
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug(tc, "Exception occurred retrieving ServerCluster name: " + e);
                        }
                    }
                }
                if (clusterList == null || clusterList.length > 0) {
                    clusterObjectName = clusterList[0];
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Exception occurred retrieving cluster name: " + e);
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterName", clusterObjectName);
        }
        return clusterObjectName;
    }

    private boolean validateClusterAtleastVersion7(ObjectName clusterName, Session session) {
        boolean validated;
        block6: {
            validated = true;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateCluster: " + clusterName);
            }
            try {
                com.ibm.websphere.management.configservice.ConfigService configService = null;
                CommandProviderHelper helper = CommandMgr.getCommandMgr().getCommandProviderHelper();
                configService = helper.getConfigService();
                validated = this.checkClusterMembersAtleastV7(clusterName, session, configService);
            }
            catch (ConfigServiceException cse) {
                FFDCFilter.processException(cse, "com.ibm.ws.security.securitydomain.DomainCheckeExtension", "1106");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception validating resource", cse);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.securitydomain.DomainCheckeExtension", "1112");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "exception validating resource", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClusterAtleastVersion7", validated);
        }
        return validated;
    }

    private boolean checkClusterMembersAtleastV7(ObjectName clusterObject, Session session, com.ibm.websphere.management.configservice.ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClusterMembersAtleastV7", clusterObject);
        }
        List members = (List)configService.getAttribute(session, clusterObject, "members");
        for (AttributeList member : members) {
            String memberName = (String)ConfigServiceHelper.getAttributeValue(member, "memberName");
            String nodeName = (String)ConfigServiceHelper.getAttributeValue(member, "nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberName=" + memberName + " nodeName=" + nodeName);
            }
            if (NodeVersionUtils.isNodeValid((String)nodeName, (Session)session, (int)7, (int)0)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkClusterMembersAtleastV7 false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClusterMembersAtleastV7 true");
        }
        return true;
    }

    @Override
    public boolean isMultiDomainDefined() {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "isMultiDomainDefined");
        }
        boolean defined = false;
        if (_isMultiDomainDefinedChecked) {
            defined = _isMultiDomainDefined;
        } else if (this.isMixedCluster()) {
            _isMultiDomainDefined = false;
            _isMultiDomainDefinedChecked = true;
        } else {
            block16: {
                if (!this._serverSecurityXMLCheckDone) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "isMultiDomainDefined checking for server level security.xml");
                    }
                    this._serverSecurityXMLExists = SecurityConfigManagerImpl.loadTopLevelObjectFromRCS("security.xml", "server") != null;
                    this._serverSecurityXMLCheckDone = true;
                }
                if (this._serverSecurityXMLExists) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "isMultiDomainDefined server level security.xml exists, ignoring any domains");
                    }
                } else {
                    try {
                        ConfigService configService = WsServiceRegistry.getService(o, ConfigService.class);
                        ConfigScope scope = configService.createScope(0);
                        String[] domains = scope.list("../../waspolicies/default/securitydomains");
                        if (domains == null) break block16;
                        if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                            Tr.debug(tc, "isMultiDomainDefined - domain list found", new Object[]{domains});
                        }
                        for (int i = 0; i < domains.length; ++i) {
                            List resource;
                            if (domains[i] == null || domains[i].equalsIgnoreCase("PassThroughToGlobalSecurity")) continue;
                            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                Tr.debug(tc, "isMultiDomainDefined - domain name: " + domains[i]);
                            }
                            if ((resource = configService.getDocumentObjects(scope, "../../waspolicies/default/securitydomains/" + domains[i] + "/domain-security-map.xml")) == null) continue;
                            defined = true;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "isMultiDomainDefined- unexpected exception", e);
                    }
                }
            }
            _isMultiDomainDefined = defined;
            _isMultiDomainDefinedChecked = true;
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "isMultiDomainDefined " + defined);
        }
        return defined;
    }

    @Override
    public boolean isWIMUserRegAssignedToDomain() throws Exception {
        boolean assigned;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isWIMUserRegAssignedToDomain");
            }
            assigned = false;
            if (!this.isMultiDomainDefined()) {
                _WIMUserRegAssignedToDomainChecked = true;
                _isWIMUserRegAssignedToDomain = assigned;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, " no MultiDomainDefined defined returning: " + assigned);
                }
                return assigned;
            }
            if (_WIMUserRegAssignedToDomainChecked) {
                assigned = _isWIMUserRegAssignedToDomain;
            } else {
                boolean pushed = false;
                try {
                    String processType = AdminServiceFactory.getAdminService().getProcessType();
                    if (processType == null || processType.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "isWIMUserRegAssignedToDomain: Cannot determine process type");
                        }
                        throw new Exception("Cannot determine the process type.");
                    }
                    ConfigService configService = null;
                    configService = WsServiceRegistry.getService(this, ConfigService.class);
                    if (configService == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isWIMUserRegAssignedToDomain: got a null ConfigService.");
                        }
                        throw new Exception("isWIMUserRegAssignedToDomain: exception getting ConfigService object.");
                    }
                    ConfigScope scope = configService.createScope(0);
                    String[] domains = scope.list("../../waspolicies/default/securitydomains");
                    if (domains == null) break block22;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isWIMUserRegAssignedToDomain - domain list found", new Object[]{domains});
                    }
                    for (int i = 0; i < domains.length; ++i) {
                        if (domains[i] != null && !domains[i].equalsIgnoreCase("PassThroughToGlobalSecurity")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "isWIMUserRegAssignedToDomain - domain name: " + domains[i]);
                            }
                            pushed = !processType.equalsIgnoreCase("DeploymentManager") ? SecurityObjectLocator.pushAppContext("") : SecurityObjectLocator.pushContext(domains[i], "domain");
                            UserRegistryConfig aur = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry(false);
                            if (aur != null && aur.getType() != null && aur.getType().equals("WIMUserRegistry")) {
                                _WIMUserRegAssignedToDomainChecked = true;
                                assigned = _isWIMUserRegAssignedToDomain = true;
                            }
                        }
                        if (!assigned) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isWIMUserRegAssignedToDomain - unexpected exception", e);
                    }
                    throw e;
                }
                finally {
                    if (pushed) {
                        SecurityObjectLocator.popContext();
                    }
                }
            }
        }
        _isMultiDomainDefined = assigned;
        _isMultiDomainDefinedChecked = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWIMUserRegAssignedToDomain: " + assigned);
        }
        return assigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String do_getDomainForRealm(String realm) {
        String domain;
        block19: {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.entry(tc, "do_getDomainForRealm: " + realm);
            }
            domain = null;
            if (this._realmsDomainScanDone) {
                domain = this._realmToDomainMap.get(realm);
                if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                    Tr.exit(tc, "do_getDomainForRealm: " + domain);
                }
                return domain;
            }
            String[] domains = null;
            try {
                ConfigService configService = WsServiceRegistry.getService(this, ConfigService.class);
                if (configService == null) {
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "do_getDomainForRealm got a null ConfigService.");
                    }
                } else {
                    ConfigScope scope = configService.createScope(0);
                    domains = scope.list("../../waspolicies/default/securitydomains");
                }
                if (domains != null) {
                    int nextRealmDomainIndex = 0;
                    if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                        Tr.debug(tc, "do_getDomainForRealm - domain list found, size = " + domains.length, domains);
                    }
                    for (int i = nextRealmDomainIndex; i < domains.length; ++i) {
                        if (domains[i] == null || domains[i].equalsIgnoreCase("PassThroughToGlobalSecurity")) continue;
                        boolean pushed = false;
                        try {
                            UserRegistry ur;
                            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                                Tr.debug(tc, "do_getDomainForRealm - domain name: " + domains[i]);
                            }
                            pushed = SecurityObjectLocator.pushContext(domains[i], "domain");
                            UserRegistryConfig aur = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry(false);
                            if (aur == null) continue;
                            String domainRealm = aur.getString("realm");
                            if ((domainRealm == null || domainRealm.length() == 0) && (ur = (UserRegistry)aur.getUserRegistryStub()) != null) {
                                domainRealm = ur.getRealm();
                            }
                            if (domainRealm == null || domainRealm.length() == 0) continue;
                            if (this._realmToDomainMap.containsKey(domainRealm) && tc.isDebugEnabled()) {
                                Tr.debug(tc, "do_getDomainForRealm - realm already mapped! realm: " + domainRealm + " old domain: " + this._realmToDomainMap.get(domainRealm) + " new domain: " + domains[i]);
                            }
                            this._realmToDomainMap.put(domainRealm, domains[i]);
                            if (!domainRealm.equals(realm)) continue;
                            domain = domains[i];
                            continue;
                        }
                        finally {
                            if (pushed) {
                                SecurityObjectLocator.popContext();
                            }
                        }
                    }
                    this._realmsDomainScanDone = true;
                }
            }
            catch (Exception e) {
                if (!SecurityConfigGlobals.enableVerboseSCM || !tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "do_getDomainForRealm - unexpected exception", e);
            }
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "do_getDomainForRealm: " + domain);
        }
        return domain;
    }

    @Override
    public String getDomainForRealm(String realm) {
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainForRealm " + realm);
        }
        if (realm == null || realm.length() == 0) {
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
                Tr.entry(tc, "getDomainForRealm realm is null, returning null");
            }
            return null;
        }
        String domain = null;
        String adminRealm = DomainInfo.getAdminRealm();
        if (adminRealm != null && realm.equals(adminRealm)) {
            domain = "admin";
        } else if (this._realmsDomainScanDone) {
            domain = this._realmToDomainMap.get(realm);
        } else if (!this.isMultiDomainDefined()) {
            this._realmsDomainScanDone = true;
            if (SecurityConfigGlobals.enableVerboseSCM && tc.isDebugEnabled()) {
                Tr.debug(tc, "getDomainForRealm no realms defined, returning null");
            }
        } else {
            domain = this.do_getDomainForRealm(realm);
        }
        if (SecurityConfigGlobals.enableVerboseSCM && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainForRealm: " + domain);
        }
        return domain;
    }
}

