/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class MapPlatformSubject
implements LoginModule {
    private static final TraceComponent tc = Tr.register(MapPlatformSubject.class, "Security", "com.ibm.ejs.resources.security");
    private static final int MAXIMUM_NAME_LENGTH = 8;
    private static final int MAXIMUM_AUDIT_TOKEN_LENGTH = 223;
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private boolean succeeded = false;
    private WSCredential credential = null;
    private PlatformCredential pc = null;
    private String principalClass = null;

    public MapPlatformSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{subject, callbackHandler, sharedState, options});
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login");
        }
        Boolean isLocalOS = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getType().equals("LOCALOS");
        if (DomainInfo.isMultiDomainDefined() || isLocalOS == null || !isLocalOS.booleanValue()) {
            if (!this.sharedState.containsKey("WSPrincipal") || !this.sharedState.containsKey("WSCredential")) {
                this.succeeded = false;
                WSLoginFailedException e = new WSLoginFailedException("A WSPrincipal or WSCredential does not exist in the shared state.");
                Tr.event(tc, "Throwing LoginException from login", e);
                throw e;
            }
            this.credential = (WSCredential)this.sharedState.get("WSCredential");
            String name = (String)this.sharedState.get("com.ibm.wsspi.security.token.zos_userid");
            String audit = (String)this.sharedState.get("com.ibm.wsspi.security.token.zos_audit_string");
            this.pc = ContextManagerFactory.getInstance().isInternalServerCredential(this.credential) ? PlatformCredentialManager.instance().createServerCredential() : (name != null ? PlatformCredentialManager.instance().createCredential(name, audit) : PlatformCredentialManager.instance().createDefaultCredential());
        }
        this.principalClass = this.sharedState.containsKey("com.ibm.wsspi.security.token.caller_principal_class") ? (String)this.sharedState.get("com.ibm.wsspi.security.token.caller_principal_class") : "com.ibm.websphere.security.auth.WSPrincipal";
        this.succeeded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", new Boolean(this.succeeded));
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        try {
            block6: {
                try {
                    if (this.pc == null || !this.succeeded) break block6;
                    this.credential.set("com.ibm.ws.security.zos.PlatformCredential", this.pc);
                    this.credential.set("com.ibm.wsspi.security.token.caller_principal_class", this.principalClass);
                }
                catch (Exception e) {
                    WSLoginFailedException lfe = new WSLoginFailedException(e);
                    Tr.event(tc, "Throwing LoginException from commit", lfe);
                    throw lfe;
                }
            }
            Object var4_1 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.cleanup();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit", Boolean.TRUE);
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort", Boolean.TRUE);
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout", Boolean.TRUE);
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        this.pc = null;
        this.principalClass = null;
        this.credential = null;
        this.succeeded = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }
}

