/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.authorize.JaccTaskUtil;
import com.ibm.ws.security.util.DomainContextHelper;
import java.util.Hashtable;

public class JaccUninstallTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(JaccUninstallTask.class, null, "com.ibm.ejs.resources.security");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sec-uninstall performTask");
            }
            if (!this._isLocal) {
                String processType = null;
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    processType = adminService.getProcessType();
                }
                if (processType == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "sec performTask");
                    }
                    return true;
                }
                if (!processType.equals("DeploymentManager") && !processType.equals("UnManagedProcess")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "sec performTask");
                    }
                    return true;
                }
            }
            boolean switched = false;
            String appName = null;
            try {
                block16: {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Check to see if JACC is enabled");
                        }
                        appName = cachedAD.getAppName();
                        switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                        boolean proceed = JaccTaskUtil.checkForJacc(this._repository, this._isLocal, this._cellName, false);
                        if (!proceed) break block16;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "JACC is enabled");
                        }
                        String earFileLocation = cachedAD.getBinURL();
                        String contextID = cachedAD.getAppContextIDForSecurity();
                        ApplicationDeployment appDepl = (ApplicationDeployment)cachedAD.getProperties().get("OLDDEPLOY_KEY");
                        AppInstallNotify.getInstance().appUninstall(appDepl, appName, contextID, this._isLocal);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.authorize.JaccUninstallTask.performTask", "79", this);
                        Tr.warning(tc, "security.jacc.uninstall.task.warning", new Object[]{cachedAD.getAppName(), e});
                        Object var11_13 = null;
                        if (switched) {
                            DomainContextHelper.unwindAppDomain(appName);
                        }
                        break block17;
                    }
                }
                Object var11_12 = null;
                if (!switched) break block17;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (switched) {
                    DomainContextHelper.unwindAppDomain(appName);
                }
                throw throwable;
            }
            DomainContextHelper.unwindAppDomain(appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sec performTask ");
        }
        return true;
    }
}

