/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class JaccServerTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(JaccServerTask.class, null, "com.ibm.ejs.resources.security");
    private static final String contextIDPrefix = "href:";
    private static final String defaultSecBundleName = "com.ibm.ejs.resources.security";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask:appContextID");
        }
        String appName = EditionHelper.getCompositeName(((InstallScheduler)this.scheduler).getAppName(), ((InstallScheduler)this.scheduler).getProperties());
        String cellName = null;
        try {
            Collection c;
            Iterator itr;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding contextID to the deployment.xml for application: " + appName);
            }
            RepositoryContext rc = ((InstallScheduler)this.scheduler).getCellContext();
            cellName = rc.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppName is: " + appName + " , CellName is " + cellName);
            }
            if ((itr = (c = rc.findContext("deployments", appName)).iterator()).hasNext()) {
                RepositoryContext rc1 = (RepositoryContext)itr.next();
                URI uri = URI.createURI("deployment.xml");
                HashMap options = new HashMap();
                Resource res = rc1.getResourceSet().getResource(uri, true);
                Deployment d = (Deployment)res.getContents().get(0);
                ApplicationDeployment appdepl = (ApplicationDeployment)d.getDeployedObject();
                StringBuffer sb = new StringBuffer(contextIDPrefix);
                sb.append(cellName).append("/").append(appName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appContextID is: " + sb.toString());
                }
                appdepl.setAppContextIDForSecurity(sb.toString());
                res.save(options);
                AppNotification appNotify = this.createNotification("Completed", "security.jacc.server.task.information", new String[]{this.scheduler.getAppName()});
                this.scheduler.propagateTaskEvent(appNotify);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No deployment information");
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.security.authorize.JaccServerTask.performTask", "115", this);
            Tr.error(tc, "security.jacc.server.task.error", new Object[]{appName, th});
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "security.jacc.server.task.error", new String[]{this.scheduler.getAppName(), th.toString()}));
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, th.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask:appContextID");
        }
        return true;
    }

    public String getResourceBundleName() {
        return defaultSecBundleName;
    }
}

