/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import java.util.Arrays;

public class SecretKeyTokenCacheKey {
    private byte[] encryptedBytes;
    private byte[] signatureBytes;
    private int hash = 0;

    SecretKeyTokenCacheKey(byte[] _encryptedBytes, byte[] _signatureBytes) {
        this.encryptedBytes = _encryptedBytes;
        this.signatureBytes = _signatureBytes;
    }

    public byte[] getEncryptedBytes() {
        return this.encryptedBytes;
    }

    public byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public boolean equals(Object arrayObj) {
        if (arrayObj instanceof SecretKeyTokenCacheKey) {
            SecretKeyTokenCacheKey anotherArrayObject = (SecretKeyTokenCacheKey)arrayObj;
            return Arrays.equals(this.encryptedBytes, anotherArrayObject.getEncryptedBytes()) && Arrays.equals(this.signatureBytes, anotherArrayObject.getSignatureBytes());
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int i;
            int len = this.encryptedBytes.length;
            for (i = 0; i < len; ++i) {
                h = 31 * h + this.encryptedBytes[i];
            }
            len = this.signatureBytes.length;
            for (i = 0; i < len; ++i) {
                h = 31 * h + this.signatureBytes[i];
            }
            this.hash = h;
        }
        return h;
    }
}

