/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class SecretKeyToken {
    private static final TraceComponent tc = Tr.register(SecretKeyToken.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    public static final String tokenHeader = "WS_SECRET_KEY_TOKEN_HEADER";
    private static final byte[] tokenHeaderBytes = "WS_SECRET_KEY_TOKEN_HEADER".getBytes();
    private final int tokenHeaderSize = tokenHeaderBytes.length;
    private int version;
    private byte[] secretKey;
    private int keyLength;
    private String encrypt_algorithm;
    private String mode;
    private String padding;
    private byte[] cachedBytes = null;

    SecretKeyToken() {
    }

    SecretKeyToken(byte[] _secretKey, int _keyLength, String _encrypt_algorithm, String _mode, String _padding, int _version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecretKeyToken <init>");
        }
        this.secretKey = _secretKey;
        this.keyLength = _keyLength;
        this.encrypt_algorithm = _encrypt_algorithm;
        this.mode = _mode;
        this.padding = _padding;
        this.version = _version;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecretKeyToken <init>");
        }
    }

    SecretKeyToken(byte[] skt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecretKeyToken <init>");
        }
        this.readBytes(skt);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecretKeyToken <init>");
        }
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public String getEncryptAlgorithm() {
        return this.encrypt_algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public byte[] getBytes() {
        if (this.cachedBytes == null) {
            this.cachedBytes = this.writeBytes();
        }
        return this.cachedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readBytes(byte[] secret_key_token_bytes) {
        block30: {
            block33: {
                block27: {
                    block32: {
                        if (SecretKeyToken.tc.isEntryEnabled()) {
                            Tr.entry(SecretKeyToken.tc, "readBytes");
                        }
                        this.cachedBytes = secret_key_token_bytes;
                        bais = null;
                        dis = null;
                        try {
                            try {
                                bais = new ByteArrayInputStream(secret_key_token_bytes);
                                dis = new DataInputStream(bais);
                                isSecretKeyToken = this.checkSecretKeyTokenHeader(dis);
                                if (isSecretKeyToken) {
                                    if (SecretKeyToken.tc.isDebugEnabled()) {
                                        Tr.debug(SecretKeyToken.tc, "Found secret key token.");
                                    }
                                    this.version = dis.readInt();
                                    if (this.version == 1) {
                                        if (SecretKeyToken.tc.isDebugEnabled()) {
                                            Tr.debug(SecretKeyToken.tc, "Token version == 1");
                                        }
                                        this.readSecretKeyTokenV1Bytes(dis);
                                    }
                                    break block27;
                                }
                                if (SecretKeyToken.tc.isEntryEnabled()) {
                                    Tr.exit(SecretKeyToken.tc, "readBytes (not SKT)");
                                }
                                var6_6 = null;
                            }
                            catch (Exception e) {
                                if (SecretKeyToken.tc.isDebugEnabled()) {
                                    Tr.debug(SecretKeyToken.tc, "Exception reading secret key token bytes.", new Object[]{e});
                                }
                                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.SecretKeyToken.readBytes", "166", new Object[]{this});
                                var6_8 = null;
                                try {
                                    if (bais != null) {
                                        bais.close();
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    if (dis != null) {
                                        dis.close();
                                    }
                                    break block30;
                                }
                                catch (Exception e) {}
                                break block30;
                            }
                        }
                        catch (Throwable var5_14) {
                            block31: {
                                var6_9 = null;
                                ** try [egrp 2[TRYBLOCK] [5 : 208->219)] { 
lbl49:
                                // 1 sources

                                if (bais != null) {
                                    bais.close();
                                }
                                break block31;
lbl52:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [6 : 221->232)] { 
lbl56:
                            // 1 sources

                            if (dis == null) throw var5_14;
                            dis.close();
                            throw var5_14;
lbl59:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                            throw var5_14;
                        }
                        ** try [egrp 2[TRYBLOCK] [5 : 208->219)] { 
lbl64:
                        // 1 sources

                        if (bais != null) {
                            bais.close();
                        }
                        break block32;
lbl67:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [6 : 221->232)] { 
lbl71:
                    // 1 sources

                    if (dis == null) return;
                    dis.close();
                    return;
lbl74:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                var6_7 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 208->219)] { 
lbl80:
                // 1 sources

                if (bais != null) {
                    bais.close();
                }
                break block33;
lbl83:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
            }
            try {}
            catch (Exception e) {}
            if (dis != null) {
                dis.close();
            }
        }
        if (SecretKeyToken.tc.isEntryEnabled() == false) return;
        Tr.exit(SecretKeyToken.tc, "readBytes");
    }

    private void readSecretKeyTokenV1Bytes(DataInputStream dis) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readSecretKeyTokenV1Bytes");
        }
        int secret_key_len = dis.readInt();
        this.secretKey = new byte[secret_key_len];
        dis.read(this.secretKey, 0, secret_key_len);
        this.keyLength = dis.readInt();
        int encrypt_algorithm_len = dis.readInt();
        byte[] encrypt_algorithm_bytes = new byte[encrypt_algorithm_len];
        dis.read(encrypt_algorithm_bytes, 0, encrypt_algorithm_len);
        this.encrypt_algorithm = new String(encrypt_algorithm_bytes, "UTF-8");
        int mode_len = dis.readInt();
        byte[] mode_bytes = new byte[mode_len];
        dis.read(mode_bytes, 0, mode_len);
        this.mode = new String(mode_bytes, "UTF-8");
        int padding_len = dis.readInt();
        byte[] padding_bytes = new byte[padding_len];
        dis.read(padding_bytes, 0, padding_len);
        this.padding = new String(padding_bytes, "UTF-8");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readSecretKeyTokenV1Bytes");
        }
    }

    private boolean checkSecretKeyTokenHeader(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSecretKeyTokenHeader");
        }
        try {
            byte[] header = null;
            String headerString = null;
            header = new byte[this.tokenHeaderSize];
            dis.read(header, 0, this.tokenHeaderSize);
            if (header != null) {
                headerString = new String(header, "UTF-8");
                if (headerString.equals(tokenHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkSecretKeyTokenHeader (true)");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSecretKeyTokenHeader (invalid header)");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkSecretKeyTokenHeader (no header)");
            }
            return false;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception reading secret key token header.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.SecretKeyToken.checkSecretKeyTokenHeader", "279", this);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] writeBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBytes");
        }
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        baos = new ByteArrayOutputStream(500);
        dos = new DataOutputStream(baos);
        dos.write(tokenHeaderBytes, 0, this.tokenHeaderSize);
        dos.writeInt(this.version);
        int secret_key_len = this.secretKey.length;
        dos.writeInt(secret_key_len);
        dos.write(this.secretKey, 0, secret_key_len);
        dos.writeInt(this.keyLength);
        byte[] encrypt_algorithm_bytes = this.encrypt_algorithm.getBytes("UTF-8");
        int encrypt_algorithm_len = encrypt_algorithm_bytes.length;
        dos.writeInt(encrypt_algorithm_len);
        dos.write(encrypt_algorithm_bytes, 0, encrypt_algorithm_len);
        byte[] mode_bytes = this.mode.getBytes("UTF-8");
        int mode_len = mode_bytes.length;
        dos.writeInt(mode_len);
        dos.write(mode_bytes, 0, mode_len);
        byte[] padding_bytes = this.padding.getBytes("UTF-8");
        int padding_len = padding_bytes.length;
        dos.writeInt(padding_len);
        dos.write(padding_bytes, 0, padding_len);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total opaque token length: " + baos.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBytes");
        }
        byte[] byArray = baos.toByteArray();
        Object var12_12 = null;
        try {
            if (baos != null) {
                baos.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (dos != null) {
                dos.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return byArray;
        catch (Exception e) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception writing secret key token bytes.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.SecretKeyToken.writeBytes", "344", this);
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception e2) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBytes (null)");
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Version: ");
        buf.append(this.version);
        buf.append("\n");
        buf.append("SecretKey: ");
        for (int i = 0; i < this.secretKey.length; ++i) {
            buf.append((char)this.secretKey[i]);
        }
        buf.append("\n");
        buf.append("EncryptAlgorithm: ");
        buf.append(this.encrypt_algorithm);
        buf.append("\n");
        buf.append("Mode: ");
        buf.append(this.mode);
        buf.append("\n");
        buf.append("Padding: ");
        buf.append(this.padding);
        buf.append("\n");
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            SecureRandom sr = SecureRandom.getInstance("IBMSecureRandom");
            byte[] random = sr.generateSeed(32);
            SecretKeySpec sks = new SecretKeySpec(random, "AES");
            SecretKeyFactory skf = SecretKeyFactory.getInstance("AES");
            SecretKey sk = skf.generateSecret(sks);
            byte[] skBytes = sk.getEncoded();
            SecretKeyToken token1 = new SecretKeyToken(skBytes, 128, "AES", "CBC", "PKCS5Padding", 1);
            System.out.println(token1.toString());
            byte[] token1Bytes = token1.writeBytes();
            SecretKeyToken token1a = new SecretKeyToken();
            token1a.readBytes(token1Bytes);
            System.out.println(token1a.toString());
        }
        catch (Throwable t) {
            System.out.println("Exception occurred.");
            t.printStackTrace();
        }
    }
}

