/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

class NonceCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(NonceCache.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static final String clsName = NonceCache.class.getName();
    private static final String DEFAULT_VALUE = "exist";
    private Hashtable _table;
    private Hashtable _secondaryTable;
    private Hashtable _tertiaryTable;
    private int _minSize = 0;
    private boolean _wipeCache;
    private Alarm _defaultAlarm;
    long _timeout;

    public NonceCache(int size, long timeout, boolean wipeCache) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonceCache(int size[" + size + "]," + "int timeout[" + timeout + "]," + "boolean wipeCache[" + wipeCache + "])");
        }
        this._defaultAlarm = new Alarm(timeout);
        this._table = new Hashtable(size);
        this._secondaryTable = new Hashtable(size);
        this._tertiaryTable = new Hashtable(size);
        this._minSize = size;
        this._wipeCache = wipeCache;
        this.addAlarmListener(this, timeout);
        this._timeout = timeout;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonceCache(int size, int timeout,boolean wipeCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains");
            StringBuffer sb = new StringBuffer("Key = ");
            sb.append(key.toString());
            sb.append(", key class is ");
            sb.append(key.getClass().getName());
            Tr.debug(tc, sb.toString());
        }
        boolean retValue = true;
        Hashtable tableRef = null;
        CacheEntry curEntry = null;
        curEntry = (CacheEntry)this._table.get(key);
        if (curEntry == null) {
            curEntry = (CacheEntry)this._secondaryTable.get(key);
            if (curEntry == null) {
                curEntry = (CacheEntry)this._tertiaryTable.get(key);
                if (curEntry != null) {
                    tableRef = this._tertiaryTable;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached nonce corresponding the key [" + key + "] in the tertiary table.");
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found cached nonce corresponding the key [" + key + "] in the secondary table.");
                }
                tableRef = this._secondaryTable;
            }
            if (curEntry == null) {
                Hashtable hashtable = this._table;
                synchronized (hashtable) {
                    if (tc.isEntryEnabled() && (this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size()) % 100 == 0) {
                        StringBuffer sb = new StringBuffer(this.getClass().getName());
                        sb.append(" number of entries: ");
                        sb.append(this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size());
                        Tr.debug(tc, sb.toString());
                    }
                    if ((curEntry = (CacheEntry)this._table.get(key)) == null) {
                        curEntry = new CacheEntry(key, new Date());
                        this._table.put(key, curEntry);
                        retValue = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Created a new cache corresponding the key [" + key + "].");
                        }
                    }
                }
            } else {
                this._table.put(key, curEntry);
                tableRef.remove(key);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found cached nonce corresponding the key [" + key + "] in the firs table.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains returns " + retValue);
        }
        return retValue;
    }

    protected void mark() {
        if (this._wipeCache) {
            this._tertiaryTable.clear();
        } else {
            this._tertiaryTable.putAll(this._secondaryTable);
        }
        this._secondaryTable = this._table;
        this._table = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size() + 100);
    }

    public void alarm(Object alarmCtx) {
        long startTime = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer(this.getClass().getName());
            sb.append(" Time elapsed cleaning cache: ");
            sb.append(System.currentTimeMillis() - startTime);
            sb.append(" milliseconds, Primary cache size: ");
            sb.append(this._table.size());
            sb.append(", Secondary cache size: ");
            sb.append(this._secondaryTable.size());
            sb.append(", Tertiary cache size: ");
            sb.append(this._tertiaryTable.size());
            Tr.debug(tc, sb.toString());
        }
    }

    private void addAlarmListener(AlarmListener al, long to) {
        if (to == this._defaultAlarm.getTimeout()) {
            this._defaultAlarm.addAlarmListener(al);
        } else {
            Alarm alarm = new Alarm(to);
            alarm.addAlarmListener(al);
        }
    }

    public static class CacheEntry {
        public Object key;
        public Object value;

        public CacheEntry() {
        }

        public CacheEntry(Object _key, Object _value) {
            this.value = _value;
            this.key = _key;
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener al) {
            this.alarms.addElement(al);
        }

        public Alarm(long to) {
            this.timeout = to / 2L;
            this.alarm(null);
        }

        public void alarm(Object alarmCtx) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(alarmCtx);
            }
            AlarmManager.create(this.timeout * 1000L, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }
}

