/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class WSKrb5LoginModule
implements LoginModule {
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map _sharedState;
    private Map _options;
    private boolean _succeeded = false;
    private boolean _commitSucceeded = false;
    private WSPrincipal _principal;
    private WSCredential _credential;
    protected boolean _debug = true;
    protected boolean _validatedone = false;
    protected boolean _authenticatedone = false;
    private GSSCredential _gssCred = null;
    private GSSManager _mgr = GSSManager.getInstance();
    private boolean _krb5Login = true;
    private KerberosTicket _kTicket = null;
    private static final TraceComponent tc = Tr.register(WSKrb5LoginModule.class, null, "com.ibm.ws.security.auth.kerberos.krbsecurity");

    public WSKrb5LoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKrb5LoginModule()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKrb5LoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
        }
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        this._sharedState = sharedState;
        this._options = options;
        this._debug = "true".equalsIgnoreCase((String)this._options.get("debug"));
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        block76: {
            if (this._debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            this._krb5Login = true;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (!contextManager.isCellSecurityEnabled()) {
                try {
                    Tr.warning(tc, "security.disabled.during.login");
                    if (tc.isDebugEnabled()) {
                        Thread.dumpStack();
                    }
                    Subject unAuthSubject = SubjectHelper.createUnauthenticatedSubject();
                    this._credential = SubjectHelper.getWSCredentialFromSubject(unAuthSubject);
                    this._principal = SubjectHelper.createPrincipal(this._credential);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception creating principal.", new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.WSKrb5LoginModule.login", "241", this);
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                this._sharedState.put("WSPrincipal", this._principal);
                this._sharedState.put("WSCredential", this._credential);
                this._succeeded = true;
                if (this._debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(security disabled)");
                }
                return this._succeeded;
            }
            Iterator keys = this._sharedState.keySet().iterator();
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "shared state contains: " + this._sharedState.keySet());
            }
            this._succeeded = false;
            if (this._commitSucceeded) {
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
                }
                this.cleanup();
            }
            if (this._callbackHandler == null) {
                throw new LoginException("No CallbackHandler available to gather authentication information from the user.");
            }
            Callback[] callbacks = null;
            if (!this._sharedState.containsKey("Callback")) {
                if (this._callbackHandler == null) {
                    WSLoginFailedException e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                    contextManager.setRootException(e);
                    throw e;
                }
                callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: "), new WSTokenHolderCallback("Authz Token List: "), new WSRealmNameCallbackImpl("Realm Name", contextManager.getDefaultRealm()), new WSX509CertificateChainCallback("X509Certificate[]: "), new WSAuthMechOidCallbackImpl("AuthMechOid: ")};
                try {
                    this._callbackHandler.handle(callbacks);
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "221", this);
                    Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), e});
                    contextManager.setRootException(e);
                    throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
                }
                catch (UnsupportedCallbackException uce) {
                    FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "228", this);
                    Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), uce.getCallback().toString(), uce});
                    contextManager.setRootException(uce);
                    throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
                }
                this._sharedState.put("Callback", callbacks);
            } else {
                callbacks = (Callback[])this._sharedState.get("Callback");
            }
            String uid = null;
            String mapUid = null;
            String realm = null;
            char[] password = null;
            byte[] credToken = null;
            String authMechOid = null;
            List authzTokenList = null;
            authMechOid = ((WSAuthMechOidCallbackImpl)callbacks[9]).getAuthMechOid();
            uid = ((NameCallback)callbacks[0]).getName();
            char[] tmp = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmp != null) {
                password = new char[tmp.length];
                System.arraycopy(tmp, 0, password, 0, tmp.length);
            }
            realm = ((WSRealmNameCallbackImpl)callbacks[7]).getRealmName();
            byte[] tmpCred = ((WSCredTokenCallbackImpl)callbacks[2]).getCredToken();
            if (tmpCred != null) {
                credToken = CredentialsHelper.copyCredToken(tmpCred);
                if (authMechOid == null || authMechOid.length() == 0) {
                    try {
                        authMechOid = GSSFactory.getMechOIDFromGSSToken(credToken);
                        if (this._debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "authMechOid pass in is null, get authMechOid from the credToken: " + authMechOid);
                        }
                    }
                    catch (Exception e) {
                        Object[] parms = new Object[]{WSKrb5LoginModule.class, "credToken"};
                        throw new WSLoginFailedException("Get authMechOid from the credToken exception - " + e.getMessage(), e);
                    }
                }
            }
            this._krb5Login = Krb5Utils.isKrb5Login(authMechOid, uid);
            if (!this._krb5Login) {
                this._succeeded = true;
                return this._succeeded;
            }
            authzTokenList = ((WSTokenHolderCallback)callbacks[6]).getTokenHolderList();
            this._gssCred = SubjectHelper.getGSSCredentialFromSubject(this._subject);
            mapUid = (String)this._sharedState.get("com.ibm.wsspi.security.cred.userId");
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "mapUid: " + mapUid);
            }
            this._kTicket = (KerberosTicket)this._sharedState.get("javax.security.auth.kerberos.KerberosTicket");
            KerberosPrincipal kPrinc = (KerberosPrincipal)this._sharedState.get("javax.security.auth.kerberos.KerberosPrincipal");
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "_kTicket: " + this._kTicket);
                Tr.debug(tc, "kPrinc: " + kPrinc);
            }
            SecurityConfig secCfg = SecurityObjectLocator.getSecurityConfig();
            String mapKrbPrincToRacfId = secCfg.getProperty("com.ibm.websphere.security.krb.useBuiltInMappingToSAF");
            UserRegistryConfig aur = secCfg.getActiveUserRegistry();
            if (PlatformHelperFactory.getPlatformHelper().isZOS() && aur.getType().equals("LOCALOS") && mapKrbPrincToRacfId != null && mapKrbPrincToRacfId.equalsIgnoreCase("true")) {
                KerberosPrincipal kPrincipal;
                String racfId = null;
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Map Kerberos principal name to RACF ID");
                }
                if ((kPrincipal = (KerberosPrincipal)this._sharedState.get("javax.security.auth.kerberos.KerberosPrincipal")) != null) {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Get Kerberos principal name in the shared state");
                    }
                    if ((racfId = PlatformCredentialManager.instance().mapKerbPrincipal(kPrincipal.toString())) == null || racfId.length() == 0) {
                        if (this._debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Can not map Kerberos principal " + kPrincipal + " to RACF ID");
                        }
                        throw new LoginException("Can not map Kerberos principal " + kPrincipal + " to RACF ID");
                    }
                    this._sharedState.put("com.ibm.wsspi.security.cred.userId", racfId);
                    mapUid = racfId;
                } else if (this._gssCred != null) {
                    try {
                        GSSName gssName;
                        if (this._debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Get Kerberos principal name in GSSCred");
                        }
                        if ((gssName = this._gssCred.getName()) != null) {
                            racfId = PlatformCredentialManager.instance().mapKerbPrincipal(((Object)gssName).toString());
                            if (racfId == null || racfId.length() == 0) {
                                if (this._debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Can not map Kerberos principal " + kPrincipal + " to RACF ID");
                                }
                                throw new LoginException("Can not map Kerberos principal " + kPrincipal + " to RACF ID");
                            }
                            this._sharedState.put("com.ibm.wsspi.security.cred.userId", racfId);
                            mapUid = racfId;
                        }
                    }
                    catch (GSSException e) {
                        if (this._debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error getting name from GSSCredential.");
                        }
                        throw new WSLoginFailedException(e.getMessage(), e);
                    }
                }
            }
            Hashtable customProperties = (Hashtable)this._sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "uid = " + uid);
                Tr.debug(tc, "mapUid = " + mapUid);
                Tr.debug(tc, "realm = " + realm);
                Tr.debug(tc, "password = " + (password == null ? "<null>" : "XXXXXXXX"));
                Tr.debug(tc, "cred token = " + (credToken != null ? "<not null>" : "<null>"));
                Tr.debug(tc, "authz token list = " + authzTokenList);
                Tr.debug(tc, "_kTicket = " + SubjectHelper.getKerberosTicketFromSubject(this._subject));
                Tr.debug(tc, "gssCred = " + this._gssCred);
                Tr.debug(tc, "customProperties = " + customProperties);
                Tr.debug(tc, "authMechOid = " + authMechOid);
            }
            if (this._gssCred != null && customProperties != null && customProperties.get("com.ibm.wsspi.security.cred.uniqueId") != null) {
                String temp_uniqueid = null;
                if (customProperties != null) {
                    temp_uniqueid = (String)customProperties.get("com.ibm.wsspi.security.cred.uniqueId");
                }
                if (temp_uniqueid != null && !temp_uniqueid.equals("")) {
                    this.createCredentialsFromHashtable(customProperties, this._gssCred);
                    this._sharedState.put("WSCredential", this._credential);
                    this._sharedState.put("WSPrincipal", this._principal);
                }
                this._succeeded = true;
                return this._succeeded;
            }
            if (this._gssCred != null && authzTokenList == null) {
                try {
                    GSSName gssUserName = this._gssCred.getName();
                    if (gssUserName != null) {
                        String userName = ((Object)gssUserName).toString();
                        if (mapUid != null) {
                            this.createCredentialsFromUsername(mapUid);
                        } else {
                            this.createCredentialsFromUsername(userName);
                        }
                        this._sharedState.put("WSCredential", this._credential);
                        this._sharedState.put("WSPrincipal", this._principal);
                    }
                }
                catch (GSSException e) {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting name from GSSCredential.");
                    }
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                this._succeeded = true;
                return this._succeeded;
            }
            if ((credToken != null || this._gssCred != null) && authzTokenList != null) {
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Skipping WSKrb5LoginModule to validate in wsMapDefaultInboundLoginModule.");
                }
                this._krb5Login = false;
                this._succeeded = true;
                return this._succeeded;
            }
            if (uid == null && password == null && credToken == null) {
                throw new LoginException("No authentication data.");
            }
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Successfully gathered authentication information");
            }
            this._authenticatedone = false;
            this._validatedone = false;
            if (uid != null && (password == null || password.length == 0) && credToken == null) {
                this._krb5Login = false;
                this._succeeded = true;
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Only UID pass in. Skipping WSKrb5LoginModule. Handling login outside this login module.");
                }
                return this._succeeded;
            }
            if (uid != null || password != null) {
                String loginUser = null;
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using Kerberos ticket for authentication");
                }
                try {
                    if (SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getBoolean("trimUserName")) {
                        int i = uid.indexOf("@");
                        if (i < 0) {
                            if (this._debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "There is nothing to trim in the principal name.");
                            }
                        } else {
                            uid = uid.substring(0, i);
                            if (this._debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Principal name was trimmed to: " + uid);
                            }
                        }
                    }
                    loginUser = mapUid != null ? mapUid : uid;
                    this._authenticatedone = this.authenticate(loginUser);
                    this._succeeded = true;
                }
                catch (Exception e) {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.error(tc, "security.auth.kerberos.LoginException", new Object[]{loginUser, e});
                    }
                    break block76;
                }
            }
            if (credToken != null) {
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using credential token for authentication");
                }
                try {
                    this._validatedone = this.validate(credToken);
                    if (this._credential != null) {
                        this._succeeded = true;
                        this._authenticatedone = true;
                        break block76;
                    }
                    this._succeeded = false;
                }
                catch (Exception e) {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.error(tc, "security.auth.kerberos.ValidateException", new Object[]{e});
                    }
                    break block76;
                }
            }
            throw new LoginException("No authentication data");
        }
        if (this._credential == null) {
            throw new LoginException("credential is null");
        }
        Tr.debug(tc, "credential = " + this._credential);
        this._sharedState.put("WSCredential", this._credential);
        this._sharedState.put("WSPrincipal", this._principal);
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this._succeeded;
    }

    public boolean commit() throws LoginException {
        boolean bRet;
        block37: {
            if (this._debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "commit()");
            }
            if (!this._krb5Login) {
                return true;
            }
            bRet = false;
            if (!this._succeeded) {
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do not commit because of authentication failed.");
                }
                return false;
            }
            if (!this._commitSucceeded) {
                block36: {
                    if (this._authenticatedone) {
                        try {
                            this._credential = (WSCredential)this._sharedState.get("WSCredential");
                            this._principal = (WSPrincipal)this._sharedState.get("WSPrincipal");
                            KerberosTicket kTicket = SubjectHelper.getKerberosTicketFromSubject(this._subject);
                            if (kTicket == null) {
                                if (this._debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Kerberos Ticket is null ");
                                }
                                break block36;
                            }
                            boolean _renewable = kTicket.isRenewable();
                            if (this._debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Kerberos Ticket renewable is " + String.valueOf(_renewable));
                            }
                            final String _myName = kTicket.getClient().getName();
                            if (this._debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Name for cred: " + _myName);
                            }
                            Krb5Utils.setUseSubjectCredsOnly(true);
                            try {
                                Subject.doAs(this._subject, new PrivilegedExceptionAction(){

                                    public Object run() throws WSLoginFailedException {
                                        try {
                                            Oid krb5MechOid = Krb5Utils.getKrb5MechOid();
                                            GSSName _gssName = null;
                                            if (WSKrb5LoginModule.this._gssCred == null) {
                                                SingleSignonToken ssoToken;
                                                _gssName = _myName != null ? WSKrb5LoginModule.this._mgr.createName(_myName, GSSName.NT_USER_NAME, krb5MechOid) : null;
                                                boolean credsType = false;
                                                WSKrb5LoginModule.this._gssCred = WSKrb5LoginModule.this._mgr.createCredential(_gssName.canonicalize(krb5MechOid), Integer.MAX_VALUE, krb5MechOid, 1);
                                                if (WSKrb5LoginModule.this._gssCred != null && WSKrb5LoginModule.this._credential == null) {
                                                    SubjectHelper.putGSSCredentialInSubject(WSKrb5LoginModule.this._gssCred, WSKrb5LoginModule.this._subject);
                                                }
                                                if (WSKrb5LoginModule.this._credential != null) {
                                                    WSKrb5LoginModule.this._credential = Krb5WSCredentialUtils.Krb5ToAuthMechWSCredential(WSKrb5LoginModule.this._subject, WSKrb5LoginModule.this._gssCred, WSKrb5LoginModule.this._credential);
                                                    WSKrb5LoginModule.this._sharedState.put("WSCredential", WSKrb5LoginModule.this._credential);
                                                }
                                                if ((ssoToken = (SingleSignonToken)WSKrb5LoginModule.this._sharedState.get("com.ibm.wsspi.security.token.wsSingleSignonToken")) != null) {
                                                    if (WSKrb5LoginModule.this._debug || tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Setting expiration in SSO token: " + String.valueOf(WSKrb5LoginModule.this._credential.getExpiration()));
                                                    }
                                                    ssoToken.addAttribute("com.ibm.wsspi.security.cred.expiration", String.valueOf(WSKrb5LoginModule.this._credential.getExpiration()));
                                                    WSKrb5LoginModule.this._sharedState.put("com.ibm.wsspi.security.token.wsSingleSignonToken", ssoToken);
                                                } else if (WSKrb5LoginModule.this._debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Could not find the SSO token in shared state.");
                                                }
                                                AuthorizationToken authzToken = (AuthorizationToken)WSKrb5LoginModule.this._sharedState.get("com.ibm.wsspi.security.token.wsAuthorizationToken");
                                                if (authzToken != null) {
                                                    authzToken.addAttribute("com.ibm.wsspi.security.cred.expiration", String.valueOf(WSKrb5LoginModule.this._credential.getExpiration()));
                                                    authzToken.addAttribute("com.ibm.wsspi.security.cred.oid", WSKrb5LoginModule.this._credential.getOID());
                                                    boolean f_boolean = WSKrb5LoginModule.this._credential.isForwardable();
                                                    authzToken.addAttribute("com.ibm.wsspi.security.cred.forwardable", String.valueOf(f_boolean));
                                                } else if (WSKrb5LoginModule.this._debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Could not find the authorization token in shared state.");
                                                }
                                                if (WSKrb5LoginModule.this._gssCred != null | WSKrb5LoginModule.this._kTicket != null) {
                                                    Krb5Utils.createKRBAuthnToken(WSKrb5LoginModule.this._kTicket, WSKrb5LoginModule.this._gssCred, WSKrb5LoginModule.this._subject);
                                                }
                                                if (WSKrb5LoginModule.this._kTicket != null) {
                                                    WSKrb5LoginModule.this._subject.getPrivateCredentials().remove(WSKrb5LoginModule.this._kTicket);
                                                }
                                            } else if (WSKrb5LoginModule.this._debug || tc.isDebugEnabled()) {
                                                Tr.debug(tc, "No gssCred and Kerberos ticket in shared state, can not create KRBAuthnToken");
                                            }
                                        }
                                        catch (GSSException e) {
                                            if (WSKrb5LoginModule.this._debug || tc.isDebugEnabled()) {
                                                Tr.error(tc, "security.auth.kerberos.GSSException", new Object[]{e});
                                            }
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                        catch (Exception e) {
                                            if (WSKrb5LoginModule.this._debug || tc.isDebugEnabled()) {
                                                Tr.error(tc, "security.auth.kerberos.Exception", new Object[]{e});
                                            }
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                Tr.debug(tc, "Exception in Subject.doAS.", new Object[]{e});
                                throw e.getException();
                            }
                        }
                        catch (Exception e) {
                            Tr.debug(tc, "Exception during commit.", new Object[]{e});
                            if (e instanceof WSLoginFailedException) {
                                throw (WSLoginFailedException)e;
                            }
                            throw new WSLoginFailedException(e.getMessage(), e);
                        }
                    }
                }
                if (this._principal == null) {
                    this._principal = (WSPrincipal)this._sharedState.get("WSPrincipal");
                    if (this._principal == null) {
                        throw new WSLoginFailedException("WSPrincipal is null in commit (phase 2) stage");
                    }
                } else if (this._sharedState.get("WSPrincipal") == null) {
                    this._sharedState.put("WSPrincipal", this._principal);
                }
                if (this._credential == null) {
                    this._credential = (WSCredential)this._sharedState.get("WSCredential");
                    if (this._credential == null) {
                        throw new WSLoginFailedException("WSCredential is null in commit (phase 2) stage");
                    }
                } else if (this._sharedState.get("WSCredential") == null) {
                    this._sharedState.put("WSCredential", this._credential);
                }
                try {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (!WSKrb5LoginModule.this._subject.getPrincipals().contains(WSKrb5LoginModule.this._principal)) {
                                WSKrb5LoginModule.this._subject.getPrincipals().add(WSKrb5LoginModule.this._principal);
                            }
                            if (!WSKrb5LoginModule.this._subject.getPublicCredentials().contains(WSKrb5LoginModule.this._credential)) {
                                WSKrb5LoginModule.this._subject.getPublicCredentials().add(WSKrb5LoginModule.this._credential);
                            }
                            return null;
                        }
                    });
                    GSSCredential verifyCred = SubjectHelper.getGSSCredentialFromSubject(this._subject);
                    if (verifyCred == null && WSSecurityHelper.isGlobalSecurityEnabled() && (this._debug || tc.isDebugEnabled())) {
                        Tr.debug(tc, "GSSCredential is not in the Subject after commit (phase 2) stage.");
                    }
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this._commitSucceeded = true;
                }
                catch (Exception e) {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.error(tc, "security.auth.kerberos.DoPrivException", new Object[]{e});
                    }
                    this.cleanup();
                    this._commitSucceeded = false;
                }
            } else if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            try {
                if (this._kTicket != null && this._subject.getPrivateCredentials().contains(this._kTicket)) {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removed Kerberos ticket from a subject: " + this._kTicket);
                    }
                    this._subject.getPrivateCredentials().remove(this._kTicket);
                }
            }
            catch (Exception e) {
                if (!this._debug && !tc.isDebugEnabled()) break block37;
                Tr.error(tc, "security.auth.kerberos.RemCredException", new Object[]{e});
            }
        }
        bRet = this._commitSucceeded;
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (this._debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes principal and credential, reset variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this._debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes principal and credential, reset variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this._debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this._succeeded = false;
        this._commitSucceeded = false;
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing principal and credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                try {
                                    if (WSKrb5LoginModule.this._principal != null && WSKrb5LoginModule.this._subject.getPrincipals().contains(WSKrb5LoginModule.this._principal)) {
                                        WSKrb5LoginModule.this._subject.getPrincipals().remove(WSKrb5LoginModule.this._principal);
                                    }
                                }
                                catch (Exception e) {
                                    if (!WSKrb5LoginModule.this._debug && !tc.isDebugEnabled()) break block13;
                                    Tr.error(tc, "security.auth.kerberos.RemPrincException", new Object[]{e});
                                }
                            }
                            try {
                                if (WSKrb5LoginModule.this._credential != null && WSKrb5LoginModule.this._subject.getPublicCredentials().contains(WSKrb5LoginModule.this._credential)) {
                                    WSKrb5LoginModule.this._subject.getPublicCredentials().remove(WSKrb5LoginModule.this._credential);
                                }
                            }
                            catch (Exception e) {
                                if (!WSKrb5LoginModule.this._debug && !tc.isDebugEnabled()) break block14;
                                Tr.error(tc, "security.auth.kerberos.RemCredException", new Object[]{e});
                            }
                        }
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "acceptSecContext: clean up Kerberos ticket " + WSKrb5LoginModule.this._kTicket);
                            }
                            if (WSKrb5LoginModule.this._kTicket != null && WSKrb5LoginModule.this._subject.getPrivateCredentials().contains(WSKrb5LoginModule.this._kTicket)) {
                                WSKrb5LoginModule.this._subject.getPrivateCredentials().remove(WSKrb5LoginModule.this._kTicket);
                                Tr.debug(tc, "acceptSecContext: removed Kerberos ticket " + WSKrb5LoginModule.this._kTicket);
                            }
                        }
                        catch (Exception e) {
                            if (!WSKrb5LoginModule.this._debug && !tc.isDebugEnabled()) break block15;
                            Tr.error(tc, "security.auth.kerberos.RemCredException", new Object[]{e});
                        }
                    }
                    if (WSKrb5LoginModule.this._credential != null) {
                        try {
                            WSKrb5LoginModule.this._credential.destroy();
                        }
                        catch (Exception e) {
                            if (!WSKrb5LoginModule.this._debug && !tc.isDebugEnabled()) break block16;
                            Tr.error(tc, "security.auth.kerberos.DestroyCredException", new Object[]{e});
                        }
                    }
                }
                return null;
            }
        });
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this._principal = null;
        this._credential = null;
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private boolean authenticate(String uid) throws LoginException {
        block9: {
            block8: {
                if (this._debug || tc.isEntryEnabled()) {
                    Tr.entry(tc, "authenticate()");
                }
                try {
                    this._credential = Krb5WSCredentialUtils.Krb5ToRegistryWSCredential(uid);
                }
                catch (Exception ex) {
                    if (!this._debug && !tc.isDebugEnabled()) break block8;
                    Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
                }
            }
            try {
                if (this._credential == null) {
                    throw new LoginException("WSCredential is null in login (phase 1) stage");
                }
                this._principal = ContextManagerFactory.getInstance().createPrincipal(this._credential);
                if (this._principal == null) {
                    throw new LoginException("WSPrincipal is null in login (phase 1) stage");
                }
            }
            catch (Exception ex) {
                if (!this._debug && !tc.isDebugEnabled()) break block9;
                Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
            }
        }
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate()");
        }
        return true;
    }

    private boolean validate(byte[] CredToken) throws LoginException {
        byte[] outToken = null;
        GSSCredential serverCred = null;
        GSSContext serverContext = null;
        boolean credDelegState = false;
        if (this._debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        try {
            Object[] parms;
            if (CredToken == null || CredToken.length == 0) {
                throw new WSLoginFailedException("CredToken is null");
            }
            Object serverName = null;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            try {
                serverCred = contextManager.getServerSpnGSSCred();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "acceptSecContext: GSScredentials: " + serverCred);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                Object[] parms2 = new Object[]{"createCredential()", exc};
                Tr.error(tc, "security.auth.kerberos.exception", parms2);
                throw new WSLoginFailedException(exc.getMessage(), exc);
            }
            try {
                serverContext = this._mgr.createContext(serverCred);
            }
            catch (GSSException exc) {
                exc.printStackTrace();
                Object[] parms3 = new Object[]{"createContext()", exc};
                Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms3);
                throw new WSLoginFailedException(exc.getMessage(), exc);
            }
            Krb5Utils.setUseSubjectCredsOnly(true);
            try {
                final GSSContext inServerContext = serverContext;
                final byte[] inCredToken = CredToken;
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "acceptSecContext: calling acceptSecContext.");
                        }
                        return inServerContext.acceptSecContext(inCredToken, 0, inCredToken.length);
                    }
                };
                try {
                    outToken = (byte[])Subject.doAsPrivileged(this._subject, action, AccessController.getContext());
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.wskrb5loginmodule.login", "979", this);
                    e.printStackTrace();
                    throw e.getException();
                }
            }
            catch (GSSException exc) {
                Object[] parms4 = new Object[]{"acceptSecContext()", exc};
                Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms4);
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.auth.kerberos.wskrb5loginmodule.login", "987", this);
                exc.printStackTrace();
                throw new WSLoginFailedException(exc.getMessage(), exc);
            }
            catch (Exception e) {
                Object[] parms5 = new Object[]{"acceptSecContext()", e};
                Tr.error(tc, "security.auth.kerberos.exception", parms5);
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.wskrb5loginmodule.login", "995", this);
                e.printStackTrace();
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            if (outToken == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "acceptSecContext: outToken is null");
            }
            if (this._subject != null && this._subject.toString().length() != 0) {
                this._kTicket = SubjectHelper.getKerberosTicketFromSubject(this._subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "acceptSecContext: " + this._subject.toString());
                    Tr.debug(tc, "acceptSecContext: kerberos ticket: " + this._kTicket);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "acceptSecContext: subject is null.");
            }
            if (serverContext.isEstablished()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "acceptSecContext: serverContext established successfully.");
                }
            } else {
                Object[] parms6 = new Object[]{serverContext};
                Tr.error(tc, "security.auth.kerberos.init.ctxnotestablished", parms6);
                throw new WSLoginFailedException("Server context is not establish");
            }
            GSSName gssUserName = null;
            boolean enabledGssCredDel = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getBoolean("enabledGssCredDelegate");
            if (enabledGssCredDel) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "acceptSecContext: delegated credentials state for the context is " + serverContext.getCredDelegState());
                    }
                    this._gssCred = serverContext.getDelegCred();
                }
                catch (GSSException exc) {
                    parms = new Object[]{"getDelegCred()", exc};
                    Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
                }
            }
            gssUserName = this._gssCred != null ? this._gssCred.getName() : serverContext.getSrcName();
            String userName = null;
            if (gssUserName != null) {
                userName = ((Object)gssUserName).toString();
                if (this._gssCred == null && enabledGssCredDel) {
                    Tr.warning(tc, "security.auth.kerberos.noDelegatedCredentialsFound", userName);
                }
            } else {
                parms = new Object[]{serverContext, serverName};
                Tr.error(tc, "security.auth.kerberos.gssUserNameIsNull", parms);
                throw new WSLoginFailedException("GSS user name is null");
            }
            this.createCredentialsFromUsername(userName);
        }
        catch (Exception exc) {
            Object[] parms = new Object[]{"validate()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            if (exc instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exc;
            }
            throw new WSLoginFailedException(exc.getMessage(), exc);
        }
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return true;
    }

    private void createCredentialsFromUsername(String userName) {
        block6: {
            if (this._debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "createCredentialsFromUsername()");
            }
            try {
                this._credential = Krb5WSCredentialUtils.Krb5ToRegistryWSCredential(userName);
                if (this._credential != null) {
                    this._credential = Krb5WSCredentialUtils.Krb5ToAuthMechWSCredential(this._subject, this._gssCred, this._credential);
                    this._principal = ContextManagerFactory.getInstance().createPrincipal(this._credential);
                    if (this._principal == null) {
                        throw new LoginException("WSPrincipal is null in validate stage");
                    }
                    break block6;
                }
                throw new LoginException("WSCredential is null in validate stage");
            }
            catch (Exception ex) {
                if (!this._debug && !tc.isDebugEnabled()) break block6;
                Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
            }
        }
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredentialsFromUsername()");
        }
    }

    private void createCredentialsFromHashtable(Hashtable customProperties, GSSCredential _gssCred) {
        block6: {
            if (this._debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "createCredentialsFromHashtable()");
            }
            try {
                WSCredentialTokenMapperInterface wsCredMapper = WSCredentialTokenMapper.getInstance();
                this._credential = wsCredMapper.createWSCredentialFromProperties(customProperties);
                if (this._credential != null) {
                    this._credential = Krb5WSCredentialUtils.Krb5ToAuthMechWSCredential(this._subject, _gssCred, this._credential);
                    this._principal = ContextManagerFactory.getInstance().createPrincipal(this._credential);
                    if (this._principal == null) {
                        throw new LoginException("WSPrincipal is null in validate stage");
                    }
                    break block6;
                }
                throw new LoginException("WSCredential is null in validate stage");
            }
            catch (Exception ex) {
                if (!this._debug && !tc.isDebugEnabled()) break block6;
                Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
            }
        }
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredentialsFromUsername()");
        }
    }
}

