/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AuditLogger {
    private static final TraceComponent tc = Tr.register(AuditLogger.class, null, "com.ibm.ejs.resources.security");
    public static String fileName = null;
    public static WrappingFileOutputStream wfosAuditLog = null;
    public static WrappingFileOutputStream wfosBinaryLog = null;
    public static TraceLogger traceLogger = null;
    public static TraceLogger binaryLogger = null;
    private static boolean logInited = false;
    private static boolean usingBinaryLog = false;
    private static String osName = null;
    private static String tailLine = "************* End Display Current Environment *************";
    private static String filePrefix = null;
    private static String fileSuffix = null;
    private static String ivPreviousTime = "";

    public static WsHandler createAuditLogger(String header, String maxFileSize, String maxArchives, String fileLocation) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "createAuditLogger");
        }
        int index = -1;
        if (!logInited) {
            try {
                String cellName = SecurityObjectLocator.getAdminData().getString("cellname");
                if (cellName == null) {
                    traceLogger = null;
                    return traceLogger;
                }
                String process = RasHelper.getServerName();
                osName = System.getProperty("os.name");
                if (osName == null) {
                    Tr.info(tc, "osName was null");
                } else {
                    index = process.lastIndexOf("\\");
                    fileName = index != -1 ? AuditLogger.getDirectoryName() + File.separator + process.substring(index + 1) + File.separator + "AuditLog.log" : AuditLogger.getDirectoryName() + File.separator + process + File.separator + "AuditLog.log";
                }
                wfosAuditLog = maxFileSize != null && maxArchives != null ? new WrappingFileOutputStream(fileName, Integer.parseInt(maxArchives), Integer.parseInt(maxFileSize)) : new WrappingFileOutputStream(fileName, 10, 0x1400000L);
                logInited = true;
                traceLogger = new TraceLogger(wfosAuditLog, true, true, header);
                wfosAuditLog.addRolloverListener(traceLogger);
                traceLogger.logRolled();
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "createAuditLogger");
                }
                return traceLogger;
            }
            catch (RasException re2) {
                Tr.error(tc, "security.audit.logger.init.error", new Object[]{re2});
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "createAuditLogger");
                }
                return null;
            }
            catch (IOException ie) {
                Tr.error(tc, "security.audit.logger.init.error", new Object[]{ie});
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "createAuditLogger");
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "createAuditLogger");
        }
        return traceLogger;
    }

    public static void closeAuditLogger(WsHandler handler) {
        if (wfosAuditLog == null) {
            return;
        }
        try {
            wfosAuditLog.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        wfosAuditLog = null;
        if (handler == null) {
            return;
        }
        Tr.removeWsHandler(handler);
    }

    public static WrappingFileOutputStream getAuditLog() {
        return wfosAuditLog;
    }

    public static void writeBytes(byte[] bytes) {
        try {
            if (usingBinaryLog) {
                if (wfosBinaryLog == null) {
                    Tr.error(tc, "security.audit.logger.write.error");
                    return;
                }
            } else if (wfosAuditLog == null) {
                Tr.error(tc, "security.audit.logger.write.error");
                return;
            }
            if (bytes == null) {
                Tr.error(tc, "security.audit.logger.write.error");
                return;
            }
            if (usingBinaryLog) {
                wfosBinaryLog.write(bytes);
            } else {
                wfosAuditLog.write(bytes);
            }
        }
        catch (IOException ioe) {
            Tr.error(tc, "security.audit.logger.write.error");
        }
    }

    public static WsHandler createBinaryLogger(String header, String maxFileSize, String maxArchives, String fileLocation) throws Exception {
        int index = -1;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "createBinaryLogger");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "maxFileSize: " + maxFileSize + " maxArchives: " + maxArchives + " fileLocation: " + fileLocation);
        }
        try {
            String cellName = SecurityObjectLocator.getAdminData().getString("cellname");
            if (cellName == null) {
                binaryLogger = null;
                return binaryLogger;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fileLocation = " + fileLocation);
                Tr.debug(tc, "maxFileSize =  " + Integer.parseInt(maxFileSize) * 1024 * 1024);
                Tr.debug(tc, "maxArchives =  " + maxArchives);
            }
            if ((index = fileLocation.indexOf("${PROFILE_ROOT}")) != -1) {
                String firstPart = fileLocation.substring(0, index);
                String lastPart = fileLocation.substring(index + "${PROFILE_ROOT}".length());
                String userRoot = System.getProperty("user.install.root");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "User install root: " + userRoot);
                }
                if (userRoot != null) {
                    fileLocation = firstPart != null && !firstPart.equals("") ? firstPart + userRoot + lastPart : userRoot + lastPart;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adjusted fileLocation: " + fileLocation);
                }
            }
            if (fileLocation != null) {
                String processType = null;
                AdminService adminService = AdminServiceFactory.getAdminService();
                processType = adminService.getProcessType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process type: " + processType);
                }
                String nodeName = SecurityObjectLocator.getAdminData().getString("nodename");
                String serverName = SecurityObjectLocator.getAdminData().getString("shortservername");
                fileName = fileLocation + File.separator + "BinaryAudit_" + cellName + "_" + nodeName + "_" + serverName + ".log";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fileName: " + fileName);
                }
                filePrefix = fileName.substring(0, fileName.indexOf(".log"));
                fileSuffix = ".log";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "filePrefix: " + filePrefix + " fileSuffix: " + fileSuffix);
                }
                File backup = new File(fileName);
                boolean exists = false;
                final File tempFileToCheck = backup;
                try {
                    Boolean existsB = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return new Boolean(tempFileToCheck.exists());
                        }
                    });
                    exists = existsB;
                }
                catch (SecurityException se) {
                    exists = false;
                }
                if (exists) {
                    String ts = AuditLogger.generateTimeStampQualifier();
                    String backupFileName = filePrefix + "_" + ts + fileSuffix;
                    File newbackup = new File(backupFileName);
                    boolean renameSucceeded = RasHelper.renameFile(backup, newbackup);
                    try {
                        RasHelper.copyFile(backup, newbackup);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                wfosBinaryLog = maxFileSize != null && maxArchives != null ? new WrappingFileOutputStream(fileName, Integer.parseInt(maxArchives), Integer.parseInt(maxFileSize) * 1024 * 1024) : new WrappingFileOutputStream(fileName, 10, 0x1400000L);
            }
            usingBinaryLog = true;
            binaryLogger = new TraceLogger(wfosBinaryLog, true, true, header);
            wfosBinaryLog.addRolloverListener(binaryLogger);
            binaryLogger.logRolled();
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "createBinaryLogger");
            }
            return binaryLogger;
        }
        catch (RasException re2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditLogger: caught RasException opening binary log");
            }
            Tr.error(tc, "security.audit.logger.init.error", new Object[]{re2});
            re2.printStackTrace();
            throw new Exception(re2);
        }
        catch (IOException ie) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditLogger: caught IOException opening binary log");
            }
            Tr.error(tc, "security.audit.logger.init.error", new Object[]{ie});
            ie.printStackTrace();
            throw new Exception(ie);
        }
    }

    private static String generateTimeStampQualifier() {
        SimpleDateFormat ivDateFormatter = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
        Date date = new Date(System.currentTimeMillis());
        String current = ivDateFormatter.format(date);
        int maxTries = 20;
        while (current.equals(ivPreviousTime)) {
            if (--maxTries <= 0) {
                return current;
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            date = new Date(System.currentTimeMillis());
            current = ivDateFormatter.format(date);
        }
        ivPreviousTime = current;
        return current;
    }

    public static void closeBinaryLogger(WsHandler handler) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "closeBinaryLogger");
        }
        if (wfosBinaryLog == null) {
            return;
        }
        try {
            wfosBinaryLog.flush();
            wfosBinaryLog.close();
            String backupFileName = null;
            File backup = new File(fileName);
            File newbackup = null;
            boolean exists = true;
            for (int counter = 0; exists && counter < 3; ++counter) {
                String ts = AuditLogger.generateTimeStampQualifier();
                backupFileName = filePrefix + "_" + ts + fileSuffix;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "backupFileName: " + backupFileName);
                }
                newbackup = new File(backupFileName);
                exists = RasHelper.fileExists(newbackup);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "counter: " + counter + " exists: " + exists);
            }
            if (exists) {
                String msg = "Failed to rename the BinaryAudit.log with a timestamp";
                throw new Exception(msg);
            }
            boolean renameSucceeded = RasHelper.renameFile(backup, newbackup);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "renameSucceeded: " + renameSucceeded);
            }
            RasHelper.copyFile(backup, newbackup);
        }
        catch (Exception exception) {
            // empty catch block
        }
        wfosBinaryLog = null;
        if (handler == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "closeBinaryLogger");
            }
            return;
        }
        Tr.removeWsHandler(handler);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "closeBinaryLogger");
        }
    }

    public static WrappingFileOutputStream getBinaryLog() {
        return wfosBinaryLog;
    }

    public static String getDirectoryName() {
        String name = System.getProperty("user.install.root");
        if (name == null) {
            Tr.error(tc, "Error: Could not find WebSphere install root");
            return null;
        }
        if (osName.indexOf("Windows") != -1) {
            name = name.concat("\\logs");
            return name;
        }
        name = name.concat("/logs");
        return name;
    }
}

