/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.security.SecurityCommon;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.config.securitydomain.SecDomainHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.securitydomain.DomainCheckerExtensionsProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SecurityDomainProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(SecurityDomainProvider.class, "security", "com.ibm.ws.security.admintask.securityDomain");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static final String CELL = "Cell";
    private static final String SERVER = "Server";
    private static final String SERVERCLUSTER = "ServerCluster";
    private static final String CLUSTER = "Cluster";
    private static final String SIBUS = "SIBus";

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public String createSecurityDomain(AbstractAdminCommand cmd) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSecurityDomain", new Object[]{cmd});
        }
        ObjectName secID = null;
        ObjectName secDomain = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomainName = (String)cmd.getParameter("securityDomainName");
            String secDomainDesc = (String)cmd.getParameter("securityDomainDescription");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainDescription name is " + secDomainDesc);
            }
            if (secDomainName.equalsIgnoreCase("global") || secDomainName.equalsIgnoreCase("admin")) {
                String msg = this.getMsg(resBundle, "security.admintask.cannotCreateDomain.SECJ7811E", new Object[]{secDomainName});
                throw new CommandValidationException(msg);
            }
            ObjectName cell = this.getCellObjectName(session, configService);
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, "name", secDomainName);
            ConfigServiceHelper.setAttributeValue(attrList, "description", secDomainDesc);
            secID = configService.createConfigData(session, cell, "SecurityDomain", "SecurityDomain", attrList);
            attrList.clear();
            secDomain = configService.createConfigData(session, secID, "AppSecurity", "AppSecurity", attrList);
            string = ConfigServiceHelper.getConfigDataId(secDomain).toString();
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSecurityDomain", secDomain);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSecurityDomain", secDomain);
        }
        return string;
    }

    public List listSecurityDomains(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSecurityDomains", new Object[]{cmd});
        }
        Object secDomain = null;
        ArrayList<Object> domainList = new ArrayList<Object>();
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            Boolean listDescription = (Boolean)cmd.getParameter("listDescription");
            Boolean listSpecialDomains = (Boolean)cmd.getParameter("doNotDisplaySpecialDomains");
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
            ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
            for (int i = 0; i < domains.length; ++i) {
                ObjectName domain = domains[i];
                String name = (String)configService.getAttribute(session, domain, "name");
                if (name == null || name.equals("PassThroughToGlobalSecurity") && listSpecialDomains.booleanValue()) continue;
                AttributeList attrs = new AttributeList();
                if (listDescription.booleanValue()) {
                    ConfigServiceHelper.setAttributeValue(attrs, "name", name);
                    String desc = (String)configService.getAttribute(session, domain, "description");
                    ConfigServiceHelper.setAttributeValue(attrs, "description", desc);
                    domainList.add(attrs);
                    continue;
                }
                domainList.add(name);
            }
            ArrayList<Object> arrayList = domainList;
            return arrayList;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listSecurityDomains", secDomain);
            }
        }
    }

    public void deleteSecurityDomain(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSecurityDomain", new Object[]{cmd});
        }
        ArrayList realms = null;
        try {
            ObjectName pattern;
            ObjectName apps;
            ObjectName domain;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomainName = (String)cmd.getParameter("securityDomainName");
            Boolean force = (Boolean)cmd.getParameter("force");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomainName + ":" + "force is " + force);
            }
            if ((domain = this.getSecurityDomainObj(session, configService, secDomainName)) == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomainName});
                throw new CommandValidationException(msg);
            }
            if (force == null || !force.booleanValue()) {
                String msg;
                List members = (List)configService.getAttribute(session, domain, "members");
                boolean validMembers = false;
                if (members.size() > 0) {
                    for (AttributeList member : members) {
                        String resourceName = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                        String convertedResourceName = SecDomainHelper.convertResource(resourceName);
                        try {
                            ObjectName[] resourceObjectName = configService.resolve(session, convertedResourceName);
                            String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
                            validMembers = true;
                            break;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "resourceName = " + convertedResourceName + " is not a valid resource");
                        }
                    }
                }
                if (validMembers) {
                    msg = this.getMsg(resBundle, "security.admintask.scopeMapped.SECJ7717E", null);
                    throw new CommandValidationException(msg);
                }
                if (this.bindingsExists(session, secDomainName)) {
                    msg = this.getMsg(resBundle, "security.admintask.scopeMapped.SECJ7717E", null);
                    throw new CommandValidationException(msg);
                }
            }
            if ((apps = configService.queryConfigObjects(session, domain, pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity"), null)[0]) != null) {
                realms = this.getRealmsFromDomain(configService, session, apps);
                configService.deleteConfigData(session, apps);
            }
            configService.deleteConfigData(session, domain);
            if (realms != null && realms.size() > 0 && (realms = this.checkForValidRealm(configService, session, realms)) != null && realms.size() > 0) {
                this.removeRealmFromTrustedRealmsList(configService, session, realms);
            }
            return;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteSecurityDomains");
            }
        }
    }

    private boolean bindingsExists(Session session, String secDomainName) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "bindingsExists", new Object[]{secDomainName});
            }
            try {
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand getUserCmd = commandMgr.createCommand("getDefaultBindings");
                getUserCmd.setParameter("domainName", secDomainName);
                getUserCmd.setConfigSession(session);
                getUserCmd.execute();
                CommandResult cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    Properties props;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Successfully called getDefaultBindings");
                    }
                    if ((props = (Properties)cmdResult.getResult()) != null && props.size() > 0) {
                        String providerValue;
                        String clientValue;
                        if (props.containsKey("client") && (clientValue = (String)props.get("client")) != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "bindingsExists -> false");
                            }
                            return true;
                        }
                        if (props.containsKey("provider") && (providerValue = (String)props.get("provider")) != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "bindingsExists -> false");
                            }
                            return true;
                        }
                    }
                } else {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "verifyKrbConfig did not execute.", new Object[]{e});
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "getDefaultBindings did not execute.", new Object[]{e});
            }
        }
        return false;
    }

    public void mapResourceToSecurityDomain(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapResourceToSecurityDomain", new Object[]{cmd});
        }
        String resource = null;
        try {
            ObjectName domain;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            ObjectName[] resourceObjectName = null;
            String secDomainName = (String)cmd.getParameter("securityDomainName");
            String resourceName = (String)cmd.getParameter("resourceName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName is " + secDomainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName is " + resourceName);
            }
            if ((domain = this.getSecurityDomainObj(session, configService, secDomainName)) == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomainName});
                throw new CommandValidationException(msg);
            }
            resourceObjectName = configService.resolve(session, resourceName);
            if (resourceObjectName.length > 0) {
                String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
                String resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName[0]);
                if (!DomainCheckerExtensionsProcessor.getProcessor().processHandleResource(resourceType)) {
                    String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                    throw new CommandValidationException(msg);
                }
                if (!secDomainName.equals("PassThroughToGlobalSecurity") && !DomainCheckerExtensionsProcessor.getProcessor().processValidateResource(resourceName, resourceType, session)) {
                    String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                    throw new CommandValidationException(msg);
                }
                if (resourceType.equalsIgnoreCase(SERVER) && this.isServerSecurityConfigured(session, configService, resourceObjectName[0])) {
                    String msg = this.getMsg(resBundle, "security.admintask.multidomain.oldServerSecurity.SECJ7788E", new Object[]{resourceName});
                    throw new CommandValidationException(msg);
                }
                if (resourceType.equalsIgnoreCase("cell") && this.isCellMixedVersion(session, configService)) {
                    this.createSpecialDomain(session, configService);
                }
                if (resourceType.equalsIgnoreCase("cell")) {
                    DomainCheckerExtensionsProcessor.getProcessor().processCellDomainMapped(session, configService);
                }
                if (!this.isResourceInADomain(session, configService, resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID)) {
                    AttributeList attrList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attrList, "resourceName", resource);
                    ConfigServiceHelper.setAttributeValue(attrList, "resourceType", resourceType);
                    configService.createConfigData(session, domain, "members", "SecurityDomainMember", attrList);
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                throw new CommandValidationException(msg);
            }
            return;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapResourceToSecurityDomain");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeResourceFromSecurityDomain(AbstractAdminCommand cmd) throws Exception {
        if (SecurityDomainProvider.tc.isEntryEnabled()) {
            Tr.entry(SecurityDomainProvider.tc, "removeResourceFromSecurityDomain", new Object[]{cmd});
        }
        try {
            helper = this.getCommandProviderHelper();
            configService = helper.getConfigService();
            session = cmd.getConfigSession();
            secDomainName = (String)cmd.getParameter("securityDomainName");
            resourceName = (String)cmd.getParameter("resourceName");
            if (SecurityDomainProvider.tc.isDebugEnabled()) {
                Tr.debug(SecurityDomainProvider.tc, "securityDomainName name is " + secDomainName);
            }
            if (SecurityDomainProvider.tc.isDebugEnabled()) {
                Tr.debug(SecurityDomainProvider.tc, "resourceName name is " + resourceName);
            }
            resource = null;
            resourceObjectName = configService.resolve(session, resourceName);
            if (resourceObjectName.length <= 0) ** GOTO lbl-1000
            resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
            resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName[0]);
            if (!DomainCheckerExtensionsProcessor.getProcessor().processHandleResource(resourceType)) {
                msg = this.getMsg(SecurityDomainProvider.resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                throw new CommandValidationException(msg);
            }
            resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
            pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
            domains = configService.queryConfigObjects(session, null, pattern, null);
            ** GOTO lbl27
lbl-1000:
            // 1 sources

            {
                block14: {
                    msg = this.getMsg(SecurityDomainProvider.resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                    throw new CommandValidationException(msg);
lbl27:
                    // 2 sources

                    for (i = 0; i < domains.length; ++i) {
                        domain = domains[i];
                        name = (String)configService.getAttribute(session, domain, "name");
                        if (!name.equals(secDomainName)) continue;
                        members = (List)configService.getAttribute(session, domain, "members");
                        iter = members.iterator();
                        break block14;
                    }
                    msg = this.getMsg(SecurityDomainProvider.resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomainName});
                    throw new CommandValidationException(msg);
                }
                while (iter.hasNext()) {
                    member = (AttributeList)iter.next();
                    if (resource.equals(ConfigServiceHelper.getAttributeValue(member, "resourceName"))) {
                        configService.deleteConfigData(session, ConfigServiceHelper.createObjectName(member));
                        return;
                    }
                    ** try [egrp 2[TRYBLOCK] [1 : 416->523)] { 
lbl43:
                    // 1 sources

                }
                msg = this.getMsg(SecurityDomainProvider.resBundle, "security.admintask.scope.not.in.domain.SECJ7719E", new Object[]{resourceName, secDomainName});
                throw new CommandValidationException(msg);
            }
        }
lbl46:
        // 2 sources

        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
            if (SecurityDomainProvider.tc.isDebugEnabled() == false) throw cse;
            Tr.debug(SecurityDomainProvider.tc, "exception caught", cse);
            throw cse;
        }
        finally {
            if (SecurityDomainProvider.tc.isEntryEnabled()) {
                Tr.exit(SecurityDomainProvider.tc, "removeResourceFromSecurityDomain");
            }
        }
    }

    public List listResourcesInSecurityDomain(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourcesInSecurityDomain", new Object[]{cmd});
        }
        ArrayList<String> listResources = new ArrayList<String>();
        try {
            ObjectName domain;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomainName = (String)cmd.getParameter("securityDomainName");
            Boolean expandCell = (Boolean)cmd.getParameter("expandCell");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expandCell name is " + expandCell);
            }
            if ((domain = this.getSecurityDomainObj(session, configService, secDomainName)) == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomainName});
                throw new CommandValidationException(msg);
            }
            List members = (List)configService.getAttribute(session, domain, "members");
            for (AttributeList member : members) {
                ObjectName resourceObjectName;
                String resourceName = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                if (resourceName == null || (resourceObjectName = configService.resolve(session, SecDomainHelper.convertResource(resourceName))[0]) == null) continue;
                String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName).toString();
                String resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName);
                if (expandCell.booleanValue() && resourceType.equalsIgnoreCase("cell")) {
                    List expandedCell = this.getServersInCell(session, configService, (String)configService.getAttribute(session, resourceObjectName, "name", false));
                    for (int i = 0; i < expandedCell.size(); ++i) {
                        String cellResource = (String)expandedCell.get(i);
                        if (listResources.contains(cellResource)) continue;
                        listResources.add(cellResource);
                    }
                    continue;
                }
                listResources.add(SecDomainHelper.convertResource1(resourceName));
            }
            ArrayList<String> arrayList = listResources;
            return arrayList;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listResourcesInSecurityDomain");
            }
        }
    }

    public String getSecurityDomainForResource(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityDomainForResource", new Object[]{cmd});
        }
        try {
            String name = null;
            String resource = null;
            String domainOfCell = null;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            ObjectName[] resourceObjectName = null;
            String resourceName = (String)cmd.getParameter("resourceName");
            Boolean getEffectiveDomain = (Boolean)cmd.getParameter("getEffectiveDomain");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName name is " + resourceName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getEffectiveDomain name is " + getEffectiveDomain);
            }
            domainOfCell = SecDomainHelper.getCellDomain(session, configService);
            resourceObjectName = configService.resolve(session, resourceName);
            if (resourceObjectName.length > 0) {
                String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
                String resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName[0]);
                if (!DomainCheckerExtensionsProcessor.getProcessor().processHandleResource(resourceType)) {
                    String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                    throw new CommandValidationException(msg);
                }
                resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
                name = SecDomainHelper.findDomainForResource(session, configService, resource);
                if (name == null && getEffectiveDomain != null && getEffectiveDomain.booleanValue()) {
                    ObjectName cluster;
                    String inCluster;
                    if (resourceType.equals(SERVER) && (inCluster = (String)configService.getAttribute(session, resourceObjectName[0], "clusterName")) != null && (cluster = configService.resolve(session, "Cell=:ServerCluster=" + inCluster)[0]) != null) {
                        String clusterResource = null;
                        String clusterConfigID = ConfigServiceHelper.getConfigDataId(cluster).toString();
                        clusterResource = clusterConfigID != null && clusterConfigID.lastIndexOf(124) > 0 ? clusterConfigID.substring(0, clusterConfigID.lastIndexOf(124)) : clusterConfigID;
                        name = SecDomainHelper.findDomainForResource(session, configService, clusterResource);
                    }
                    if (name == null && domainOfCell != null) {
                        name = domainOfCell;
                    }
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                throw new CommandValidationException(msg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityDomainForResource");
            }
            return name;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
    }

    public String copySecurityDomainFromGlobalSecurity(AbstractAdminCommand cmd) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copySecurityDomainFromGlobalSecurity", new Object[]{cmd});
        }
        ObjectName cell = null;
        ObjectName globalSec = null;
        ObjectName secDomain = null;
        ObjectName secID = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomainName = (String)cmd.getParameter("securityDomainName");
            String secDomainDesc = (String)cmd.getParameter("securityDomainDescription");
            String realmName = (String)cmd.getParameter("realmName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainDescription name is " + secDomainDesc);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmName name is " + realmName);
            }
            cell = this.getCellObjectName(session, configService);
            globalSec = this.getSecurityObjectName(session, configService);
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("name", secDomainName));
            attrList.add(new Attribute("description", secDomainDesc));
            secID = configService.createConfigData(session, cell, "SecurityDomain", "SecurityDomain", attrList);
            attrList.clear();
            secDomain = configService.createConfigData(session, secID, "AppSecurity", "AppSecurity", attrList);
            this.copyToSecurityConfig(session, configService, globalSec, secDomain, realmName);
            string = ConfigServiceHelper.getConfigDataId(secDomain).toString();
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "88");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "copySecurityDomainFromGlobalSecurity", secDomain);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copySecurityDomainFromGlobalSecurity", secDomain);
        }
        return string;
    }

    public String copySecurityDomain(AbstractAdminCommand cmd) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copySecurityDomain", new Object[]{cmd});
        }
        ObjectName cell = null;
        ObjectName fromConfig = null;
        ObjectName secDomain = null;
        ObjectName secID = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomainName = (String)cmd.getParameter("securityDomainName");
            String secDomainDesc = (String)cmd.getParameter("securityDomainDescription");
            String fromSecDomainName = (String)cmd.getParameter("copyFromSecurityDomainName");
            String realmName = (String)cmd.getParameter("realmName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainDescription name is " + secDomainDesc);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copyFromSecurityDomainName name is " + fromSecDomainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmName name is " + realmName);
            }
            cell = this.getCellObjectName(session, configService);
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("name", secDomainName));
            attrList.add(new Attribute("description", secDomainDesc));
            secID = configService.createConfigData(session, cell, "SecurityDomain", "SecurityDomain", attrList);
            attrList.clear();
            secDomain = configService.createConfigData(session, secID, "AppSecurity", "AppSecurity", attrList);
            fromConfig = this.getSecurityDomain(session, configService, fromSecDomainName);
            if (fromConfig == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{fromSecDomainName});
                throw new CommandValidationException(msg);
            }
            this.copyToSecurityConfig(session, configService, fromConfig, secDomain, realmName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copySecurityConfig", new Object[]{cmd});
            }
            string = ConfigServiceHelper.getConfigDataId(secDomain).toString();
        }
        catch (Exception cse) {
            try {
                FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "copySecurityDomain", secDomain);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copySecurityDomain", secDomain);
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    public void modifySecurityDomain(AbstractAdminCommand cmd) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] listSecurityDomainsForResources(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSecurityDomainsForResources");
        }
        String[] resources = null;
        String domainOfResource = null;
        String domainOfCell = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            domainOfCell = SecDomainHelper.getCellDomain(session, configService);
            String resourceList = (String)cmd.getParameter("resourceNames");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceNames name is " + resourceList);
            }
            resources = resourceList.split("\\+");
            for (int i = 0; i < resources.length; ++i) {
                String resourceName = resources[i];
                String resource = null;
                ObjectName[] resourceObjectName = configService.resolve(session, resourceName);
                if (resourceObjectName.length > 0) {
                    String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
                    String resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName[0]);
                    String displayName = ConfigServiceHelper.getDisplayName(resourceObjectName[0]);
                    if (!DomainCheckerExtensionsProcessor.getProcessor().processHandleResource(resourceType)) {
                        String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                        throw new CommandValidationException(msg);
                    }
                    resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
                    if (resourceType.equalsIgnoreCase(SERVER)) {
                        ObjectName cluster;
                        String inCluster;
                        domainOfResource = SecDomainHelper.findDomainForResource(session, configService, resource);
                        if (domainOfResource == null && (inCluster = (String)configService.getAttribute(session, resourceObjectName[0], "clusterName")) != null && (cluster = configService.resolve(session, "Cell=:ServerCluster=" + inCluster)[0]) != null) {
                            String clusterResource = null;
                            String clusterConfigID = ConfigServiceHelper.getConfigDataId(cluster).toString();
                            clusterResource = clusterConfigID != null && clusterConfigID.lastIndexOf(124) > 0 ? clusterConfigID.substring(0, clusterConfigID.lastIndexOf(124)) : clusterConfigID;
                            domainOfResource = SecDomainHelper.findDomainForResource(session, configService, clusterResource);
                        }
                    } else {
                        domainOfResource = SecDomainHelper.findDomainForResource(session, configService, resource);
                    }
                    if (domainOfResource != null) {
                        resources[i] = "WebSphere:" + SecDomainHelper.convertResource1(resource) + "(" + domainOfResource + ")";
                        continue;
                    }
                    if (domainOfCell != null) {
                        resources[i] = "WebSphere:" + SecDomainHelper.convertResource1(resource) + "(" + domainOfCell + ")";
                        continue;
                    }
                    resources[i] = "WebSphere:" + SecDomainHelper.convertResource1(resource);
                    continue;
                }
                String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "%c%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listSecurityDomainsForResources");
            }
        }
        return resources;
    }

    private ObjectName getCellObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellObjectName", new Object[]{session, configService, this});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Policy");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + cell + ". Cell Name is " + ConfigServiceHelper.getDisplayName(cell));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellObjectName", cell);
        }
        return cell;
    }

    private ObjectName getSecurityObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityObjectName", new Object[]{session, configService, this});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
        ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security ObjectName is " + security2 + ". Cell Name is " + ConfigServiceHelper.getDisplayName(security2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityObjectName", security2);
        }
        return security2;
    }

    private ObjectName getSecurityDomain(Session session, ConfigService configService, String domainName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityDomain", new Object[]{session, configService, this});
        }
        ObjectName domainObj = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
        ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < domains.length; ++i) {
            ObjectName domain = domains[i];
            String name = (String)configService.getAttribute(session, domain, "name");
            if (!name.equals(domainName)) continue;
            pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
            ObjectName apps = configService.queryConfigObjects(session, domain, pattern, null)[0];
            if (apps == null) break;
            domainObj = apps;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityDomain", domainObj);
        }
        return domainObj;
    }

    private ObjectName getSecurityDomainObj(Session session, ConfigService configService, String domainName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityDomainObj", new Object[]{session, configService, this});
        }
        ObjectName domainObj = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
        ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < domains.length; ++i) {
            ObjectName domain = domains[i];
            String name = (String)configService.getAttribute(session, domain, "name");
            if (!name.equals(domainName)) continue;
            domainObj = domain;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityDomainObj", domainObj);
        }
        return domainObj;
    }

    private boolean isResourceInADomain(Session session, ConfigService configService, String resourceName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResourceInADomain");
        }
        boolean inDomain = false;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
        ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < domains.length; ++i) {
            ObjectName domain = domains[i];
            List members = (List)configService.getAttribute(session, domain, "members");
            for (AttributeList member : members) {
                if (!resourceName.equals(ConfigServiceHelper.getAttributeValue(member, "resourceName"))) continue;
                String name = (String)configService.getAttribute(session, domain, "name");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error: " + resourceName + " already exists in the " + name + " domain.");
                }
                String msg = this.getMsg(resBundle, "security.admintask.scope.in.domain.SECJ7703E", new Object[]{resourceName, name});
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResouceInADomain");
        }
        return inDomain;
    }

    private void copyToSecurityConfig(Session session, ConfigService configService, ObjectName fromConfig, ObjectName toConfig, String realm) throws Exception {
        Boolean appEnabled;
        Boolean enforceJava2Security;
        Boolean issuePermissionWarning;
        Integer cacheTimeout;
        ArrayList registries;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToSecurityConfig");
        }
        ObjectName auObj = null;
        AttributeList attrList = new AttributeList();
        attrList = configService.getAttributes(session, fromConfig, new String[]{"authConfig"}, true);
        configService.setAttributes(session, toConfig, attrList);
        AttributeList auth = (AttributeList)configService.getAttribute(session, toConfig, "authConfig");
        if (auth != null) {
            attrList.clear();
            attrList.add(new Attribute("useNativeAuthorization", null));
            ObjectName authObj = ConfigServiceHelper.createObjectName(auth);
            configService.setAttributes(session, authObj, attrList);
        }
        attrList.clear();
        attrList = configService.getAttributes(session, fromConfig, new String[]{"applicationLoginConfig"}, true);
        configService.setAttributes(session, toConfig, attrList);
        attrList.clear();
        attrList = configService.getAttributes(session, fromConfig, new String[]{"authDataEntries"}, true);
        configService.setAttributes(session, toConfig, attrList);
        attrList.clear();
        attrList = configService.getAttributes(session, fromConfig, new String[]{"CSI"}, true);
        configService.setAttributes(session, toConfig, attrList);
        attrList.clear();
        attrList = configService.getAttributes(session, fromConfig, new String[]{"systemLoginConfig"}, true);
        configService.setAttributes(session, toConfig, attrList);
        attrList.clear();
        attrList = configService.getAttributes(session, fromConfig, new String[]{"properties"}, true);
        configService.setAttributes(session, toConfig, attrList);
        attrList.clear();
        attrList = configService.getAttributes(session, fromConfig, new String[]{"authMechanisms"}, true);
        ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrList, "authMechanisms");
        Iterator iter = mechanisms.iterator();
        while (iter.hasNext()) {
            AttributeList authMechanism = (AttributeList)iter.next();
            String mechanism = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found auth mechanism of type " + mechanism);
            }
            if (mechanism.equals("LTPA")) {
                Iterator iter1 = authMechanism.iterator();
                while (iter1.hasNext()) {
                    Attribute o = (Attribute)iter1.next();
                    String name = o.getName();
                    if (name.equals("trustAssociation")) continue;
                    if (name.equals("singleSignon")) {
                        iter1.remove();
                    }
                    if (!name.equals("keySetGroup")) continue;
                    iter1.remove();
                }
                continue;
            }
            if (mechanism.equals("KRB5") || mechanism.equals("SPNEGO")) continue;
            iter.remove();
        }
        configService.setAttributes(session, toConfig, attrList);
        attrList.clear();
        AttributeList dynamicReloadAttrs = configService.getAttributes(session, fromConfig, new String[]{"dynamicReload"}, false);
        ObjectName dynamicReload = (ObjectName)ConfigServiceHelper.getAttributeValue(dynamicReloadAttrs, "dynamicReload");
        if (dynamicReload != null) {
            ArrayList authMechs = (ArrayList)configService.getAttribute(session, dynamicReload, "authMechanisms");
            ObjectName authMech = (ObjectName)authMechs.get(0);
            AttributeList authMechAttrs = configService.getAttributes(session, authMech, null, true);
            String authType = (String)ConfigServiceHelper.getAttributeValue(authMechAttrs, "_Websphere_Config_Data_Type");
            AttributeList toAuthMech = configService.getAttributes(session, toConfig, new String[]{"authMechanisms"}, true);
            ArrayList toMechanisims = (ArrayList)ConfigServiceHelper.getAttributeValue(toAuthMech, "authMechanisms");
            for (AttributeList authMechanism : toMechanisims) {
                String mechanism = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
                if (!mechanism.equals(authType)) continue;
                ConfigDataId id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Id");
                ObjectName obj = ConfigServiceHelper.createObjectName(id);
                ArrayList<ObjectName> authReferenceList = new ArrayList<ObjectName>();
                authReferenceList.add(obj);
                attrList.add(new Attribute("authMechanisms", authReferenceList));
            }
            configService.createConfigData(session, toConfig, "dynamicReload", "DynamicReload", attrList);
        }
        ObjectName aur = null;
        Object type = null;
        aur = (ObjectName)configService.getAttribute(session, fromConfig, "activeUserRegistry");
        if (aur != null) {
            AttributeList activeRegAttrs = configService.getAttributes(session, aur, null, false);
            type = ConfigServiceHelper.getAttributeValue(activeRegAttrs, "_Websphere_Config_Data_Type");
            if (realm == null) {
                realm = (String)ConfigServiceHelper.getAttributeValue(activeRegAttrs, "realm");
            }
        }
        if ((registries = (ArrayList)configService.getAttribute(session, fromConfig, "userRegistries")) != null) {
            for (int i = 0; i < registries.size(); ++i) {
                AttributeList urAttrs = (AttributeList)registries.get(i);
                Object urObj = ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                if (urObj == null) continue;
                String serverid = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "serverId");
                String password = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "serverPassword");
                String primaryAdmin = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "primaryAdminId");
                Boolean useRegistryServerId = (Boolean)ConfigServiceHelper.getAttributeValue(urAttrs, "useRegistryServerId");
                if (serverid != null) {
                    urAttrs.remove(new Attribute("serverId", serverid));
                }
                if (password != null) {
                    urAttrs.remove(new Attribute("serverPassword", password));
                }
                if (primaryAdmin != null) {
                    urAttrs.remove(new Attribute("primaryAdminId", primaryAdmin));
                }
                if (useRegistryServerId != null) {
                    urAttrs.remove(new Attribute("useRegistryServerId", useRegistryServerId));
                }
                if (!urObj.toString().equals("WIMUserRegistry") && realm != null && type != null && urObj.toString().equals(type.toString())) {
                    ConfigServiceHelper.setAttributeValue(urAttrs, "realm", realm);
                }
                ObjectName regObj = configService.createConfigData(session, toConfig, "userRegistries", urObj.toString(), urAttrs);
                if (type == null || !urObj.toString().equals(type.toString())) continue;
                auObj = regObj;
            }
        }
        attrList.clear();
        SecurityCommon commonSecurity = (SecurityCommon)MOFUtil.convertToEObject((Session)session, (ObjectName)fromConfig);
        Boolean useDomainQualifiedUserNames = (Boolean)configService.getAttribute(session, fromConfig, "useDomainQualifiedUserNames");
        if (useDomainQualifiedUserNames != null && commonSecurity.isSetUseDomainQualifiedUserNames()) {
            attrList.add(new Attribute("useDomainQualifiedUserNames", useDomainQualifiedUserNames));
        }
        if ((cacheTimeout = (Integer)configService.getAttribute(session, fromConfig, "cacheTimeout")) != null && commonSecurity.isSetCacheTimeout()) {
            attrList.add(new Attribute("cacheTimeout", cacheTimeout));
        }
        if ((issuePermissionWarning = (Boolean)configService.getAttribute(session, fromConfig, "issuePermissionWarning")) != null && commonSecurity.isSetIssuePermissionWarning()) {
            attrList.add(new Attribute("issuePermissionWarning", issuePermissionWarning));
        }
        if ((enforceJava2Security = (Boolean)configService.getAttribute(session, fromConfig, "enforceJava2Security")) != null && commonSecurity.isSetIssuePermissionWarning()) {
            attrList.add(new Attribute("enforceJava2Security", enforceJava2Security));
        }
        if ((appEnabled = (Boolean)configService.getAttribute(session, fromConfig, "appEnabled")) != null && commonSecurity.isSetAppEnabled()) {
            attrList.add(new Attribute("appEnabled", appEnabled));
        }
        configService.setAttributes(session, toConfig, attrList);
        if (auObj != null) {
            attrList.clear();
            attrList.add(new Attribute("activeUserRegistry", auObj));
            configService.setAttributes(session, toConfig, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToSecurityConfig");
        }
    }

    private List getServersInCell(Session session, ConfigService cs, String cellName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersInCell", new Object[]{cellName});
        }
        ArrayList<String> cellServers = new ArrayList<String>();
        String resource = null;
        try {
            String pattern = "Cell=:Node=";
            ObjectName[] clusters = cs.resolve(session, "Cell=:ServerCluster=");
            for (int i = 0; i < clusters.length; ++i) {
                ObjectName cluster = clusters[i];
                if (cluster == null) continue;
                String clusterName = (String)cs.getAttribute(session, cluster, "name");
                resource = "Cell=" + cellName + ":Cluster=" + clusterName;
                if (this.isResourceAlreadyMapped(session, cs, resource)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "adding " + resource + " to cell server list");
                }
                if (cellServers.contains(resource)) continue;
                cellServers.add(resource);
            }
            ObjectName[] nodes = cs.resolve(session, pattern);
            for (int i = 0; i < nodes.length; ++i) {
                ObjectName node = nodes[i];
                if (node == null) continue;
                String nodeName = (String)cs.getAttribute(session, node, "name");
                ObjectName[] entries = cs.queryConfigObjects(session, node, ConfigServiceHelper.createObjectName(null, "ServerEntry"), null);
                for (int j = 0; j < entries.length; ++j) {
                    ObjectName entry = entries[j];
                    String serverType = (String)cs.getAttribute(session, entry, "serverType");
                    if (!serverType.equals("APPLICATION_SERVER")) continue;
                    String serverName = (String)cs.getAttribute(session, entry, "serverName");
                    resource = "Cell=" + cellName + ":Node=" + nodeName + ":Server=" + serverName;
                    if (this.isResourceAlreadyMapped(session, cs, resource) || this.isResourceClusterMember(session, cs, nodeName, serverName)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "adding " + resource + " to cell server list");
                    }
                    if (cellServers.contains(resource)) continue;
                    cellServers.add(resource);
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersInCell", new Object[]{cellServers});
        }
        return cellServers;
    }

    private boolean isResourceAlreadyMapped(Session session, ConfigService cs, String resource) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isResourceAlreadyMapped");
            }
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                ObjectName[] domains = cs.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < domains.length; ++i) {
                    ObjectName domain = domains[i];
                    List members = (List)cs.getAttribute(session, domain, "members");
                    for (int j = 0; j < members.size(); ++j) {
                        AttributeList member = (AttributeList)members.get(j);
                        String resourceMember = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                        String convertedResource = SecDomainHelper.convertResource1(resourceMember);
                        if (!convertedResource.equalsIgnoreCase(resource)) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isResourceAlreadyMapped -> true");
                        }
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "exception caught", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResourceAlreadyMapped -> false");
        }
        return false;
    }

    private boolean isResourceClusterMember(Session session, ConfigService cs, String nodeName, String serverName) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isResourceClusterMember");
            }
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, SERVERCLUSTER);
                ObjectName[] clusters = cs.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < clusters.length; ++i) {
                    ObjectName cluster = clusters[i];
                    List members = (List)cs.getAttribute(session, cluster, "members");
                    for (int j = 0; j < members.size(); ++j) {
                        AttributeList member = (AttributeList)members.get(j);
                        String memberName = (String)ConfigServiceHelper.getAttributeValue(member, "memberName");
                        String node = (String)ConfigServiceHelper.getAttributeValue(member, "nodeName");
                        if (!nodeName.equals(node) || !serverName.equals(memberName)) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isResourceClusterMember -> true");
                        }
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "exception caught", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResourceClusterMember -> false");
        }
        return false;
    }

    private boolean isServerSecurityConfigured(Session session, ConfigService configService, ObjectName resourceObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerSecurityConfigured");
        }
        boolean serverSecurityConfig = false;
        ObjectName[] serverSecObj = configService.queryConfigObjects(session, resourceObj, ConfigServiceHelper.createObjectName(null, "Security"), null);
        if (serverSecObj.length > 0) {
            serverSecurityConfig = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerSecurityConfigured", serverSecurityConfig);
        }
        return serverSecurityConfig;
    }

    private boolean isCellMixedVersion(Session session, ConfigService cs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCellMixedVersion");
        }
        boolean result = false;
        Properties props = new Properties();
        props.setProperty("CONFIG_SESSION", session.toString());
        ManagedObjectMetadataAccessor metadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(props);
        ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(metadataAccessor);
        ObjectName[] nodes = cs.resolve(session, "Cell=:Node=");
        for (int i = 0; i < nodes.length; ++i) {
            int nodeMajorVersionInt;
            ObjectName node = nodes[i];
            String nodeName = (String)cs.getAttribute(session, node, "name");
            if (nodeName == null) continue;
            String productVersion = metadataHelper.getNodeBaseProductVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node product version is " + productVersion);
            }
            String nodeMajorVersion = metadataHelper.getNodeMajorVersion(nodeName);
            String nodeMinorVersion = metadataHelper.getNodeMinorVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMajorVersion is " + nodeMajorVersion + " nodeMinorVersion is " + nodeMinorVersion);
            }
            if ((nodeMajorVersionInt = Integer.parseInt(nodeMajorVersion)) >= 7) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource is not a version 7.0.  Version is " + productVersion);
            }
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCellMixedVersion", new Boolean(result));
        }
        return result;
    }

    private void createSpecialDomain(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSpecialDomain");
        }
        String secDomainName = "PassThroughToGlobalSecurity";
        ObjectName secID = null;
        ObjectName secDomain = null;
        try {
            ObjectName domain = this.getSecurityDomainObj(session, configService, secDomainName);
            if (domain != null) {
                return;
            }
            ObjectName cell = this.getCellObjectName(session, configService);
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, "name", secDomainName);
            secID = configService.createConfigData(session, cell, "SecurityDomain", "SecurityDomain", attrList);
            attrList.clear();
            secDomain = configService.createConfigData(session, secID, "AppSecurity", "AppSecurity", attrList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Domain created: " + secDomain);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecurityDomainProvider", "1440");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSpecialDomain");
        }
    }

    private ArrayList getRealmsFromDomain(ConfigService configService, Session session, ObjectName appObj) throws Exception {
        ArrayList<String> delRealms = new ArrayList<String>();
        ArrayList registries = (ArrayList)configService.getAttribute(session, appObj, "userRegistries");
        if (registries != null) {
            for (int i = 0; i < registries.size(); ++i) {
                AttributeList urAttrs = (AttributeList)registries.get(i);
                String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                if (realm == null || realm.length() <= 0) continue;
                delRealms.add(realm);
            }
        }
        return delRealms;
    }

    private void removeRealmFromTrustedRealmsList(ConfigService configService, Session session, ArrayList realms) throws Exception {
        String delRealms = null;
        AttributeList attrs = new AttributeList();
        try {
            ObjectName outboundTrustedRealmObj;
            for (int i = 0; i < realms.size(); ++i) {
                String realm = (String)realms.get(i);
                delRealms = delRealms != null ? delRealms + "|" + realm : realm;
            }
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
            ObjectName inboundTrustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, security2, "inboundTrustedAuthenticationRealm");
            if (inboundTrustedRealmObj != null) {
                attrs.clear();
                String updatedRealmList = SecConfigTaskHelper.updateRealmList(session, configService, inboundTrustedRealmObj, delRealms);
                attrs.add(new Attribute("realmList", updatedRealmList));
                configService.setAttributes(session, inboundTrustedRealmObj, attrs);
            }
            if ((outboundTrustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, security2, "outboundTrustedAuthenticationRealm")) != null) {
                attrs.clear();
                String updatedRealmList = SecConfigTaskHelper.updateRealmList(session, configService, inboundTrustedRealmObj, delRealms);
                attrs.add(new Attribute("realmList", updatedRealmList));
                configService.setAttributes(session, outboundTrustedRealmObj, attrs);
            }
            pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
            ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
            for (int i = 0; i < domains.length; ++i) {
                String updatedRealmList;
                ObjectName domain = domains[i];
                inboundTrustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, domain, "inboundTrustedAuthenticationRealm");
                if (inboundTrustedRealmObj != null) {
                    attrs.clear();
                    updatedRealmList = SecConfigTaskHelper.updateRealmList(session, configService, inboundTrustedRealmObj, delRealms);
                    attrs.add(new Attribute("realmList", updatedRealmList));
                    configService.setAttributes(session, inboundTrustedRealmObj, attrs);
                }
                if ((outboundTrustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, domain, "outboundTrustedAuthenticationRealm")) == null) continue;
                attrs.clear();
                updatedRealmList = SecConfigTaskHelper.updateRealmList(session, configService, outboundTrustedRealmObj, delRealms);
                attrs.add(new Attribute("realmList", updatedRealmList));
                configService.setAttributes(session, outboundTrustedRealmObj, attrs);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "772");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
    }

    private ArrayList checkForValidRealm(ConfigService configService, Session session, ArrayList realms) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForValidRealm");
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
            ArrayList registries = (ArrayList)configService.getAttribute(session, security2, "userRegistries");
            if (registries != null) {
                for (int i = 0; i < registries.size(); ++i) {
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realms.contains(realm)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove " + realm + " from the list of realms to delete from trusted list.");
                    }
                    realms.remove(realm);
                }
            }
            pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
            ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
            for (int i = 0; i < domains.length; ++i) {
                ObjectName domain = domains[i];
                registries = (ArrayList)configService.getAttribute(session, domain, "userRegistries");
                if (registries == null) continue;
                for (int j = 0; j < registries.size(); ++j) {
                    AttributeList urAttrs = (AttributeList)registries.get(j);
                    String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realms.contains(realm)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove " + realm + " from the list of realms to delete from trusted list.");
                    }
                    realms.remove(realm);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "772");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForValidRealm");
        }
        return realms;
    }
}

