/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigureLTPAAuthMechanism
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureLTPAAuthMechanism.class, "ConfigureLTPAAuthMechanism", "com.ibm.ws.security.admintask.securityDomain");
    private ObjectName secObj;
    private ObjectName globalSecObj;
    private ConfigService configService;
    private Session session;
    private String secDomain = null;
    private Boolean enable = null;
    private String interceptor = null;
    private String customProps = null;
    private Boolean requiresSSL = null;
    private String domainName = null;
    private Boolean interoperable = null;
    private Boolean attributePropagation = null;
    private String timeout = null;

    public ConfigureLTPAAuthMechanism(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureLTPAAuthMechanism(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void deleteProperty(ObjectName secObj, String property) throws Exception {
        AttributeList temp = this.configService.getAttributes(this.session, secObj, new String[]{"properties"}, true);
        ArrayList props = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "properties");
        for (int i = 0; i < props.size(); ++i) {
            AttributeList a = (AttributeList)props.get(i);
            if (!((String)ConfigServiceHelper.getAttributeValue(a, "name")).equals(property)) continue;
            ObjectName obj = this.configService.queryConfigObjects(this.session, secObj, ConfigServiceHelper.createObjectName(a), null)[0];
            this.configService.deleteConfigData(this.session, obj);
        }
    }

    public Attribute getProperty(ObjectName secObj, String property) throws Exception {
        AttributeList temp = this.configService.getAttributes(this.session, secObj, new String[]{"properties"}, true);
        ArrayList props = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "properties");
        for (int i = 0; i < props.size(); ++i) {
            AttributeList a = (AttributeList)props.get(i);
            if (!((String)ConfigServiceHelper.getAttributeValue(a, "name")).equals(property)) continue;
            return new Attribute(property, (String)ConfigServiceHelper.getAttributeValue(a, "value"));
        }
        return null;
    }

    public void setProperty(ObjectName secObj, String property, Object value) throws Exception {
        AttributeList temp = this.configService.getAttributes(this.session, secObj, new String[]{"properties"}, true);
        ArrayList props = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "properties");
        for (int i = 0; i < props.size(); ++i) {
            AttributeList a = (AttributeList)props.get(i);
            if (!((String)ConfigServiceHelper.getAttributeValue(a, "name")).equals(property)) continue;
            ObjectName propObj = this.configService.queryConfigObjects(this.session, secObj, ConfigServiceHelper.createObjectName(a), null)[0];
            temp = new AttributeList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, value.toString());
            }
            temp.add(new Attribute("value", value));
            this.configService.setAttributes(this.session, propObj, temp);
            return;
        }
        temp = new AttributeList();
        temp.add(new Attribute("name", property));
        temp.add(new Attribute("value", value));
        temp.add(new Attribute("required", new Boolean(false)));
        ObjectName propObj = this.configService.createConfigData(this.session, secObj, "properties", null, temp);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added property " + property + ".");
        }
    }

    private AttributeList getAuthMechanism(String section, boolean createIfDomain) throws Exception {
        String am;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthMechanism: " + section);
        }
        AttributeList attrs = this.configService.getAttributes(this.session, this.secObj, new String[]{"authMechanisms"}, true);
        ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
        ArrayList<AttributeList> mechs = new ArrayList<AttributeList>();
        Iterator iter = mechanisms.iterator();
        while (iter.hasNext()) {
            AttributeList authMechanism;
            AttributeList authMech = authMechanism = (AttributeList)iter.next();
            am = (String)ConfigServiceHelper.getAttributeValue(authMech, "_Websphere_Config_Data_Type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found auth mechanism of type " + am);
            }
            if (!am.equals("LTPA")) continue;
            return authMech;
        }
        if (this.secObj == this.globalSecObj) {
            String msg = this.getMsg(resBundle, "security.admintask.noTrustAssociation.SECJ7730E", null);
            throw new CommandValidationException(msg);
        }
        if (createIfDomain) {
            attrs = this.configService.getAttributes(this.session, this.globalSecObj, new String[]{"authMechanisms"}, true);
            mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
            AttributeList attrList = new AttributeList();
            iter = mechanisms.iterator();
            while (iter.hasNext()) {
                AttributeList authMechanism;
                attrList = authMechanism = (AttributeList)iter.next();
                am = (String)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found auth mechanism of type " + am);
                }
                if (am.equals("LTPA")) {
                    Iterator iter2 = attrList.iterator();
                    while (iter2.hasNext()) {
                        Attribute o = (Attribute)iter2.next();
                        String name = o.getName();
                        if (name.equals(section) || !name.equals("singleSignon") && !name.equals("keySetGroup") && !name.equals("trustAssociation")) continue;
                        iter2.remove();
                    }
                    break;
                }
                iter.remove();
            }
            mechs.add(attrList);
            AttributeList authAttrs = new AttributeList();
            authAttrs.add(new Attribute("authMechanisms", mechs));
            this.configService.setAttributes(this.session, this.secObj, authAttrs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechanism");
        }
        return this.getAuthMechanism();
    }

    private AttributeList getAuthMechanism() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthMechanism");
        }
        AttributeList attrs = this.configService.getAttributes(this.session, this.secObj, new String[]{"authMechanisms"}, true);
        ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
        AttributeList authMechanism2 = new AttributeList();
        for (AttributeList authMechanism2 : mechanisms) {
            String am = (String)ConfigServiceHelper.getAttributeValue(authMechanism2, "_Websphere_Config_Data_Type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found auth mechanism of type " + am);
            }
            if (!am.equals("LTPA")) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechanism");
        }
        return authMechanism2;
    }

    private AttributeList getSingleSignon() throws Exception {
        AttributeList authMechanism = this.getAuthMechanism("singleSignon", true);
        AttributeList singleSignon = (AttributeList)ConfigServiceHelper.getAttributeValue(authMechanism, "singleSignon");
        ObjectName authObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(authMechanism), null)[0];
        if (singleSignon == null) {
            if (this.secObj == this.globalSecObj) {
                String msg = this.getMsg(resBundle, "security.admintask.noSingleSignon.SECJ7728E", null);
                throw new CommandValidationException(msg);
            }
            ObjectName tempObj = this.secObj;
            this.secObj = this.globalSecObj;
            AttributeList temp = this.getSingleSignon();
            this.secObj = tempObj;
            this.configService.createConfigData(this.session, authObj, "singleSignon", null, temp);
            authMechanism = this.getAuthMechanism(null, true);
            singleSignon = (AttributeList)ConfigServiceHelper.getAttributeValue(authMechanism, "singleSignon");
        }
        if (singleSignon == null) {
            String msg = this.getMsg(resBundle, "security.admintask.noSingleSignon.SECJ7728E", null);
            throw new CommandValidationException(msg);
        }
        return singleSignon;
    }

    private ObjectName getTrustAssociation() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAssociation");
        }
        ObjectName trustObj = null;
        AttributeList authMechanism = this.getAuthMechanism("LTPA", true);
        AttributeList trustAssociation = (AttributeList)ConfigServiceHelper.getAttributeValue(authMechanism, "trustAssociation");
        trustObj = trustAssociation == null ? this.createTrustAssociation(authMechanism) : this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(trustAssociation), null)[0];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAssociation");
        }
        return trustObj;
    }

    public AttributeList getSingleSignonTask() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSingleSignonEntry");
        }
        try {
            AttributeList attrs = this.configService.getAttributes(this.session, this.secObj, new String[]{"authMechanisms"}, true);
            ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
            for (AttributeList authMechanism : mechanisms) {
                ObjectName authObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(authMechanism), null)[0];
                String am = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found auth mechanism of type " + am);
                }
                if (!am.equals("LTPA")) continue;
                AttributeList singleSignon = (AttributeList)ConfigServiceHelper.getAttributeValue(authMechanism, "singleSignon");
                if (singleSignon == null) continue;
                Attribute temp = this.getProperty(this.secObj, "com.ibm.ws.security.ssoInteropModeEnabled");
                if (temp != null) {
                    singleSignon.add(temp);
                }
                if ((temp = this.getProperty(this.secObj, "com.ibm.ws.security.webInboundPropagationEnabled")) != null) {
                    singleSignon.add(temp);
                }
                AttributeList attributeList = singleSignon;
                return attributeList;
            }
            String msg = this.getMsg(resBundle, "security.admintask.noSingleSignon.SECJ7728E", null);
            throw new CommandValidationException(msg);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonEntry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureSingleSignon() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureSingleSignonEntry");
        }
        try {
            AttributeList temp;
            AttributeList singleSignon = this.getSingleSignon();
            ObjectName singleObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(singleSignon), null)[0];
            if (this.enable != null) {
                temp = new AttributeList();
                temp.add(new Attribute("enabled", this.enable));
                this.configService.setAttributes(this.session, singleObj, temp);
            }
            if (this.requiresSSL != null) {
                temp = new AttributeList();
                temp.add(new Attribute("requiresSSL", this.requiresSSL));
                this.configService.setAttributes(this.session, singleObj, temp);
            }
            if (this.domainName != null) {
                temp = new AttributeList();
                temp.add(new Attribute("domainName", this.domainName));
                this.configService.setAttributes(this.session, singleObj, temp);
            }
            if (this.interoperable != null) {
                this.setProperty(this.secObj, "com.ibm.ws.security.ssoInteropModeEnabled", this.interoperable.toString());
            }
            if (this.attributePropagation != null) {
                this.setProperty(this.secObj, "com.ibm.ws.security.webInboundPropagationEnabled", this.attributePropagation.toString());
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureSingleSignonEntry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList listInterceptors() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listInterceptorsEntry");
        }
        try {
            AttributeList trustAssoc = new AttributeList();
            ArrayList interceptors = new ArrayList();
            AttributeList attrs = this.configService.getAttributes(this.session, this.secObj, new String[]{"authMechanisms"}, true);
            ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
            for (AttributeList authMechanism : mechanisms) {
                ObjectName authObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(authMechanism), null)[0];
                String am = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found auth mechanism of type " + am);
                }
                if (!am.equals("LTPA")) continue;
                trustAssoc = (AttributeList)ConfigServiceHelper.getAttributeValue(authMechanism, "trustAssociation");
                break;
            }
            if (trustAssoc != null && trustAssoc.size() > 0) {
                ObjectName trustObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(trustAssoc), null)[0];
                AttributeList temp = this.configService.getAttributes(this.session, trustObj, new String[]{"interceptors"}, true);
                interceptors = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "interceptors");
            }
            ArrayList arrayList = interceptors;
            return arrayList;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listInterceptorsEntry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getTrustAssociationInfo() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAssociationInfo");
        }
        try {
            AttributeList trustAssoc = new AttributeList();
            AttributeList attrs = this.configService.getAttributes(this.session, this.secObj, new String[]{"authMechanisms"}, true);
            ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
            for (AttributeList authMechanism : mechanisms) {
                String am = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found auth mechanism of type " + am);
                }
                if (!am.equals("LTPA")) continue;
                trustAssoc = (AttributeList)ConfigServiceHelper.getAttributeValue(authMechanism, "trustAssociation");
                break;
            }
            AttributeList attributeList = trustAssoc;
            return attributeList;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustAssociationInfo");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unconfigureInterceptor() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unconfigureInterceptorEntry");
        }
        try {
            ObjectName trustObj = this.getTrustAssociation();
            AttributeList temp = this.configService.getAttributes(this.session, trustObj, new String[]{"interceptors"}, true);
            ArrayList interceptors = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "interceptors");
            boolean flag = true;
            for (int i = 0; i < interceptors.size(); ++i) {
                AttributeList inter = (AttributeList)interceptors.get(i);
                if (!((String)ConfigServiceHelper.getAttributeValue(inter, "interceptorClassName")).equals(this.interceptor)) continue;
                ObjectName interObj = this.configService.queryConfigObjects(this.session, trustObj, ConfigServiceHelper.createObjectName(inter), null)[0];
                this.configService.deleteConfigData(this.session, interObj);
                flag = false;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Interceptor " + this.interceptor + " is removed.");
            }
            if (flag) {
                String msg = this.getMsg(resBundle, "security.admintask.noInterceptor.SECJ7731E", null);
                throw new CommandValidationException(msg);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unconfigureInterceptorEntry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureTrustAssociation() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureTrustAssociationEntry");
        }
        try {
            ObjectName trustObj = this.getTrustAssociation();
            if (this.enable != null) {
                AttributeList temp = new AttributeList();
                temp.add(new Attribute("enabled", this.enable));
                this.configService.setAttributes(this.session, trustObj, temp);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Set trust association enabled to " + this.enable.toString() + ".");
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureTrustAssociationEntry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unconfigureTrustAssociation() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unconfigureTrustAssociation");
        }
        try {
            AttributeList attrs = this.configService.getAttributes(this.session, this.secObj, new String[]{"authMechanisms"}, true);
            ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
            for (AttributeList authMech : mechanisms) {
                String am = (String)ConfigServiceHelper.getAttributeValue(authMech, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found auth mechanism of type " + am);
                }
                if (!am.equals("LTPA")) continue;
                AttributeList trustAssoc = (AttributeList)ConfigServiceHelper.getAttributeValue(authMech, "trustAssociation");
                if (trustAssoc != null) {
                    ObjectName trustAssocObj = ConfigServiceHelper.createObjectName(trustAssoc);
                    this.configService.deleteConfigData(this.session, trustAssocObj);
                }
                return;
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unconfigureTrustAssociation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureInterceptor() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureTrustAssociationEntry");
        }
        try {
            ObjectName trustObj = this.getTrustAssociation();
            if (this.interceptor != null) {
                AttributeList temp = this.configService.getAttributes(this.session, trustObj, new String[]{"interceptors"}, true);
                ArrayList interceptors = (ArrayList)ConfigServiceHelper.getAttributeValue(temp, "interceptors");
                boolean flag = true;
                for (int i = 0; i < interceptors.size(); ++i) {
                    AttributeList inter = (AttributeList)interceptors.get(i);
                    if (!((String)ConfigServiceHelper.getAttributeValue(inter, "interceptorClassName")).equals(this.interceptor)) continue;
                    flag = false;
                    if (this.customProps == null) continue;
                    ObjectName interObj = this.configService.queryConfigObjects(this.session, trustObj, ConfigServiceHelper.createObjectName(inter), null)[0];
                    SecConfigTaskHelper.addCustomEntries(this.session, this.configService, interObj, this.customProps, "trustProperties");
                }
                if (flag) {
                    temp = new AttributeList();
                    temp.add(new Attribute("interceptorClassName", this.interceptor));
                    ObjectName interObj = this.configService.createConfigData(this.session, trustObj, "interceptors", null, temp);
                    if (this.customProps != null) {
                        SecConfigTaskHelper.addCustomEntries(this.session, this.configService, interObj, this.customProps, "trustProperties");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added interceptor " + this.interceptor + ".");
                    }
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureTrustAssociationEntry");
            }
        }
    }

    public void setLTPATimeout() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLTPATimeout");
        }
        Long time2 = null;
        boolean isGlobalSecurity = false;
        AttributeList attrList = new AttributeList();
        int ltpaMinimum = 5;
        AttributeList authMechanism = null;
        authMechanism = this.timeout != null && this.timeout.length() > 0 ? this.getAuthMechanism("LTPA", true) : this.getAuthMechanism("LTPA", false);
        if (this.timeout != null && authMechanism != null && !authMechanism.isEmpty()) {
            ObjectName authObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(authMechanism), null)[0];
            if (this.secObj == this.globalSecObj) {
                isGlobalSecurity = true;
            }
            if (isGlobalSecurity && this.timeout.equals("")) {
                String msg = this.getMsg(resBundle, "security.admintask.timeout.SECJ7765E", new Object[]{ltpaMinimum});
                throw new CommandValidationException(msg);
            }
            if (this.timeout.equals("")) {
                attrList.add(new Attribute("timeout", null));
            } else {
                try {
                    time2 = new Long(this.timeout);
                    if (time2 < (long)ltpaMinimum) {
                        String msg = this.getMsg(resBundle, "security.admintask.timeout.SECJ7765E", new Object[]{ltpaMinimum});
                        throw new CommandValidationException(msg);
                    }
                    attrList.add(new Attribute("timeout", time2));
                }
                catch (NumberFormatException e) {
                    String msg = this.getMsg(resBundle, "security.admintask.timeout.SECJ7765E", new Object[]{ltpaMinimum});
                    throw new CommandValidationException(msg);
                }
            }
            this.configService.setAttributes(this.session, authObj, attrList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLTPATimeout");
        }
    }

    public String getLTPATimeout() throws Exception {
        Long timeoutLong;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPATimeout");
        }
        AttributeList authMechanism = this.getAuthMechanism();
        String timeoutValue = "";
        if (!authMechanism.isEmpty() && (timeoutLong = (Long)ConfigServiceHelper.getAttributeValue(authMechanism, "timeout")) != null && timeoutLong != 0L) {
            timeoutValue = timeoutLong.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPATimeout");
        }
        return timeoutValue;
    }

    private ObjectName createTrustAssociation(AttributeList authMechFromDomain) throws Exception {
        AttributeList authMechAttrs;
        String mechanism;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTrustAssociation");
        }
        ObjectName domainAuthMech = null;
        ObjectName[] authMechs = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(null, "AuthMechanism"), null);
        for (int i = 0; i < authMechs.length && !(mechanism = (String)ConfigServiceHelper.getAttributeValue(authMechAttrs = this.configService.getAttributes(this.session, domainAuthMech = authMechs[i], null, true), "_Websphere_Config_Data_Type")).equals("LTPA"); ++i) {
        }
        AttributeList attrs = this.configService.getAttributes(this.session, this.globalSecObj, new String[]{"authMechanisms"}, true);
        ArrayList mechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "authMechanisms");
        AttributeList attrList = new AttributeList();
        for (AttributeList authMechanism : mechanisms) {
            String am = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found auth mechanism of type " + am);
            }
            if (!am.equals("LTPA")) continue;
            AttributeList newAttrs = new AttributeList();
            attrList = (AttributeList)ConfigServiceHelper.getAttributeValue(authMechanism, "trustAssociation");
            Iterator iter2 = attrList.iterator();
            Boolean enabled = (Boolean)ConfigServiceHelper.getAttributeValue(attrList, "enabled");
            if (enabled != null) {
                newAttrs.add(new Attribute("enabled", enabled));
            }
            ArrayList interceptors = (ArrayList)ConfigServiceHelper.getAttributeValue(attrList, "interceptors");
            ObjectName trustAssoc = this.configService.createConfigData(this.session, domainAuthMech, "trustAssociation", null, newAttrs);
            AttributeList intercept = new AttributeList();
            intercept.add(new Attribute("interceptors", interceptors));
            this.configService.setAttributes(this.session, trustAssoc, intercept);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTrustAssociation");
            }
            return trustAssoc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTrustAssociation");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        String commandName = this.getName();
        try {
            this.configService = this.getConfigService();
            this.session = this.getConfigSession();
            try {
                this.secDomain = (String)this.getParameter("securityDomainName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.enable = (Boolean)this.getParameter("enable");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.interceptor = (String)this.getParameter("interceptor");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.customProps = (String)this.getParameter("customProperties");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.requiresSSL = (Boolean)this.getParameter("requiresSSL");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.domainName = (String)this.getParameter("domainName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.interoperable = (Boolean)this.getParameter("interoperable");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.attributePropagation = (Boolean)this.getParameter("attributePropagation");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.timeout = (String)this.getParameter("timeout");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            this.globalSecObj = SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService);
            if (this.secDomain != null) {
                String msg;
                if ((commandName.equals("configureTrustAssociation") || commandName.equals("unconfigureInterceptor") || commandName.equals("configureInterceptor") || commandName.equals("unconfigureTrustAssociation") || commandName.equals("setLTPATimeout")) && this.secDomain.equals("PassThroughToGlobalSecurity")) {
                    msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{commandName, this.secDomain});
                    throw new CommandValidationException(msg);
                }
                this.secObj = SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain);
                if (this.secObj == null) {
                    msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                this.secObj = this.globalSecObj;
            }
            if (commandName.equals("configureTrustAssociation")) {
                this.configureTrustAssociation();
            }
            if (commandName.equals("unconfigureInterceptor")) {
                this.unconfigureInterceptor();
            }
            if (commandName.equals("configureInterceptor")) {
                this.configureInterceptor();
            }
            if (commandName.equals("listInterceptors")) {
                result.setResult(this.listInterceptors());
            }
            if (commandName.equals("getTrustAssociationInfo")) {
                result.setResult(this.getTrustAssociationInfo());
            }
            if (commandName.equals("unconfigureTrustAssociation")) {
                this.unconfigureTrustAssociation();
            }
            if (commandName.equals("configureSingleSignon")) {
                this.configureSingleSignon();
            }
            if (commandName.equals("getSingleSignon")) {
                result.setResult(this.getSingleSignonTask());
            }
            if (commandName.equals("setLTPATimeout")) {
                this.setLTPATimeout();
            }
            if (commandName.equals("getLTPATimeout")) {
                result.setResult(this.getLTPATimeout());
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureLTPAAuthMechanism", "206");
            Tr.debug(tc, "exception caught", cse);
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }
}

