/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigureCustomUserRegistry
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureCustomUserRegistry.class, "ConfigureCustomUserRegistry", "com.ibm.ws.security.admintask.securityDomain");
    Boolean globalSecEnabled = new Boolean(false);

    public ConfigureCustomUserRegistry(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureCustomUserRegistry(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ObjectName secObj = null;
        boolean useRegServerId = true;
        AttributeList attrList = new AttributeList();
        String commandName = this.getName();
        String secDomain = null;
        String realm = null;
        String serverid = null;
        String password = null;
        String primaryAdminId = null;
        Boolean autoGenServerId = null;
        String customRegClass = null;
        Boolean ignoreCase = null;
        String customProps = null;
        Boolean verifyRegistry = null;
        Boolean useRegistryRealm = Boolean.FALSE;
        Properties props = new Properties();
        try {
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            if (commandName.equalsIgnoreCase("configureAdminCustomUserRegistry")) {
                serverid = (String)this.getParameter("serverId");
                password = (String)this.getParameter("serverIdPassword");
                primaryAdminId = (String)this.getParameter("primaryAdminId");
                autoGenServerId = (Boolean)this.getParameter("autoGenerateServerId");
            } else {
                secDomain = (String)this.getParameter("securityDomainName");
                realm = (String)this.getParameter("realmName");
            }
            customRegClass = (String)this.getParameter("customRegClass");
            ignoreCase = (Boolean)this.getParameter("ignoreCase");
            customProps = (String)this.getParameter("customProperties");
            verifyRegistry = (Boolean)this.getParameter("verifyRegistry");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverId name is " + serverid);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "primaryAdminId name is " + primaryAdminId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "autoGenerateServerId name is " + autoGenServerId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmName name is " + realm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customRegClass name is " + customRegClass);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoreCase name is " + ignoreCase);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customProperties name is " + customProps);
            }
            if (secDomain != null) {
                if (secDomain.equals("PassThroughToGlobalSecurity")) {
                    String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{commandName, secDomain});
                    throw new CommandValidationException(msg);
                }
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
            } else {
                secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            }
            if (secObj == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                throw new CommandValidationException(msg);
            }
            ObjectName regObj = SecConfigTaskHelper.getRegObj(session, configService, secObj, "CustomUserRegistry");
            if (regObj != null) {
                if (commandName.equalsIgnoreCase("configureAdminCustomUserRegistry")) {
                    attrList.add(new Attribute("serverId", (String)configService.getAttribute(session, regObj, "serverId")));
                    attrList.add(new Attribute("serverPassword", (String)configService.getAttribute(session, regObj, "serverPassword")));
                    attrList.add(new Attribute("primaryAdminId", (String)configService.getAttribute(session, regObj, "primaryAdminId")));
                    attrList.add(new Attribute("useRegistryServerId", (Boolean)configService.getAttribute(session, regObj, "useRegistryServerId")));
                }
                if (customRegClass == null) {
                    customRegClass = (String)configService.getAttribute(session, regObj, "customRegistryClassName");
                    attrList.add(new Attribute("customRegistryClassName", customRegClass));
                }
                if (ignoreCase == null) {
                    ignoreCase = (Boolean)configService.getAttribute(session, regObj, "ignoreCase");
                    attrList.add(new Attribute("ignoreCase", ignoreCase));
                }
                if (realm == null) {
                    realm = (String)configService.getAttribute(session, regObj, "realm");
                    attrList.add(new Attribute("realm", realm));
                    useRegistryRealm = (Boolean)configService.getAttribute(session, regObj, "useRegistryRealm");
                }
                props = SecConfigTaskHelper.getCustomPropertiesFromConfig(session, configService, regObj, props);
            }
            if (serverid != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "serverId", serverid);
            }
            if (password != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "serverPassword", password);
            }
            if (primaryAdminId != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "primaryAdminId", primaryAdminId);
            }
            if (customRegClass == null || customRegClass.length() <= 0) {
                String msg = this.getMsg(resBundle, "security.admintask.notClassProvided.SECJ7744E", null);
                throw new CommandValidationException(msg);
            }
            ConfigServiceHelper.setAttributeValue(attrList, "customRegistryClassName", customRegClass);
            if (ignoreCase != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "ignoreCase", ignoreCase);
            } else {
                ignoreCase = Boolean.FALSE;
            }
            if (realm != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "realm", realm);
            }
            if (autoGenServerId != null) {
                useRegServerId = autoGenServerId == false;
                ConfigServiceHelper.setAttributeValue(attrList, "useRegistryServerId", new Boolean(useRegServerId));
            }
            props = SecConfigTaskHelper.mergeCustomProperties(customProps, props);
            props.setProperty("activeRegistry", "CUSTOM");
            if (customRegClass != null) {
                props.setProperty("CustUserRegImplClass", customRegClass);
            }
            if (ignoreCase != null) {
                props.setProperty("security.registry.IgnoreCase", ignoreCase.toString());
            }
            props.setProperty("WAS_UseRegistryRealm", useRegistryRealm.toString());
            if (realm != null) {
                props.setProperty("WAS_Realm", realm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting WAS_UseRegistryRealm: " + useRegistryRealm.toString() + " and WAS_Realm: " + realm);
            }
            if (realm == null || realm != null && realm.equals("")) {
                realm = SecConfigTaskHelper.getDefaultRealm(props);
                useRegistryRealm = Boolean.TRUE;
                ConfigServiceHelper.setAttributeValue(attrList, "realm", realm);
                props.setProperty("WAS_UseRegistryRealm", useRegistryRealm.toString());
                if (realm != null) {
                    props.setProperty("WAS_Realm", realm);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting new WAS_UseRegistryRealm: " + useRegistryRealm.toString() + " and WAS_Realm: " + realm);
                }
            }
            ConfigServiceHelper.setAttributeValue(attrList, "useRegistryRealm", useRegistryRealm);
            if (verifyRegistry != null && verifyRegistry.booleanValue()) {
                if (commandName.equalsIgnoreCase("configureAdminCustomUserRegistry")) {
                    if (!SecConfigTaskHelper.isRegistryGood(session, configService, "CustomUserRegistry", attrList, props)) {
                        String msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                        throw new CommandValidationException(msg);
                    }
                } else if (!SecConfigTaskHelper.isGoodServerId(session, "*", "CustomUserRegistry", props)) {
                    String msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                    throw new CommandValidationException(msg);
                }
            }
            SecConfigTaskHelper.addInfoToConfig(session, configService, secObj, regObj, "CustomUserRegistry", attrList, customProps);
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureCustomUserRegistry", "219");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }
}

