/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.notification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteAuditNotification
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(DeleteAuditNotification.class, "AUDIT", "com.ibm.ws.security.admintask.audit.notification");
    private String notificationRef = null;

    public DeleteAuditNotification(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteAuditNotification(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.notificationRef = (String)this.getParameter("notificationRef");
        if (this.notificationRef == null || this.notificationRef.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationRef", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notificationRef: " + this.notificationRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        ObjectName notificationObj = null;
        String noteRef = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            boolean foundNotification = false;
            ArrayList notificationArray = (ArrayList)cs.getAttribute(session, audit, "wsNotifications");
            if (notificationArray == null) {
                result.setResult(new Boolean(false));
                return;
            }
            for (int k = 0; k < notificationArray.size(); ++k) {
                AttributeList notificationAttrs = (AttributeList)notificationArray.get(k);
                notificationObj = ConfigServiceHelper.createObjectName(notificationAttrs);
                noteRef = ConfigServiceHelper.getAttributeValue(notificationAttrs, "_Websphere_Config_Data_Id").toString();
                if (!(noteRef = noteRef.split("#")[1]).equals(this.notificationRef)) continue;
                foundNotification = true;
                break;
            }
            if (!foundNotification) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationRef", null);
                result.addWarnings(msg);
                result.setException(new CommandException(msg));
                result.setResult(new Boolean(false));
                throw new CommandValidationException(msg);
            }
            AttributeList monitorAttrs = null;
            try {
                monitorAttrs = (AttributeList)cs.getAttribute(session, audit, "auditNotificationMonitor");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Monitor not configured, so we can safely delete the notification");
                }
                cs.deleteConfigData(session, notificationObj);
                result.setResult(new Boolean(true));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            if (monitorAttrs == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Monitor not configured, so we can safely delete the notification");
                }
                cs.deleteConfigData(session, notificationObj);
                result.setResult(new Boolean(true));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Monitor configured, need to check if notification is in use");
            }
            ObjectName monitorObj = ConfigServiceHelper.createObjectName(monitorAttrs);
            ObjectName notObj = (ObjectName)cs.getAttribute(session, monitorObj, "wsNotification");
            String notRef = ConfigServiceHelper.getConfigDataId(notObj).toString().split("#")[1];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "notRef: " + notRef);
            }
            if (notRef.equals(this.notificationRef)) {
                String msg = this.getMsg(resBundle, "security.admintask.NotificationInUse", null);
                throw new CommandValidationException(msg);
            }
            cs.deleteConfigData(session, notificationObj);
            result.setResult(new Boolean(true));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.DeleteAuditNotification.afterStepsExecuted", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.DeleteAuditNotification.afterStepsExecuted", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
    }
}

