/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyAuditFilter
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyAuditFilter.class, "AUDIT", "com.ibm.ws.security.admintask.audit.filter");
    String events = null;
    String outcomes = null;
    String name = null;
    String ref = null;
    Boolean enabled = new Boolean(false);
    boolean noEnableFlagChg = false;
    boolean foundEvents = false;
    boolean foundOutcomes = false;

    public ModifyAuditFilter(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditFilter(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.ref = (String)this.getParameter("filterRef");
        if (this.ref == null || this.ref.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
            throw new CommandValidationException(msg);
        }
        this.events = (String)this.getParameter("eventType");
        if (this.events != null && this.events.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
            throw new CommandValidationException(msg);
        }
        this.outcomes = (String)this.getParameter("outcome");
        if (this.outcomes != null && this.outcomes.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
            throw new CommandValidationException(msg);
        }
        this.name = (String)this.getParameter("name");
        this.enabled = (Boolean)this.getParameter("enableFilter");
        if (this.enabled == null) {
            this.noEnableFlagChg = true;
        }
        if (this.events == null && this.outcomes == null && this.name == null && this.noEnableFlagChg) {
            String msg = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "filterArray: " + filterArray.toString());
            }
            Vector<String> eventsList = new Vector<String>();
            if (this.events != null) {
                this.foundEvents = true;
                StringTokenizer st = new StringTokenizer(this.events, ",;: ");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!AuditCommandHelper.isValidEventType(token)) {
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    eventsList.add(token);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "eventsList: " + eventsList.toString());
                }
            }
            Vector<String> outcomesList = new Vector<String>();
            if (this.outcomes != null) {
                this.foundOutcomes = true;
                StringTokenizer st = new StringTokenizer(this.outcomes, ",;: ");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!AuditCommandHelper.isValidOutcome(token)) {
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    outcomesList.add(token);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "outcomesList: " + outcomesList.toString());
                }
            }
            boolean found = false;
            for (int i = 0; i < filterArray.size(); ++i) {
                int j;
                String filterRef;
                AttributeList filterAttrs = (AttributeList)filterArray.get(i);
                ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "auditSpec: " + auditSpec.toString());
                }
                if (!(filterRef = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1]).equals(this.ref)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found matching audit spec");
                }
                found = true;
                AttributeList attrs = new AttributeList();
                if (!this.noEnableFlagChg) {
                    attrs.add(new Attribute("enabled", this.enabled));
                }
                if (this.name != null && this.name.length() > 0) {
                    attrs.add(new Attribute("name", this.name));
                }
                ArrayList eventAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "event");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "eventAttrs: " + eventAttrs.toString());
                }
                ArrayList outcomeAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "outcome");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "outcomeAttrs: " + outcomeAttrs.toString());
                }
                if (this.foundEvents) {
                    ArrayList eventArray = new ArrayList();
                    for (j = 0; j < eventsList.size(); ++j) {
                        eventArray.add(eventsList.elementAt(j));
                    }
                    eventAttrs.clear();
                    eventAttrs.addAll(eventArray);
                    ConfigServiceHelper.setAttributeValue(attrs, "event", eventAttrs);
                }
                if (this.foundOutcomes) {
                    ArrayList outcomeArray = new ArrayList();
                    for (j = 0; j < outcomesList.size(); ++j) {
                        outcomeArray.add(outcomesList.elementAt(j));
                    }
                    outcomeAttrs.clear();
                    outcomeAttrs.addAll(outcomeArray);
                    ConfigServiceHelper.setAttributeValue(attrs, "outcome", outcomeAttrs);
                }
                cs.setAttributes(session, auditSpec, attrs);
                break;
            }
            if (!found) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            result.setResult(new Boolean(true));
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.ModifyAuditFilter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.ModifyAuditFilter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

