/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.encryption;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class ImportEncryptionCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ImportEncryptionCertificate.class, "Audit", "com.ibm.ws.security.admintask.audit.certificates");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private String keyStoreName = null;
    private String keyFilePath = null;
    private String keyFilePathExpanded = null;
    private String keyFilePassword = null;
    private String keyFileType = null;
    private String certAliasFromKeyFile = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private KeyStoreInfo ksInfo = null;

    public ImportEncryptionCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ImportEncryptionCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName audit = null;
        try {
            boolean granted;
            RoleBasedConfigurator configurator = RoleBasedConfiguratorFactory.getConfigurator();
            RoleBasedAuthorizer adminAuthorizer = configurator.getRoleBasedAuthorizer("admin-authz", "domain");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the RoleBasedAuthorizer object.");
            }
            if (!(granted = adminAuthorizer.isCallerInRole("administrator"))) {
                String msg = this.getMsg(resBundle, "security.admintask.UserNotInRole", new Object[]{"administrator"});
                throw new CommandValidationException(msg);
            }
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            Object keyFileName = null;
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.keyFilePath = (String)this.getParameter(CommandConstants.KEY_FILE_PATH);
            this.keyFilePassword = (String)this.getParameter(CommandConstants.KEY_FILE_PASSWORD);
            this.keyFileType = (String)this.getParameter(CommandConstants.KEY_FILE_TYPE);
            this.certAliasFromKeyFile = (String)this.getParameter(CommandConstants.CERT_ALIAS_FROM_KEY_FILE);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " keyFilePath=" + this.keyFilePath + " keyFileType=" + this.keyFileType + " certAliasFromKeyFile=" + this.certAliasFromKeyFile + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
                }
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            this.keyFilePathExpanded = KeyStoreManager.getInstance().expand(this.keyFilePath);
            if (KeyStoreHelper.checkKeyFile(this.keyFileType, this.keyFilePathExpanded, this.keyFilePassword) != 0) {
                String msg = this.getMsg(resBundle, "security.admintask.CheckKeyStore", null);
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateImport(this.ksInfo, this.keyFilePath, this.keyFileType, this.keyFilePassword, this.certAlias, this.certAliasFromKeyFile);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.admintask.audit.ImportEncryptionCertificate.afterStepsExecuted", "176", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        result.setResult(new Boolean(true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void personalCertificateImport(KeyStoreInfo info, String keyFileLocation, String keyFileType, String keyFilePassword, String importAlias, String aliasFromKeyFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateImport");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        String alias = importAlias;
        String keyFileLocationExpanded = KeyStoreManager.getInstance().expand(keyFileLocation);
        if (alias == null) {
            alias = aliasFromKeyFile;
        }
        String method2 = "getCertificateChainFromUnManagedKeyStore";
        Object[] parms = new Object[]{keyFileLocationExpanded, keyFileType, keyFilePassword != null ? keyFilePassword.toCharArray() : null, aliasFromKeyFile};
        Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
        method2 = "getKeyFromUnManagedKeyStore";
        parms = new Object[]{keyFileLocationExpanded, keyFileType, keyFilePassword != null ? keyFilePassword.toCharArray() : null, aliasFromKeyFile};
        Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
        if (certChain[0] != null && key[0] != null) {
            method2 = "containsAlias";
            parms = new Object[]{alias};
            Object[] aliasExists = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)aliasExists[0]).booleanValue()) {
                String msg = this.getMsg(resBundle, "security.admintask.CertAliasExists", null);
                throw new CommandValidationException(msg);
            }
        } else {
            String msg = this.getMsg(resBundle, "security.admintask.AliasNotPersonalCert", null);
            throw new CommandValidationException(msg);
        }
        method2 = "setKeyEntry";
        parms = new Object[]{alias, (Key)key[0], info.getPassword() != null ? info.getPassword().toCharArray() : null, (Certificate[])certChain[0]};
        wsksr.invokeKeyStoreCommand(method2, parms);
        Session session = this.getConfigSession();
        PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
        PersonalCertificateHelper.markSSLConfigChanged(info, session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateImport");
        }
    }
}

