/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.encryption;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateAuditEncryptionConfig
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateAuditEncryptionConfig.class, "AUDIT", "com.ibm.ws.security.admintask.audit.encryption");
    private Boolean enable = null;
    private String certAlias = null;
    private Boolean autogenCert = null;
    private Boolean importCert = null;
    private String certKeyFileName = null;
    private String certKeyFilePath = null;
    private String certKeyFileType = null;
    private String certKeyFilePassword = null;
    private String certAliasToImport = null;
    private String encryptionKeyStoreName = null;
    private String encryptionKeyStoreRef = null;
    private String encryptionKeyStorePath = null;
    private String encryptionKeyStoreType = null;
    private String encryptionKeyStorePassword = null;
    private String encryptionKeyStoreConfirmPassword = null;
    private String origCertAlias = null;
    private Boolean keyStoreIsFileBased = Boolean.TRUE;
    private Boolean keyStoreReadOnly = Boolean.FALSE;
    private Boolean keyStoreInitAtStartup = null;
    private String keyStoreCustomProvider = null;
    private Boolean keyStoreStashFile = null;
    private String scopeName = null;
    private boolean createKeyFile = true;
    private String keyStoreDescription = null;
    private ObjectName mgmScopeObjName = null;
    private boolean createMgmScope = false;
    String keyFileName = null;
    ObjectName keyStoreCreated = null;
    boolean keyStoreFound = false;
    String foundKeyStoreRef = null;

    public CreateAuditEncryptionConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditEncryptionConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.enable = (Boolean)this.getParameter("enableAuditEncryption");
        if (this.enable != null && !this.enable.booleanValue()) {
            String msg = this.getMsg(resBundle, "security.admintask.CannotConfigEncryption", null);
            throw new CommandValidationException(msg);
        }
        this.encryptionKeyStoreRef = (String)this.getParameter("encryptionKeyStoreRef");
        if (this.encryptionKeyStoreRef == null || this.encryptionKeyStoreRef.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.NoKeyStoreRefValue", null);
            throw new CommandValidationException(msg);
        }
        this.certAlias = (String)this.getParameter("certAlias");
        if (this.certAlias == null || this.certAlias.length() == 0) {
            String msg = this.getMsg(resBundle, " security.admintask.NoCertAliasValue", null);
            throw new CommandValidationException(msg);
        }
        if (this.certAlias != null && this.certAlias.length() != 0) {
            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                this.origCertAlias = this.certAlias;
            }
            this.certAlias = this.certAlias.toLowerCase();
        }
        this.autogenCert = (Boolean)this.getParameter("autogenCert");
        this.importCert = (Boolean)this.getParameter("importCert");
        if (this.autogenCert != null && this.importCert != null && this.autogenCert.equals(Boolean.TRUE) && this.importCert.equals(Boolean.TRUE)) {
            String msg = this.getMsg(resBundle, "security.admintask.MustSpecifyCertGenMethod", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFileName = (String)this.getParameter("certKeyFileName");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFileName == null || this.certKeyFileName.length() == 0)) {
            String msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFileNameValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFilePath = (String)this.getParameter("certKeyFilePath");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFilePath == null || this.certKeyFilePath.length() == 0)) {
            String msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFilePathValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFileType = (String)this.getParameter("certKeyFileType");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFileType == null || this.certKeyFileType.length() == 0)) {
            String msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFileTypeValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFilePassword = (String)this.getParameter("certKeyFilePassword");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFilePassword == null || this.certKeyFilePassword.length() == 0)) {
            String msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFilePasswordValue", null);
            throw new CommandValidationException(msg);
        }
        this.certAliasToImport = (String)this.getParameter("certAliasToImport");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certAliasToImport == null || this.certAliasToImport.length() == 0)) {
            String msg = this.getMsg(resBundle, "security.admintask.NoCertAliasToImport", null);
            throw new CommandValidationException(msg);
        }
        if (this.certAliasToImport != null && this.certAliasToImport.length() != 0) {
            this.certAliasToImport = this.certAliasToImport.toLowerCase();
        }
        if (tc.isDebugEnabled()) {
            if (this.enable != null) {
                Tr.debug(tc, "enable: " + this.enable.toString());
            }
            if (this.certAlias != null && this.certAlias.length() != 0) {
                Tr.debug(tc, "certAlias: " + this.certAlias);
            }
            if (this.autogenCert != null) {
                Tr.debug(tc, "autogenCert: " + this.autogenCert);
            }
            if (this.importCert != null) {
                Tr.debug(tc, "importCert: " + this.importCert);
            }
            Tr.debug(tc, "certKeyFileName: " + this.certKeyFileName);
            Tr.debug(tc, "certKeyFilePath: " + this.certKeyFilePath);
            Tr.debug(tc, "certKeyFileType: " + this.certKeyFileType);
            Tr.debug(tc, "certAliasToImport: " + this.certAliasToImport);
            if (this.encryptionKeyStoreRef != null && this.encryptionKeyStoreRef.length() != 0) {
                Tr.debug(tc, "encryptionKeyStoreRef: " + this.encryptionKeyStoreRef);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        ObjectName matches = null;
        AttributeList settings = new AttributeList();
        try {
            String msg;
            CommandResult cmdResult;
            AdminCommand getUserCmd;
            ObjectName policyObject;
            block50: {
                block51: {
                    block48: {
                        block49: {
                            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                            matches = cs.resolve(session, "Cell=")[0];
                            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                            if (audit == null) {
                                String msg2 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                                result.addWarnings(msg2);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg2));
                                return;
                            }
                            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
                            policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
                            if (policyObject != null && tc.isDebugEnabled()) {
                                Tr.debug(tc, "policyObj: " + policyObject);
                            }
                            boolean found = false;
                            ArrayList keystoreList = (ArrayList)cs.getAttribute(session, audit, "keyStores");
                            for (int i = 0; i < keystoreList.size(); ++i) {
                                AttributeList keystoreAttrs = (AttributeList)keystoreList.get(i);
                                ObjectName keystoreObj = ConfigServiceHelper.createObjectName(keystoreAttrs);
                                String keystoreRef = ConfigServiceHelper.getAttributeValue(keystoreAttrs, "_Websphere_Config_Data_Id").toString();
                                if (!(keystoreRef = keystoreRef.split("#")[1]).equals(this.encryptionKeyStoreRef)) continue;
                                found = true;
                                this.foundKeyStoreRef = keystoreRef;
                                this.encryptionKeyStoreName = ConfigServiceHelper.getAttributeValue(keystoreAttrs, "name").toString();
                                this.keyStoreCreated = keystoreObj;
                                break;
                            }
                            if (!found) {
                                String msg3 = this.getMsg(resBundle, "security.admintask.NoEncryptionKeyStore", null);
                                result.addWarnings(msg3);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg3));
                                return;
                            }
                            settings.add(new Attribute("encrypt", this.enable));
                            if (this.autogenCert == null || !this.autogenCert.booleanValue()) break block48;
                            CommandMgr commandMgr = CommandMgr.getCommandMgr();
                            getUserCmd = commandMgr.createCommand("createAuditSelfSignedCertificate");
                            getUserCmd.setParameter("keyStoreName", this.encryptionKeyStoreName);
                            getUserCmd.setParameter("certificateAlias", this.certAlias);
                            getUserCmd.setParameter("certificateSize", new Integer(2048));
                            getUserCmd.setParameter("certificateCommonName", InetAddress.getLocalHost().getHostName());
                            getUserCmd.setParameter("certificateOrganization", "IBM");
                            getUserCmd.setConfigSession(session);
                            getUserCmd.execute();
                            cmdResult = getUserCmd.getCommandResult();
                            if (!cmdResult.isSuccessful()) break block49;
                            if (((Boolean)cmdResult.getResult()).booleanValue()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Successfully created self signed personal certificate for audit encryption");
                                }
                                break block50;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Was not successful creating self signed personal certificate for audit encryption");
                                }
                                msg = this.getMsg(resBundle, "security.admintask.AutogenCertFailure", null);
                                if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                                    msg = msg.concat(": ");
                                    msg = msg.concat(cmdResult.getException().getMessage());
                                }
                                result.addWarnings(msg);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg));
                                return;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Was not successful creating self signed personal certificate for audit encryption");
                        }
                        msg = this.getMsg(resBundle, "security.admintask.AutogenCertFailure", null);
                        if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                            msg = msg.concat(": ");
                            msg = msg.concat(cmdResult.getException().getMessage());
                        }
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    if (this.importCert == null || !this.importCert.booleanValue()) break block50;
                    CommandMgr commandMgr = CommandMgr.getCommandMgr();
                    getUserCmd = commandMgr.createCommand("importAuditCertificate");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "encryptionKeyStoreName: " + this.encryptionKeyStoreName);
                        Tr.debug(tc, "keyFilePath: " + this.certKeyFilePath);
                        Tr.debug(tc, "keyFileType: " + this.certKeyFileType);
                        Tr.debug(tc, "certificateAliasFromKeyFile: " + this.certAliasToImport);
                        Tr.debug(tc, "certificateAlias: " + this.certAlias);
                    }
                    getUserCmd.setParameter("keyStoreName", this.encryptionKeyStoreName);
                    getUserCmd.setParameter("keyFilePath", this.certKeyFilePath);
                    getUserCmd.setParameter("keyFilePassword", this.certKeyFilePassword);
                    getUserCmd.setParameter("keyFileType", this.certKeyFileType);
                    getUserCmd.setParameter("certificateAliasFromKeyFile", this.certAliasToImport);
                    getUserCmd.setParameter("certificateAlias", this.certAlias);
                    getUserCmd.setConfigSession(session);
                    getUserCmd.execute();
                    cmdResult = getUserCmd.getCommandResult();
                    if (!cmdResult.isSuccessful()) break block51;
                    if (((Boolean)cmdResult.getResult()).booleanValue()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully imported self signed personal certificate for audit encryption");
                        }
                        break block50;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Was not successful importing self signed personal certificate for audit encryption");
                        }
                        msg = this.getMsg(resBundle, "security.admintask.ImportCertFailure", null);
                        if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                            msg = msg.concat(": ");
                            msg = msg.concat(cmdResult.getException().getMessage());
                        }
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Was not successful importing self signed personal certificate for audit encryption");
                }
                msg = this.getMsg(resBundle, "security.admintask.ImportCertFailure", null);
                if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                    msg = msg.concat(": ");
                    msg = msg.concat(cmdResult.getException().getMessage());
                }
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            if (this.autogenCert != null && !this.autogenCert.booleanValue() && this.importCert != null && !this.importCert.booleanValue() && this.certAlias != null && this.certAlias.length() != 0) {
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                getUserCmd = commandMgr.createCommand("listCertAliases");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyStoreName: " + this.encryptionKeyStoreName);
                }
                getUserCmd.setParameter("keyStoreName", this.encryptionKeyStoreName);
                getUserCmd.setConfigSession(session);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cmdResult.isSuccessful: " + cmdResult.isSuccessful());
                    Tr.debug(tc, "cmdResult.getResult: " + cmdResult.getResult().toString());
                }
                if (cmdResult.isSuccessful()) {
                    String a;
                    int j;
                    boolean foundCert = false;
                    ArrayList aList = (ArrayList)cmdResult.getResult();
                    for (j = 0; j < aList.size(); ++j) {
                        a = (String)aList.get(j);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "alias: " + a + " matching with certAlias: " + this.certAlias);
                        }
                        if (!a.equals(this.certAlias)) continue;
                        foundCert = true;
                    }
                    if (!foundCert) {
                        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                            for (j = 0; j < aList.size(); ++j) {
                                a = (String)aList.get(j);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "alias: " + a + " matching with z certAlias: " + this.origCertAlias);
                                }
                                if (!a.equals(this.origCertAlias)) continue;
                                foundCert = true;
                            }
                        }
                        if (!foundCert) {
                            String msg4 = this.getMsg(resBundle, "security.admintask.CertNotInKeyStore", null);
                            result.addWarnings(msg4);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg4));
                            return;
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Was unsuccessful listing the certificate aliases in the referenced keystore");
                    }
                    msg = this.getMsg(resBundle, "security.admintask.ListCertFailure", null);
                    if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                        msg = msg.concat(": ");
                        msg = msg.concat(cmdResult.getException().getMessage());
                    }
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
            }
            ArrayList certList = (ArrayList)cs.getAttribute(session, audit, "certificates");
            ObjectName certObj = null;
            if (certList.size() == 0) {
                AttributeList certObjAttrs = new AttributeList();
                certObjAttrs.add(new Attribute("alias", this.certAlias));
                certObjAttrs.add(new Attribute("keyStore", this.keyStoreCreated));
                certObj = cs.createConfigData(session, audit, "certificates", "Certificate", certObjAttrs);
                if (certObj == null) {
                    String msg5 = this.getMsg(resBundle, "security.admintask.CreateObjFailure", null);
                    msg5 = msg5.concat(": Certificate");
                    result.addWarnings(msg5);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg5));
                    return;
                }
            } else {
                for (int i = 0; i < certList.size(); ++i) {
                    AttributeList certAttrs = (AttributeList)certList.get(i);
                    certObj = ConfigServiceHelper.createObjectName(certAttrs);
                    AttributeList newSettings = new AttributeList();
                    newSettings.add(new Attribute("alias", this.certAlias));
                    newSettings.add(new Attribute("keyStore", this.keyStoreCreated));
                    cs.setAttributes(session, certObj, newSettings);
                }
            }
            settings.add(new Attribute("encryptionCert", certObj));
            cs.setAttributes(session, policyObject, settings);
            result.setResult(this.foundKeyStoreRef);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.encryption.CreateAuditEncryptionConfig.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            e.printStackTrace();
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.encryption.CreateAuditEncryptionConfig.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            e.printStackTrace();
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public ObjectName createKeyStoreObjectName(Session session, KeyStoreInfo ksInfo) throws Exception {
        TaskCommandResultImpl result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreObjectName");
        }
        if (!(result = (TaskCommandResultImpl)this.getTaskCommandResult()).isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CreateKeyStoreObjectName");
            }
            return null;
        }
        ObjectName keyStoreObj = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName audit = cs.queryConfigObjects(session, null, pattern, null)[0];
        AttributeList attrList = KeyStoreHelper.createKeyStoreAttrList(ksInfo);
        if (attrList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to create KeyStore ObjectName.");
            }
            String msg = this.getMsg(resBundle, "security.admintask.CreateKeyStoreObjectFailure", null);
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return null;
        }
        keyStoreObj = cs.createConfigData(session, audit, "keyStores", "KeyStore", attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreObjectName");
        }
        return keyStoreObj;
    }

    private String fixLocation(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixLocation", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/cells/");
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixLocation -> " + newPath);
        }
        return newPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate getCertFromArmFile(String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertFromArmFile");
        }
        String fileName = null;
        String filePath = null;
        X509Certificate cert = null;
        if (type.equals("server")) {
            fileName = "serverCert.arm";
        } else if (type.equals("client")) {
            fileName = "clientCert.arm";
        } else {
            return null;
        }
        FileInputStream fis = null;
        String profilePath = System.getProperty("user.install.root");
        filePath = profilePath + "/etc/" + fileName;
        try {
            CertificateFactory certificatefactory = null;
            Collection<? extends Certificate> collection = null;
            fis = new FileInputStream(filePath);
            certificatefactory = CertificateFactory.getInstance("X509");
            collection = certificatefactory.generateCertificates(fis);
            X509Certificate[] certFromReqFile = new X509Certificate[collection.size()];
            Iterator<? extends Certificate> iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                certFromReqFile[i] = (X509Certificate)iterator.next();
                ++i;
            }
            cert = certFromReqFile[0];
        }
        catch (FileNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, filePath + " does not exist.  Certificate will no be used.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception recieve while trying to get certificate from arm file: " + e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertFromArmFile");
        }
        return cert;
    }

    public static boolean createKeyStoreFile(KeyStoreInfo keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreFile");
        }
        boolean keyCreated = false;
        X509Certificate clientCert = null;
        X509Certificate serverCert = null;
        String hostList = keyStore.getHostList();
        String type = keyStore.getType();
        String name = keyStore.getLocation();
        String password = keyStore.getPassword();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type: " + type + " name: " + keyStore.getName() + " location: " + keyStore.getLocation());
        }
        if (hostList != null && hostList.equals("")) {
            hostList = null;
        }
        clientCert = CreateAuditEncryptionConfig.getCertFromArmFile("client");
        serverCert = CreateAuditEncryptionConfig.getCertFromArmFile("server");
        keyStore.setReadOnly(false);
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStore);
        try {
            String method2 = null;
            Object[] parms = null;
            if (hostList != null) {
                method2 = "createRemoteKeyStore";
                parms = new Object[]{keyStore.getName(), keyStore.getType(), keyStore.getProvider(), keyStore.getLocation(), keyStore.getPassword(), "dummyClientSigner", clientCert, "dummyServerSigner", serverCert};
                wsksr.invokeKeyStoreCommand(method2, parms);
                keyCreated = true;
            } else if (type.equals("JCERACFKS") || type.equals("JCECCARACFKS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trying to load RACF key store.");
                }
                try {
                    WSKeyStore.loadKeyStore(name, type, password);
                    keyCreated = true;
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failure loading key ring.  The key ring needs to be created on RACF .");
                    }
                }
            } else {
                if (clientCert != null) {
                    method2 = "setCertificateEntry";
                    parms = new Object[]{"dummyClientSigner", clientCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (serverCert != null) {
                    method2 = "setCertificateEntry";
                    parms = new Object[]{"dummyServerSigner", serverCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (clientCert == null && serverCert == null) {
                    wsksr.store();
                    keyCreated = true;
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreFile");
        }
        return keyCreated;
    }
}

