/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.certificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.certificates.PersonalCertificateHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ImportAuditCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ImportAuditCertificate.class, "Audit", "com.ibm.ws.security.admintask.audit.certificates");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private String keyStoreName = null;
    private String fromKeyStoreName = null;
    private String keyFilePath = null;
    private String keyFilePathExpanded = null;
    private String keyFilePassword = null;
    private String keyFileType = null;
    private String certAliasFromKeyFile = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private String fromKeyStoreScope = null;
    private String fromKeyStorePassword = null;
    private KeyStoreInfo ksInfo = null;
    private KeyStoreInfo fromKsInfo = null;
    private String certAliasFromKeyStore = null;
    private String msgLocation = null;

    public ImportAuditCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ImportAuditCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ObjectName pattern = null;
            ObjectName audit = null;
            try {
                String msg;
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                ObjectName cell = cs.resolve(session, "Cell=")[0];
                pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                String keyFileName = null;
                String commandName = this.getName();
                if (commandName.equals("importAuditCertificate")) {
                    this.keyFilePath = (String)this.getParameter(CommandConstants.KEY_FILE_PATH);
                    this.keyFilePassword = (String)this.getParameter(CommandConstants.KEY_FILE_PASSWORD);
                    this.keyFileType = (String)this.getParameter(CommandConstants.KEY_FILE_TYPE);
                    this.certAliasFromKeyFile = (String)this.getParameter(CommandConstants.CERT_ALIAS_FROM_KEY_FILE);
                    if (this.isManagedKeyStore(this.keyFilePath)) {
                        boolean granted;
                        RoleBasedConfigurator configurator = RoleBasedConfiguratorFactory.getConfigurator();
                        RoleBasedAuthorizer adminAuthorizer = configurator.getRoleBasedAuthorizer("admin-authz", "domain");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the RoleBasedAuthorizer object.");
                        }
                        if (!(granted = adminAuthorizer.isCallerInRole("administrator"))) {
                            String msg2 = this.getMsg(resBundle, "security.admintask.UserNotInRole", new Object[]{"administrator"});
                            throw new CommandValidationException(msg2);
                        }
                    }
                } else {
                    this.fromKeyStoreName = (String)this.getParameter(CommandConstants.FROM_KEY_STORE_NAME);
                    this.fromKeyStoreScope = (String)this.getParameter(CommandConstants.FROM_KEY_STORE_SCOPE);
                    this.fromKeyStorePassword = (String)this.getParameter(CommandConstants.FROM_KEY_STORE_PASSWORD);
                    this.certAliasFromKeyStore = (String)this.getParameter(CommandConstants.FROM_KEY_STORE_OBJ);
                }
                this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
                this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
                this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyFileName=" + keyFileName + " keyFileType=" + this.keyFileType + " certAliasFromKeyFile=" + this.certAliasFromKeyFile + " certAlias=" + this.certAlias);
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.keyStoreScope == null) {
                    this.keyStoreScope = commandHelper.defaultCellScope(cell);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
                    }
                }
                this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
                if (this.ksInfo.getReadOnly().booleanValue()) {
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                    throw new CommandValidationException(msg);
                }
                if (this.fromKeyStoreName != null) {
                    if (this.fromKeyStoreScope == null) {
                        this.fromKeyStoreScope = commandHelper.defaultScope();
                    }
                    this.fromKsInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.fromKeyStoreName, this.fromKeyStoreScope);
                    if (this.ksInfo.getFileBased().booleanValue() && KeyStoreHelper.checkKeyFile(this.fromKsInfo.getType(), this.fromKsInfo.getLocation(), this.fromKeyStorePassword) != 0) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.fromKsInfo.getLocation()}, "Key store file \"" + this.fromKsInfo.getLocation() + "\" did not verify, make sure the file exists, check key store type and password.");
                        throw new CommandValidationException(msg);
                    }
                    if (this.ksInfo.getType().equals("JCERACFKS") || this.ksInfo.getType().equals("JCECCARACFKS")) {
                        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(this.ksInfo);
                        try {
                            String method2 = "load";
                            Object[] parms = new Object[]{this.ksInfo.getLocation(), this.ksInfo.getType(), this.fromKeyStorePassword};
                            wsksr.invokeKeyStoreCommand(method2, parms);
                        }
                        catch (Exception e) {
                            String msg3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.ksInfo.getLocation()}, "Key store file \"" + this.ksInfo.getLocation() + "\" did not verify, make sure the file or keyring exists, check key store type and password.");
                            throw new CommandValidationException(msg3);
                        }
                    }
                    this.msgLocation = this.fromKsInfo.getName();
                    break block20;
                }
                this.keyFilePathExpanded = KeyStoreManager.getInstance().expand(this.keyFilePath);
                if (this.ksInfo.getFileBased().booleanValue() && KeyStoreHelper.checkKeyFile(this.keyFileType, this.keyFilePathExpanded, this.keyFilePassword) != 0) {
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyFilePath}, "Key store file \"" + this.keyFilePath + "\" did not verify, make sure the file exits, check key store type and password.");
                    throw new CommandValidationException(msg);
                }
                this.msgLocation = this.ksInfo.getLocation();
            }
            catch (Exception e) {
                String msg = e.getMessage();
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            if (this.fromKeyStoreName != null) {
                this.personalCertificateImport(this.ksInfo, this.fromKsInfo, this.certAlias, this.certAliasFromKeyStore);
            } else {
                this.personalCertificateImport(this.ksInfo, this.keyFilePath, this.keyFileType, this.keyFilePassword, this.certAlias, this.certAliasFromKeyFile);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.admintask.audit.ImportAuditCertificate.afterStepsExecuted", "176", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        result.setResult(new Boolean(true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void personalCertificateImport(KeyStoreInfo info, String keyFileLocation, String keyFileType, String keyFilePassword, String importAlias, String aliasFromKeyFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateImport");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        String alias = importAlias;
        String keyFileLocationExpanded = KeyStoreManager.getInstance().expand(keyFileLocation);
        if (alias == null || alias != null && alias.length() == 0) {
            alias = aliasFromKeyFile;
        }
        try {
            String method2 = "getCertificateChainFromUnManagedKeyStore";
            Object[] parms = new Object[]{keyFileLocationExpanded, keyFileType, keyFilePassword != null ? keyFilePassword.toCharArray() : null, aliasFromKeyFile};
            Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
            method2 = "getKeyFromUnManagedKeyStore";
            parms = new Object[]{keyFileLocationExpanded, keyFileType, keyFilePassword != null ? keyFilePassword.toCharArray() : null, aliasFromKeyFile};
            Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
            if (certChain[0] == null || key[0] == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{aliasFromKeyFile, keyFileLocation}, "Alias \"" + aliasFromKeyFile + "\" is not a personal certificate in key store \"" + keyFileLocation + "\".");
                throw new CommandValidationException(msg);
            }
            this.setPersonalCertificate(info, alias, key, certChain);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.ImportCertificate.personalCertificateImport", "225", this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateImport");
        }
    }

    public void personalCertificateImport(KeyStoreInfo info, KeyStoreInfo fromInfo, String importAlias, String aliasFromKeyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateImport");
        }
        WSKeyStoreRemotable fromWsksr = new WSKeyStoreRemotable(fromInfo);
        String alias = importAlias;
        if (alias == null || alias != null && alias.length() == 0) {
            alias = aliasFromKeyStore;
        }
        try {
            String method2 = "getCertificateChain";
            Object[] parms = new Object[]{aliasFromKeyStore};
            Object[] certChain = fromWsksr.invokeKeyStoreCommand(method2, parms);
            method2 = "getKey";
            parms = new Object[]{aliasFromKeyStore, fromInfo.getPassword() != null ? fromInfo.getPassword().toCharArray() : null};
            Object[] key = fromWsksr.invokeKeyStoreCommand(method2, parms);
            if (certChain[0] == null || key[0] == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{aliasFromKeyStore, fromInfo.getLocation()}, "Alias \"" + aliasFromKeyStore + "\" is not a personal certificate in key store \"" + fromInfo.getLocation() + "\".");
                throw new CommandValidationException(msg);
            }
            this.setPersonalCertificate(info, alias, key, certChain);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.ImportCertificate.personalCertificateImport", "266", this);
            throw e;
        }
    }

    private void setPersonalCertificate(KeyStoreInfo info, String alias, Object[] key, Object[] certChain) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPersonalCertificate");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        String method2 = "containsAlias";
        Object[] parms = new Object[]{alias};
        Object[] aliasExists = wsksr.invokeKeyStoreCommand(method2, parms);
        if (((Boolean)aliasExists[0]).booleanValue()) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.already.exists.CWPKI0630E", new Object[]{alias, this.msgLocation}, "Alias \"" + alias + "\" already exists in key store \"" + this.msgLocation + "\".");
            throw new CommandValidationException(msg);
        }
        method2 = "setKeyEntry";
        parms = new Object[]{alias, (Key)key[0], info.getPassword() != null ? info.getPassword().toCharArray() : null, (Certificate[])certChain[0]};
        wsksr.invokeKeyStoreCommand(method2, parms);
        Session session = this.getConfigSession();
        if (info.getFileBased().booleanValue()) {
            PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPersonalCertificate");
        }
    }

    public boolean isManagedKeyStore(String keyFilePath) throws Exception {
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        if (cs == null) {
            AdminClient adminClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
            cs = new ConfigServiceProxy(adminClient);
        }
        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
        CommandHelper commandHelper = new CommandHelper();
        List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
        String expandedInputKeyFilePath = KeyStoreManager.getInstance().expand(keyFilePath);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "searching for keyFilePath: " + expandedInputKeyFilePath);
        }
        for (AttributeList keyStore : keyStores) {
            String ksPath = (String)ConfigServiceHelper.getAttributeValue(keyStore, "location");
            String keyFilePathExpanded = KeyStoreManager.getInstance().expand(ksPath);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyFilePathExpanded: " + keyFilePathExpanded);
            }
            if (!expandedInputKeyFilePath.equalsIgnoreCase(keyFilePathExpanded)) continue;
            return true;
        }
        return false;
    }
}

