/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListLoginConfigs
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(ListLoginConfigs.class, "ListLoginConfigs", "com.ibm.ws.security.adminTasks");

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        return super.loadCommand(cmdData);
    }

    public List listLoginConfigs(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeGroup", new Object[]{cmd});
        }
        CommandProviderHelper helper = this.getCommandProviderHelper();
        ConfigService cs = helper.getConfigService();
        Session session = cmd.getConfigSession();
        ObjectName security2 = null;
        String loginModuleType = null;
        String type = null;
        ArrayList<String> loginModules = new ArrayList<String>();
        try {
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            loginModuleType = (String)cmd.getParameter("loginModuleType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loginModuleType: " + loginModuleType);
            }
            if (!loginModuleType.equalsIgnoreCase("system") && !loginModuleType.equalsIgnoreCase("application")) {
                String msg = "Login module type must be \"system\" or \"application\".";
                throw new CommandValidationException(msg);
            }
            if (loginModuleType.equalsIgnoreCase("system")) {
                type = "systemLoginConfig";
            } else if (loginModuleType.equalsIgnoreCase("application")) {
                type = "applicationLoginConfig";
            }
            AttributeList entry2 = null;
            AttributeList loginModule = (AttributeList)cs.getAttribute(session, security2, type);
            ArrayList entries = (ArrayList)ConfigServiceHelper.getAttributeValue(loginModule, "entries");
            for (AttributeList entry2 : entries) {
                String alias = (String)ConfigServiceHelper.getAttributeValue(entry2, "alias");
                loginModules.add(alias);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.cwadminTask.listLoginConfigs.validate", "136");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        return loginModules;
    }
}

