/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.Locale;
import java.util.ResourceBundle;

public class IsJACCEnabled
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(IsJACCEnabled.class, "IsJACCEnabled", "com.ibm.ws.security.admintasks");

    public IsJACCEnabled(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public IsJACCEnabled(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted - isJACCEnabled");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTaskCommandResult() failed");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted - isJACCEnabled");
            }
            return;
        }
        try {
            boolean isEnabled = SecurityObjectLocator.getSecurityConfig("security").getAuthorizationConfig().getBoolean("useJACCProvider");
            if (isEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JACC is enabled");
                }
                result.setResult(new Boolean(true));
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JACC is not enabled");
                }
                result.setResult(new Boolean(false));
            }
        }
        catch (Throwable th) {
            String msg = this.getMsg(resBundle, "security.admintask.ExceptionIsJACCEnabled", null);
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted - isJACCEnabled");
        }
    }
}

