/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.models.config.rolebasedauthz.impl.RolebasedauthzFactoryImpl;
import com.ibm.websphere.security.Result;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class IsAdminLockedOut
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(IsAdminLockedOut.class, "IsAdminLockedOut", "com.ibm.ws.security.admintask");
    private String registryType = null;
    ConfigService cs = null;
    Session session = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";

    public IsAdminLockedOut(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public IsAdminLockedOut(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private AuthorizationTableExt getAuthTable(Session session, String subStr, WorkSpace ws) throws WorkSpaceException, Exception {
        String resourceName = "";
        resourceName = "admin-authz.xml";
        AuthorizationTableExt atx = null;
        RepositoryContext cellContext = AppUtils.findContext("cells", subStr, null, null, ws, true);
        cellContext.extract(resourceName, false);
        Resource resource = cellContext.getResourceSet().createResource(URI.createURI(resourceName));
        resource.load(new HashMap());
        EList ext = resource.getContents();
        Iterator itr = ext.iterator();
        while (itr.hasNext() && !(atx = (AuthorizationTableExt)itr.next()).getContext().equals("domain")) {
        }
        return atx;
    }

    public boolean validUserRegType(String userRegType) {
        return userRegType.equalsIgnoreCase(ldapUR) || userRegType.equalsIgnoreCase(wimUR) || userRegType.equalsIgnoreCase(customUR) || userRegType.equalsIgnoreCase(localOSUR);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.registryType = (String)this.getParameter("registryType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registryType = " + this.registryType);
        }
        if (!this.validUserRegType(this.registryType)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        block48: {
            TaskCommandResultImpl result;
            WorkSpace ws;
            String subStr;
            ObjectName security2;
            block47: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "afterStepsExecuted");
                }
                super.afterStepsExecuted();
                security2 = null;
                subStr = null;
                ws = null;
                String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
                result = (TaskCommandResultImpl)this.getTaskCommandResult();
                if (!result.isSuccessful()) {
                    if (tc.isDebugEnabled()) {
                        Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
                    }
                    return;
                }
                try {
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
                    this.cs = ConfigServiceFactory.getConfigService();
                    this.session = this.getConfigSession();
                    ObjectName cellName = this.cs.resolve(this.session, "Cell=")[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cell = " + cellName.toString());
                    }
                    if (cellName != null) {
                        security2 = this.cs.queryConfigObjects(this.session, cellName, pattern, null)[0];
                    }
                    int index1 = cellName.toString().indexOf("_Websphere_Config_Data_Display_Name");
                    subStr = cellName.toString().substring(index1);
                    int index2 = subStr.indexOf(",");
                    subStr = subStr.substring(0, index2);
                    int index3 = subStr.indexOf("=");
                    subStr = subStr.substring(index3 + 1);
                    ws = WorkspaceHelper.getWorkspace((Session)this.session);
                }
                catch (Throwable th) {
                    String msg = this.getMsg(resBundle, "security.admintask.FailAccesstoSecWS", null);
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    if (!tc.isEntryEnabled()) break block47;
                    Tr.exit(tc, "afterStepsExecuted");
                }
            }
            boolean foundUserInRegistry = false;
            RolebasedauthzFactoryImpl authFactory = new RolebasedauthzFactoryImpl();
            try {
                AuthorizationTableExt authTable = this.getAuthTable(this.session, subStr, ws);
                if (authTable == null) break block48;
                EList authorizations = authTable.getAuthorizations();
                for (RoleAssignmentExt roleAssignment : authorizations) {
                    SecurityRoleExt role;
                    if (roleAssignment == null || !(role = roleAssignment.getRole()).getRoleName().equals("administrator")) continue;
                    EList userList = roleAssignment.getUsers();
                    for (UserExt user : userList) {
                        Properties userRegProps = new Properties();
                        ObjectName[] matches = null;
                        ArrayList urs = (ArrayList)this.cs.getAttribute(this.session, security2, "userRegistries");
                        for (int i = 0; i < urs.size(); ++i) {
                            AttributeList urAttrs = (AttributeList)urs.get(i);
                            Object urObj = ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                            if (!urObj.toString().equals(this.registryType)) continue;
                            matches = this.cs.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(urAttrs), null);
                        }
                        ArrayList<String> cNameProps = new ArrayList<String>();
                        ArrayList<String> cValueProps = new ArrayList<String>();
                        AttributeList regAttrs = this.cs.getAttributes(this.session, (ObjectName)matches[0], null, true);
                        for (int i = 0; i < regAttrs.size(); ++i) {
                            Attribute a = (Attribute)regAttrs.get(i);
                            if (a.getValue() == null) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "name[" + i + "]:  " + a.getName());
                                Tr.debug(tc, "value[" + i + "]: " + a.getValue().toString());
                            }
                            if (a.getName().equals("properties")) {
                                ArrayList customPropsArray = (ArrayList)this.cs.getAttribute(this.session, matches[0], "properties");
                                for (int ii = 0; ii < customPropsArray.size(); ++ii) {
                                    AttributeList customAttrs = (AttributeList)customPropsArray.get(ii);
                                    for (int j = 0; j < customAttrs.size(); ++j) {
                                        Attribute c = (Attribute)customAttrs.get(j);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "c = " + c.toString());
                                        }
                                        if (c.getValue() == null) continue;
                                        if (c.getName().equals("name")) {
                                            cNameProps.add(c.getValue().toString());
                                            if (!tc.isDebugEnabled()) continue;
                                            Tr.debug(tc, "cNameProps:add: " + c.getValue().toString());
                                            continue;
                                        }
                                        if (!c.getName().equals("value")) continue;
                                        cValueProps.add(c.getValue().toString());
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "cValueProps:add: " + c.getValue().toString());
                                    }
                                }
                            }
                            userRegProps.setProperty(a.getName(), a.getValue().toString());
                        }
                        String[] hostProps = new String[10];
                        String[] portProps = new String[10];
                        Properties searchProps = new Properties();
                        if (this.registryType.equals(ldapUR)) {
                            int hostIndex = 0;
                            int portIndex = 0;
                            ArrayList hosts = (ArrayList)this.cs.getAttribute(this.session, matches[0], "hosts");
                            for (int i = 0; i < hosts.size(); ++i) {
                                AttributeList hostAttrs = (AttributeList)hosts.get(i);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, " hostAttrs.size = " + hostAttrs.size());
                                }
                                for (int j = 0; j < hostAttrs.size(); ++j) {
                                    Attribute h = (Attribute)hostAttrs.get(j);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "h = " + h.toString());
                                    }
                                    if (h.getValue() == null) continue;
                                    if (h.getName().equals("host")) {
                                        hostProps[hostIndex++] = h.getValue().toString();
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "host[" + (hostIndex - 1) + "]: " + h.getValue().toString());
                                        continue;
                                    }
                                    if (!h.getName().equals("port")) continue;
                                    portProps[portIndex++] = h.getValue().toString();
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "port[" + (portIndex - 1) + "]: " + h.getValue().toString());
                                }
                            }
                            ArrayList searchFilters = (ArrayList)this.cs.getAttribute(this.session, matches[0], "searchFilter");
                            for (int i = 0; i < searchFilters.size(); ++i) {
                                Attribute sa = (Attribute)searchFilters.get(i);
                                if (sa.getValue() == null) continue;
                                searchProps.setProperty(sa.getName(), sa.getValue().toString());
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "name[" + i + "]:  " + sa.getName());
                                Tr.debug(tc, "value[" + i + "]: " + sa.getValue().toString());
                            }
                        }
                        Properties props = null;
                        if (this.registryType.equals(wimUR)) {
                            String className = userRegProps.getProperty("registryClassName");
                            props = new Properties();
                            props.setProperty("CustUserRegImplClass", className);
                        } else if (this.registryType.equals(customUR)) {
                            String className = userRegProps.getProperty("customRegistryClassName");
                            props = new Properties();
                            props.setProperty("CustUserRegImplClass", className);
                            for (int i = 0; i < cNameProps.size(); ++i) {
                                props.put((String)cNameProps.get(i), (String)cValueProps.get(i));
                            }
                        } else if (this.registryType.equals(ldapUR)) {
                            props = new Properties();
                            props.setProperty("security.registry.ldap.searchTimeLimit", userRegProps.getProperty("searchTimeout"));
                            props.setProperty("LDAP.server.pwd", userRegProps.getProperty("serverPassword"));
                            props.setProperty("com.ibm.ssl.remotePort", hostProps[0]);
                            props.setProperty("com.ibm.ssl.remoteHost", portProps[0]);
                            props.setProperty("groupmember.idmap", searchProps.getProperty("groupMemberIdMap"));
                            props.setProperty("user.filter", searchProps.getProperty("userFilter"));
                            props.setProperty("group.idmap", searchProps.getProperty("groupIdMap"));
                            props.setProperty("security.registry.ldap.reuseConn", userRegProps.getProperty("reuseConnection"));
                            props.setProperty("group.filter", searchProps.getProperty("groupFilter"));
                            props.setProperty("dirType", userRegProps.getProperty("type"));
                            props.setProperty("user.idmap", searchProps.getProperty("userIdMap"));
                            props.setProperty("ldap.basedn", userRegProps.getProperty("baseDN"));
                            if (userRegProps.getProperty("bindDN") != null && userRegProps.getProperty("bindDN").length() > 0) {
                                props.setProperty("java.naming.security.principal", userRegProps.getProperty("bindDN"));
                            }
                            if (userRegProps.getProperty("bindPassword") != null && userRegProps.getProperty("bindPassword").length() > 0) {
                                props.setProperty("java.naming.security.credentials", userRegProps.getProperty("bindPassword"));
                            }
                            props.setProperty("LDAP.server.id", userRegProps.getProperty("serverId"));
                            props.setProperty("LDAP.server.realm", userRegProps.getProperty("realm"));
                            props.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
                            if (searchProps.getProperty("certificateMapMode").equals("EXACT_DN")) {
                                props.setProperty("certificate.map.mode", "exactDNMode");
                            } else {
                                props.setProperty("certificate.map.mode", searchProps.getProperty("certificateMapMode"));
                            }
                            props.setProperty("java.naming.provider.url", "ldap://" + hostProps[0] + ":" + portProps[0]);
                        } else if (this.registryType.equals(localOSUR)) {
                            props = new Properties();
                            props.setProperty("security.activeUserRegistryType", "LOCALOS");
                        }
                        if (props != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "props = " + props.toString());
                        }
                        int count = 0;
                        String method2 = "getUsers";
                        try {
                            String processName = AdminServiceFactory.getAdminService().getProcessName();
                            ObjectName on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                            Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                            if (!it.hasNext()) {
                                result.setResult(new Boolean(false));
                                return;
                            }
                            on = (ObjectName)it.next();
                            Result results = (Result)AdminServiceFactory.getAdminService().invoke(on, method2, new Object[]{user.getName(), new Integer(100), props}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                            count = results.getList().size();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "count = " + count);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (count == 0) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "user " + user.getName() + " not found in registry");
                            continue;
                        }
                        foundUserInRegistry = true;
                        break;
                    }
                    if (!foundUserInRegistry) continue;
                    break;
                }
                if (!foundUserInRegistry) {
                    result.setResult(new Boolean(true));
                } else {
                    result.setResult(new Boolean(false));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = this.getMsg(resBundle, "security.admintask.IsAdminLockedOut", null);
                result.setException(new CommandException(e, msg));
                result.setResult(new Boolean(false));
                return;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

