/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.LDAPDirectoryType;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.security.WIMUserRegistry;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class GetCurrentWizardSettings
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(GetCurrentWizardSettings.class, "GetCurrentWizardSettings", "com.ibm.ws.security.admintasks");
    final String isEnabledKey = "isEnabled";
    final String secureAppsKey = "secureApps";
    final String secureLocalResourcesKey = "secureLocalResources";
    final String userRegistryTypeKey = "userRegistryType";

    public GetCurrentWizardSettings(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetCurrentWizardSettings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        Properties resultProps = new Properties();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            ObjectName cellName = cs.resolve(s, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + cellName.toString());
            }
            if (cellName != null) {
                security2 = cs.queryConfigObjects(s, cellName, pattern, null)[0];
            }
            int index1 = cellName.toString().indexOf("_Websphere_Config_Data_Display_Name");
            String subStr = cellName.toString().substring(index1);
            int index2 = subStr.indexOf(",");
            subStr = subStr.substring(0, index2);
            int index3 = subStr.indexOf("=");
            subStr = subStr.substring(index3 + 1);
            WorkSpace ws = WorkspaceHelper.getWorkspace((Session)s);
            RepositoryContext cellC = AppUtils.findContext("cells", subStr, null, null, ws, true);
            URI uri = URI.createURI("security.xml");
            Resource res = cellC.getResourceSet().getResource(uri, true);
            Security contents = (Security)res.getContents().get(0);
            boolean isEnabled = contents.isEnabled();
            boolean secureApps = contents.isAppEnabled();
            boolean secureLocalResources = contents.isEnforceJava2Security();
            UserRegistry activeUserRegistry = contents.getActiveUserRegistry();
            ObjectName activeUserRegistryObj = (ObjectName)cs.getAttribute(s, security2, "activeUserRegistry");
            if (isEnabled) {
                resultProps.setProperty("isEnabled", "true");
            } else {
                resultProps.setProperty("isEnabled", "false");
            }
            if (secureApps) {
                resultProps.setProperty("secureApps", "true");
            } else {
                resultProps.setProperty("secureApps", "false");
            }
            if (secureApps) {
                resultProps.setProperty("secureLocalResources", "true");
            } else {
                resultProps.setProperty("secureLocalResources", "false");
            }
            if (contents.getActiveUserRegistry() instanceof LocalOSUserRegistry) {
                resultProps.setProperty("userRegistryType", "LocalOSUserRegistry");
                LocalOSUserRegistry localOSUR = (LocalOSUserRegistry)contents.getActiveUserRegistry();
                String localOSServerUserName = activeUserRegistry.getServerId();
                resultProps.setProperty("serverUserName", localOSServerUserName);
            }
            if (contents.getActiveUserRegistry() instanceof CustomUserRegistry) {
                EList activeUserRegProps = activeUserRegistry.getProperties();
                resultProps.setProperty("userRegistryType", "CustomUserRegistry");
                CustomUserRegistry customUR = (CustomUserRegistry)contents.getActiveUserRegistry();
                String customURClassName = customUR.getCustomRegistryClassName();
                String customServerUserName = activeUserRegistry.getServerId();
                if (customServerUserName != null) {
                    resultProps.setProperty("serverUserName", customServerUserName);
                }
                resultProps.setProperty("customRegistryClass", customURClassName);
                String[] customPropName = new String[activeUserRegProps.size()];
                String[] customPropValue = new String[activeUserRegProps.size()];
                ArrayList props = (ArrayList)cs.getAttribute(s, activeUserRegistryObj, "properties");
                String customProps = new String();
                for (int i = 0; i < activeUserRegProps.size(); ++i) {
                    AttributeList newPropAttrs = (AttributeList)props.get(i);
                    Object pName = ConfigServiceHelper.getAttributeValue(newPropAttrs, "name");
                    Object pValue = ConfigServiceHelper.getAttributeValue(newPropAttrs, "value");
                    customPropName[i] = (String)pName;
                    customPropValue[i] = (String)pValue;
                    customProps = customProps.concat(pName.toString() + ":" + pValue.toString() + ";");
                }
                resultProps.setProperty("customProps", customProps);
            }
            if (contents.getActiveUserRegistry() instanceof WIMUserRegistry) {
                resultProps.setProperty("userRegistryType", "WIMUserRegistry");
                WIMUserRegistry wimUR = (WIMUserRegistry)contents.getActiveUserRegistry();
                String wimServerUserName = activeUserRegistry.getServerId();
                resultProps.setProperty("serverUserName", wimServerUserName);
            }
            if (contents.getActiveUserRegistry() instanceof LDAPUserRegistry) {
                resultProps.setProperty("userRegistryType", "LDAPUserRegistry");
                LDAPUserRegistry ldapUR = (LDAPUserRegistry)contents.getActiveUserRegistry();
                LDAPDirectoryType ldapServerType = ldapUR.getType();
                String realmName = activeUserRegistry.getRealm();
                index1 = realmName.indexOf(":");
                String ldapHostName = realmName.substring(0, index1);
                String ldapPort = realmName.substring(index1 + 1, realmName.length());
                String ldapBaseDN = ldapUR.getBaseDN();
                String ldapBindDN = ldapUR.getBindDN();
                String ldapBindPassword = ldapUR.getBindPassword();
                String ldapServerUserName = activeUserRegistry.getServerId();
                Integer sType = new Integer(ldapServerType.getValue());
                resultProps.setProperty("ldapServerType", sType.toString());
                resultProps.setProperty("ldapHostname", ldapHostName);
                resultProps.setProperty("ldapPort", ldapPort);
                resultProps.setProperty("ldapBaseDN", ldapBaseDN);
                resultProps.setProperty("ldapBindDN", ldapBindDN);
                resultProps.setProperty("ldapBindPassword", ldapBindPassword);
                resultProps.setProperty("ldapServerUserName", ldapServerUserName);
            }
            result.setResult(resultProps);
        }
        catch (Throwable th) {
            String msg = this.getMsg(resBundle, "security.admintask.ExceptionGettingWizardSettings", null);
            result.addWarnings(msg);
            result.setResult(null);
            result.setException(new CommandException(msg));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resultProps = " + resultProps.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

