/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.models.config.rolebasedauthz.impl.RolebasedauthzFactoryImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class AddToAdminAuthz
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(AddToAdminAuthz.class, "AddToAdminAuthz", "com.ibm.ws.security.admintask");
    private String adminUser = null;
    private String registryType = null;
    ConfigService cs = null;
    Session session = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";

    public AddToAdminAuthz(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public AddToAdminAuthz(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private AuthorizationTableExt getAuthTable(Session session, String subStr, WorkSpace ws) throws WorkSpaceException, Exception {
        String resourceName = "";
        resourceName = "admin-authz.xml";
        AuthorizationTableExt atx = null;
        RepositoryContext cellContext = AppUtils.findContext("cells", subStr, null, null, ws, true);
        cellContext.extract(resourceName, false);
        Resource resource = cellContext.getResourceSet().createResource(URI.createURI(resourceName));
        resource.load(new HashMap());
        EList ext = resource.getContents();
        Iterator itr = ext.iterator();
        while (itr.hasNext() && !(atx = (AuthorizationTableExt)itr.next()).getContext().equals("domain")) {
        }
        return atx;
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.adminUser = (String)this.getParameter("adminUser");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        String subStr = null;
        WorkSpace ws = null;
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            this.session = this.getConfigSession();
            ObjectName cellName = cs.resolve(this.session, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + cellName.toString());
            }
            if (cellName != null) {
                security2 = cs.queryConfigObjects(this.session, cellName, pattern, null)[0];
            }
            int index1 = cellName.toString().indexOf("_Websphere_Config_Data_Display_Name");
            subStr = cellName.toString().substring(index1);
            int index2 = subStr.indexOf(",");
            subStr = subStr.substring(0, index2);
            int index3 = subStr.indexOf("=");
            subStr = subStr.substring(index3 + 1);
            ws = WorkspaceHelper.getWorkspace((Session)this.session);
        }
        catch (Throwable th) {
            String msg = this.getMsg(resBundle, "security.admintask.FailAccesstoSecWS", null);
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        RolebasedauthzFactoryImpl authFactory = new RolebasedauthzFactoryImpl();
        boolean found_in_admin_authz = false;
        try {
            AuthorizationTableExt authTable = this.getAuthTable(this.session, subStr, ws);
            if (authTable != null) {
                SecurityRoleExt role;
                EList authorizations = authTable.getAuthorizations();
                for (RoleAssignmentExt roleAssignment : authorizations) {
                    if (roleAssignment == null || !(role = roleAssignment.getRole()).getRoleName().equals("administrator")) continue;
                    EList userList = roleAssignment.getUsers();
                    for (UserExt user : userList) {
                        if (!user.getName().equals(this.adminUser)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found user " + this.adminUser + " in admin-authz.xml");
                        }
                        found_in_admin_authz = true;
                        result.setResult(new Boolean(true));
                    }
                }
                if (!found_in_admin_authz) {
                    for (RoleAssignmentExt roleAssignment : authorizations) {
                        UserExt user;
                        if (roleAssignment == null) continue;
                        role = roleAssignment.getRole();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "role.getRoleName = " + role.getRoleName());
                        }
                        if (role.getRoleName().equals("administrator")) {
                            user = authFactory.createUserExt();
                            user.setName(this.adminUser);
                            roleAssignment.getUsers().add(user);
                            continue;
                        }
                        if (!role.getRoleName().equals("adminsecuritymanager")) continue;
                        user = authFactory.createUserExt();
                        user.setName(this.adminUser);
                        roleAssignment.getUsers().add(user);
                    }
                }
                RepositoryContext cellContext = AppUtils.findContext("cells", subStr, null, null, ws, true);
                String resourceName = "";
                resourceName = "admin-authz.xml";
                Resource resource = cellContext.getResourceSet().getResource(URI.createURI(resourceName), false);
                resource.save(new HashMap());
            }
        }
        catch (WorkSpaceException e) {
            e.printStackTrace();
            String msg = this.getMsg(resBundle, "security.admintask.WorkSpaceFailAddUsertoAdminAuthz", null);
            result.setException(new CommandException(e, msg));
            result.setResult(new Boolean(false));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = this.getMsg(resBundle, "security.admintask.FailAddUsertoAdminAuthz", null);
            result.setException(new CommandException(e, msg));
            result.setResult(new Boolean(false));
            return;
        }
        result.setResult(new Boolean(true));
    }
}

