/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.IIOPTransportTSHelper;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class TransportLayerTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(TransportLayerTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public TransportLayerTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable table, ConfigNameCache cache) {
        super(configClient, shell, table, cache);
        this.reset();
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "sslConfig";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList input, ObjectName on, boolean create) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(input, on);
        }
        catch (AdminException ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        catch (ConnectorException ce) {
            this._shell.setLastException(ce);
            throw new ScriptingException(ce.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return input;
    }

    protected boolean validate(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        AttributeList aList;
        boolean warning;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            warning = false;
            aList = null;
            Object aVal = null;
            try {
                aList = (AttributeList)ConfigServiceHelper.getAttributeValue(input, "serverAuthentication");
            }
            catch (AttributeNotFoundException anfe) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Ex - " + anfe.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "aList: " + aList);
        }
        if (aList != null) {
            IIOPTransportTSHelper transportHelper = (IIOPTransportTSHelper)this.getTSHelper("IIOPTransport");
            transportHelper.setMessageId("SECURITY_NONFIPS_PROVIDER");
            transportHelper.setValidationType("sslConfig");
            warning = transportHelper.validate(aList, on);
            transportHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + warning);
        }
        return warning;
    }
}

