/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.PropertyTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class SecureSocketLayerTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(SecureSocketLayerTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public SecureSocketLayerTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable helper, ConfigNameCache cache) {
        super(configClient, shell, helper, cache);
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "com.ibm.ssl.contextProvider";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList input, ObjectName on, boolean create) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(input, on);
        }
        catch (AdminException ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        catch (ConnectorException ce) {
            this._shell.setLastException(ce);
            throw new ScriptingException(ce.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return input;
    }

    protected boolean validate(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        boolean warning;
        ArrayList arlist;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            arlist = null;
            warning = false;
            try {
                arlist = (ArrayList)ConfigServiceHelper.getAttributeValue(input, "properties");
            }
            catch (AttributeNotFoundException anfe) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Ex - " + anfe.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "arlist: " + arlist);
        }
        if (arlist != null) {
            PropertyTSHelper propHelper = (PropertyTSHelper)this.getTSHelper("Property");
            propHelper.setMessageId(this.msgId);
            propHelper.setValidationType(this.validationType);
            for (int i = 0; i < arlist.size(); ++i) {
                AttributeList aList = null;
                Object ob = arlist.get(i);
                if (ob instanceof ObjectName) {
                    AttributeList attrList = this.getAttributeListFromON((ObjectName)ob);
                    on = (ObjectName)ob;
                    if (attrList != null) {
                        aList = attrList;
                    }
                } else if (ob instanceof AttributeList) {
                    aList = (AttributeList)ob;
                }
                warning = propHelper.validate(aList, on);
                if (warning) break;
            }
            propHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + warning);
        }
        return warning;
    }
}

