/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.compat;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.compat.StringEditor;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringPropertiesEditor
extends StringEditor {
    Properties theProperties = null;
    private static TraceComponent tc = Tr.register(StringPropertiesEditor.class, null, "com.ibm.ws.scripting.resources.wscpMessage");
    protected String nl = System.getProperty("line.separator");

    public String getAsText() {
        Tr.entry(tc, "getAsText");
        StringBuffer ret = new StringBuffer(1024);
        if (this.theProperties != null) {
            Enumeration<?> keys = this.theProperties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String val = this.theProperties.getProperty(key);
                if (val == null) continue;
                if (0 < ret.length() && '}' == ret.charAt(ret.length() - 1)) {
                    ret.append(this.nl);
                }
                ret.append("{");
                ret.append(key.equals("") || key.indexOf(32) > -1 ? "{" + key + "}" : key);
                ret.append(" ");
                ret.append(val.equals("") || val.indexOf(32) > -1 ? "{" + val + "}" : val);
                ret.append("}");
            }
        }
        Tr.exit(tc, "getAsText");
        return ret.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        Tr.entry(tc, "setAsText");
        this.theProperties = new Properties();
        StringTokenizer strtok = new StringTokenizer(text, "{} ", true);
        String next = null;
        String key = null;
        String value = null;
        try {
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken("{} \"");
                if (next.equals("{")) {
                    block9: {
                        try {
                            key = this.getString(strtok, " ");
                            value = this.getString(strtok, " ");
                        }
                        catch (IllegalArgumentException e) {
                            Tr.debug(tc, "Catch IllegalArgumentException");
                            if (key == null || e.getMessage().indexOf("UNEXPECTED_CLOSING") <= 0) break block9;
                            System.out.println("WSCP_EXC_UNEXPECTED_CLOSING_BRACE: Unexpected '}' found.  The key: \"" + key + "\" has no value specified that will not be set to property.");
                            continue;
                        }
                    }
                    while (strtok.hasMoreTokens() && (next = strtok.nextToken()).equals(" ")) {
                    }
                    if (!next.equals("}")) {
                        Tr.event(tc, "Expected '}' not found");
                        Object[] parms = new Object[]{};
                        String msg = "WSCP_EXC_CLOSING_BRACE " + parms + " Expected '}' not found";
                        throw new IllegalArgumentException(msg);
                    }
                    Tr.event(tc, "key=" + key + ", value=" + value);
                    if (value.startsWith("{") && !value.endsWith("}")) {
                        value = "{" + value + "}";
                        Tr.debug(tc, "value " + value);
                    }
                    this.theProperties.put(key, value);
                    continue;
                }
                if (next.equals(" ")) continue;
                Object[] parms = new Object[]{next};
                String msg = "WSCP_EXC_OPENING_BRACE '" + next + "' found instead of expected '{'";
                throw new IllegalArgumentException(msg);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange();
        Tr.exit(tc, "setAsText");
    }

    public void setValue(Object value) {
        Tr.entry(tc, "setValue");
        this.theProperties = (Properties)value;
        this.firePropertyChange();
        Tr.exit(tc, "setValue");
    }

    public Object getValue() {
        Tr.entry(tc, "getValue");
        Tr.exit(tc, "getValue");
        return this.theProperties;
    }

    public void setAsTextForJython(String text, boolean isBraceSupported) throws IllegalArgumentException {
        Tr.entry(tc, "setAsTextForJython");
        StringPropertiesEditor ed = new StringPropertiesEditor();
        this.theProperties = new Properties();
        if (text.indexOf("{") >= 0 && isBraceSupported) {
            this.setAsText(text);
        } else {
            StringTokenizer strtok = new StringTokenizer(text, "[] ", true);
            String next = null;
            String key = null;
            String value = null;
            try {
                while (strtok.hasMoreTokens() && !text.equals("[]")) {
                    next = strtok.nextToken("[] \"");
                    if (next.equals("[")) {
                        block10: {
                            try {
                                key = this.getStringForJython(strtok, " ");
                                value = this.getStringForJython(strtok, " ");
                            }
                            catch (IllegalArgumentException e) {
                                Tr.debug(tc, "Catch IllegalArgumentException");
                                if (key == null || e.getMessage().indexOf("UNEXPECTED_CLOSING") <= 0) break block10;
                                System.out.println("WSCP_EXC_UNEXPECTED_CLOSING_BRACE: Unexpected ']' found.  The key: \"" + key + "\" has no value specified that will not be set to property.");
                                continue;
                            }
                        }
                        while (strtok.hasMoreTokens() && (next = strtok.nextToken()).equals(" ")) {
                        }
                        if (!next.equals("]")) {
                            Tr.event(tc, "Expected ']' not found");
                            Object[] parms = new Object[]{};
                            String msg = "WSCP_EXC_CLOSING_BRACE " + parms + " Expected ']' not found";
                            throw new IllegalArgumentException(msg);
                        }
                        Tr.event(tc, "key=" + key + ", value=" + value);
                        this.theProperties.put(key, value);
                        continue;
                    }
                    if (next.equals(" ")) continue;
                    Object[] parms = new Object[]{next};
                    String msg = "WSCP_EXC_OPENING_BRACE '" + next + "' found instead of expected '['";
                    throw new IllegalArgumentException(msg);
                }
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException();
            }
        }
        this.firePropertyChange();
        Tr.exit(tc, "setAsTextForJython");
    }
}

