/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.bsf.BSFManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.CommonScriptingObject;
import com.ibm.ws.scripting.HelpSupport;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminClassLoader;
import com.ibm.ws.scripting.adminCommand.AdminCmdInterfaceGenerator;
import com.ibm.ws.scripting.adminCommand.AdminCmdProxyHandler;
import com.ibm.ws.scripting.adminCommand.AdminCmdScriptGenerator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Collection;

public class AdminCmdClient
extends CommonScriptingObject {
    private static AdminClassLoader cl = new AdminClassLoader(Thread.currentThread().getContextClassLoader());
    private static TraceComponent tc = Tr.register(AdminCmdClient.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    AdminCmdClient _self;
    BSFManager bsfMgr;
    CommandMgr cmdMgr;
    HelpSupport help;

    public AdminCmdClient(AbstractShell shell, HelpSupport help, BSFManager mgr) {
        super(shell, null);
        try {
            if (this._shell.getConnectionType().equals("NONE") || this._shell.getConnectionType().equals("NULL")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing local command mgr");
                }
                this.cmdMgr = CommandMgr.getCommandMgr();
            } else if (_client == null) {
                Tr.warning(tc, "WASX7198W", null);
            } else {
                this.cmdMgr = CommandMgr.getCommandMgr(_client);
            }
        }
        catch (Exception ex) {
            Tr.warning(tc, "WASX7198W", null);
        }
        this._self = this;
        this.help = help;
        this.bsfMgr = mgr;
    }

    public void setMgr(BSFManager mgr) {
        this.bsfMgr = mgr;
    }

    public void doReconnect() throws ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReconnect");
        }
        this.checkService();
        _client.isAlive();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReconnect");
        }
    }

    public void checkService() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkService");
        }
        if (_client == null) {
            this._shell.setAndThrowScriptingException("CONTROL_SERVICE_NOT_AVAILABLE", "AdminControl service not available", new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkService");
        }
    }

    public String help(String command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help", new Object[]{command});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return "Help text for: [" + command + "]";
    }

    public AdminCmdClient getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return this._self;
    }

    public void generateAdminCmds() throws ScriptingException, ConnectorException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateAdminCmds");
            }
            this._shell.setLastException(null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Generating admin command objects...");
            }
            try {
                if (this.cmdMgr == null) {
                    Tr.warning(tc, "WASX8011W");
                    System.out.println(this._shell.getFormattedMessage("WASX8011W", new Object[0], "AdminTask object is not available"));
                    break block9;
                }
                Collection cmdMetadata = this.cmdMgr.getAllCommandMetadata();
                AdminCmdInterfaceGenerator generator = new AdminCmdInterfaceGenerator(this);
                Tr.debug(tc, "cmdMetadata size " + cmdMetadata.size());
                try {
                    generator.generateClass(cmdMetadata);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                AdminCmdProxyHandler handler = new AdminCmdProxyHandler(this);
                Class<?> iClass = cl.loadClass(AdminCmdInterfaceGenerator.CLASS_NAME);
                Constructor<?> constructor = iClass.getDeclaredConstructor(AdminCmdProxyHandler.class);
                Object adminTask = constructor.newInstance(handler);
                this.bsfMgr.declareBean(AdminCmdScriptGenerator.CMD_FRAMEWORK_SCRIPTING_OBJECT, adminTask, iClass);
            }
            catch (Exception t) {
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                Tr.error(tc, t.toString() + nl + sw.toString());
                Tr.warning(tc, "WASX8011W");
                System.out.println(this._shell.getFormattedMessage("WASX8011W", new Object[0], "AdminTask object is not available"));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Finished generating dynamic AdminTask Object.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateAdminCmds");
        }
    }

    public static AdminClassLoader getClassLoader() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader - " + cl);
        }
        return cl;
    }

    public CommandMgr getCommandMgr() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMgr");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMgr - " + this.cmdMgr);
        }
        return this.cmdMgr;
    }

    public AbstractShell getShell() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getShell");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getShell - " + this._shell);
        }
        return this._shell;
    }
}

