/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.JaclUtilities;
import com.ibm.ws.scripting.JythonUtilities;
import com.ibm.ws.scripting.ScriptingException;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class StartServerCommand {
    private static TraceComponent tc = Tr.register(StartServerCommand.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String startAction = "launchProcess";
    private static final String syncAction = "sync";
    private static final String enableAttr = "serverStartupSyncEnabled";
    private AbstractShell _shell = null;
    private AdminClient _client = null;
    private ConfigService cfgService = null;
    private AdminConfigClient cfgClient = null;
    private AdminControlClient ctrlClient = null;
    private ConfigHelper cfgHelper = null;
    private ResourceBundle _bundle = null;
    private String serverName = null;
    private String nodeName = null;
    private String domain = null;
    private String processType = null;
    private boolean immediate = false;
    private Integer waittime = null;
    private boolean isOverload = false;

    public StartServerCommand(AdminClient client, AbstractShell shell, AdminControlClient control) throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StartServerCommand");
        }
        this._client = client;
        this._shell = shell;
        this.cfgService = AdminConfigClient.getConfigService();
        this.cfgClient = AdminConfigClient.getInstance();
        this.ctrlClient = control;
        this.cfgHelper = this.cfgClient.getConfigHelper();
        this._bundle = this._shell.getBundle();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StartServerCommand");
        }
    }

    public void setServerName(String sName) {
        this.serverName = sName;
    }

    public void setNodeName(String nName) {
        this.nodeName = nName;
        if (!(this.nodeName == null || this.nodeName.indexOf(" ") < 0 || this.nodeName.startsWith("\"") || this.nodeName.endsWith("\"") || this.nodeName.startsWith("{") || this.nodeName.endsWith("}"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding quotes to \"" + this.nodeName + "\"");
            }
            this.nodeName = "\"" + this.nodeName + "\"";
        }
    }

    public void setWaitTime(Integer time2) {
        this.waittime = time2;
    }

    public void setProcessType(String type) {
        this.processType = type;
    }

    public void setDomain(String dom) {
        this.domain = dom;
    }

    public void setIsOverload(boolean overload) {
        this.isOverload = overload;
    }

    public Object invoke() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer", new Object[]{this.serverName, this.nodeName, this.processType, this.waittime, this.domain});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isOverload: " + this.isOverload);
        }
        String ret = null;
        boolean status = false;
        try {
            String msg;
            String result;
            String servName;
            if ("UnManagedProcess".equals(this.processType) || "ManagedProcess".equals(this.processType) || this.processType.equals("unknown")) {
                this._shell.setAndThrowScriptingException("WASX7254E", "startServer action not supported when process type is " + this.processType, new Object[]{"startServer", this.processType});
            }
            if ("NodeAgent".equals(this.processType) || "AdminAgent".equals(this.processType)) {
                if (this.isOverload && !this.nodeName.equals(this.ctrlClient.getNode())) {
                    try {
                        this.waittime = Integer.valueOf(this.nodeName);
                        this.nodeName = null;
                    }
                    catch (NumberFormatException ex) {
                        this._shell.setAndThrowScriptingException("WASX7356E", "Unrecognized argument: {0}. The specified argument is neither a valid node nor a valid wait time when connected to {1}.", new Object[]{this.nodeName, this.processType});
                    }
                }
                if (this.nodeName == null || this.nodeName.trim().length() == 0 || this.nodeName != null && this.nodeName.equals(this.ctrlClient.getNode())) {
                    this.nodeName = this.ctrlClient.getNode();
                } else {
                    this._shell.setAndThrowScriptingException("WASX7343E", "startServer action not supported when specified node name {0} is not the same as the node (1) this client is currently connected to.", new Object[]{this.nodeName, this.ctrlClient.getNode()});
                }
            }
            if (this.nodeName == null || this.nodeName.trim().length() == 0) {
                this._shell.setAndThrowScriptingException("WASX7344E", "node name is required when the client is connected to process type {0}.", new Object[]{this.processType});
            }
            if (!"NodeAgent".equals(this.processType)) {
                String configId = null;
                boolean validServerName = false;
                if (this.cfgClient != null) {
                    ObjectName[] oList = this.cfgClient.internalList("Server", null, false);
                    for (int i = 0; i < oList.length; ++i) {
                        String displayName = oList[i].getKeyProperty("_Websphere_Config_Data_Display_Name");
                        String node = ConfigServiceHelper.getObjectLocation(oList[i]).getProperty("node");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "displayname " + displayName + "; serverName " + this.serverName + ";node " + node + ";nodename " + this.nodeName);
                        }
                        if (this.serverName.equals(displayName)) {
                            validServerName = true;
                        }
                        if (!this.serverName.equals(displayName) || node == null || !node.equals(this.nodeName)) continue;
                        configId = oList[i].getKeyProperty("_Websphere_Config_Data_Id");
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "server configId " + configId);
                        break;
                    }
                }
                if (configId == null) {
                    if (!validServerName) {
                        this._shell.setAndThrowScriptingException("WASX7255E", "Cannot find server " + this.serverName + " in configuration data", new Object[]{this.serverName});
                    } else {
                        this._shell.setAndThrowScriptingException("WASX7345E", "Cannot find node " + this.nodeName + " in configuration data", new Object[]{this.nodeName});
                    }
                }
            }
            if (!(servName = this.ctrlClient.completeObjectName(this.domain + ":node=" + this.nodeName + ",type=Server,process=" + this.serverName + ",*")).trim().equals("")) {
                this._shell.setAndThrowScriptingException("WASX7320E", "Server " + this.serverName + " on node " + this.nodeName + " is already running and cannot be started", new Object[]{this.serverName, this.nodeName});
            }
            if ("NodeAgent".equals(this.processType)) {
                String msg2 = this._shell.getFormattedMessage("WASX7305W", new Object[]{this.processType, this.serverName, this.nodeName}, "Client is connected to a server of type " + this.processType + ".  The server " + this.serverName + " will be started on node " + this.nodeName + " without attempting to synchronize the configuration.");
                System.out.println(msg2);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Connected to " + this.processType + ".  No sync attempted.");
                }
            }
            String naName = this.ctrlClient.completeObjectName(this.domain + ":node=" + this.nodeName + ",type=NodeAgent,*");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "About to invoke launchProcess for server " + this.serverName);
            }
            if (naName.trim().equals("")) {
                this._shell.setAndThrowScriptingException("WASX7257E", "Cannot locate NodeAgent object on node " + this.nodeName + ".  Unable to start server " + this.serverName + " on that node", new Object[]{this.nodeName, this.serverName});
            }
            String parms = null;
            String sName = this.serverName;
            if (!(this.serverName.indexOf(" ") < 0 || this.serverName.startsWith("\"") || this.serverName.endsWith("\"") || this.serverName.startsWith("{") || this.serverName.endsWith("}"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding quotes to \"" + this.serverName + "\"");
                }
                sName = "\"" + this.serverName + "\"";
            }
            parms = this.waittime == null ? sName : (this._shell.getLangUtils() instanceof JaclUtilities || this._shell.getLangUtils() instanceof JythonUtilities ? sName + " " + this.waittime.toString() : sName + "," + this.waittime.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parms: " + parms);
            }
            if ((result = this.ctrlClient.invoke(naName, startAction, parms)).equals("true")) {
                msg = this._shell.getFormattedMessage("WASX7262I", new Object[]{this.serverName, this.nodeName}, "Start completed for server " + this.serverName + " on node " + this.nodeName);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Start  OK for server " + this.serverName);
                }
            } else {
                msg = this._shell.getFormattedMessage("WASX7263W", new Object[]{this.serverName, this.nodeName}, "Start not completed for server " + this.serverName + " on node " + this.nodeName + ".  The server launching process may have timed out.");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Server start not complete; possibly timed out.");
                }
            }
            ret = msg;
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer - " + this.serverName);
        }
        return ret;
    }
}

