/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.CommonScriptingObject;
import com.ibm.ws.scripting.MessageLookup;
import com.ibm.ws.scripting.ScriptingException;
import java.util.Locale;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class HelpSupport
extends CommonScriptingObject {
    private static TraceComponent tc = Tr.register(HelpSupport.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final int MARGIN = 32;
    private static final int SHORTMARGIN = 12;
    private static final String ACTION = "ACTION";
    private static final String ACTIONINFO = "ACTION INFO";
    private static final String INFO = "INFO";
    private static final String UNKNOWN = "UNKNOWN";
    private String S_Attribute;
    private String S_Type;
    private String S_Access;
    private String S_none;
    private String S_RW;
    private String S_RO;
    private String S_WO;
    private String S_Operation;
    private String S_ReturnType;
    private String S_Impact;
    private String S_Signature;
    private String S_Notification;
    private String S_Constructor;
    private String S_Name;
    private String S_Description;
    private String S_ClassName;
    private String S_Parameters;
    private AdminControlClient controlClient = null;

    public HelpSupport(AbstractShell shell) throws ScriptingException {
        super(shell, null);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HelpSupport");
        }
        this.controlClient = AdminControlClient.getInstance();
        this.S_Attribute = this._shell.getFormattedMessage("HELP_STRING_ATTRIBUTE", null, "Attribute");
        this.S_Type = this._shell.getFormattedMessage("HELP_STRING_TYPE", null, "Type");
        this.S_Access = this._shell.getFormattedMessage("HELP_STRING_ACCESS", null, "Access");
        this.S_none = this._shell.getFormattedMessage("HELP_STRING_NONE", null, "none");
        this.S_RW = this._shell.getFormattedMessage("HELP_STRING_RW", null, "RW");
        this.S_RO = this._shell.getFormattedMessage("HELP_STRING_RO", null, "RO");
        this.S_WO = this._shell.getFormattedMessage("HELP_STRING_WO", null, "WO");
        this.S_Operation = this._shell.getFormattedMessage("HELP_STRING_OPERATION", null, "Operation");
        this.S_ReturnType = this._shell.getFormattedMessage("HELP_STRING_RETURNTYPE", null, "ReturnType");
        this.S_Impact = this._shell.getFormattedMessage("HELP_STRING_IMPACT", null, "Impact");
        this.S_Signature = this._shell.getFormattedMessage("HELP_STRING_SIGNATURE", null, "Signature");
        this.S_Notification = this._shell.getFormattedMessage("HELP_STRING_NOTIFICATIONS", null, "Notification");
        this.S_Constructor = this._shell.getFormattedMessage("HELP_STRING_CONSTRUCTORS", null, "Constructor signature");
        this.S_Name = this._shell.getFormattedMessage("HELP_STRING_NAME", null, "Name");
        this.S_Description = this._shell.getFormattedMessage("HELP_STRING_DESCRIPTION", null, "Description");
        this.S_ClassName = this._shell.getFormattedMessage("HELP_STRING_CLASSNAME", null, "Class name");
        this.S_Parameters = this._shell.getFormattedMessage("HELP_STRING_PARAMETERS", null, "Parameters");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HelpSupport");
        }
    }

    public void doReconnect() throws ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReconnect");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReconnect");
        }
    }

    public void checkService() throws ScriptingException {
        if (_client == null) {
            this._shell.setAndThrowScriptingException("CONTROL_NOT_AVAIL", "AdminControl service not available", new Object[0]);
        }
    }

    public String AdminControl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminControl");
        }
        String msg = this._shell.getFormattedMessage("ADMINCONTROL_GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminControl");
        }
        return msg;
    }

    public String AdminConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminConfig");
        }
        String msg = this._shell.getFormattedMessage("ADMINCONFIG_GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminConfig");
        }
        return msg;
    }

    public String AdminApp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminApp");
        }
        String msg = this._shell.getFormattedMessage("WASX7095I", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminApp");
        }
        return msg;
    }

    public String AdminTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminTask");
        }
        String msg = this._shell.getFormattedMessage("WASX8001I", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminTask");
        }
        return msg;
    }

    public String wsadmin() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wsadmin");
        }
        String msg = this._shell.getFormattedMessage("GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wsadmin");
        }
        return msg;
    }

    public String message() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "message");
        }
        String msg = this._shell.getFormattedMessage("HELP_HELP_MESSAGE", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "message");
        }
        return msg;
    }

    public String help() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        String msg = this._shell.getFormattedMessage("HELP_GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help" + msg);
        }
        return msg;
    }

    public String help(String method2) {
        String key;
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        if ((msg = this._shell.getFormattedMessage(key = "HELP_HELP_" + method2.toUpperCase(), new Object[0], "No help available for " + method2)).startsWith("No help available")) {
            key = "WASX7084E";
            msg = this._shell.getFormattedMessage(key, new Object[]{method2}, "No help available for " + method2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg;
    }

    public String attributes(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes");
        }
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.getInfo(name);
            MBeanAttributeInfo[] mbai = mbi.getAttributes();
            this.attributeInfo(buf, mbai, null, mbi);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes");
        }
        return buf.toString();
    }

    public String attributes(String name, String attrname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes");
        }
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.getInfo(name);
            MBeanAttributeInfo[] mbai = mbi.getAttributes();
            this.attributeInfo(buf, mbai, attrname, mbi);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes");
        }
        return buf.toString();
    }

    public String operations(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "operations");
        }
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.getInfo(name);
            MBeanOperationInfo[] mboi = mbi.getOperations();
            this.operationInfo(buf, mboi, mbi);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "operations");
        }
        return buf.toString();
    }

    public String operations(String name, String opname) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "operations");
        }
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.getInfo(name);
            MBeanOperationInfo[] mboi = mbi.getOperations();
            this.operationInfo(buf, mboi, opname, mbi);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "operations");
        }
        return buf.toString();
    }

    public String notifications(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifications");
        }
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.getInfo(name);
            MBeanNotificationInfo[] mbni = mbi.getNotifications();
            this.notificationInfo(buf, mbni);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifications");
        }
        return buf.toString();
    }

    public String constructors(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructors");
        }
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.getInfo(name);
            MBeanConstructorInfo[] mbci = mbi.getConstructors();
            this.constructorInfo(buf, mbci);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructors");
        }
        return buf.toString();
    }

    protected MBeanInfo getInfo(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInfo");
        }
        MBeanInfo result = null;
        this.checkService();
        ObjectName objName = this.controlClient.makeObjectName(name);
        result = this.controlClient.getMBeanInfo_jmx(objName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInfo");
        }
        return result;
    }

    public String description(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "description");
        }
        this.checkService();
        ObjectName objName = this.controlClient.makeObjectName(name);
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.controlClient.getMBeanInfo_jmx(objName);
            if (mbi != null) {
                buf.append(mbi.getDescription());
            } else {
                String msg = this._shell.getFormattedMessage("ADMIN_CONTROL_HELP_NOMBEANINFO", new Object[]{name}, "No MBean info available for  \"" + name + "\"");
                buf.append(msg);
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "description");
        }
        return buf.toString();
    }

    public String classname(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "classname");
        }
        this.checkService();
        ObjectName objName = this.controlClient.makeObjectName(name);
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.controlClient.getMBeanInfo_jmx(objName);
            if (mbi != null) {
                buf.append(mbi.getClassName());
            } else {
                String msg = this._shell.getFormattedMessage("ADMIN_CONTROL_HELP_NOMBEANINFO", new Object[]{name}, "No MBean info available for  \"" + name + "\"");
                buf.append(msg);
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "classname");
        }
        return buf.toString();
    }

    public String all(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "all");
        }
        this.checkService();
        ObjectName objName = this.controlClient.makeObjectName(name);
        StringBuffer buf = new StringBuffer();
        try {
            MBeanInfo mbi = this.controlClient.getMBeanInfo_jmx(objName);
            if (mbi != null) {
                MBeanAttributeInfo[] mbai = mbi.getAttributes();
                MBeanOperationInfo[] mboi = mbi.getOperations();
                MBeanNotificationInfo[] mbni = mbi.getNotifications();
                MBeanConstructorInfo[] mbci = mbi.getConstructors();
                String desc = mbi.getDescription();
                String classnm = mbi.getClassName();
                buf.append(this.S_Name + ": " + name + nl + "\t" + this.S_Description + ": " + desc + nl + "\t" + this.S_ClassName + ": " + classnm);
                buf.append(nl);
                buf.append(nl);
                this.attributeInfo(buf, mbai, null, mbi);
                buf.append(nl);
                this.operationInfo(buf, mboi, mbi);
                buf.append(nl);
                this.notificationInfo(buf, mbni);
                buf.append(nl);
                this.constructorInfo(buf, mbci);
            } else {
                String msg = this._shell.getFormattedMessage("ADMIN_CONTROL_HELP_NOMBEANINFO", new Object[]{name}, "No MBean info available for  \"" + name + "\"");
                buf.append(msg);
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "all");
        }
        return buf.toString();
    }

    public String message(String msgid) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "message " + msgid);
        }
        this._shell.setLastException(null);
        String msg = null;
        try {
            if (msgid != null || !msgid.trim().equals("")) {
                boolean initMessageDB = MessageLookup.initializeMessageDB(Locale.getDefault());
                if (!initMessageDB) {
                    this._shell.setAndThrowScriptingException("WASX7364E", "no help available", new Object[]{msgid});
                }
                if ((msg = MessageLookup.getMessages(this._shell, msgid)) == null || msg.trim().equals("")) {
                    this._shell.setAndThrowScriptingException("WASX7363E", "no help available", new Object[]{msgid});
                }
            } else {
                msg = this._shell.getFormattedMessage("HELP_HELP_MESSAGE", new Object[]{msgid}, "No message info available for  \"" + msgid + "\"");
            }
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "message");
        }
        return msg;
    }

    protected static void spaceit(StringBuffer buf, String name, int min) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "spaceit");
        }
        buf.append(name);
        int len = name.length();
        int margin = len <= min - 4 ? min : (len + 3) / 2 * 2;
        for (int k = 0; k < margin - len; ++k) {
            buf.append(" ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "spaceit");
        }
    }

    protected void attributeInfo(StringBuffer buf, MBeanAttributeInfo[] mbai, String attrname, MBeanInfo mbi) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeInfo");
        }
        HelpSupport.spaceit(buf, this.S_Attribute, 32);
        HelpSupport.spaceit(buf, this.S_Type, 32);
        buf.append(this.S_Access);
        String desc = null;
        String deprecated = null;
        for (int i = 0; i < mbai.length; ++i) {
            ModelMBeanAttributeInfo attrInfo = null;
            StringBuffer attrbuf = new StringBuffer();
            deprecated = null;
            String attrnm = mbai[i].getName();
            attrbuf.append(attrnm);
            try {
                if (mbi instanceof ModelMBeanInfo) {
                    ModelMBeanInfo mmInfo = (ModelMBeanInfo)((Object)mbi);
                    attrInfo = mmInfo.getAttribute(attrnm);
                }
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                throw new ScriptingException(ae.toString());
            }
            if (attrInfo != null) {
                deprecated = (String)attrInfo.getDescriptor().getFieldValue("deprecated");
            }
            String access = this.S_none;
            if (mbai[i].isWritable()) {
                access = mbai[i].isReadable() ? this.S_RW : this.S_WO;
            } else if (mbai[i].isReadable()) {
                access = this.S_RO;
            }
            if (attrname != null && !attrname.equals(attrnm)) continue;
            buf.append(nl);
            if (deprecated != null) {
                attrbuf.append("  <deprecated>");
            }
            HelpSupport.spaceit(buf, mbai[i].getName(), 32);
            HelpSupport.spaceit(buf, mbai[i].getType(), 32);
            buf.append(access);
            if (attrname == null) continue;
            desc = mbai[i].getDescription();
        }
        if (desc != null) {
            buf.append(nl);
            buf.append(nl);
            buf.append(this.S_Description + ": " + desc);
            if (deprecated != null) {
                buf.append(nl);
                buf.append("<deprecated> ");
                buf.append(deprecated);
            }
        }
        buf.append(nl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeInfo");
        }
    }

    protected void operationInfo(StringBuffer buf, MBeanOperationInfo[] mboi, MBeanInfo mbi) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "operationInfo");
        }
        buf.append(this.S_Operation);
        buf.append(nl);
        for (int i = 0; i < mboi.length; ++i) {
            ModelMBeanOperationInfo opInfo = null;
            String opname = mboi[i].getName();
            try {
                if (mbi instanceof ModelMBeanInfo) {
                    ModelMBeanInfo mmInfo = (ModelMBeanInfo)((Object)mbi);
                    opInfo = mmInfo.getOperation(opname);
                }
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                throw new ScriptingException(ae.toString());
            }
            String deprecated = null;
            if (opInfo != null) {
                deprecated = (String)opInfo.getDescriptor().getFieldValue("deprecated");
            }
            buf.append(mboi[i].getReturnType());
            buf.append(" ");
            buf.append(opname);
            buf.append("(");
            MBeanParameterInfo[] mbpi = mboi[i].getSignature();
            for (int j = 0; j < mbpi.length; ++j) {
                buf.append(mbpi[j].getType());
                if (j >= mbpi.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
            if (deprecated != null) {
                buf.append("  <deprecated>");
            }
            buf.append(nl);
        }
        buf.append(nl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "operationInfo");
        }
    }

    protected void operationInfo(StringBuffer buf, MBeanOperationInfo[] mboi, String opname, MBeanInfo mbi) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "operationInfo");
        }
        for (int i = 0; i < mboi.length; ++i) {
            int j;
            ModelMBeanOperationInfo opInfo = null;
            if (!opname.equals(mboi[i].getName())) continue;
            try {
                if (mbi instanceof ModelMBeanInfo) {
                    ModelMBeanInfo mmInfo = (ModelMBeanInfo)((Object)mbi);
                    opInfo = mmInfo.getOperation(opname);
                }
            }
            catch (Exception ae) {
                this._shell.setLastException(ae);
                throw new ScriptingException(ae.toString());
            }
            String deprecated = null;
            if (opInfo != null) {
                deprecated = (String)opInfo.getDescriptor().getFieldValue("deprecated");
            }
            buf.append(mboi[i].getReturnType());
            buf.append(" ");
            buf.append(opname);
            buf.append("(");
            MBeanParameterInfo[] mbpi = mboi[i].getSignature();
            for (j = 0; j < mbpi.length; ++j) {
                buf.append(mbpi[j].getType());
                if (j >= mbpi.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
            if (deprecated != null) {
                buf.append("  <deprecated>");
            }
            buf.append(nl);
            buf.append(nl);
            buf.append(this.S_Description + ": " + mboi[i].getDescription());
            if (deprecated != null) {
                buf.append(nl);
                buf.append("<deprecated> ");
                buf.append(deprecated);
            }
            buf.append(nl);
            buf.append(nl);
            buf.append(this.S_Parameters + ": ");
            buf.append(nl);
            buf.append(nl);
            for (j = 0; j < mbpi.length; ++j) {
                buf.append(this.S_Type + "  ");
                buf.append(mbpi[j].getType());
                buf.append(nl);
                buf.append(this.S_Name + "  ");
                buf.append(mbpi[j].getName());
                buf.append(nl);
                buf.append(this.S_Description + "  ");
                buf.append(mbpi[j].getDescription());
                buf.append(nl);
                buf.append(nl);
            }
            buf.append("-------------------------------------------------------");
            buf.append(nl);
            buf.append(nl);
        }
        buf.append(nl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "operationInfo");
        }
    }

    protected void notificationInfo(StringBuffer buf, MBeanNotificationInfo[] mbni) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notificationInfo");
        }
        buf.append(this.S_Notification);
        for (int i = 0; i < mbni.length; ++i) {
            buf.append(nl);
            String[] narray = mbni[i].getNotifTypes();
            for (int j = 0; j < narray.length; ++j) {
                buf.append(narray[j] + " ");
            }
        }
        buf.append(nl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notificationInfo");
        }
    }

    protected void constructorInfo(StringBuffer buf, MBeanConstructorInfo[] mbci) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructorInfo");
        }
        buf.append(this.S_Constructor);
        for (int i = 0; i < mbci.length; ++i) {
            buf.append(nl);
            MBeanParameterInfo[] mbpi = mbci[i].getSignature();
            buf.append("(");
            for (int j = 0; j < mbpi.length; ++j) {
                buf.append(mbpi[j].getName() + " " + mbpi[j].getType());
                if (j >= mbpi.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append(nl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructorInfo");
        }
    }

    public String attributes() throws ScriptingException {
        this.helpInfo("attributes");
        return new String();
    }

    public String operations() throws ScriptingException {
        this.helpInfo("operations");
        return new String();
    }

    public String notifications() throws ScriptingException {
        this.helpInfo("notifications");
        return new String();
    }

    public String constructors() throws ScriptingException {
        this.helpInfo("constructors");
        return new String();
    }

    public String description() throws ScriptingException {
        this.helpInfo("description");
        return new String();
    }

    public String classname() throws ScriptingException {
        this.helpInfo("classname");
        return new String();
    }

    public String all() throws ScriptingException {
        this.helpInfo("all");
        return new String();
    }
}

