/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.DownloadFile;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ObjectNameHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DefaultStringHandler
implements StringHandler {
    private static TraceComponent tc = Tr.register(DefaultStringHandler.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String DOMAIN = "WebSphere";
    protected AbstractShell _shell;
    protected LanguageUtilities _langutils;

    public DefaultStringHandler(LanguageUtilities langUtils) {
        this._langutils = langUtils;
        this._shell = null;
        this.init();
    }

    public DefaultStringHandler(AbstractShell shell) {
        this._shell = shell;
        this._langutils = this._shell.getLangUtils();
        this.init();
    }

    private void init() {
        HandlerRegistry.registerHandler(this, String.class);
        HandlerRegistry.registerHandler(this, Boolean.class);
        HandlerRegistry.registerHandler(this, Character.class);
        HandlerRegistry.registerHandler(this, Integer.class);
        HandlerRegistry.registerHandler(this, Long.class);
        HandlerRegistry.registerHandler(this, Byte.class);
        HandlerRegistry.registerHandler(this, Short.class);
        HandlerRegistry.registerHandler(this, Float.class);
        HandlerRegistry.registerHandler(this, Double.class);
        HandlerRegistry.registerHandler(this, Object.class);
        HandlerRegistry.registerHandler(this, URL.class);
        HandlerRegistry.registerHandler(this, ObjectName.class);
        HandlerRegistry.registerHandler(this, Properties.class);
        HandlerRegistry.registerHandler(this, Attribute.class);
        HandlerRegistry.registerHandler(this, AttributeList.class);
        HandlerRegistry.registerHandler(this, ArrayList.class);
        HandlerRegistry.registerHandler(this, List.class);
        HandlerRegistry.registerHandler(this, Hashtable.class);
        HandlerRegistry.registerHandler(this, Integer.TYPE);
        HandlerRegistry.registerHandler(this, Long.TYPE);
        HandlerRegistry.registerHandler(this, Boolean.TYPE);
        HandlerRegistry.registerHandler(this, Character.TYPE);
        HandlerRegistry.registerHandler(this, Byte.TYPE);
        HandlerRegistry.registerHandler(this, Short.TYPE);
        HandlerRegistry.registerHandler(this, Float.TYPE);
        HandlerRegistry.registerHandler(this, Double.TYPE);
        HandlerRegistry.registerHandler(this, String[].class);
        HandlerRegistry.registerHandler(this, Object[].class);
        HandlerRegistry.registerHandler(this, Integer[].class);
        HandlerRegistry.registerHandler(this, UploadFile.class);
        HandlerRegistry.registerHandler(this, DownloadFile.class);
    }

    public String formDisplayString(Object o, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString", new Object[]{o});
        }
        if (this._shell != null && this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String ret = new String();
        if (o != null) {
            if (o instanceof Properties) {
                ret = this._langutils.propertiesToString((Properties)o);
            } else if (o instanceof ObjectName) {
                String id = ((ObjectName)o).getKeyProperty("_Websphere_Config_Data_Id");
                ret = id != null ? ObjectNameHelper.getListingName((ObjectName)o) : o.toString();
            } else if (o.getClass().isArray()) {
                ret = this.formArrayDisplayString(o, lang);
            } else if (o instanceof AttributeList) {
                AttributeList alist = (AttributeList)o;
                for (int i = 0; i < alist.size(); ++i) {
                    String nm = ((Attribute)alist.get(i)).getName();
                    Object val = ((Attribute)alist.get(i)).getValue();
                    if (val != null) {
                        Class<?> cls = val.getClass();
                        StringHandler hand = HandlerRegistry.getHandler(cls);
                        if (hand == null) {
                            hand = this;
                        }
                        alist.set(i, new Attribute(nm, hand.formDisplayString(val, lang)));
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attribute name " + nm + " has no value");
                    }
                    alist.set(i, new Attribute(nm, new String()));
                }
                ret = this._langutils.attributeListToString(alist);
            } else {
                ret = o instanceof Attribute ? this.formAttributeDisplayString(o, lang) : (o instanceof Collection ? this.formCollectionDisplayString((Collection)o, lang) : o.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString - " + ret);
        }
        return ret;
    }

    public Object formValidObject(String subject, Class target, String lang) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formValidObject - ", new Object[]{subject, target.getName(), lang});
        }
        Object ret = null;
        if (this._shell != null && this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if (subject.equalsIgnoreCase("null")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created null");
            }
        } else if (target == String[].class) {
            ret = this._langutils.stringToStringArray(subject);
        } else if (target.isArray()) {
            ret = this._langutils.stringToObjectArray(subject, target);
        } else if (target == Integer.class || target == Integer.TYPE) {
            ret = new Integer(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Integer");
            }
        } else if (target == Long.class || target == Long.TYPE) {
            ret = new Long(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Long");
            }
        } else if (target == Boolean.class || target == Boolean.TYPE) {
            if (!subject.equalsIgnoreCase("true") && !subject.equalsIgnoreCase("false")) {
                String msg = ObjectNameHelper.getFormattedMessage("WASX7435W", "Value " + subject + " is converted to a boolean" + " value of false.", new Object[]{subject});
                System.out.println(msg);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
            }
            ret = new Boolean(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Boolean");
            }
        } else if (target == Character.class || target == Character.TYPE) {
            ret = new Character(subject.charAt(0));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Character");
            }
        } else if (target == Byte.class || target == Byte.TYPE) {
            ret = new Byte(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Byte");
            }
        } else if (target == Short.class || target == Short.TYPE) {
            ret = new Short(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Short");
            }
        } else if (target == Float.class || target == Float.TYPE) {
            ret = new Float(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Float");
            }
        } else if (target == Double.class || target == Double.TYPE) {
            ret = new Double(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Double");
            }
        } else if (target == Object.class) {
            ret = new String(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Object");
            }
        } else if (target == URL.class) {
            if (subject.trim().equals("")) {
                ret = null;
            } else {
                try {
                    ret = new URL(new String(subject));
                }
                catch (MalformedURLException mue) {
                    if (this._shell != null) {
                        this._shell.setAndThrowScriptingException("MALFORMED_URL", "String \"" + subject + "\" is malformed; cannot create URL", new Object[]{subject});
                    }
                    throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_URL", "String \"" + subject + "\" is malformed; cannot create URL", new Object[]{subject}));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created URL");
            }
        } else if (target == ObjectName.class) {
            try {
                ret = ObjectNameHelper.makeObjectName(subject);
            }
            catch (ScriptingException se) {
                if (this._shell != null) {
                    this._shell.setLastException(se);
                }
                throw se;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created ObjectName");
            }
        } else if (target == Properties.class) {
            if (subject == null || subject.trim().equals(this._langutils.getOpenNestedAttribute() + this._langutils.getCloseNestedAttribute())) {
                ret = new Properties();
            } else {
                String trial = null;
                if (subject.startsWith("{") && subject.endsWith("}") && (trial = subject.substring(1, subject.length() - 1).trim()).startsWith("{") && trial.endsWith("}")) {
                    subject = trial;
                }
                ret = this._langutils.stringToProperties(subject);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Properties");
            }
        } else if (target == Attribute.class) {
            ret = this._langutils.stringToAttribute(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "... created Attribute" + ret);
            }
        } else if (target == AttributeList.class) {
            ret = this._langutils.stringToAttributeList(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "... created AttributeList" + ret);
            }
        } else if (target == UploadFile.class) {
            ret = new UploadFile(subject);
        } else if (target == DownloadFile.class) {
            ret = new DownloadFile(subject);
        } else if (target == ArrayList.class) {
            ret = this._langutils.stringToArrayList(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "... created ArrayList" + ret);
            }
        } else if (target == List.class) {
            ret = this._langutils.stringToList(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "... created List" + ret);
            }
        } else if (target == Hashtable.class) {
            ret = this._langutils.stringToHashtable(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "... created Hashtable" + ret);
            }
        } else {
            ret = new String(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created String");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formValidObject");
        }
        return ret;
    }

    private String formArrayDisplayString(Object o, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formArrayDisplayString");
        }
        Object[] oarray = null;
        oarray = (Object[])o;
        Class<?> elementType = o.getClass().getComponentType();
        if (this._shell != null && this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "class of elements is " + (elementType == null ? "null" : elementType.getName()));
        }
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < oarray.length; ++i) {
            if (oarray[i] != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "input to formDisplayString - " + oarray[i].toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class:  - " + oarray[i].getClass().getName());
                }
                al.add(this.formDisplayString(oarray[i], lang));
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "oarray[" + i + "] is null ");
            }
            al.add(new String());
        }
        String ret = this._langutils.setToString(al, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formArrayDisplayString - " + ret);
        }
        return ret;
    }

    private String formCollectionDisplayString(Collection o, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCollectionDisplayString");
        }
        if (this._shell != null && this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        ArrayList<String> al = new ArrayList<String>();
        for (Object element : o) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "element", element);
            }
            if (element != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class:  - " + element.getClass().getName());
                }
                al.add(this.formDisplayString(element, lang));
                continue;
            }
            al.add(new String());
        }
        String ret = this._langutils.setToString(al, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCollectionDisplayString", ret);
        }
        return ret;
    }

    private String formAttributeDisplayString(Object o, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formAttributeDisplayString");
        }
        if (this._shell != null && this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "input to formDisplayString - " + o.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Class:  - " + ((Attribute)o).getName());
        }
        String name = ((Attribute)o).getName();
        Object value = ((Attribute)o).getValue();
        if (!(value instanceof String)) {
            map.put(name, this.formDisplayString(value, lang));
        } else {
            map.put(name, value);
        }
        String ret = this._langutils.hashtableToStringForAdminTask(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formAttributeDisplayString - " + ret);
        }
        return ret;
    }
}

