/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.CommonScriptingObject;
import com.ibm.ws.scripting.DefaultStringHandler;
import com.ibm.ws.scripting.ExtensionHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.StartServerCommand;
import com.ibm.ws.scripting.StopServerCommand;
import com.ibm.ws.scripting.TestConnectionCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class AdminControlClient
extends CommonScriptingObject {
    private static TraceComponent tc = Tr.register(AdminControlClient.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static AdminControlClient _self = null;
    private StringHandler defaultHandler = null;
    public static String PRIVATE_KEY = "private";
    public static String PUBLIC_KEY = "public";
    public static String SHARED_KEY = "shared";
    private final String waitObject = "waitObject";
    private Vector waitTarget = null;
    private boolean isProcessMonitored = true;
    private String notification = null;

    public static AdminControlClient getInstance() {
        return _self;
    }

    public AdminControlClient(AbstractShell shell, Properties connProps) {
        super(shell, connProps);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminControlClient");
        }
        if (_client == null) {
            Tr.warning(tc, "CONTROL_SERVICE_NOT_AVAILABLE", null);
        }
        _self = this;
        this.defaultHandler = new DefaultStringHandler(this._shell);
        ExtensionHelper.processRegisterHandlersInExtensions();
        if (connectedServer != null) {
            String conntype = _client.getType();
            String node = ObjectNameHelper.getNodeName(connectedServer);
            String processName = ObjectNameHelper.getProcessName(connectedServer);
            String msg = this._shell.getFormattedMessage("WASX7209I", new Object[]{processName, node, conntype, processType}, "Connected to process \"" + processName + "\" on node " + node + " using " + conntype + " connector;  The type of process is: " + processType);
            System.out.println(msg);
        } else {
            String trFile = ManagerAdmin.getTraceFileName();
            String fn = null;
            if (trFile != null) {
                File traceFile = new File(ManagerAdmin.getTraceFileName());
                fn = traceFile.getAbsolutePath();
            } else {
                fn = "<stdout>";
            }
            String msg = this._shell.getFormattedMessage("WASX7213I", new Object[]{fn}, "Not connected to server.");
            if (connProps != null) {
                System.out.println(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminControlClient");
        }
    }

    public AdminClient getAdminClient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient", new Object[]{_client});
        }
        return _client;
    }

    public void checkService() throws ScriptingException {
        if (_client == null) {
            this._shell.setAndThrowScriptingException("CONTROL_NOT_AVAIL", "AdminControl service not available", new Object[0]);
        }
    }

    public String getType() throws ScriptingException {
        this._shell.setLastException(null);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
        }
        this.checkService();
        String ret = _client.getType();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType");
        }
        return ret;
    }

    public String getHost() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHost");
        }
        this._shell.setLastException(null);
        this.checkService();
        Properties props = _client.getConnectorProperties();
        String ret = props.getProperty("host");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHost");
        }
        return ret;
    }

    public String getNode() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNode");
        }
        this._shell.setLastException(null);
        this.checkService();
        String node = ObjectNameHelper.getNodeName(connectedServer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNode");
        }
        return node;
    }

    public String getCell() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCell");
        }
        this._shell.setLastException(null);
        this.checkService();
        String cell = ObjectNameHelper.getCellName(connectedServer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCell");
        }
        return cell;
    }

    public String getPort() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPort");
        }
        this.checkService();
        Properties props = _client.getConnectorProperties();
        String ret = props.getProperty("port");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPort");
        }
        return ret;
    }

    public String getProcessName() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessName");
        }
        this.checkService();
        String processName = ObjectNameHelper.getProcessName(connectedServer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessName");
        }
        return processName;
    }

    public String reconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this._shell.manageReconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
        return new String();
    }

    public void doReconnect() throws ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReconnect");
        }
        this.checkService();
        _client.isAlive();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReconnect");
        }
    }

    public Session isAlive() throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        Session ret = null;
        try {
            ret = _client.isAlive();
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        return ret;
    }

    public Set queryNames_jmx(ObjectName name, QueryExp query) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames_jmx - ", new Object[]{name, query});
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            return _client.queryNames(name, query);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
    }

    public Set queryMBeans(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBeans");
        }
        this._shell.setLastException(null);
        Set result = null;
        ObjectName objName = this.makeObjectName(name);
        result = this.queryMBeans(objName, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans");
        }
        return result;
    }

    public Set queryMBeans(String name, QueryExp query) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBeans - ", new Object[]{name, query});
        }
        this._shell.setLastException(null);
        Set result = null;
        ObjectName objName = this.makeObjectName(name);
        result = this.queryMBeans(objName, query);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans");
        }
        return result;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBeans - ", new Object[]{name, query});
        }
        this._shell.setLastException(null);
        this.checkService();
        Set result = null;
        try {
            result = _client.queryMBeans(name, query);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans");
        }
        return result;
    }

    public ObjectInstance getObjectInstance(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance");
        }
        this._shell.setLastException(null);
        ObjectInstance tempON = null;
        ObjectName objName = this.makeObjectName(name);
        tempON = this.getObjectInstance(objName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance");
        }
        return tempON;
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance");
        }
        this._shell.setLastException(null);
        this.checkService();
        ObjectInstance tempON = null;
        try {
            tempON = _client.getObjectInstance(name);
        }
        catch (InstanceNotFoundException infe) {
            this._shell.setLastException(infe);
            throw new ScriptingException(infe.getCause(), infe.toString());
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance");
        }
        return tempON;
    }

    public Integer getMBeanCount() throws ScriptingException {
        Integer ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanCount");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            ret = _client.getMBeanCount();
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanCount");
        }
        return ret;
    }

    public String getDomainName() throws ScriptingException {
        String ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainName");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            ret = _client.getDomainName();
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainName");
        }
        return ret;
    }

    public String getDefaultDomain() throws ScriptingException {
        String ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDomain");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            ret = _client.getDefaultDomain();
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDomain");
        }
        return ret;
    }

    public MBeanInfo getMBeanInfo_jmx(ObjectName name) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        MBeanInfo ret = null;
        try {
            ret = _client.getMBeanInfo(name);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        return ret;
    }

    public boolean isInstanceOf_jmx(ObjectName name, String className) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        boolean ret = false;
        try {
            ret = _client.isInstanceOf(name, className);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        return ret;
    }

    public boolean isRegistered_jmx(ObjectName name) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        boolean ret = false;
        try {
            ret = _client.isRegistered(name);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        return ret;
    }

    public Object getAttribute_jmx(ObjectName name, String attribute) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        Object ret = null;
        try {
            ret = _client.getAttribute(name, attribute);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        return ret;
    }

    public AttributeList getAttributes_jmx(ObjectName name, String[] attributes) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        AttributeList ret = null;
        try {
            ret = _client.getAttributes(name, attributes);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        return ret;
    }

    public String setAttribute_jmx(ObjectName name, Attribute attribute) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        try {
            _client.setAttribute(name, attribute);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        return new String();
    }

    public AttributeList setAttributes_jmx(ObjectName name, AttributeList attributes) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        try {
            return _client.setAttributes(name, attributes);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
    }

    public Object invoke_jmx(ObjectName name, String operationName, Object[] params, String[] signature) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        try {
            return _client.invoke(name, operationName, params, signature);
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
    }

    public ObjectName makeObjectName(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeObjectName");
        }
        this._shell.setLastException(null);
        ObjectName tempON = null;
        try {
            if (name == null || name.trim().equals("")) {
                throw new MalformedObjectNameException();
            }
            if (name.startsWith("\"") && name.endsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            if (name != null && name.indexOf(":") < 0) {
                name = "WebSphere:" + name;
            }
            tempON = new ObjectName(name);
        }
        catch (MalformedObjectNameException mone) {
            this._shell.setAndThrowScriptingException("MALFORMED_OBJECT_NAME", "String \"" + name + "\" is malformed; cannot create ObjectName", new Object[]{name});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeObjectName");
        }
        return tempON;
    }

    public String completeObjectName(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeObjectName - " + name);
        }
        this._shell.setLastException(null);
        Object[] result = null;
        try {
            ObjectName objName = this.makeObjectName(name);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objName - " + objName);
            }
            Set candidates = null;
            candidates = this.queryNames_jmx(objName, null);
            if (candidates == null || candidates.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeObjectName - null");
                }
                return new String();
            }
            if (candidates.size() > 1) {
                String msg = this._shell.getFormattedMessage("WARNING_MULTIPLE_MATCHES", new Object[]{name, new Integer(candidates.size())}, "String \"" + name + "\" corresponds to " + candidates.size() + " MBeans; returning first one");
                System.out.println(msg);
            }
            result = candidates.toArray();
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeObjectName");
        }
        return ((ObjectName)result[0]).toString();
    }

    public String queryNames(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        Set result = null;
        String retVal = null;
        ObjectName objName = this.makeObjectName(name);
        result = this.queryNames_jmx(objName, null);
        retVal = this._langutils.setToString(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames");
        }
        return retVal;
    }

    public boolean isInstanceOf(String name, String className) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInstanceOf");
        }
        this._shell.setLastException(null);
        boolean result = false;
        ObjectName objName = this.makeObjectName(name);
        result = this.isInstanceOf_jmx(objName, className);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInstanceOf returns " + result);
        }
        return result;
    }

    public boolean isRegistered(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered");
        }
        this._shell.setLastException(null);
        boolean result = false;
        ObjectName objName = this.makeObjectName(name);
        result = this.isRegistered_jmx(objName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered returns " + result);
        }
        return result;
    }

    public String getAttribute(String name, String attribute) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute");
        }
        this._shell.setLastException(null);
        Object result = null;
        String ret = new String();
        try {
            ObjectName objName = this.makeObjectName(name);
            result = this.getAttribute_jmx(objName, attribute);
            if (result != null) {
                Class<?> cls = result.getClass();
                StringHandler hand = HandlerRegistry.getHandler(cls);
                if (hand == null) {
                    hand = this.defaultHandler;
                }
                ret = this.formDisplayString(result);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute");
        }
        return ret;
    }

    public String getAttributes(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes");
        }
        this._shell.setLastException(null);
        String output = this.getAttributes(name, (String)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return output;
    }

    public String getAttributes(String name, Object[] attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String ret = this.getAttributes(name, attrString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return ret;
    }

    public String getAttributes(String name, String attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        ObjectName objName = this.makeObjectName(name);
        String output = null;
        try {
            String[] sarray = null;
            sarray = attributes == null || attributes.length() == 0 ? this.attributes(objName) : this._langutils.stringToStringArray(attributes);
            AttributeList alist = this.getAttributes_jmx(objName, sarray);
            for (int i = 0; i < alist.size(); ++i) {
                String nm = ((Attribute)alist.get(i)).getName();
                Object o = ((Attribute)alist.get(i)).getValue();
                if (o != null) {
                    Class<?> cls = o.getClass();
                    StringHandler hand = HandlerRegistry.getHandler(cls);
                    if (hand == null) {
                        hand = this.defaultHandler;
                    }
                    alist.set(i, new Attribute(nm, this.formDisplayString(o)));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attribute name " + nm + " has no value");
                }
                alist.set(i, new Attribute(nm, new String()));
            }
            output = this._langutils.attributeListToString(alist);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return output;
    }

    public String setAttribute(String name, String attributeName, String attributeValue) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttribute");
        }
        this._shell.setLastException(null);
        ObjectName objName = this.makeObjectName(name);
        try {
            Object o = this.getAttribute_jmx(objName, attributeName);
            Attribute att = null;
            Class<Object> cls = null;
            if (o != null) {
                cls = o.getClass();
            } else {
                String classname = this.attributeType(objName, attributeName);
                try {
                    cls = classname.equals("int") ? Integer.TYPE : (classname.equals("boolean") ? Boolean.TYPE : (classname.equals("char") ? Character.TYPE : (classname.equals("byte") ? Byte.TYPE : (classname.equals("short") ? Short.TYPE : (classname.equals("long") ? Long.TYPE : (classname.equals("float") ? Float.TYPE : (classname.equals("double") ? Double.TYPE : Class.forName(classname))))))));
                }
                catch (ClassNotFoundException cnfe) {
                    String msg = this._shell.getFormattedMessage("WASX7237W", new Object[]{attributeName, classname}, "Type " + classname + " for attribute " + attributeName + " is not supported.");
                    System.out.println(msg);
                    cls = String.class;
                }
            }
            StringHandler hand = HandlerRegistry.getHandler(cls);
            if (hand == null) {
                hand = this.defaultHandler;
            }
            Object value = null;
            value = hand.formValidObject(attributeValue, cls, this._shell.getLang());
            att = new Attribute(attributeName, value);
            this.setAttribute_jmx(objName, att);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
        return new String();
    }

    public String setAttributes(String name, Object[] attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String attrString = this._langutils.objectArrayToString(attributes);
        String ret = this.setAttributes(name, attrString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
        return ret;
    }

    public String setAttributes(String name, String attributes) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        ObjectName objName = this.makeObjectName(name);
        String retstring = null;
        try {
            attributes = this._langutils.cleanAttributeString(attributes);
            AttributeList alist = this._langutils.stringToAttributeList(attributes);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < alist.size(); ++i) {
                String nm = ((Attribute)alist.get(i)).getName();
                buf.append(nm);
                buf.append(" ");
            }
            String[] sarray = this._langutils.stringToStringArray(buf.toString());
            AttributeList currentlist = this.getAttributes_jmx(objName, sarray);
            for (int i = 0; i < alist.size(); ++i) {
                String nm = ((Attribute)alist.get(i)).getName();
                boolean found = false;
                Object value = null;
                Class<?> cls = null;
                for (int j = 0; j < currentlist.size(); ++j) {
                    if (!nm.equals(((Attribute)currentlist.get(j)).getName())) continue;
                    cls = ((Attribute)currentlist.get(j)).getValue().getClass();
                    found = true;
                    break;
                }
                if (!found) continue;
                StringHandler hand = HandlerRegistry.getHandler(cls);
                if (hand == null) {
                    hand = this.defaultHandler;
                }
                value = hand.formValidObject((String)((Attribute)alist.get(i)).getValue(), cls, this._shell.getLang());
                alist.set(i, new Attribute(nm, value));
            }
            AttributeList retlist = this.setAttributes_jmx(objName, alist);
            retstring = this._langutils.attributeListToString(retlist);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
        return retstring;
    }

    public String invoke(String name, String operationName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        this._shell.setLastException(null);
        String parms = new String();
        String ret = this.invoke(name, operationName, parms);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return ret;
    }

    public String invoke(String name, String operationName, String params) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        this._shell.setLastException(null);
        String ret = this.invoke(name, operationName, params, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return ret;
    }

    public String invoke(String name, String operationName, Object[] params) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke with object array parameter");
        }
        this._shell.setLastException(null);
        String paramString = this._langutils.objectArrayToString(params);
        String ret = this.invoke(name, operationName, paramString, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke with object array parameter");
        }
        return ret;
    }

    public String invoke(String name, String operationName, String params, String sigs) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        this._shell.setLastException(null);
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        ObjectName objName = this.makeObjectName(name);
        String ret = new String();
        try {
            ArrayList allSigs = null;
            String[] sarray = this._langutils.stringToStringArray(params);
            String[] signatures = null;
            boolean userSuppliedSignatures = true;
            if (sigs == null) {
                userSuppliedSignatures = false;
                allSigs = this.signature(objName, operationName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "size of sig array: " + allSigs.size());
                }
                if (allSigs.size() == 0) {
                    signatures = new String[sarray.length];
                    for (int i = 0; i < sarray.length; ++i) {
                        signatures[i] = "java.lang.String";
                    }
                }
            } else {
                signatures = this._langutils.stringToStringArray(sigs);
            }
            boolean found = false;
            StringBuffer buf = new StringBuffer();
            if (signatures == null) {
                for (int i = 0; i < allSigs.size(); ++i) {
                    signatures = (String[])allSigs.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "length of this sig " + signatures.length);
                    }
                    buf.append(Integer.toString(signatures.length));
                    if (i < allSigs.size() - 1) {
                        buf.append(", ");
                    }
                    if (signatures.length != sarray.length) continue;
                    found = true;
                    break;
                }
            } else {
                found = true;
            }
            if (!found) {
                if (!userSuppliedSignatures) {
                    this._shell.setAndThrowScriptingException("WASX7139E", "Operation \"" + operationName + "\" requires " + buf.toString() + " parameters, but " + sarray.length + " were supplied: " + params, new Object[]{operationName, buf.toString(), new Integer(sarray.length), params});
                } else {
                    this._shell.setAndThrowScriptingException("WASX7140E", "Length mismatch: " + sarray.length + " parameters were specified, but " + signatures.length + " signatures were supplied. The same number must be specified for both.", new Object[]{new Integer(sarray.length), new Integer(signatures.length)});
                }
            }
            Object[] parmArray = new Object[sarray.length];
            for (int i = 0; i < sarray.length; ++i) {
                Class<Object> cls = null;
                StringHandler hand = null;
                try {
                    cls = signatures[i].equals("int") ? Integer.TYPE : (signatures[i].equals("boolean") ? Boolean.TYPE : (signatures[i].equals("char") ? Character.TYPE : (signatures[i].equals("byte") ? Byte.TYPE : (signatures[i].equals("short") ? Short.TYPE : (signatures[i].equals("long") ? Long.TYPE : (signatures[i].equals("float") ? Float.TYPE : (signatures[i].equals("double") ? Double.TYPE : Class.forName(signatures[i]))))))));
                    hand = HandlerRegistry.getHandler(cls);
                }
                catch (ClassNotFoundException cnfe) {
                    Tr.warning(tc, "Caught ClassNotFoundException for " + signatures[i] + "; using String");
                    cls = String.class;
                }
                if (hand == null) {
                    hand = this.defaultHandler;
                }
                parmArray[i] = hand.formValidObject(sarray[i], cls, this._shell.getLang());
            }
            Object o = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to invoke " + operationName + " on " + objName.toString());
                for (int i = 0; i < parmArray.length; ++i) {
                    String parm = null;
                    if (parmArray[i] != null && ((parm = parmArray[i].toString()).toLowerCase().lastIndexOf("password") >= 0 || parm.equals(PRIVATE_KEY) || parm.equals(PUBLIC_KEY) || parm.equals(SHARED_KEY))) {
                        parm = "*****";
                    }
                    Tr.debug(tc, "parm " + i + ": " + parm);
                    if (parmArray[i] != null) {
                        Tr.debug(tc, "type of parm " + i + ": " + parmArray[i].getClass().getName());
                    }
                    Tr.debug(tc, "Signature element " + i + ": " + signatures[i]);
                }
            }
            o = this.invoke_jmx(objName, operationName, parmArray, signatures);
            ret = this.formDisplayString(o, false);
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return ret;
    }

    public String invoke(String name, String operationName, Object[] params, Object[] sigs) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke using object array");
        }
        this._shell.setLastException(null);
        String paramString = this._langutils.objectArrayToString(params);
        String sigString = this._langutils.objectArrayToString(sigs);
        String ret = this.invoke(name, operationName, paramString, sigString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke using object array");
        }
        return ret;
    }

    protected String formDisplayString(Object o) throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString");
        }
        String ret = this.formDisplayString(o, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString");
        }
        return ret;
    }

    protected String formDisplayString(Object o, boolean sort) throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString");
        }
        String ret = new String();
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if (o != null) {
            Class<?> cls = o.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "class of return object is " + cls.getName());
            }
            Object[] oarray = null;
            if (o instanceof Collection) {
                oarray = ((Collection)o).toArray();
                for (int j = 0; j < oarray.length; ++j) {
                    if (oarray[j] != null) continue;
                    oarray[j] = "Null returned from server";
                }
            } else if (cls.isArray()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return object is an array");
                }
                oarray = (Object[])o;
            }
            if (oarray != null) {
                StringHandler hand;
                Class<?> elementType = oarray.getClass().getComponentType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "class of elements is " + (elementType == null ? "null" : elementType.getName()));
                }
                if ((hand = HandlerRegistry.getHandler(elementType)) == null) {
                    hand = this.defaultHandler;
                }
                ArrayList<String> al = new ArrayList<String>();
                for (int i = 0; i < oarray.length; ++i) {
                    if (oarray[i] != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "input to formDisplayString - " + oarray[i].toString());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Class:  - " + oarray[i].getClass().getName());
                        }
                        al.add(hand.formDisplayString(oarray[i], this._shell.getLang()));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "oarray[" + i + "] is null ");
                }
                ret = this._langutils.setToString(al, sort);
            } else {
                StringHandler hand = HandlerRegistry.getHandler(cls);
                if (hand == null) {
                    hand = this.defaultHandler;
                }
                ret = hand.formDisplayString(o, this._shell.getLang());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString");
        }
        return ret;
    }

    public String help() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        String msg = this._shell.getFormattedMessage("ADMINCONTROL_GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg;
    }

    public String help(String method2) {
        String key;
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        if ((msg = this._shell.getFormattedMessage(key = "ADMINCONTROL_HELP_" + method2.toUpperCase(), new Object[0], "No help available for " + method2)).startsWith("No help available")) {
            key = "WASX7084E";
            msg = this._shell.getFormattedMessage(key, new Object[]{method2}, "No help available for " + method2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg;
    }

    public String queryNames() throws ScriptingException {
        this.helpInfo("queryNames");
        return new String();
    }

    public String queryNames_jmx() throws ScriptingException {
        this.helpInfo("queryNames_jmx");
        return new String();
    }

    public String queryMBeans() throws ScriptingException {
        this.helpInfo("queryMBeans");
        return new String();
    }

    public String getObjectInstance() throws ScriptingException {
        this.helpInfo("getObjectInstance");
        return new String();
    }

    public String getMBeanInfo_jmx() throws ScriptingException {
        this.helpInfo("getMBeanInfo_jmx");
        return new String();
    }

    public String isInstanceOf() throws ScriptingException {
        this.helpInfo("isInstanceOf");
        return new String();
    }

    public String isInstanceOf_jmx() throws ScriptingException {
        this.helpInfo("isInstanceOf_jmx");
        return new String();
    }

    public String isRegistered() throws ScriptingException {
        this.helpInfo("isRegistered");
        return new String();
    }

    public String isRegistered_jmx() throws ScriptingException {
        this.helpInfo("isRegistered_jmx");
        return new String();
    }

    public String getAttribute() throws ScriptingException {
        this.helpInfo("getAttribute");
        return new String();
    }

    public String getAttribute(Object x) throws ScriptingException {
        this.helpInfo("getAttribute");
        return new String();
    }

    public String getAttribute_jmx() throws ScriptingException {
        this.helpInfo("getAttribute_jmx");
        return new String();
    }

    public String getAttribute_jmx(Object x) throws ScriptingException {
        this.helpInfo("getAttribute_jmx");
        return new String();
    }

    public String getAttributes() throws ScriptingException {
        this.helpInfo("getAttributes");
        return new String();
    }

    public String getAttributes_jmx() throws ScriptingException {
        this.helpInfo("getAttributes_jmx");
        return new String();
    }

    public String getAttributes_jmx(Object x) throws ScriptingException {
        this.helpInfo("getAttributes_jmx");
        return new String();
    }

    public String setAttribute() throws ScriptingException {
        this.helpInfo("setAttribute");
        return new String();
    }

    public String setAttribute(Object x) throws ScriptingException {
        this.helpInfo("setAttribute");
        return new String();
    }

    public String setAttribute(Object x, Object y) throws ScriptingException {
        this.helpInfo("setAttribute");
        return new String();
    }

    public String setAttribute_jmx() throws ScriptingException {
        this.helpInfo("setAttribute_jmx");
        return new String();
    }

    public String setAttribute_jmx(Object x) throws ScriptingException {
        this.helpInfo("setAttribute_jmx");
        return new String();
    }

    public String setAttributes() throws ScriptingException {
        this.helpInfo("setAttributes");
        return new String();
    }

    public String setAttributes(Object x) throws ScriptingException {
        this.helpInfo("setAttributes");
        return new String();
    }

    public String setAttributes_jmx() throws ScriptingException {
        this.helpInfo("setAttributes_jmx");
        return new String();
    }

    public String setAttributes_jmx(Object x) throws ScriptingException {
        this.helpInfo("setAttributes_jmx");
        return new String();
    }

    public String invoke() throws ScriptingException {
        this.helpInfo("invoke");
        return new String();
    }

    public String invoke(Object x) throws ScriptingException {
        this.helpInfo("invoke");
        return new String();
    }

    public String invoke_jmx() throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String invoke_jmx(Object x) throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String invoke_jmx(Object x, Object y) throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String invoke_jmx(Object x, Object y, Object z) throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String trace() throws ScriptingException {
        this.helpInfo("trace");
        return new String();
    }

    public String makeObjectName() throws ScriptingException {
        this.helpInfo("makeObjectName");
        return new String();
    }

    public String completeObjectName() throws ScriptingException {
        this.helpInfo("completeObjectName");
        return new String();
    }

    public String testConnection() throws ScriptingException {
        this.helpInfo("testConnection");
        return new String();
    }

    public String stopServer() throws ScriptingException {
        this.helpInfo("stopServer");
        return new String();
    }

    public String startServer() throws ScriptingException {
        this.helpInfo("startServer");
        return new String();
    }

    public String getConfigId() throws ScriptingException {
        this.helpInfo("getConfigId");
        return new String();
    }

    public String getConfigId(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigId - " + name);
        }
        this._shell.setLastException(null);
        String result = new String();
        String objName = null;
        try {
            String mbeanId;
            AdminConfigClient config = AdminConfigClient.getInstance();
            config.checkService();
            objName = this.completeObjectName(name);
            if (objName == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeObjectName - null");
                }
                return new String();
            }
            ObjectName on = null;
            StringBuffer buf = new StringBuffer();
            on = new ObjectName(objName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObjectName: " + on.toString());
            }
            if ((mbeanId = on.getKeyProperty("mbeanIdentifier")) != null) {
                int slash = mbeanId.lastIndexOf(47);
                if (slash >= 0 && mbeanId.substring(slash, mbeanId.length()).indexOf(".xml") >= 0) {
                    buf.append(mbeanId.substring(0, slash));
                    buf.append('|');
                    buf.append(mbeanId.substring(slash + 1));
                } else {
                    buf.append(mbeanId);
                }
                result = config.internalGetID(buf.toString());
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (MalformedObjectNameException mone) {
            this._shell.setAndThrowScriptingException("MALFORMED_OBJECT_NAME", "String \"" + objName + "\" is malformed; cannot create ObjectName", new Object[]{objName});
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigId");
        }
        return result;
    }

    public String startServer(String serverName) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer - " + serverName);
        }
        this._shell.setLastException(null);
        String ret = this.startServer(serverName, null, "0", false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer - " + serverName);
        }
        return ret;
    }

    public String startServer(String serverName, String nodeOrWaittime) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer", new Object[]{serverName, nodeOrWaittime});
        }
        this._shell.setLastException(null);
        String ret = this.startServer(serverName, nodeOrWaittime, "0", true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return ret;
    }

    public String startServer(String serverName, int waittime) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer - " + serverName + " " + waittime);
        }
        this._shell.setLastException(null);
        String ret = this.startServer(serverName, "", Integer.toString(waittime), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return ret;
    }

    public String startServer(String serverName, String nodeName, String waittime) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer", new Object[]{serverName, nodeName, waittime});
        }
        this._shell.setLastException(null);
        String ret = this.startServer(serverName, nodeName, waittime, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return ret;
    }

    public String startServer(String serverName, String nodeName, int waittime) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer - " + serverName + " " + nodeName + " " + waittime);
        }
        this._shell.setLastException(null);
        String ret = this.startServer(serverName, nodeName, Integer.toString(waittime), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return ret;
    }

    protected String startServer(String serverName, String nodeName, String waittime, boolean overload) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName - " + serverName + " " + nodeName + " " + waittime + " " + overload);
        }
        this._shell.setLastException(null);
        String ret = null;
        try {
            StartServerCommand cmd = new StartServerCommand(_client, this._shell, this);
            cmd.setServerName(serverName);
            cmd.setNodeName(nodeName);
            cmd.setWaitTime(Integer.valueOf(waittime));
            cmd.setIsOverload(overload);
            cmd.setDomain("WebSphere");
            cmd.setProcessType(processType);
            ret = (String)cmd.invoke();
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return ret;
    }

    public String stopServer(String serverName) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName - " + serverName);
        }
        this._shell.setLastException(null);
        String ret = this.stopServer(serverName, null, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer - " + serverName);
        }
        return ret;
    }

    public String stopServer(String serverName, String nodeOrAction) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName - ", new Object[]{serverName, nodeOrAction});
        }
        this._shell.setLastException(null);
        if (nodeOrAction.equalsIgnoreCase("terminate") && !"AdminAgent".equals(processType)) {
            this._shell.setAndThrowScriptingException("WASX7442E", "stopServer {0} action not supported without node name", new Object[]{nodeOrAction});
        }
        String ret = processType.equals("AdminAgent") ? this.stopServer(serverName, null, nodeOrAction, true) : this.stopServer(serverName, nodeOrAction, null, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer - " + serverName);
        }
        return ret;
    }

    public String stopServer(String serverName, String nodeName, String action) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName", new Object[]{serverName, nodeName, action});
        }
        this._shell.setLastException(null);
        String ret = this.stopServer(serverName, nodeName, action, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer - " + serverName);
        }
        return ret;
    }

    protected String stopServer(String serverName, String nodeName, String action, boolean overload) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopServer serverName - " + serverName + " " + nodeName + " " + action + " " + overload);
        }
        this._shell.setLastException(null);
        String ret = null;
        try {
            if (nodeName == null || nodeName.length() == 0) {
                if ("AdminAgent".equals(processType)) {
                    nodeName = this.getNode();
                } else {
                    this._shell.setAndThrowScriptingException("WASX7442E", "stopServer {0} action not supported without node name", new Object[]{action});
                }
            }
            StopServerCommand cmd = new StopServerCommand(_client, this._shell, this);
            cmd.setServerName(serverName);
            cmd.setNodeName(nodeName);
            cmd.setActionMode(action);
            cmd.setIsOverload(overload);
            cmd.setDomain("WebSphere");
            cmd.setConnectedProcessType(processType);
            ret = (String)cmd.invoke();
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer");
        }
        return ret;
    }

    public String testConnection(String configId) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection - " + configId);
        }
        this._shell.setLastException(null);
        String ret = null;
        try {
            TestConnectionCommand cmd = new TestConnectionCommand(_client, this._shell, this, configId);
            ret = (String)cmd.invoke();
        }
        catch (ScriptingException se) {
            if (se.toString().indexOf("WASX7387E") != -1) {
                ret = this._shell.getFormattedMessage("WASX7387E", new Object[0], "TestConnection not supported when connection to 5.0 server");
                Tr.error(tc, "WASX7387E");
            }
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.getCause(), ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnection - " + configId);
        }
        return ret;
    }

    public String testConnection(String configId, String props) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection", new Object[]{configId, props});
        }
        this._shell.setLastException(null);
        String msg = this._shell.getFormattedMessage("WASX7390E", new Object[0], "testConnection operation not supported");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deprecated version of testConnection is invoked");
        }
        Tr.error(tc, "WASX7390E");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnection");
        }
        return msg;
    }

    public String getPropertiesForDataSource(String configId) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesForDataSource");
        }
        this._shell.setLastException(null);
        String msg = this._shell.getFormattedMessage("WASX7389E", new Object[0], "getPropertiesForDataSource operation not supported");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deprecated version of getPropertiesForDataSource is invoked");
        }
        Tr.error(tc, "WASX7389E");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesForDataSource");
        }
        return msg;
    }

    public String trace(String traceSpec) throws ScriptingException {
        this._shell.setLastException(null);
        if (traceSpec != null) {
            try {
                ManagerAdmin.checkTraceString(traceSpec);
            }
            catch (MalformedTraceStringException mtse) {
                this._shell.setAndThrowScriptingException("WASX7141E", "Incorrect trace string supplied: " + traceSpec, new Object[]{traceSpec});
            }
            ManagerAdmin.setTraceState(traceSpec);
        }
        return new String();
    }

    protected String[] attributes(ObjectName objName) throws ScriptingException, ConnectorException, JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes");
        }
        MBeanInfo mbi = null;
        this.checkService();
        mbi = _client.getMBeanInfo(objName);
        MBeanAttributeInfo[] mbai = mbi.getAttributes();
        String[] attrs = new String[mbai.length];
        for (int i = 0; i < mbai.length; ++i) {
            attrs[i] = mbai[i].getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes");
        }
        return attrs;
    }

    protected String attributeType(ObjectName objName, String attrName) throws ScriptingException, ConnectorException, JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes");
        }
        MBeanInfo mbi = null;
        String ret = null;
        this.checkService();
        mbi = _client.getMBeanInfo(objName);
        MBeanAttributeInfo[] mbai = mbi.getAttributes();
        boolean found = false;
        for (int i = 0; i < mbai.length; ++i) {
            if (!attrName.equals(mbai[i].getName())) continue;
            ret = mbai[i].getType();
            found = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes");
        }
        return ret;
    }

    protected ArrayList signature(ObjectName objName, String operationName) throws ScriptingException, ConnectorException, JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signature - " + operationName);
        }
        ArrayList<String[]> al = new ArrayList<String[]>();
        MBeanInfo mbi = null;
        this.checkService();
        mbi = _client.getMBeanInfo(objName);
        MBeanOperationInfo[] mboi = mbi.getOperations();
        for (int i = 0; i < mboi.length; ++i) {
            if (!operationName.equals(mboi[i].getName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found operation!");
            }
            MBeanParameterInfo[] mbpi = mboi[i].getSignature();
            String[] sig = new String[mbpi.length];
            for (int j = 0; j < mbpi.length; ++j) {
                sig[j] = mbpi[j].getType();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "set type " + j + " to " + sig[j]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding sig: " + sig.toString());
            }
            al.add(sig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signature");
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notf, Object handback) {
        if (notf == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMX event Recd: (handback obj= " + handback + "): " + "Notification object is null");
            }
            return;
        }
        Object ud = notf.getUserData();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "JMX event Recd: (handback obj= " + handback + "): " + ud);
        }
        String type = notf.getType();
        String string = "waitObject";
        synchronized ("waitObject") {
            if (this.waitTarget == null) {
                this.notification = type;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set notification to" + type);
                }
            } else if (this.waitTarget.contains(type)) {
                if (type.equals("websphere.process.not.monitored")) {
                    this.isProcessMonitored = false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "received event " + type + " isProcessMonitored " + this.isProcessMonitored);
                }
                this.waitTarget = null;
                "waitObject".notify();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCompletion(Vector notifName, int waittime) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForCompletion");
        }
        boolean ret = false;
        String string = "waitObject";
        synchronized ("waitObject") {
            this.waitTarget = notifName;
            if (this.notification != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notification received early " + this.notification);
                }
                if (this.notification.equals("websphere.process.not.monitored")) {
                    this.isProcessMonitored = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isProcessMonitored " + this.isProcessMonitored);
                    }
                }
                this.notification = null;
                ret = true;
            } else {
                block13: {
                    this.isProcessMonitored = true;
                    try {
                        "waitObject".wait(waittime);
                    }
                    catch (InterruptedException ie) {
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Interrupted; time to work.");
                    }
                }
                if (this.waitTarget == null) {
                    ret = true;
                }
            }
            this.waitTarget = null;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForCompletion " + ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessMonitored() {
        String string = "waitObject";
        synchronized ("waitObject") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.isProcessMonitored;
        }
    }
}

