/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Properties;
import javax.naming.Referenceable;

public class WASTopicConnectionFactoryBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(WASTopicConnectionFactoryBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.internalmessaging.xmi", "WASTopicConnectionFactory");
    }

    public Object getBindingObject(ConfigObject resource) throws ResourceBindingException {
        int intValuePort;
        Properties jmsProps = new Properties();
        ConfigObject jmsProvider = resource.getParent();
        ConfigObject connectionPool = resource.getObject("connectionPool");
        this.checkRequiredProperty(connectionPool, "Invalid Configuration! The JMS Resource: " + resource.getString("name", "__null__") + " has a null ConnectionPool property.");
        ConfigObject sessionPool = resource.getObject("sessionPool");
        try {
            Server server = WsServiceRegistry.getService(this, Server.class);
            this.setProperty(jmsProps, "CELL", server.getCellName(), true);
        }
        catch (Throwable e) {
            Tr.audit(tc, "Exception getting Server Service", e);
        }
        this.addPropertySet(jmsProps, resource.getObject("propertySet"), true);
        this.addPropertySet(jmsProps, jmsProvider.getObject("propertySet"), true);
        String name = resource.getString("name", "__null__");
        if (name == null || name.length() <= 0) {
            throw new ResourceBindingException("WASTopicConnectionFactory can not be bound as no name has been specified.");
        }
        this.setProperty(jmsProps, "NAME", name, true);
        this.setProperty(jmsProps, "DESC", resource.getString("description", "__null__"), true);
        Object property = resource.getString("node", "__null__");
        this.checkRequiredProperty(property, "WASTopicConnectionFactory " + name + " can not be bound as no node property has been specified.");
        this.setProperty(jmsProps, "NODE", property, true);
        this.addJMSServerProperties(jmsProps, resource.getString("node", "__null__"));
        String stringValue = resource.getString("port", "DIRECT");
        if (stringValue.equals("DIRECT")) {
            intValuePort = 0;
        } else if (stringValue.equals("QUEUED")) {
            intValuePort = 1;
        } else {
            throw new IllegalStateException(stringValue);
        }
        property = resource.isSet("port") ? Integer.valueOf(intValuePort) : null;
        this.checkRequiredProperty(property, "WASTopicConnectionFactory " + name + " can not be bound as no port property has been specified.");
        this.setProperty(jmsProps, "PORTTYPE", new Integer(intValuePort), true);
        this.setProperty(jmsProps, "CID", resource.getString("clientID", "clientID"), true);
        this.setProperty(jmsProps, "CLONESUP", resource.isSet("cloneSupport") ? new Boolean(resource.getBoolean("cloneSupport", false)) : Boolean.FALSE, true);
        this.setAuthenticationProperties(resource, jmsProps);
        this.setProperty(jmsProps, "XAEnabled", resource.isSet("XAEnabled") ? new Boolean(resource.getBoolean("XAEnabled", true)) : Boolean.TRUE, true);
        Properties connectionPoolProperties = new Properties();
        this.addConnectionPoolProperties(connectionPoolProperties, connectionPool);
        this.addJ2EEHrefProperties(connectionPoolProperties, resource);
        Properties sessionPoolProperties = new Properties();
        this.addConnectionPoolProperties(sessionPoolProperties, sessionPool);
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            ref = refBuilder.createEmbeddedTopicConnectionFactoryReferenceable(jmsProps, connectionPoolProperties, sessionPoolProperties);
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.WASTopicConnectionFactoryBinder.getBindingObject", "127", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.WASTopicConnectionFactoryBinder.getBindingObject", "132", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }
}

