/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.WSThreadPool;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.HashMap;

public class WSThreadPoolRepository
implements ThreadPoolRepository {
    private static final TraceComponent tc = Tr.register(WSThreadPoolRepository.class, "Runtime", "com.ibm.ws.runtime");
    private final HashMap _threadPools = new HashMap();
    private ThreadPoolMgr _threadPoolMgr = null;

    public WSThreadPoolRepository() {
        try {
            this._threadPoolMgr = WsServiceRegistry.getService(this, ThreadPoolMgr.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.WSThreadPoolRepository.WSThreadPoolRepository", "45", this);
        }
    }

    public ThreadPool createThreadPool(String name) throws ThreadPoolAlreadyKnownException {
        return this.createThreadPool(name, 0, 10, 5000L);
    }

    public ThreadPool createThreadPool(String name, int minimumPoolSize, int maximumPoolSize) throws ThreadPoolAlreadyKnownException {
        return this.createThreadPool(name, minimumPoolSize, maximumPoolSize, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool createThreadPool(String name, int minimumPoolSize, int maximumPoolSize, long keepAliveTime) throws ThreadPoolAlreadyKnownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createThreadPool", new Object[]{name, new Integer(minimumPoolSize), new Integer(maximumPoolSize), new Long(keepAliveTime), this});
        }
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            if (this._threadPools.get(name) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createThreadPool", "ThreadPoolAlreadyKnownException");
                }
                throw new ThreadPoolAlreadyKnownException();
            }
            WSThreadPool newPool = new WSThreadPool(name, minimumPoolSize, maximumPoolSize, keepAliveTime, this);
            this._threadPools.put(name, newPool);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadPool", newPool);
            }
            return newPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool createThreadPool(String name, int minimumPoolSize, int maximumPoolSize, long keepAliveTime, int backingStorageSize) throws ThreadPoolAlreadyKnownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createThreadPool", new Object[]{name, new Integer(minimumPoolSize), new Integer(maximumPoolSize), new Long(keepAliveTime), new Integer(backingStorageSize), this});
        }
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            if (this._threadPools.get(name) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createThreadPool", "ThreadPoolAlreadyKnownException");
                }
                throw new ThreadPoolAlreadyKnownException();
            }
            WSThreadPool newPool = new WSThreadPool(name, minimumPoolSize, maximumPoolSize, keepAliveTime, backingStorageSize, this);
            this._threadPools.put(name, newPool);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadPool", newPool);
            }
            return newPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getThreadPool(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool", new Object[]{name, this});
        }
        ThreadPool threadPool = null;
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            com.ibm.ws.util.ThreadPool utilsPool;
            threadPool = (ThreadPool)this._threadPools.get(name);
            if (threadPool == null && (utilsPool = this._threadPoolMgr.getThreadPool(name)) != null) {
                threadPool = new WSThreadPool(utilsPool, this);
                this._threadPools.put(name, threadPool);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool", threadPool);
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeThreadPool(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeThreadPool", new Object[]{name, this});
        }
        HashMap hashMap = this._threadPools;
        synchronized (hashMap) {
            this._threadPools.remove(name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeThreadPool");
        }
    }
}

