/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.protocol;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Protocols {
    private static final String PKGNAME_DELIMITER = "|";

    public static void init() {
    }

    public static synchronized void registerPackage(String pkgNamePrefix) {
        ArrayList<String> transportPackages = new ArrayList<String>();
        String currentPackageList = System.getProperty("java.protocol.handler.pkgs");
        if (currentPackageList != null) {
            StringTokenizer tok = new StringTokenizer(currentPackageList, PKGNAME_DELIMITER);
            while (tok.hasMoreTokens()) {
                transportPackages.add(tok.nextToken());
            }
        }
        if (transportPackages.contains(pkgNamePrefix)) {
            return;
        }
        transportPackages.add(pkgNamePrefix);
        StringBuffer currentPackages = new StringBuffer();
        Iterator i = transportPackages.iterator();
        while (i.hasNext()) {
            String thisPackage = (String)i.next();
            currentPackages.append(thisPackage);
            if (!i.hasNext()) continue;
            currentPackages.append('|');
        }
        System.setProperty("java.protocol.handler.pkgs", currentPackages.toString());
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Protocols.registerPackage("com.ibm.ws.protocol");
                    Protocols.registerPackage("com.ibm.net.ssl.internal.www.protocol");
                    Protocols.registerPackage("com.ibm.net.ssl.www2.protocol");
                    Protocols.registerPackage("com.ibm.crypto.provider");
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.protocol.Protocols.run", "64", this);
                }
                return null;
            }
        });
    }
}

