/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.wire;

import com.ibm.ws.pmi.wire.WpdData;
import com.ibm.ws.pmi.wire.WpdDataImpl;

public class WpdLoad
extends WpdDataImpl {
    private static final long serialVersionUID = -1608134391368458856L;
    private long createTime;
    private double currentLevel;
    private double integral;

    public WpdLoad(int id, long time2, double currentLevel, double integral, long createTime) {
        super(id, time2);
        this.currentLevel = currentLevel;
        this.integral = integral;
        this.createTime = createTime;
    }

    public double getLastValue() {
        return this.currentLevel;
    }

    public double getIntegral() {
        return this.integral;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String toXML() {
        String res = "<PerfInt ID=\"" + this.id + "\" time=\"" + this.time + "\" lastValue=\"" + this.currentLevel + "\" integral=\"" + this.integral + "\" createTime=\"" + this.createTime + "\"/>\n";
        return res;
    }

    public String toString() {
        return "Data Id=" + this.id + " time=" + this.time + " currentLevel=" + this.currentLevel + " integral=" + this.integral + " createTime=" + this.createTime;
    }

    public void combine(WpdData other) {
        if (other == null) {
            return;
        }
        if (!(other instanceof WpdLoad)) {
            System.err.println("WpdLoad.combine: wrong type. WpdLoad is needed!");
        } else {
            WpdLoad otherLoad = (WpdLoad)other;
            this.currentLevel += otherLoad.getLastValue();
            double timeWeight = this.time - this.createTime;
            double timeWeight2 = otherLoad.getTime() - otherLoad.getCreateTime();
            this.integral = timeWeight2 <= timeWeight ? (this.integral += otherLoad.getIntegral()) : (this.integral += otherLoad.getIntegral() * (timeWeight / timeWeight2));
        }
    }
}

