/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WSGWPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;

public class WSGWModule
extends PmiAbstractModule
implements WSGWPerf {
    private static final long serialVersionUID = 6360159954303507404L;
    private static TraceComponent tc = Tr.register(WSGWModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "wsgwModule";
    public static final int defaultLevel = 0;
    private SPICountStatistic numSyncRequests = null;
    private SPICountStatistic numSyncResponse = null;
    private SPICountStatistic numAsyncRequests = null;
    private SPICountStatistic numAsyncResponse = null;
    public static final int SYNC_REQ = 1;
    public static final int SYNC_RESP = 2;
    public static final int ASYNC_REQ = 3;
    public static final int ASYNC_RESP = 4;

    public WSGWModule(String appName) {
        super(moduleID, appName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new WSGWModule: " + appName);
        }
        this.registerModule(this);
    }

    public void onSyncRequest() {
        if (this.numSyncRequests != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "onSyncRequest()");
            }
            this.numSyncRequests.increment();
        }
    }

    public void onSyncResponse() {
        if (this.numSyncResponse != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "onSyncResponse()");
            }
            this.numSyncResponse.increment();
        }
    }

    public void onAsyncRequest() {
        if (this.numAsyncRequests != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "onAsyncRequest()");
            }
            this.numAsyncRequests.increment();
        }
    }

    public void onAsyncResponse() {
        if (this.numAsyncResponse != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "onAsyncResponse()");
            }
            this.numAsyncResponse.increment();
        }
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.numSyncRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 2: {
                this.numSyncResponse = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 3: {
                this.numAsyncRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 4: {
                this.numAsyncResponse = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }
}

