/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.Transaction.JtsPerformanceMetrics;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class TransactionModule
extends PmiAbstractModule {
    private static final long serialVersionUID = -2134508338986823171L;
    public static final String moduleID = "transactionModule";
    private static final int defaultLevel = 0;
    private SPICountStatistic gTransBegun = null;
    private SPICountStatistic gTransInvolved = null;
    private SPICountStatistic lTransBegun = null;
    private SPICountStatistic activeGTrans = null;
    private SPICountStatistic activeLTrans = null;
    private SPITimeStatistic gTranRt = null;
    private SPITimeStatistic lTranRt = null;
    private SPITimeStatistic gBeforeCompDuration = null;
    private SPITimeStatistic gPrepareDuration = null;
    private SPITimeStatistic gCommitDuration = null;
    private SPITimeStatistic lBeforeCompDuration = null;
    private SPITimeStatistic lCommitDuration = null;
    private SPICountStatistic numOptim = null;
    private SPICountStatistic gTransCommitted = null;
    private SPICountStatistic lTransCommitted = null;
    private SPICountStatistic gTransRollback = null;
    private SPICountStatistic lTransRollback = null;
    private SPICountStatistic gTransTimeout = null;
    private SPICountStatistic lTransTimeout = null;
    private String containerName = null;
    private static final TraceComponent tc = Tr.register(TransactionModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final int G_TRANS_BEGUN = 1;
    public static final int G_TRANS_INVOLVED = 2;
    public static final int L_TRANS_BEGUN = 3;
    public static final int ACTIVE_G_TRANS = 4;
    public static final int ACTIVE_L_TRANS = 5;
    public static final int G_TRAN_RT = 6;
    public static final int L_TRAN_RT = 7;
    public static final int G_BEFORE_COMPLETION = 8;
    public static final int G_PREPARE = 9;
    public static final int G_COMMIT = 10;
    public static final int L_BEFORE_COMPLETION = 11;
    public static final int L_COMMIT = 12;
    public static final int NUM_OPTIM = 13;
    public static final int G_TRANS_COMMITTED = 14;
    public static final int L_TRANS_COMMITTED = 15;
    public static final int G_TRANS_ROLL_BACK = 16;
    public static final int L_TRANS_ROLL_BACK = 17;
    public static final int G_TRANS_TIMEOUT = 18;
    public static final int L_TRANS_TIMEOUT = 19;

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.gTransBegun = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 2: {
                this.gTransInvolved = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 3: {
                this.lTransBegun = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 13: {
                this.numOptim = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 14: {
                this.gTransCommitted = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 15: {
                this.lTransCommitted = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 16: {
                this.gTransRollback = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 17: {
                this.lTransRollback = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 18: {
                this.gTransTimeout = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 19: {
                this.lTransTimeout = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 4: {
                this.activeGTrans = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 5: {
                this.activeLTrans = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 6: {
                this.gTranRt = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 7: {
                this.lTranRt = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 8: {
                this.gBeforeCompDuration = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 9: {
                this.gPrepareDuration = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 10: {
                this.gCommitDuration = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 11: {
                this.lBeforeCompDuration = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
            case 12: {
                this.lCommitDuration = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        return true;
    }

    public TransactionModule() {
        super(moduleID, "Jts");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new TransactionModule");
        }
        this.type = 13;
        this.registerModule(this);
    }

    public void init(Object[] params) {
        if (params == null || params.length == 0) {
            return;
        }
        WebSphereTransactionManager txManager = (WebSphereTransactionManager)params[0];
        if (txManager != null) {
            GlobalTran global = new GlobalTran();
            LocalTran local = new LocalTran();
            txManager.registerPerformanceMetrics(global, local);
        }
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public class LocalTran
    implements JtsPerformanceMetrics {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long started() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "started local");
            }
            if (TransactionModule.this.lTransBegun != null) {
                TransactionModule.this.lTransBegun.increment();
            }
            if (TransactionModule.this.activeLTrans != null) {
                SPICountStatistic sPICountStatistic = TransactionModule.this.activeLTrans;
                synchronized (sPICountStatistic) {
                    TransactionModule.this.activeLTrans.increment();
                }
            }
            if (TransactionModule.this.lTranRt != null) {
                return System.currentTimeMillis();
            }
            return 0L;
        }

        public void imported() {
            System.err.println("ERROR: local tran imported() should not be called");
        }

        public long commitRequested() {
            if (TransactionModule.this.lBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "commitRequested local");
                }
                return System.currentTimeMillis();
            }
            return 0L;
        }

        public long preparing(long commitRequestTime) {
            return 0L;
        }

        public long committing(long startCommitRequestedTime) {
            long currentTime = 0L;
            if (TransactionModule.this.lBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "committing local");
                }
                currentTime = System.currentTimeMillis();
                if (startCommitRequestedTime > 0L) {
                    TransactionModule.this.lBeforeCompDuration.add(currentTime - startCommitRequestedTime);
                }
            }
            return currentTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(long startCommittingTime, long startTime, boolean committed) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "completed local");
            }
            if (TransactionModule.this.lCommitDuration != null || TransactionModule.this.lTranRt != null) {
                long currentTime = System.currentTimeMillis();
                if (TransactionModule.this.lCommitDuration != null && startCommittingTime > 0L) {
                    TransactionModule.this.lCommitDuration.add(currentTime - startCommittingTime);
                }
                if (startTime > 0L && TransactionModule.this.lTranRt != null) {
                    TransactionModule.this.lTranRt.add(currentTime - startTime);
                }
            }
            if (TransactionModule.this.activeLTrans != null) {
                SPICountStatistic sPICountStatistic = TransactionModule.this.activeLTrans;
                synchronized (sPICountStatistic) {
                    TransactionModule.this.activeLTrans.decrement();
                }
            }
            if (committed) {
                if (TransactionModule.this.lTransCommitted != null) {
                    TransactionModule.this.lTransCommitted.increment();
                }
            } else if (TransactionModule.this.lTransRollback != null) {
                TransactionModule.this.lTransRollback.increment();
            }
        }

        public void timeout() {
            if (TransactionModule.this.lTransTimeout != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "timeout local");
                }
                TransactionModule.this.lTransTimeout.increment();
            }
        }

        public void onePhase() {
            if (TransactionModule.this.numOptim != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "onePhase local");
                }
                TransactionModule.this.numOptim.increment();
            }
        }
    }

    public class GlobalTran
    implements JtsPerformanceMetrics {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long started() {
            long rc = 0L;
            if (TransactionModule.this.gTransBegun != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "started");
                }
                TransactionModule.this.gTransBegun.increment();
            }
            if (TransactionModule.this.gTransInvolved != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "started");
                }
                TransactionModule.this.gTransInvolved.increment();
            }
            if (TransactionModule.this.activeGTrans != null) {
                SPICountStatistic sPICountStatistic = TransactionModule.this.activeGTrans;
                synchronized (sPICountStatistic) {
                    TransactionModule.this.activeGTrans.increment();
                }
            }
            if (TransactionModule.this.gTranRt != null) {
                rc = System.currentTimeMillis();
            }
            return rc;
        }

        public void imported() {
            if (TransactionModule.this.gTransInvolved != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "imported");
                }
                TransactionModule.this.gTransInvolved.increment();
            }
        }

        public long commitRequested() {
            if (TransactionModule.this.gBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "commitRequested");
                }
                return System.currentTimeMillis();
            }
            return 0L;
        }

        public long preparing(long startCommitRequestedTime) {
            long currentTime = 0L;
            if (TransactionModule.this.gBeforeCompDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "preparing");
                }
                currentTime = System.currentTimeMillis();
                if (startCommitRequestedTime > 0L) {
                    TransactionModule.this.gBeforeCompDuration.add(currentTime - startCommitRequestedTime);
                }
            }
            return currentTime;
        }

        public long committing(long startPreparingTime) {
            long currentTime = 0L;
            if (TransactionModule.this.gPrepareDuration != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "committing");
                }
                currentTime = System.currentTimeMillis();
                if (startPreparingTime > 0L) {
                    TransactionModule.this.gPrepareDuration.add(currentTime - startPreparingTime);
                }
            }
            return currentTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(long startCommittingTime, long startTime, boolean committed) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startCommitting");
            }
            if (TransactionModule.this.gCommitDuration != null || TransactionModule.this.gTranRt != null) {
                long currentTime = System.currentTimeMillis();
                if (TransactionModule.this.gCommitDuration != null && startCommittingTime > 0L) {
                    TransactionModule.this.gCommitDuration.add(currentTime - startCommittingTime);
                }
                if (startTime > 0L && TransactionModule.this.gTranRt != null) {
                    TransactionModule.this.gTranRt.add(currentTime - startTime);
                }
            }
            if (TransactionModule.this.activeGTrans != null) {
                SPICountStatistic sPICountStatistic = TransactionModule.this.activeGTrans;
                synchronized (sPICountStatistic) {
                    TransactionModule.this.activeGTrans.decrement();
                }
            }
            if (committed) {
                if (TransactionModule.this.gTransCommitted != null) {
                    TransactionModule.this.gTransCommitted.increment();
                }
            } else if (TransactionModule.this.gTransRollback != null) {
                TransactionModule.this.gTransRollback.increment();
            }
        }

        public void timeout() {
            if (TransactionModule.this.gTransTimeout != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "timeout");
                }
                TransactionModule.this.gTransTimeout.increment();
            }
        }

        public void onePhase() {
            if (TransactionModule.this.numOptim != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "onePhase");
                }
                TransactionModule.this.numOptim.increment();
            }
        }
    }
}

