/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.PMIPlugin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.util.Hashtable;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.InterceptorOperations;

public class OrbPerfModule
extends PmiAbstractModule
implements PMIPlugin {
    private static final long serialVersionUID = 670611849591509156L;
    private static final String moduleID = "orbPerfModule";
    private static final int defaultLevel = 0;
    private SPITimeStatistic referenceLookupTime = null;
    private SPICountStatistic numRequests = null;
    private SPIRangeStatistic currentRequests = null;
    private Hashtable interceptorData = new Hashtable();
    private String orbIdentifier = null;
    private static final TraceComponent tc = Tr.register(OrbPerfModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final int REFERENCE_LOOKUP_TIME = 1;
    public static final int TOTAL_NUM_REQUESTS = 2;
    public static final int CONCURRENT_REQUESTS = 3;
    public static final int INTERCEPTORS = 10;
    public static final int PROCESSING_TIME = 11;
    private static boolean fixInterceptor60defect = false;

    public OrbPerfModule() throws Exception {
        super(moduleID, "ORB");
        if (PmiRegistry.isDisabled()) {
            throw new Exception("PMI is disabled and new OrbPerfModule should not be initiated");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new OrbPerfModule");
        }
        this.type = 13;
    }

    public OrbPerfModule(ORB orb) throws Exception {
        this();
        if (PmiRegistry.isDisabled()) {
            throw new Exception("PMI is disabled and new OrbPerfModule should not be initiated");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new OrbPerfModule");
        }
        this.init(orb);
    }

    public void init(ORB orb) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init");
        }
        if (orb != null && !PmiRegistry.isDisabled()) {
            this.orbIdentifier = "IBM ORB:" + orb.getServerId();
            this.registerModule(this);
            if (!PmiRegistry.Z) {
                new InterceptorModuleAggregate(moduleID, null, "orbPerfModule.interceptors");
            }
        }
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public void onInterceptorRegister(Interceptor interceptor) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onInterceptorRegister");
        }
        if (interceptor != null) {
            InterceptorPmiModule data;
            String interceptorName = this.interceptorName(interceptor);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "interceptorName=" + interceptorName);
            }
            if ((data = (InterceptorPmiModule)this.interceptorData.get(interceptorName)) == null) {
                InterceptorPmiModule interceptorPmiModule = this.recoverFromInterceptorNotFound(interceptorName);
            }
        }
    }

    public void preInterceptorRun(Interceptor interceptor) {
    }

    public void postInterceptorRun(Interceptor interceptor, long timeTaken) {
        if (interceptor != null) {
            String interceptorName = this.interceptorName(interceptor);
            InterceptorPmiModule data = (InterceptorPmiModule)this.interceptorData.get(interceptorName);
            if (data == null) {
                data = this.recoverFromInterceptorNotFound(interceptorName);
            }
            data.addResponseTime(timeTaken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "postInterceptorRun " + interceptorName);
            }
        }
    }

    public void preObjectReferenceLookup() {
    }

    public void postObjectReferenceLookup(long timeTaken) {
        if (this.referenceLookupTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "postObjectReferenceLookup, timeTaken=" + timeTaken);
            }
            this.referenceLookupTime.add(timeTaken);
        }
    }

    public void preRequestMarshalling() {
    }

    public void postRequestMarshalling(long timeTaken) {
    }

    public void newRequest() {
        if (this.currentRequests != null) {
            this.currentRequests.increment();
        }
        if (this.numRequests != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newRequest");
            }
            this.numRequests.increment();
        }
    }

    public void requestCompleted() {
        if (this.currentRequests != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requestCompleted");
            }
            this.currentRequests.decrement();
        }
    }

    public void lsdLookupRequired() {
    }

    private String interceptorName(Interceptor interceptor) {
        String interceptorName = null;
        if (interceptor != null && ((interceptorName = interceptor.name()) == null || interceptorName.equals(""))) {
            interceptorName = interceptor.getClass().getName();
        }
        return interceptorName;
    }

    protected InterceptorPmiModule recoverFromInterceptorNotFound(String interceptorName) {
        InterceptorPmiModule data = new InterceptorPmiModule(this.orbIdentifier, interceptorName);
        this.interceptorData.put(interceptorName, data);
        return data;
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 2: {
                this.numRequests = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        switch (data.getId()) {
            case 3: {
                this.currentRequests = (SPIRangeStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 1: {
                this.referenceLookupTime = (SPITimeStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        return false;
    }

    public void onInterceptorRegister(InterceptorOperations iop) {
    }

    public void preInterceptorRun(InterceptorOperations iop) {
    }

    public void postInterceptorRun(InterceptorOperations iop, long code) {
    }

    public void locationForwardResponseReceived() {
    }

    public String getWCCMStatsType() {
        return "orbPerfModule#";
    }

    protected void initializeMe(int newLevel) {
        if (this.currentLevel >= 7 || newLevel < 7) {
            return;
        }
        long numRequests = 0L;
        if (this.currentRequests != null) {
            numRequests = this.currentRequests.getCurrent();
        }
        if (numRequests < 0L) {
            this.currentRequests.setLastValue(0L);
        }
    }

    public synchronized boolean setFineGrainedInstrumentation(int[] enabled, int[] enableWithSync) {
        if (enabled != null) {
            for (int i = 0; i < enabled.length; ++i) {
                if (enabled[i] != 11) continue;
                fixInterceptor60defect = true;
            }
        }
        return super.setFineGrainedInstrumentation(enabled, enableWithSync);
    }

    class InterceptorModuleAggregate
    extends ModuleAggregate {
        public InterceptorModuleAggregate(String name, String instanceName, String submoduleName) {
            super(name, instanceName, submoduleName);
        }

        public synchronized void setInstrumentationLevel(int newLevel) {
            super.setInstrumentationLevel(newLevel);
            if (fixInterceptor60defect) {
                fixInterceptor60defect = false;
                int[] enabled = new int[]{11};
                this.setFineGrainedInstrumentation(enabled, new int[0]);
            }
        }
    }

    class InterceptorPmiModule
    extends PmiAbstractModule {
        private static final long serialVersionUID = -5081210619971748075L;
        private final TraceComponent tc;
        SPITimeStatistic processingTime;

        public InterceptorPmiModule(String orbIdentifier, String interceptorName) {
            super(OrbPerfModule.moduleID, orbIdentifier);
            this.tc = Tr.register(InterceptorPmiModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
            this.processingTime = null;
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "new InterceptorPmiModule");
            }
            this.submoduleName = "orbPerfModule.interceptors";
            this.subinstanceName = interceptorName;
            this.type = 16;
            this.registerModule(this);
        }

        public String getWCCMStatsType() {
            return "orbPerfModule#orbPerfModule.interceptors";
        }

        public String[] getPath() {
            return new String[]{OrbPerfModule.moduleID, "orbPerfModule.interceptors", this.subinstanceName};
        }

        public void destroy() {
            this.processingTime = null;
            PmiRegistry.unregisterModule(this);
        }

        public void addResponseTime(long execTime) {
            if (this.processingTime != null) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "addResponseTime, time=" + execTime + ", ORB interceptor is " + this.subinstanceName);
                }
                this.processingTime.add(execTime);
            }
        }

        protected boolean statCreated(SpdStat data) {
            switch (data.getId()) {
                case 11: {
                    this.processingTime = (SPITimeStatistic)((Object)data.getStatistic());
                    return true;
                }
            }
            return false;
        }

        public String getModuleID() {
            return OrbPerfModule.moduleID;
        }

        public int getDefaultLevel() {
            return 0;
        }
    }
}

