/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.pmi.PmiBean;
import com.ibm.websphere.pmi.PmiBeanFactory;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import java.util.HashMap;

public class BeanModule
extends PmiAbstractModule
implements PmiBean {
    private static final long serialVersionUID = -4551321068413271323L;
    private static final TraceComponent tc = Tr.register(BeanModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "beanModule";
    public static final String beanWccmType = "beanModule#";
    public static final String beanMethodWccmType = "beanModule#beanModule.methods";
    private static final int defaultLevel = 0;
    private PmiBeanFactory myfactory = null;
    private static final int TYPE_STATELESS = 1;
    private static final int TYPE_STATEFUL = 2;
    private static final int TYPE_ENTITY = 3;
    private static final int TYPE_MDB = 4;
    private int iType = -1;
    private CountStatisticImpl instantiates = null;
    private CountStatisticImpl destroys = null;
    private CountStatisticImpl loads = null;
    private CountStatisticImpl stores = null;
    private CountStatisticImpl creates = null;
    private CountStatisticImpl removes = null;
    private CountStatisticImpl passivations = null;
    private RangeStatisticImpl passivatedSFSB = null;
    private CountStatisticImpl activations = null;
    private CountStatisticImpl methodCalls = null;
    private TimeStatisticImpl methodRt = null;
    private RangeStatisticImpl methodLoad = null;
    private TimeStatisticImpl createRt = null;
    private TimeStatisticImpl removeRt = null;
    private TimeStatisticImpl loadRt = null;
    private TimeStatisticImpl storeRt = null;
    private TimeStatisticImpl activationRt = null;
    private TimeStatisticImpl passivationRt = null;
    private RangeStatisticImpl actives = null;
    private RangeStatisticImpl lives = null;
    private CountStatisticImpl getsFromPool = null;
    private CountStatisticImpl getsFound = null;
    private CountStatisticImpl returnsToPool = null;
    private CountStatisticImpl returnsDiscarded = null;
    private CountStatisticImpl drainsFromPool = null;
    private AverageStatisticImpl avgDrainSize = null;
    private RangeStatisticImpl poolSize = null;
    private BeanMethodsModule methodsSubmodule = null;
    private String ejbjarName;
    private String beanName;
    protected boolean methodDataEnabled = false;
    private CountStatisticImpl messageCount = null;
    private CountStatisticImpl messageBackoutCount = null;
    private TimeStatisticImpl averageServerSessionWaitTime = null;
    private RangeStatisticImpl serverSessionUsage = null;
    public static final int CREATES = 1;
    public static final int REMOVES = 2;
    public static final int ACTIVATIONS = 3;
    public static final int PASSIVATIONS = 4;
    public static final int INSTANTIATES = 5;
    public static final int DESTROYS = 6;
    public static final int LOADS = 7;
    public static final int STORES = 8;
    public static final int ACTIVES = 9;
    public static final int LIVES = 10;
    public static final int METHOD_CALLS = 11;
    public static final int METHOD_RT = 12;
    public static final int CREATE_RT = 14;
    public static final int REMOVE_RT = 15;
    public static final int METHOD_LOAD = 18;
    public static final int GETS_FROM_POOL = 19;
    public static final int GETS_FOUND = 20;
    public static final int RETURNS_TO_POOL = 21;
    public static final int RETURNS_DISCARDED = 22;
    public static final int DRAINS_FROM_POOL = 23;
    public static final int DRAIN_SIZE = 24;
    public static final int POOL_SIZE = 25;
    public static final int MESSAGE_DELIVERED = 26;
    public static final int MESSAGE_BACKOUT = 27;
    public static final int AVERAGE_SERVER_SESSION_WAIT_TIME = 28;
    public static final int SERVER_SESSION_USAGE = 29;
    public static final int ACTIVATION_TIME = 30;
    public static final int PASSIVATION_TIME = 31;
    public static final int LOAD_TIME = 32;
    public static final int STORE_TIME = 33;
    public static final int PASSIVATION_COUNT = 34;
    public static final int METHODREADY_COUNT = 35;
    public static final int METHODS = 50;
    public static final int CALLS_PER_METHOD = 51;
    public static final int RT_PER_METHOD = 52;
    public static final int LOAD_PER_METHOD = 53;

    public String getWCCMStatsType() {
        if (this.categoryName != null) {
            return beanWccmType + this.categoryName;
        }
        return beanWccmType;
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.creates = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 2: {
                this.removes = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 3: {
                this.activations = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 4: {
                this.passivations = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 5: {
                this.instantiates = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 6: {
                this.destroys = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 7: {
                this.loads = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 8: {
                this.stores = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 11: {
                this.methodCalls = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 19: {
                this.getsFromPool = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 20: {
                this.getsFound = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 21: {
                this.returnsToPool = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 22: {
                this.returnsDiscarded = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 23: {
                this.drainsFromPool = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 26: {
                this.messageCount = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 27: {
                this.messageBackoutCount = (CountStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 12: {
                this.methodRt = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 14: {
                this.createRt = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 15: {
                this.removeRt = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 32: {
                this.loadRt = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 33: {
                this.storeRt = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 30: {
                this.activationRt = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 31: {
                this.passivationRt = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 24: {
                this.avgDrainSize = (AverageStatisticImpl)data.getStatistic();
                return true;
            }
            case 28: {
                this.averageServerSessionWaitTime = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        switch (data.getId()) {
            case 9: {
                this.actives = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 10: {
                this.lives = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 18: {
                this.methodLoad = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 25: {
                this.poolSize = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 29: {
                this.serverSessionUsage = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 34: {
                this.passivatedSFSB = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 35: {
                if (this.iType == 1) {
                    this.poolSize = (RangeStatisticImpl)data.getStatistic();
                    return true;
                }
                if (this.iType == 2) {
                    this.actives = (RangeStatisticImpl)data.getStatistic();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public BeanModule(String ejbjarName, String beanName, String beanType, EJBComponentMetaData data) {
        super(moduleID, beanName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BeanModule " + beanName);
        }
        this.ejbjarName = ejbjarName;
        this.beanName = beanName;
        this.categoryName = beanType;
        if (this.categoryName != null) {
            PmiRegistry.jmxMapper.setBeanMapping(beanName, this.categoryName);
            this.iType = this.categoryName.equals("ejb.stateless") ? 1 : (this.categoryName.equals("ejb.stateful") ? 2 : (this.categoryName.equals("ejb.entity") ? 3 : (this.categoryName.equals("ejb.messageDriven") ? 4 : -1)));
        }
        this.registerModule(this);
        this.methodsSubmodule = new BeanMethodsModule(beanName, this.categoryName);
    }

    public String[] getPath() {
        return new String[]{moduleID, this.ejbjarName, this.categoryName, this.beanName};
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public final void beanCreated() {
        if (this.actives != null) {
            this.actives.increment();
        }
        if (this.creates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanCreated");
            }
            this.creates.increment();
        }
    }

    public final void beanRemoved() {
        if (this.actives != null) {
            this.actives.decrement();
        }
        if (this.removes != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanRemoved");
            }
            this.removes.increment();
        }
    }

    public final void beanDiscarded() {
        if (this.actives != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanDiscarded");
            }
            this.actives.decrement();
        }
    }

    public final void beanInstantiated() {
        if (this.lives != null) {
            this.lives.increment();
        }
        if (this.iType == 1 && this.creates != null) {
            this.creates.increment();
        }
        if (this.instantiates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanInstantiated");
            }
            this.instantiates.increment();
        }
    }

    public final void beanDestroyed() {
        if (this.lives != null) {
            this.lives.decrement();
        }
        if (this.iType == 1 && this.removes != null) {
            this.removes.increment();
        }
        if (this.destroys != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanDestroyed");
            }
            this.destroys.increment();
        }
    }

    public final long activationTime() {
        if (this.activationRt == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activationTime");
        }
        return System.currentTimeMillis();
    }

    public final void activationTime(long startTime) {
        if (this.actives != null) {
            this.actives.increment();
        }
        if (this.activations != null) {
            this.activations.increment();
        }
        if (this.iType == 2 && this.passivatedSFSB != null) {
            this.passivatedSFSB.decrement();
        }
        if (this.activationRt != null && startTime > 0L) {
            long time2 = System.currentTimeMillis() - startTime;
            this.activationRt.add(time2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activationTime(long), time=" + time2);
            }
        }
    }

    public final long passivationTime() {
        if (this.passivationRt != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "passivationTime");
            }
            return System.currentTimeMillis();
        }
        return -1L;
    }

    public final void passivationTime(long startTime) {
        if (this.actives != null) {
            this.actives.decrement();
        }
        if (this.iType == 3) {
            if (this.passivations != null) {
                this.passivations.increment();
            }
        } else if (this.iType == 2 && this.passivatedSFSB != null) {
            this.passivatedSFSB.increment();
        }
        if (this.passivationRt != null && startTime > 0L) {
            long time2 = System.currentTimeMillis() - startTime;
            this.passivationRt.add(time2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "passivationTime(long), time=" + time2);
            }
        }
    }

    public final long loadTime() {
        if (this.loadRt == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadTime");
        }
        return System.currentTimeMillis();
    }

    public final void loadTime(long startTime) {
        if (this.loads != null) {
            this.loads.increment();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadTime(long)");
        }
        if (this.loadRt != null && startTime > 0L) {
            this.loadRt.add(System.currentTimeMillis() - startTime);
        }
    }

    public final long storeTime() {
        if (this.storeRt == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "storeTime");
        }
        return System.currentTimeMillis();
    }

    public final void storeTime(long startTime) {
        if (this.stores != null) {
            this.stores.increment();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "storeTime(long)");
        }
        if (this.storeRt != null && startTime > 0L) {
            this.storeRt.add(System.currentTimeMillis() - startTime);
        }
    }

    public final long methodPreInvoke(EJBKey key, EJBMethodInfo mi) {
        if (this.methodLoad != null) {
            this.methodLoad.increment();
        }
        if (this.methodCalls != null) {
            this.methodCalls.increment();
        }
        if (this.methodDataEnabled) {
            String methodName = null;
            if (mi == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "methodPreInvoke - exception to get mothod name");
                }
                return -1L;
            }
            methodName = mi.getMethodName();
            this.methodsSubmodule.preInvoke(methodName);
        }
        return System.currentTimeMillis();
    }

    public final void methodPostInvoke(EJBKey key, EJBMethodInfo mi, long startTime) {
        if (startTime <= 0L) {
            return;
        }
        long curTime = System.currentTimeMillis();
        long elapsedTime = curTime - startTime;
        if (this.methodRt != null) {
            this.methodRt.add(curTime, elapsedTime);
        }
        if (this.methodLoad != null) {
            this.methodLoad.decrement(curTime, 1L);
        }
        String methodName = mi.getMethodName();
        if (this.methodDataEnabled) {
            this.methodsSubmodule.postInvoke(methodName, startTime);
        }
        if (methodName.equals("create")) {
            if (this.createRt != null) {
                this.createRt.add(curTime, elapsedTime);
            }
        } else if (methodName.equals("remove") && this.removeRt != null) {
            this.removeRt.add(curTime, elapsedTime);
        }
    }

    public final void objectRetrieve(int size, boolean objectInPool) {
        if (this.getsFromPool != null) {
            this.getsFromPool.increment();
        }
        if (objectInPool) {
            if (this.getsFound != null) {
                this.getsFound.increment();
            }
            if (this.poolSize != null) {
                this.poolSize.set(size);
            }
        }
    }

    public final void objectReturn(int size, boolean objectDiscarded) {
        if (!objectDiscarded) {
            if (this.poolSize != null) {
                this.poolSize.set(size);
            }
        } else if (this.returnsDiscarded != null) {
            this.returnsDiscarded.increment();
        }
        if (this.returnsToPool != null) {
            this.returnsToPool.increment();
        }
    }

    public void poolCreated(int size) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "poolCreated");
        }
        if (this.poolSize != null) {
            this.poolSize.set(size);
        }
    }

    public final void poolDrained(int size, int numObjectsDiscarded) {
        if (this.poolSize != null && numObjectsDiscarded > 0) {
            this.poolSize.set(size);
        }
        if (this.drainsFromPool != null) {
            this.drainsFromPool.increment();
        }
        if (this.avgDrainSize != null) {
            this.avgDrainSize.add(numObjectsDiscarded);
        }
    }

    public void setFactory(PmiBeanFactory factory) {
        this.myfactory = factory;
    }

    public void unregister() {
        super.unregister();
        this.methodsSubmodule.clear();
    }

    public void destroy() {
        if (this.myfactory != null) {
            this.myfactory.removePmiModule(this);
        } else {
            this.unregister();
        }
    }

    public void messageDelivered() {
        if (this.messageCount != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageDelivered");
            }
            this.messageCount.increment();
        }
    }

    public void messageBackedOut() {
        if (this.messageBackoutCount != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageBackedOut");
            }
            this.messageBackoutCount.increment();
        }
    }

    public long waitingForServerSession() {
        if (this.averageServerSessionWaitTime == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "waitingForServerSession");
        }
        return System.currentTimeMillis();
    }

    public void gotServerSession(long startTime) {
        if (this.averageServerSessionWaitTime == null || startTime <= 0L) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "gotServerSession");
        }
        long endTime = System.currentTimeMillis();
        this.averageServerSessionWaitTime.add(endTime - startTime);
    }

    public void serverSessionRetrieve(int newInUseCount, int poolSize) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverSessionRetrieve(" + newInUseCount + "," + poolSize + ")");
        }
        if (this.serverSessionUsage != null) {
            int poolLoad = newInUseCount * 100 / poolSize;
            this.serverSessionUsage.set(poolLoad);
        }
    }

    public void serverSessionReturn(int newInUseCount, int poolSize) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverSessionReturn(" + newInUseCount + "," + poolSize + ")");
        }
        if (this.serverSessionUsage != null) {
            int poolLoad = newInUseCount * 100 / poolSize;
            this.serverSessionUsage.set(poolLoad);
        }
    }

    protected void initializeMe(int newLevel) {
        if (this.currentLevel >= 7 || newLevel < 7) {
            return;
        }
        long value = 0L;
        if (this.actives != null) {
            value = this.actives.getCurrent();
        }
        if (value < 0L) {
            this.actives.setLastValue(0L);
        }
        value = 0L;
        if (this.lives != null) {
            value = this.lives.getCurrent();
        }
        if (value < 0L) {
            this.lives.setLastValue(0L);
        }
    }

    protected int[] filterMethodCounters(int[] e) {
        if (e == null) {
            return new int[0];
        }
        int[] et = new int[]{-1, -1, -1};
        for (int i = 0; i < e.length; ++i) {
            if (e[i] == 51) {
                et[0] = 51;
                continue;
            }
            if (e[i] == 52) {
                et[1] = 52;
                continue;
            }
            if (e[i] != 53) continue;
            et[2] = 53;
        }
        int c = 0;
        for (int i = 0; i < et.length; ++i) {
            if (et[i] == -1) continue;
            ++c;
        }
        if (c == 0) {
            return new int[0];
        }
        int x = 0;
        int[] er = new int[c];
        for (int i = 0; i < et.length; ++i) {
            if (et[i] == -1) continue;
            er[x++] = et[i];
        }
        for (int k = 0; k < er.length; ++k) {
        }
        return er;
    }

    class PerMethodModule
    extends PmiAbstractModule {
        private static final long serialVersionUID = 1130973806467009193L;
        CountStatisticImpl perMethodCalls;
        TimeStatisticImpl perMethodRt;
        RangeStatisticImpl perMethodLoad;
        int defaultLevel;

        public PerMethodModule(String beanName, String beanType, String methodName) {
            super(BeanModule.moduleID, beanName);
            this.perMethodCalls = null;
            this.perMethodRt = null;
            this.perMethodLoad = null;
            this.defaultLevel = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new PerMethodModule");
            }
            this.submoduleName = "beanModule.methods";
            this.subinstanceName = methodName;
            this.categoryName = beanType;
            this.type = 16;
            this.bStandaloneTree = true;
            this.registerModule(this);
        }

        protected boolean longCreated(SpdLong data) {
            switch (data.getId()) {
                case 51: {
                    this.perMethodCalls = (CountStatisticImpl)data.getStatistic();
                    return true;
                }
            }
            return false;
        }

        protected boolean statCreated(SpdStat data) {
            switch (data.getId()) {
                case 52: {
                    this.perMethodRt = (TimeStatisticImpl)data.getStatistic();
                    return true;
                }
            }
            return false;
        }

        protected boolean loadCreated(SpdLoad data) {
            switch (data.getId()) {
                case 53: {
                    this.perMethodLoad = (RangeStatisticImpl)data.getStatistic();
                    return true;
                }
            }
            return false;
        }

        public String[] getPath() {
            return new String[]{BeanModule.moduleID, BeanModule.this.ejbjarName, this.categoryName, BeanModule.this.beanName, this.submoduleName, this.subinstanceName};
        }

        public String getModuleID() {
            return BeanModule.moduleID;
        }

        public int getDefaultLevel() {
            return this.defaultLevel;
        }

        public String getWCCMStatsType() {
            return BeanModule.beanMethodWccmType;
        }

        public StatDescriptor getStatDescriptor() {
            String[] subpath = new String[]{this.submoduleName, this.subinstanceName};
            return new StatDescriptor(subpath);
        }

        public synchronized boolean setFineGrainedInstrumentation(int[] enabled, int[] enableWithSync) {
            return super.setFineGrainedInstrumentation(BeanModule.this.filterMethodCounters(enabled), BeanModule.this.filterMethodCounters(enableWithSync));
        }
    }

    class BeanMethodsModule
    extends ModuleAggregate {
        private static final long serialVersionUID = 5988712569185928707L;
        private HashMap methodSubinstances;
        public static final int enableLevel = 15;
        private int defaultLevel;

        public BeanMethodsModule(String beanName, String beanType) {
            super(BeanModule.moduleID, false);
            this.methodSubinstances = new HashMap();
            this.defaultLevel = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BeanMethodsModule " + beanName + ", beanType=" + beanType);
            }
            this.type = 15;
            this.instanceName = beanName;
            this.categoryName = beanType;
            this.submoduleName = "beanModule.methods";
            super.registerModule(this);
        }

        public String[] getPath() {
            return new String[]{BeanModule.moduleID, BeanModule.this.ejbjarName, this.categoryName, BeanModule.this.beanName, this.submoduleName};
        }

        public String getModuleID() {
            return BeanModule.moduleID;
        }

        public int getDefaultLevel() {
            return this.defaultLevel;
        }

        public synchronized boolean setFineGrainedInstrumentation(int[] enabled, int[] enableWithSync) {
            for (int i = 0; i < enabled.length; ++i) {
                if (enabled[i] != 51 && enabled[i] != 52 && enabled[i] != 53) continue;
                BeanModule.this.methodDataEnabled = true;
                break;
            }
            for (int k = 0; k < enableWithSync.length; ++k) {
                if (enableWithSync[k] != 51 && enableWithSync[k] != 52 && enableWithSync[k] != 53) continue;
                BeanModule.this.methodDataEnabled = true;
                break;
            }
            return super.setFineGrainedInstrumentation(enabled, enableWithSync);
        }

        public synchronized void setInstrumentationLevel(int newLevel) {
            super.setInstrumentationLevel(newLevel);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setInstrumentationLevel");
            }
            if (this.moduleConfig == null) {
                Tr.warning(tc, "PMI0007W", BeanModule.moduleID);
                return;
            }
            if (newLevel == -1) {
                return;
            }
            BeanModule.this.methodDataEnabled = newLevel == 15;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preInvoke(String methodName) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BeanMethodsModule.preInvoke for method: " + methodName);
            }
            PerMethodModule oneMethod = null;
            HashMap hashMap = this.methodSubinstances;
            synchronized (hashMap) {
                oneMethod = (PerMethodModule)this.methodSubinstances.get(methodName);
                if (oneMethod == null) {
                    oneMethod = new PerMethodModule(this.instanceName, this.categoryName, methodName);
                    if (oneMethod == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "BeanMethodsModule.preInvoke - error creating per method submodule");
                        }
                        return;
                    }
                    this.methodSubinstances.put(methodName, oneMethod);
                }
            }
            if (oneMethod.perMethodCalls != null) {
                oneMethod.perMethodCalls.increment();
            }
            if (oneMethod.perMethodLoad != null) {
                oneMethod.perMethodLoad.increment();
            }
        }

        public void postInvoke(String methodName, long startTime) {
            PerMethodModule oneMethod = (PerMethodModule)this.methodSubinstances.get(methodName);
            if (oneMethod == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BeanMethodsModule.postInvoke - no per method submodule found");
                }
                return;
            }
            if (oneMethod.perMethodLoad != null) {
                oneMethod.perMethodLoad.decrement();
            }
            if (oneMethod.perMethodRt != null) {
                long endTime = System.currentTimeMillis();
                oneMethod.perMethodRt.add(endTime - startTime);
            }
        }

        public void clear() {
            this.methodSubinstances.clear();
        }

        public void removeMethodInstance(String methodName) {
            this.methodSubinstances.remove(methodName);
        }

        public void destroy() {
        }

        public String getWCCMStatsType() {
            return BeanModule.beanMethodWccmType;
        }
    }
}

