/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport.protocol.https;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orb.transport.WSSSLClientSocketFactory;
import com.ibm.ws.orbimpl.transport.WSTransport;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

public class HttpsURLConnection
extends URLConnection {
    OutputStream os = null;
    InputStream is = null;
    Socket theSocket = null;
    ORB orb = null;
    static int defaultPort = 443;

    protected HttpsURLConnection(URL u) {
        super(u);
    }

    public void setOrb(ORB orb) {
        this.orb = orb;
    }

    public synchronized void disconnect() throws IOException {
        if (this.theSocket != null) {
            this.theSocket.close();
        }
    }

    public synchronized void connect() throws IOException {
        block3: {
            String methodName = "connect()";
            int port = this.url.getPort();
            if (port == -1) {
                port = defaultPort;
            }
            String host = this.url.getHost();
            try {
                String connectionKey = host + ":" + Integer.toString(port) + ":" + "IIOPSSL" + ":" + Integer.toString(4);
                ConnectionInterceptor ci = WSTransport.getConnectionInterceptor();
                ci.init(this.orb);
                SSLConnectionData theConnectionData = ci.getSSLConfigurationParameters(connectionKey, 1L, (short)4, 0);
                WSSSLClientSocketFactory factory = WSTransport.getWSSSLClientSocketFactory(this.orb.getORBForTransports());
                this.theSocket = factory.createSSLSocket(theConnectionData);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.protocol.https.HttpsURLConnection.connect", "158", this);
                if (!ORBRas.isTrcLogging) break block3;
                ORBRas.orbTrcLogger.exception(4112L, (Object)this, "connect()", e);
            }
        }
        this.os = this.theSocket.getOutputStream();
        this.is = this.theSocket.getInputStream();
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.os;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    public String getContentType() {
        return new String("ijavaorb/iiop");
    }
}

