/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.ConnectionKey;
import com.ibm.ws.orbimpl.transport.HTTPInputStream;
import com.ibm.ws.orbimpl.transport.HTTPOutputStream;
import com.ibm.ws.orbimpl.transport.HTTPReaderThread;
import com.ibm.ws.security.util.AccessController;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class WSHTTPTransportConnection
implements TransportConnection {
    ConnectionInterceptor connectionInterceptor = null;
    ConnectionData connectionData = null;
    ConnectionKey connectionKey = null;
    HTTPInputStream httpInputStream = null;
    HTTPOutputStream httpOutputStream = null;
    ConnectionTable connectionTable = null;
    ORBConnection orbConnection = null;
    ORB orb = null;
    Profile profile = null;
    HTTPReaderThread httpReaderThread = null;
    String theParameterString = null;
    ConnectionInformation connectionInformation = null;

    public WSHTTPTransportConnection(ConnectionTable table, ConnectionKey key, ORBConnection conn, ORB orb, Profile profile, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor) {
        String methodName = "WSHTTPTransportConnection<init>(ConnectionTable, ConnectionKey, ORBConnection, ORB, Profile, ConnectionData, ConnectionInterceptor)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "WSHTTPTransportConnection<init>(ConnectionTable, ConnectionKey, ORBConnection, ORB, Profile, ConnectionData, ConnectionInterceptor)", "Client side constructor, ConnectionKey=" + key);
        }
        this.connectionInterceptor = connectionInterceptor;
        this.connectionData = connectionData;
        this.orb = orb;
        this.profile = profile;
        this.connectionKey = key;
        this.orbConnection = conn;
        this.httpInputStream = new HTTPInputStream();
        this.httpOutputStream = new HTTPOutputStream(this, profile, orb);
        this.connectionInformation = new ConnectionInformationImpl(connectionData, null, System.currentTimeMillis(), null, -1);
        this.orbConnection.setStreams((InputStream)this.httpInputStream, (OutputStream)this.httpOutputStream, (TransportConnection)this);
    }

    public void removeConnection() {
        String methodName = "removeConnection)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "removeConnection)", "");
        }
        this.httpOutputStream.disconnect();
        this.connectionInterceptor.notifyBrokenConnection(this.connectionInformation);
        this.httpReaderThread.stop();
    }

    public String getConnectionParameterString() {
        if (this.theParameterString == null) {
            this.theParameterString = this.getClass().getName() + " remoteHost=" + this.profile.getHost() + " remotePort=" + this.profile.getPort();
        }
        return this.theParameterString;
    }

    public void readAndProcessReply() {
        String methodName = "addConnection (ORBConnection)";
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "addConnection (ORBConnection)");
        }
        final ThreadGroup finalThreadGroup = this.orb.threadGroup();
        final String finalThreadName = "P=" + ORB.orbLoadTime + ":" + "O=" + this.orb.thisInstanceNumber + ":" + this.orbConnection.getConnectionParameterString();
        final ORBConnection finalConn = this.orbConnection;
        try {
            this.httpReaderThread = (HTTPReaderThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HTTPReaderThread rt = new HTTPReaderThread(finalThreadGroup, finalConn, finalThreadName);
                    rt.setDaemon(true);
                    return rt;
                }
            });
        }
        catch (SecurityException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.orbimpl.transport.WSHTTPTransportConnection.readAndProcessReply", "197", this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4104L, (Object)this, "addConnection (ORBConnection)", (Exception)e);
            }
            this.httpReaderThread = (HTTPReaderThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HTTPReaderThread rt = new HTTPReaderThread(finalConn, finalThreadName);
                    rt.setDaemon(true);
                    return rt;
                }
            });
        }
        if (this.httpReaderThread == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8200L, (Object)this, "addConnection (ORBConnection)", "Problem starting HTTPReaderThread");
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, (Object)this, "addConnection (ORBConnection)");
            }
            throw new INTERNAL("HTTP_READER_FAILURE", 1229066320, CompletionStatus.COMPLETED_MAYBE);
        }
        this.httpReaderThread.start();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (Object)this, "addConnection (ORBConnection)");
        }
    }

    public void setInputStream(InputStream is) {
        this.httpInputStream.setActiveInputStream(is);
    }

    public final String getTunnelAgentURLString() {
        String methodName = "getTunnelAgentURLString()";
        String agentString = this.orb.getProperty("com.ibm.CORBA.TunnelAgentURL");
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelAgentURLString()", "the value of the com.ibm.CORBA.TunnelAgentURLSring=)" + agentString);
        }
        return agentString;
    }

    public void connect() {
    }

    public Object getConnectionData() {
        return this.connectionInformation;
    }

    public Socket getSocket() {
        try {
            throw new NoSuchMethodException("This is not a supported method for WSHTTPTransportConnection Type Transport");
        }
        catch (NoSuchMethodException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.WSHTTPTransportConnection.getSocket", "296", this);
            ex.printStackTrace();
            return null;
        }
    }

    public String getLocalHost() {
        return "HTTPConnection_has_no_LocalHost";
    }

    public String getLocalHostName() {
        return "HTTPConnection_has_no_LocalHostName";
    }

    public String getRemoteHost() {
        return "HTTPConnection_has_no_RemoteHost";
    }

    public String getRemoteHostName() {
        return "HTTPConnection_has_no_RemoteHostName";
    }

    public int getLocalPort() {
        return -1;
    }

    public int getRemotePort() {
        return -1;
    }

    public void preWrite(boolean responseExpected) {
    }

    public void preReply() {
    }
}

