/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.StringUtils;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.security.auth.Subject;

public final class SecurityUtil {
    private static final TraceComponent _tc = Tr.register(SecurityUtil.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static ContextManager _secCtxMgr;

    public static synchronized ContextManager getSecurityContextManager() {
        if (_secCtxMgr == null) {
            _secCtxMgr = ContextManagerFactory.getInstance();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "getSecurityContextManager", "saving security ContextManager");
            }
        }
        return _secCtxMgr;
    }

    public static Subject login(String principal, final String credentials) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "login", new String[]{"principal=" + principal, "credentials=" + StringUtils.maskPassword(credentials)});
        }
        Subject subject = null;
        final String realm = WSSecurityPropagationHelper.getRealmFromUniqueID(principal);
        final String user = WSSecurityPropagationHelper.getUserFromUniqueID(principal);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "login", new String[]{"realm=" + realm, "user=" + user});
        }
        try {
            subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                @Override
                public Subject run() throws WSLoginFailedException {
                    ContextManager secCtxMgr = SecurityUtil.getSecurityContextManager();
                    return secCtxMgr.login(realm, user, credentials);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            WSLoginFailedException lfe = (WSLoginFailedException)pae.getException();
            RasUtil.logException(lfe, _tc, CLASS_NAME, "login", "120");
            AuthenticationException ae = new AuthenticationException("Login failed: " + lfe);
            ae.initCause(lfe);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "login", ae);
            }
            throw ae;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "login", subject);
        }
        return subject;
    }

    public static Subject getRunAsSubject() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRunAsSubject");
        }
        Subject subject = null;
        try {
            subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                @Override
                public Subject run() throws WSSecurityException {
                    return WSSubject.getRunAsSubject();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            WSSecurityException se = (WSSecurityException)pae.getException();
            RasUtil.logException(se, _tc, CLASS_NAME, "getRunAsSubject", "155");
            NamingException ne = new NamingException("WSSubject.getRunAsSubject failed: " + se);
            ne.initCause(se);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getRunAsSubject", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRunAsSubject", subject);
        }
        return subject;
    }

    public static void setRunAsSubject(final Subject subject) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setRunAsSubject", "subject=" + subject);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSecurityException {
                    WSSubject.setRunAsSubject(subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            WSSecurityException se = (WSSecurityException)pae.getException();
            RasUtil.logException(se, _tc, CLASS_NAME, "setRunAsSubject", "190");
            NamingException ne = new NamingException("WSSubject.setRunAsSubject failed: " + se);
            ne.initCause(se);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "setRunAsSubject", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setRunAsSubject");
        }
    }

    private SecurityUtil() {
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/SecurityUtil.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.4");
        }
        CLASS_NAME = SecurityUtil.class.getName();
        _secCtxMgr = null;
    }
}

