/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jndicos;

import com.ibm.WsnOptimizedNaming.BindingData;
import com.ibm.WsnOptimizedNaming.BindingDataIterator;
import com.ibm.WsnOptimizedNaming.BindingDataIteratorHolder;
import com.ibm.WsnOptimizedNaming.BindingDataListHolder;
import com.ibm.WsnOptimizedNaming.DistBindingData;
import com.ibm.WsnOptimizedNaming.DistBindingDataIterator;
import com.ibm.WsnOptimizedNaming.DistBindingDataIteratorHolder;
import com.ibm.WsnOptimizedNaming.DistBindingDataListHolder;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.jndicos.CNContextImpl;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.RetryableAction;
import com.ibm.ws.naming.util.SecurityUtil;
import com.ibm.ws.naming.util.TransactionUtil;
import com.ibm.ws.naming.util.WsnNameParser;
import com.ibm.ws.naming.util.WsnNamingEnumeration;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.PartialResultException;
import javax.security.auth.Subject;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CNEnumeration<T extends NameClassPair>
extends WsnNamingEnumeration<T> {
    private static final TraceComponent _tc = Tr.register(CNEnumeration.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    protected final CNContextImpl _cnCtx;
    protected int _serverType = 0;
    protected NameServerType _nameServerType = NameServerType.COS;
    private BindingIterator _cosIterator = null;
    private DistBindingDataIterator _distIterator = null;
    private BindingDataIterator _optIterator = null;

    protected CNEnumeration(CNContextImpl cnCtx, WsnNameParser nameParser) throws NamingException {
        super(cnCtx.getEnvironment(), nameParser);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"cnCtx=" + cnCtx, "nameParser=" + nameParser});
        }
        this._cnCtx = cnCtx;
        this.init();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    @Override
    protected Boolean doInit() throws NamingException {
        Boolean more;
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "doInit");
            }
            more = null;
            try {
                this._serverType = this._cnCtx.getServerType();
                NamingContext nc = this._cnCtx.getCosContext();
                if (nc != null) {
                    com.ibm.WsnOptimizedNaming.NamingContext tmpNC;
                    more = this._serverType == 3 ? (Helpers.isDistributedNC((NamingContext)(tmpNC = (com.ibm.WsnOptimizedNaming.NamingContext)nc)) ? this.initDist((com.ibm.WsnOptimizedNaming.NamingContext)nc) : this.initOpt((com.ibm.WsnOptimizedNaming.NamingContext)nc)) : this.initCos(nc);
                    break block9;
                }
                NotContextException ne = new NotContextException("The current context is null.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doInit", ne.toString());
                }
                throw ne;
            }
            catch (SystemException se) {
                RasUtil.logException((Throwable)se, _tc, CLASS_NAME, "doInit", "145", this);
                PartialResultException ne = new PartialResultException(se.toString());
                ne.initCause(se);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doInit", ne.toString());
                }
                throw ne;
            }
            catch (Exception e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doInit", "152", this);
                PartialResultException ne = new PartialResultException(e.toString());
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doInit", ne.toString());
                }
                throw ne;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doInit", more);
        }
        return more;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean initCos(NamingContext nc) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initCos", "nc=" + nc);
        }
        Boolean more = null;
        this._nameServerType = NameServerType.COS;
        BindingIteratorHolder bih = new BindingIteratorHolder();
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._cnCtx.isSecurityEnabled()) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this._cnCtx.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                BindingListHolder blh = new BindingListHolder();
                nc.list(this._batchSize, blh, bih);
                this.addToBatch(blh.value);
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "initCos", "199", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initCos", e.toString());
                }
                throw e;
            }
            finally {
                if (restoreSubject && this._cnCtx.isJndiOnly()) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        this._cosIterator = bih.value;
        if (this._cosIterator == null) {
            more = Boolean.FALSE;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initCos", more);
        }
        return more;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean initDist(final com.ibm.WsnOptimizedNaming.NamingContext wsDistNC) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initDist", "wsDistNC=" + wsDistNC);
        }
        Boolean more = null;
        this._nameServerType = NameServerType.DIST;
        final DistBindingDataIteratorHolder bih = new DistBindingDataIteratorHolder();
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._cnCtx.isSecurityEnabled()) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this._cnCtx.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                final DistBindingDataListHolder blh = new DistBindingDataListHolder();
                Helpers.retry(new RetryableAction<Object>(){

                    @Override
                    public Object run() {
                        wsDistNC.list_complete_info_dist(CNEnumeration.this._batchSize, blh, bih);
                        return null;
                    }
                });
                this.addToBatch(blh.value);
            }
            catch (NamingException e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initDist", e.toString());
                }
                throw e;
            }
            finally {
                if (restoreSubject && this._cnCtx.isJndiOnly()) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        this._distIterator = bih.value;
        if (this._distIterator == null) {
            more = Boolean.FALSE;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initDist", more);
        }
        return more;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean initOpt(com.ibm.WsnOptimizedNaming.NamingContext wsOptNC) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initOpt", "wsOptNC=" + wsOptNC);
        }
        Boolean more = null;
        this._nameServerType = NameServerType.OPT;
        BindingDataIteratorHolder bih = new BindingDataIteratorHolder();
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._cnCtx.isSecurityEnabled()) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this._cnCtx.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                BindingDataListHolder blh = new BindingDataListHolder();
                wsOptNC.list_complete_info(this._batchSize, blh, bih);
                this.addToBatch(blh.value);
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "initOpt", "324", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initOpt", e.toString());
                }
                throw e;
            }
            finally {
                if (restoreSubject && this._cnCtx.isJndiOnly()) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        this._optIterator = bih.value;
        if (this._optIterator == null) {
            more = Boolean.FALSE;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initOpt", more);
        }
        return more;
    }

    @Override
    protected void doClose() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doClose");
        }
        if (this._cosIterator != null) {
            this._cosIterator.destroy();
            this._cosIterator = null;
        }
        if (this._distIterator != null) {
            this._distIterator.destroy();
            this._distIterator = null;
        }
        if (this._optIterator != null) {
            this._optIterator.destroy();
            this._optIterator = null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doClose");
        }
    }

    @Override
    protected Boolean doNextBatch() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doNextBatch");
        }
        Boolean more = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "doNextBatch", "_nameServerType=" + (Object)((Object)this._nameServerType));
        }
        switch (this._nameServerType) {
            case COS: {
                BindingListHolder blh = new BindingListHolder();
                more = this._cosIterator.next_n(this._batchSize, blh);
                this.addToBatch(blh.value);
                break;
            }
            case DIST: {
                DistBindingDataListHolder blh = new DistBindingDataListHolder();
                more = this._distIterator.next_n(this._batchSize, blh);
                this.addToBatch(blh.value);
                break;
            }
            case OPT: {
                BindingDataListHolder blh = new BindingDataListHolder();
                more = this._optIterator.next_n(this._batchSize, blh);
                this.addToBatch(blh.value);
                break;
            }
            default: {
                assert (false) : "Unknown value for name server type " + (Object)((Object)this._nameServerType);
                more = Boolean.FALSE;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doNextBatch", more);
        }
        return more;
    }

    private void addToBatch(Binding[] bl) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "addToBatch", "bl.length=" + bl.length);
        }
        for (Binding binding : bl) {
            try {
                this._batch.offer(this.jndiBindingData(binding));
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "addToBatch", "426", this);
                this._batch.offer(e);
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "addToBatch", "429", this);
                NamingException ne = new NamingException("Unexpected exception occurred.");
                ne.initCause(t);
                this._batch.offer(ne);
            }
        }
    }

    protected abstract T jndiBindingData(Binding var1) throws NamingException;

    private void addToBatch(DistBindingData[] bl) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "addToBatch", "bl.length=" + bl.length);
        }
        for (DistBindingData distBindingData : bl) {
            try {
                this._batch.offer(this.jndiBindingData(distBindingData));
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "addToBatch", "451", this);
                this._batch.offer(e);
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "addToBatch", "454", this);
                NamingException ne = new NamingException("Unexpected exception occurred.");
                ne.initCause(t);
                this._batch.offer(ne);
            }
        }
    }

    protected abstract T jndiBindingData(DistBindingData var1) throws NamingException;

    private void addToBatch(BindingData[] bl) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "addToBatch", "bl.length=" + bl.length);
        }
        for (BindingData bindingData : bl) {
            try {
                this._batch.offer(this.jndiBindingData(bindingData));
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "addToBatch", "476", this);
                this._batch.offer(e);
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "addToBatch", "479", this);
                NamingException ne = new NamingException("Unexpected exception occurred.");
                ne.initCause(t);
                this._batch.offer(ne);
            }
        }
    }

    protected abstract T jndiBindingData(BindingData var1) throws NamingException;

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", _cnCtx=");
        stringBuilder.append(this._cnCtx);
        stringBuilder.append(", _serverType=");
        stringBuilder.append(this._serverType);
        stringBuilder.append(", _nameServerType=");
        stringBuilder.append((Object)this._nameServerType);
        stringBuilder.append(", _cosIterator=");
        stringBuilder.append(this._cosIterator);
        stringBuilder.append(", _distIterator=");
        stringBuilder.append(this._distIterator);
        stringBuilder.append(", _optIterator=");
        stringBuilder.append(this._optIterator);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/jndicos/CNEnumeration.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.5");
        }
        CLASS_NAME = CNEnumeration.class.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum NameServerType {
        COS,
        DIST,
        OPT;

    }
}

