/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jndicos;

import com.ibm.WsnOptimizedNaming.BindingData;
import com.ibm.WsnOptimizedNaming.DistBindingData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.ws.naming.jndicos.CNContextImpl;
import com.ibm.ws.naming.jndicos.CNEnumeration;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.InvalidObjectException;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.UnresolvedURLException;
import com.ibm.ws.naming.util.WsnBinding;
import com.ibm.ws.naming.util.WsnNameParser;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CNBindingEnumeration
extends CNEnumeration<Binding> {
    private static final TraceComponent _tc = Tr.register(CNBindingEnumeration.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;

    public CNBindingEnumeration(CNContextImpl cnCtx, WsnNameParser nameParser) throws NamingException {
        super(cnCtx, nameParser);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>", new String[]{"cnCtx=" + cnCtx, "nameParser=" + nameParser});
        }
    }

    @Override
    protected Binding jndiBindingData(DistBindingData distBindingData) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "jndiBindingData", "distBindingData=" + distBindingData);
        }
        String name = this._nameParser.ncToString(distBindingData.binding_name);
        String className = distBindingData.javaClassName;
        Object corbaObject = distBindingData.corbaObj;
        boolean objectMightBeAContext = false;
        if (distBindingData.binding_type == BindingType.ncontext) {
            objectMightBeAContext = true;
        }
        JavaObjectHolder javaObjectHolder = new JavaObjectHolder();
        java.lang.Object object = null;
        try {
            object = this._cnCtx.processResolveResults(distBindingData.binding_name, name, corbaObject, distBindingData.value, objectMightBeAContext, className, distBindingData.primaryContextName, distBindingData.contextID, new String[0], javaObjectHolder);
        }
        catch (CannotInstantiateObjectException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "160", this);
            if (_tc.isDebugEnabled()) {
                NameClassPair nameClassPair = e.getNameClassPair();
                Reference reference = e.getReference();
                Tr.debug(_tc, "jndiBindingData", "CannotInstantiateObjectException: name=" + name + ", className=" + className + ", nameClassPair=" + nameClassPair + ", reference=" + reference);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        catch (UnresolvedURLException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "172", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        catch (InvalidObjectException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "177", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "182", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        Reference reference = null;
        if (javaObjectHolder.value instanceof Reference) {
            reference = (Reference)javaObjectHolder.value;
        }
        WsnBinding binding = new WsnBinding(name, className, object, distBindingData, reference);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "jndiBindingData", binding);
        }
        return binding;
    }

    @Override
    protected Binding jndiBindingData(BindingData bindingData) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "jndiBindingData", "bindingData=" + bindingData);
        }
        String name = this._nameParser.ncToString(bindingData.binding_name);
        String className = bindingData.javaClassName;
        Object corbaObject = bindingData.corbaObj;
        boolean objectMightBeAContext = false;
        if (bindingData.binding_type == BindingType.ncontext) {
            objectMightBeAContext = true;
        }
        java.lang.Object object = null;
        try {
            object = this._cnCtx.processResolveResults(bindingData.binding_name, name, corbaObject, bindingData.value, objectMightBeAContext, className, bindingData.primaryContextName, bindingData.contextID, new String[0], new JavaObjectHolder());
        }
        catch (CannotInstantiateObjectException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "231", this);
            if (_tc.isDebugEnabled()) {
                NameClassPair nameClassPair = e.getNameClassPair();
                Reference reference = e.getReference();
                Tr.debug(_tc, "jndiBindingData", "CannotInstantiateObjectException: name=" + name + ", className=" + className + ", nameClassPair=" + nameClassPair + ", reference=" + reference);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        catch (InvalidObjectException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "243", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "248", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        WsnBinding binding = new WsnBinding(name, className, object, bindingData);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "jndiBindingData", binding);
        }
        return binding;
    }

    @Override
    protected Binding jndiBindingData(org.omg.CosNaming.Binding cnBinding) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "jndiBindingData", "cnBinding=" + cnBinding);
        }
        String className = "org.omg.CORBA.Object";
        if (this._serverType == 2) {
            int index = cnBinding.binding_name.length - 1;
            className = cnBinding.binding_name[index].kind;
            cnBinding.binding_name[index].kind = "";
        }
        Name name = this._nameParser.ncToName(cnBinding.binding_name);
        java.lang.Object object = null;
        try {
            object = this._cnCtx.doLookup(name, true, new BooleanWrapper(false), new JavaObjectHolder());
        }
        catch (CannotInstantiateObjectException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "293", this);
            if (_tc.isDebugEnabled()) {
                NameClassPair nameClassPair = e.getNameClassPair();
                Reference reference = e.getReference();
                Tr.debug(_tc, "jndiBindingData", "CannotInstantiateObjectException: name=" + name + ", className=" + className + ", nameClassPair=" + nameClassPair + ", reference=" + reference);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        catch (InvalidObjectException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "305", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "jndiBindingData", "310", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", e.toString());
            }
            throw e;
        }
        if (this._serverType != 2 && object != null) {
            className = object.getClass().getName();
        }
        WsnBinding binding = new WsnBinding(name.toString(), className, object, cnBinding.binding_type);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "jndiBindingData", binding);
        }
        return binding;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/jndicos/CNBindingEnumeration.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.38");
        }
        CLASS_NAME = CNBindingEnumeration.class.getName();
    }
}

