/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.annotations;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.metadata.MetaDataException;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.metadata.annotations.ASMClassAdapter;
import com.ibm.ws.metadata.annotations.AdapterAndInstance;
import com.ibm.ws.metadata.annotations.AnnotationException;
import com.ibm.ws.metadata.annotations.WSAnnotationAdapter;
import com.ibm.ws.metadata.annotations.WSClassAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigReader
implements ConfigReader {
    private static final String CLASS_NAME = AnnotationConfigReader.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    protected static final String[] sv_Annotations = new String[]{"Ljavax/ejb/ActivationConfigProperty;", "Ljavax/ejb/Local;", "Ljavax/ejb/LocalHome;", "Ljavax/ejb/MessageDriven;", "Ljavax/ejb/Remote;", "Ljavax/ejb/RemoteHome;", "Ljavax/ejb/Stateless;", "Ljavax/ejb/Stateful;", "Ljavax/ejb/TransactionManagement;", "Ljavax/annotation/Resource;", "Ljavax/annotation/Resources;", "Ljavax/xml/bind/annotation/XmlList;"};
    protected static final String[] sv_AdapterClassName = new String[]{"com.ibm.ws.metadata.annotations.ActivationConfigPropertyAdapter", "com.ibm.ws.metadata.annotations.LocalAdapter", "com.ibm.ws.metadata.annotations.LocalHomeAdapter", "com.ibm.ws.metadata.annotations.MessageDrivenAdapter", "com.ibm.ws.metadata.annotations.RemoteAdapter", "com.ibm.ws.metadata.annotations.RemoteHomeAdapter", "com.ibm.ws.metadata.annotations.StatelessAdapter", "com.ibm.ws.metadata.annotations.StatefulAdapter", "com.ibm.ws.metadata.annotations.TransactionManagementAdapter", "com.ibm.ws.metadata.annotations.ResourceAdapter", "com.ibm.ws.metadata.annotations.ResourcesAdapter", "com.ibm.ws.metadata.annotations.XmlListAdapter"};
    private HashMap<String, AdapterAndInstance> sv_AnnotationMap;
    private static Map<String, Class> sv_AnnotationAdapterClassMap;
    private String classAdapterName;

    public AnnotationConfigReader() {
        this.classAdapterName = "ASMClassAdapter";
        this.sv_AnnotationMap = new HashMap();
        for (int i = 0; i < sv_Annotations.length; ++i) {
            this.sv_AnnotationMap.put(sv_Annotations[i], new AdapterAndInstance(sv_AdapterClassName[i]));
        }
        if (sv_AnnotationAdapterClassMap != null && !sv_AnnotationAdapterClassMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating AdapterAndInstance from dynamically registered adapters");
            }
            for (String key : sv_AnnotationAdapterClassMap.keySet()) {
                Class adapterClass = sv_AnnotationAdapterClassMap.get(key);
                this.sv_AnnotationMap.put(key, new AdapterAndInstance(adapterClass));
            }
        }
    }

    public AnnotationConfigReader(String cAdapterName) {
        this.classAdapterName = cAdapterName;
        this.sv_AnnotationMap = new HashMap();
        for (int i = 0; i < sv_Annotations.length; ++i) {
            this.sv_AnnotationMap.put(sv_Annotations[i], new AdapterAndInstance(sv_AdapterClassName[i]));
        }
        if (sv_AnnotationAdapterClassMap != null && !sv_AnnotationAdapterClassMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating AdapterAndInstance from dynamically registered adapters");
            }
            for (String key : sv_AnnotationAdapterClassMap.keySet()) {
                Class adapterClass = sv_AnnotationAdapterClassMap.get(key);
                this.sv_AnnotationMap.put(key, new AdapterAndInstance(adapterClass));
            }
        }
    }

    @Override
    public void populateModuleData(ModuleDataObject mdo, MetaDataSources sources) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateModuleData(" + mdo.iv_Key + "," + sources + ")");
        }
        JarFile jarFile = (JarFile)sources.iv_Sources[MetaDataSources.sv_JarFileIndex];
        File directory = (File)sources.iv_Sources[MetaDataSources.sv_DirectoryIndex];
        if (jarFile != null) {
            this.getAnnotationData(mdo, jarFile);
        } else if (directory != null) {
            this.getAnnotationData(mdo, directory);
        } else {
            Iterator locators = (Iterator)sources.iv_Sources[MetaDataSources.sv_FileLocatorIndex];
            this.getAnnotationData(mdo, locators);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateModuleData", mdo);
        }
    }

    private void getAnnotationData(ModuleDataObject mdo, JarFile jarFile) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationData( module = " + mdo.iv_Key + ", jarFile = " + jarFile.getName());
        }
        String name = null;
        try {
            Enumeration<JarEntry> vEnum = jarFile.entries();
            if (vEnum.hasMoreElements()) {
                mdo.ivScannedClasses = new HashSet();
            }
            int classCount = 0;
            int entryCount = 0;
            while (vEnum.hasMoreElements()) {
                ++entryCount;
                JarEntry entry = vEnum.nextElement();
                name = entry.getName();
                int j = name.length();
                if (j < 6 || !name.substring(j - 6).equals(".class")) continue;
                InputStream is = jarFile.getInputStream(entry);
                ClassReader cr = new ClassReader(is);
                ClassWriter cw = new ClassWriter(true);
                ASMClassAdapter classAdapter = this.getClassAdapter(cw, this, mdo);
                try {
                    cr.accept(classAdapter, false);
                }
                catch (MetaDataException me) {
                    is.close();
                    throw me;
                }
                catch (AnnotationException ae) {
                    is.close();
                    throw ae;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, CLASS_NAME + ".getAnnotationData", "346", this);
                    Tr.warning(tc, "UNABLE_TO_SCAN_CLASS_CWMDF0022W", new Object[]{name, jarFile.getName(), t});
                }
                is.close();
                ++classCount;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The " + jarFile.getName() + " contained " + entryCount + " entries and " + classCount + " classes");
            }
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationData", "309", this);
            AnnotationException aex = new AnnotationException("Unable to communicate with file " + name + ":  ", ex);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
            throw aex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationData", "317", this);
            AnnotationException aex = new AnnotationException("Annotation processing failed: " + name + ":  ", ex);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
            throw aex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationData");
        }
    }

    private void getAnnotationData(ModuleDataObject mdo, File directory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationData( module = " + mdo.iv_Key + ", directory = " + directory.getAbsolutePath());
        }
        try {
            ArrayList<FileInputStream> streams = new ArrayList<FileInputStream>();
            this.getStreamsFromDirectory(directory, streams);
            if (!streams.isEmpty()) {
                mdo.ivScannedClasses = new HashSet();
                FileInputStream[] files = streams.toArray(new FileInputStream[0]);
                int i = 0;
                for (i = 0; i < files.length; ++i) {
                    ClassReader cr = new ClassReader(files[i]);
                    ClassWriter cw = new ClassWriter(true);
                    ASMClassAdapter classAdapter = this.getClassAdapter(cw, this, mdo);
                    try {
                        cr.accept(classAdapter, false);
                        continue;
                    }
                    catch (MetaDataException me) {
                        throw me;
                    }
                    catch (AnnotationException ae) {
                        throw ae;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, CLASS_NAME + ".getAnnotationData", "435", this);
                        Tr.warning(tc, "UNABLE_TO_SCAN_INPUTSTREAM_CWMDF0023W", new Object[]{directory.getAbsolutePath(), t});
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + directory.getName() + " directory contained " + i + " classes");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, directory.getAbsolutePath() + " contains no files.");
            }
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationData", "368", this);
            AnnotationException aex = new AnnotationException("Annotation processing failed:  ", ex);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
            throw aex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationData", "376", this);
            AnnotationException aex = new AnnotationException("Annotation processing failed:  ", ex);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
            throw aex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationData");
        }
    }

    private void getAnnotationData(ModuleDataObject mdo, Iterator<FileLocator> locators) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationData( module = " + mdo.iv_Key + ", FileLocators = " + locators);
            Tr.entry(tc, "getAnnotationData(" + mdo.iv_Key + "," + locators + ")");
        }
        String name = null;
        try {
            if (locators.hasNext()) {
                mdo.ivScannedClasses = new HashSet();
            }
            int classCount = 0;
            int entryCount = 0;
            while (locators.hasNext()) {
                ++entryCount;
                FileLocator locator = locators.next();
                name = locator.getName();
                int j = name.length();
                if (j < 6 || !name.substring(j - 6).equals(".class")) continue;
                ++classCount;
                InputStream is = locator.getInputStream();
                if (is == null) continue;
                ClassReader cr = new ClassReader(is);
                ClassWriter cw = new ClassWriter(true);
                ASMClassAdapter classAdapter = this.getClassAdapter(cw, this, mdo);
                try {
                    cr.accept(classAdapter, false);
                }
                catch (MetaDataException me) {
                    is.close();
                    throw me;
                }
                catch (AnnotationException ae) {
                    is.close();
                    throw ae;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, CLASS_NAME + ".getAnnotationData", "346", this);
                    Tr.warning(tc, "UNABLE_TO_SCAN_CLASS_CWMDF0024W", new Object[]{name, mdo.iv_Key, t});
                }
                is.close();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "There were " + entryCount + " files processed, of which " + classCount + " were classes");
            }
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationData", "434", this);
            AnnotationException aex = new AnnotationException("Unable to communicate with file for class:  " + name, ex);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
            throw aex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationData", "442", this);
            AnnotationException aex = new AnnotationException("Annotation processing failed for class:  " + name, ex);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
            throw aex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationData");
        }
    }

    public WSAnnotationAdapter getAnnotationAdapterInstance(String annotationString) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationAdapterInstance(" + annotationString + ")");
        }
        Class<?> adapterClass = null;
        WSAnnotationAdapter result = null;
        AdapterAndInstance adapterAndInstance = this.sv_AnnotationMap.get(annotationString);
        if (adapterAndInstance != null) {
            if (adapterAndInstance.iv_AnnotationAdapterClass == null) {
                try {
                    if (adapterAndInstance.iv_AdapterClass != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AdapterAndInstance instance had non-null WSAnnotationAdapter class");
                        }
                        adapterClass = adapterAndInstance.iv_AdapterClass;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading AnnotationAdapter class using AdapterAndInstance class name: " + adapterAndInstance.iv_ClassName);
                        }
                        adapterClass = Class.forName(adapterAndInstance.iv_ClassName);
                    }
                }
                catch (ClassNotFoundException ex) {
                    FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationAdapterInstance", "193", this);
                    AnnotationException aex = new AnnotationException("No adapter class found for class:  " + adapterAndInstance.iv_ClassName, ex);
                    Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
                    throw aex;
                }
                try {
                    adapterAndInstance.iv_AnnotationAdapterClass = (WSAnnotationAdapter)adapterClass.newInstance();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationAdapterInstance", "220", this);
                    AnnotationException aex = new AnnotationException("Unable to instantiate class:  " + adapterClass.getName(), ex);
                    Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
                    throw aex;
                }
            }
            result = adapterAndInstance.iv_AnnotationAdapterClass;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationAdapterInstance", result);
        }
        return result;
    }

    protected ASMClassAdapter getClassAdapter(ClassWriter cw, AnnotationConfigReader acr, ModuleDataObject mdo) {
        if (this.classAdapterName.equals("ASMClassAdapter")) {
            return new ASMClassAdapter(cw, this, mdo);
        }
        if (this.classAdapterName.equals("WSClassAdapter")) {
            return new WSClassAdapter(cw, this, mdo);
        }
        return null;
    }

    private void getStreamsFromDirectory(File dir, ArrayList<FileInputStream> streams) {
        File[] files = dir.listFiles();
        String fileName = null;
        int classCount = 0;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getStreamsFromDirectory(files[i], streams);
                continue;
            }
            fileName = files[i].getName();
            if (!fileName.endsWith(".class")) continue;
            ++classCount;
            try {
                streams.add(new FileInputStream(files[i]));
                continue;
            }
            catch (FileNotFoundException ex) {
                FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getStreamsFromDirectory", "544", this);
                AnnotationException aex = new AnnotationException("Unable to create FileInputStream for class:  " + files[i].getName(), ex);
                Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
                throw aex;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, dir.getAbsolutePath() + " contains " + files.length + " files and " + classCount + " classes");
        }
    }

    public static void addAnnotationAdapterClass(String annotationType, Class adapterClass) {
        if (sv_AnnotationAdapterClassMap == null) {
            sv_AnnotationAdapterClassMap = new HashMap<String, Class>();
        }
        if (annotationType != null && adapterClass != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For the annotation type: " + annotationType + " registering " + "the WSAnnotationAdapter: " + adapterClass.getName());
            }
            sv_AnnotationAdapterClassMap.put(annotationType, adapterClass);
        } else if (annotationType == null && adapterClass != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For WSAnnotationAdapter: " + adapterClass.getName() + " an " + "attempt was made to register it with a null annotation type.");
            }
        } else if (annotationType != null && adapterClass == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For annotation type: " + annotationType + " an attempt was " + "made to map it to a null WSAnnotationAdapter class.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Both the annotation type and WSAnnotationAdapter class were null.");
        }
    }
}

