/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SyncResult
implements Serializable {
    private static final long serialVersionUID = 3288474355450479721L;
    private static TraceComponent tc = Tr.register(SyncResult.class, "Sync", "com.ibm.ws.management.resources.sync");
    private long initTime = 0L;
    private long completeTime = 0L;
    public static final int IN_PROGRESS = 0;
    public static final int COMPLETE = 1;
    public static final int NOT_VERIFIED = 2;
    public static final int OUT_OF_SYNC = 3;
    public static final int ERROR = 4;
    private int result;
    private boolean updated;

    SyncResult() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SyncResult");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SyncResult");
        }
    }

    public int getResult() {
        return this.result;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }

    public boolean isSuccessful() {
        return this.result == 1 || this.result == 2;
    }

    void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.initTime = System.currentTimeMillis();
        this.completeTime = 0L;
        this.updated = false;
        this.result = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    void updated() {
        this.updated = true;
    }

    void setResult(int result) {
        this.result = result;
        this.completeTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss:SSS zzz");
        buf.append("initiate time: ").append(formatter.format(new Date(this.initTime))).append('\n');
        if (this.completeTime > 0L) {
            buf.append("complete time: ").append(formatter.format(new Date(this.completeTime))).append('\n');
        }
        buf.append("result: ");
        switch (this.result) {
            case 0: {
                buf.append("In Progress");
                break;
            }
            case 1: {
                buf.append("Complete");
                break;
            }
            case 4: {
                buf.append("Error");
                break;
            }
            case 2: {
                buf.append("Not Verfied");
                break;
            }
            case 3: {
                buf.append("Out of Sync");
            }
        }
        buf.append("\n");
        if (this.updated) {
            buf.append("Update occurred\n");
        } else {
            buf.append("No update occurred.\n");
        }
        return buf.toString();
    }
}

