/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deployment.j2ee;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.deployment.core.DeployableObject;
import com.ibm.websphere.management.deployment.core.DeploymentContext;
import com.ibm.websphere.management.deployment.core.DeploymentStep;
import com.ibm.websphere.management.deployment.exception.DeploymentException;
import com.ibm.websphere.management.deployment.registry.ExtensionProvider;
import com.ibm.ws.management.deployment.j2ee.J2EEToCDFStepWrapper;
import com.ibm.ws.management.deployment.util.DeploymentExtensionHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class J2EEToCDFBridge {
    private static TraceComponent tc = Tr.register(J2EEToCDFBridge.class, "Admin", "com.ibm.ws.management.resources.DeploymentMessages");
    private static final String EAR_DO_PATH = "com.ibm.ws.management.deployment.j2ee.EARDeployableObject";
    private static final String ARCHIVE_DO_PATH = "com.ibm.ws.management.deployment.j2ee.ArchiveDeployableObject";

    public static void addCDFServerPluginToJ2EE(long op, Vector j2eeSteps, Scheduler scheduler, Hashtable prefs) throws DeploymentException {
        DeploymentContext aContext;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCDFServerPluginToJ2EE", new Object[]{new Long(op), j2eeSteps, scheduler});
        }
        List cdfSteps = J2EEToCDFBridge._convertJ2EEStepToCDFStepHelper(j2eeSteps);
        String opStr = null;
        String type = "EAR";
        if ((op & 1L) != 0L) {
            opStr = "install";
        } else if ((op & 2L) != 0L) {
            opStr = "edit";
        } else if ((op & 4L) != 0L) {
            opStr = "update";
        } else if ((op & 8L) != 0L) {
            opStr = "uninstall";
        } else if ((op & 0x10L) != 0L) {
            opStr = "createEarWrapper";
            type = "";
        }
        Vector extProviders = new Vector();
        DeploymentExtensionHelper.getProviders(extProviders);
        for (i = 0; i < extProviders.size(); ++i) {
            ((ExtensionProvider)extProviders.elementAt(i)).addSteps(type, opStr, new String(), cdfSteps);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "steps are " + cdfSteps + " after calling extension provider " + (ExtensionProvider)extProviders.elementAt(i));
        }
        if (scheduler != null) {
            aContext = J2EEToCDFBridge._createCDFContext(scheduler, opStr);
            prefs.put("appname", scheduler.getAppName());
        } else {
            aContext = new DeploymentContext();
        }
        aContext.getContextData().put(DeploymentContext.PREFS_Hashtable_key, prefs);
        j2eeSteps.clear();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing up the existing j2eeStep vector");
        }
        for (i = 0; i < cdfSteps.size(); ++i) {
            Object aStep = cdfSteps.get(i);
            if (aStep instanceof J2EEToCDFStepWrapper) {
                j2eeSteps.add(((J2EEToCDFStepWrapper)aStep).getJ2EETask());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding j2ee step to " + i + "th element: " + j2eeSteps.elementAt(i));
                continue;
            }
            if (!(aStep instanceof DeploymentStep)) continue;
            ((DeploymentStep)aStep).setContext(aContext);
            j2eeSteps.add(aStep);
            System.out.println("adding cdf step " + aStep.getClass().getName() + " to " + i + "th element: " + j2eeSteps.elementAt(i));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Adding cdf step " + aStep.getClass().getName() + " to " + i + "th element: " + j2eeSteps.elementAt(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCDFServerPluginToJ2EE");
        }
    }

    public static DeployableObject createDO(Object ob) throws DeploymentException {
        Class doConstructorClass;
        String doPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDO", new Object[]{ob});
        }
        DeployableObject aDo = null;
        if (ob instanceof Scheduler) {
            doPath = EAR_DO_PATH;
            doConstructorClass = Scheduler.class;
        } else if (ob instanceof Archive) {
            doPath = ARCHIVE_DO_PATH;
            doConstructorClass = Archive.class;
        } else {
            ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.DeploymentMessages", Locale.getDefault());
            throw new DeploymentException(bundle.getString("AMDA2000E"), null);
        }
        try {
            Class<?> doClass = Class.forName(doPath);
            Constructor<?> constructor = doClass.getDeclaredConstructor(doConstructorClass);
            aDo = (DeployableObject)constructor.newInstance(ob);
        }
        catch (Exception ae) {
            throw new DeploymentException(ae.getMessage(), ae);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDO - " + aDo);
        }
        return aDo;
    }

    private static List _convertJ2EEStepToCDFStepHelper(Vector j2eeSteps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_convertJ2EEStepToCDFStepHelper", new Object[]{j2eeSteps});
        }
        ArrayList<J2EEToCDFStepWrapper> cdfSteps = new ArrayList<J2EEToCDFStepWrapper>();
        for (int i = 0; i < j2eeSteps.size(); ++i) {
            cdfSteps.add(new J2EEToCDFStepWrapper(j2eeSteps.get(i).getClass().getName(), j2eeSteps.get(i)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_convertJ2EEStepToCDFStepHelper - " + cdfSteps);
        }
        return cdfSteps;
    }

    private static DeploymentContext _createCDFContext(Scheduler scheduler, String op) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_createCDFContext", new Object[]{scheduler});
        }
        DeploymentContext aContext = new DeploymentContext();
        aContext.getContextData().put(DeploymentContext.SESSIONID_String_key, scheduler.getWorkSpace().getSessionId());
        aContext.getContextData().put(DeploymentContext.TEMPDIR_String_key, scheduler.getTempDir());
        aContext.getContextData().put(DeploymentContext.OPERATIONNAME_String_key, op);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_createCDFContext -" + aContext);
        }
        return aContext;
    }
}

