/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.interop.JMXClassLoader;
import com.ibm.ws.management.connector.interop.JMXObjectInputStream;
import com.ibm.ws.management.connector.interop.JMXObjectOutputStream;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.connector.interop.JMXTransformReader;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import org.apache.soap.Utils;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GenericSerializer
implements Serializer,
Deserializer {
    private static TraceComponent tc = Tr.register(GenericSerializer.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static ThreadLocal remoteVersion = new ThreadLocal();
    private static ThreadLocal contextClassLoader = new ThreadLocal();
    private static JMXClassLoader classLoader = GenericSerializer.loadJMXClassLoader();
    private static JMXTransformReader jmxTransform = new JMXTransformReader();
    private static Object transformWriter = GenericSerializer.loadJMXTransformWriter();

    public static void setVersion(String version) {
        remoteVersion.set(version);
    }

    public static void setContextClassLoader(ClassLoader cl) {
        contextClassLoader.set(cl);
    }

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        ClassLoader cl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshall, src=" + src + ", context=" + context.toString());
        }
        if ((cl = (ClassLoader)contextClassLoader.get()) != null) {
            Thread currThread = Thread.currentThread();
            currThread.setContextClassLoader(cl);
            contextClassLoader.set(null);
        }
        nsStack.pushScope();
        QName elementType = new QName("urn:AdminService", javaType.getName());
        sink.write('<' + context.toString());
        String xsiNSPrefix = nsStack.getPrefixFromURI("http://www.w3.org/2001/XMLSchema-instance", sink);
        String elementTypeNSPrefix = nsStack.getPrefixFromURI(elementType.getNamespaceURI(), sink);
        sink.write(' ' + xsiNSPrefix + ':' + "type" + "=\"" + elementTypeNSPrefix + ':' + elementType.getLocalPart() + '\"');
        sink.write(62);
        String remoteJMXVersion = (String)ctx.getProperty("JMXRemoteVersion");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Remote JMX version is " + remoteJMXVersion);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JMXObjectOutputStream oos = new JMXObjectOutputStream(baos);
            oos.jmxWriteObject(src, remoteJMXVersion);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.soap.GenericSerializer.marshall", "87", this);
            Tr.error(tc, "ADMC0008E", new Object[]{javaType.getName(), ioe.getMessage()});
            throw ioe;
        }
        catch (JMXTransformException tex) {
            FFDCFilter.processException((Throwable)tex, "com.ibm.ws.management.connector.soap.GenericSerializer.marshall", "87", this);
            Tr.error(tc, "ADMC0008E", new Object[]{javaType.getName(), tex.getStackTraceAsString()});
            throw new IOException(tex.getStackTraceAsString());
        }
        String base64String = Base64.encode(baos.toByteArray());
        sink.write(Utils.cleanString(base64String) + "</" + context + '>');
        nsStack.popScope();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshall");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Object obj;
        block15: {
            ClassLoader cl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "unmarshall, src=" + src);
            }
            if ((cl = (ClassLoader)contextClassLoader.get()) != null) {
                Thread currThread = Thread.currentThread();
                currThread.setContextClassLoader(cl);
                contextClassLoader.set(null);
            }
            Element root = (Element)src;
            String value = DOMUtils.getChildCharacterData(root);
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(value));
            obj = null;
            String remoteJMXVersion = (String)ctx.getProperty("JMXRemoteVersion");
            if (remoteJMXVersion == null) {
                remoteJMXVersion = (String)remoteVersion.get();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remote JMX version is " + remoteJMXVersion);
            }
            try {
                if (JMXVersionValidation.isRemoteVersionTmx4j(remoteJMXVersion)) {
                    Thread ct = Thread.currentThread();
                    ClassLoader wscl = ct.getContextClassLoader();
                    ct.setContextClassLoader(classLoader);
                    try {
                        JMXObjectInputStream jmxois = new JMXObjectInputStream(bais);
                        obj = jmxois.jmxReadObject();
                        break block15;
                    }
                    finally {
                        ct.setContextClassLoader(wscl);
                    }
                }
                WsObjectInputStream ois = new WsObjectInputStream(bais);
                obj = ois.readObject();
            }
            catch (IOException ioe) {
                String trace = JMXTransformException.getStackTraceAsString(ioe);
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.soap.GenericSerializer.unmarshall", "110", this);
                throw new IllegalArgumentException(ioe.getMessage() + "\nServer stack trace\n" + trace + "\nClient stack trace\n");
            }
            catch (ClassNotFoundException cne) {
                String trace = JMXTransformException.getStackTraceAsString(cne);
                FFDCFilter.processException((Throwable)cne, "com.ibm.ws.management.connector.soap.GenericSerializer.unmarshall", "114", this);
                throw new IllegalArgumentException(cne.getMessage() + "\nServer stack trace\n" + trace + "\nClient stackTrace\n");
            }
            catch (JMXTransformException tex) {
                FFDCFilter.processException((Throwable)tex, "com.ibm.ws.management.connector.soap.GenericSerializer.marshall", "87", this);
                String trace = tex.getStackTraceAsString();
                throw new IllegalArgumentException(tex.getMessage() + "\nServer stack trace\n" + trace + "\nClient stackTrace\n");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unmarshalled object=" + obj);
            if (obj instanceof Object[]) {
                Tr.debug(tc, "...and the array length is " + ((Object[])obj).length);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unmarshall");
        }
        return new Bean(xjmr.queryJavaType(elementType, inScopeEncStyle), obj);
    }

    private static JMXClassLoader loadJMXClassLoader() {
        String installRoot;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadJMXClassLoader");
        }
        if ((installRoot = System.getProperty("was.install.root")) == null) {
            installRoot = System.getProperty("user.install.root");
        }
        classLoader = new JMXClassLoader(installRoot + "/etc/tmx4jTransform.jar", GenericSerializer.class.getClassLoader());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJMXClassLoader root = " + installRoot);
        }
        return classLoader;
    }

    private static Object loadJMXTransformWriter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadJMXTransformWriter");
        }
        Thread ct = Thread.currentThread();
        ClassLoader wscl = ct.getContextClassLoader();
        ct.setContextClassLoader(classLoader);
        try {
            Class[] paramTypes = new Class[]{};
            Object[] params = new Object[]{};
            Class<?> cls = classLoader.loadClass("com.ibm.ws.management.connector.interop.JMXTransformWriter");
            Constructor<?> cons = cls.getConstructor(paramTypes);
            transformWriter = cons.newInstance(params);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JMXTransformWriter loaded = " + transformWriter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ct.setContextClassLoader(wscl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJMXTransformWriter");
        }
        return transformWriter;
    }

    public static JMXTransformReader getJMXTransformReader() {
        return jmxTransform;
    }

    public static JMXClassLoader getJMXClassLoader() {
        return classLoader;
    }

    public static Object getJMXTransformWriter() {
        return transformWriter;
    }
}

